/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.PoolThread;
import edu.jas.util.StrategyEnumeration;
import java.util.LinkedList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadPool {
    static final int DEFAULT_SIZE = 3;
    final int size;
    protected PoolThread[] workers;
    protected int idleworkers = 0;
    protected volatile boolean shutdown = false;
    protected LinkedList<Runnable> jobstack;
    protected StrategyEnumeration strategy = StrategyEnumeration.LIFO;
    private static final Logger logger = LogManager.getLogger(ThreadPool.class);
    private static final boolean debug = logger.isDebugEnabled();

    public ThreadPool() {
        this(StrategyEnumeration.FIFO, 3);
    }

    public ThreadPool(StrategyEnumeration strategyEnumeration) {
        this(strategyEnumeration, 3);
    }

    public ThreadPool(int n) {
        this(StrategyEnumeration.FIFO, n);
    }

    public ThreadPool(StrategyEnumeration strategyEnumeration, int n) {
        this.size = n;
        this.strategy = strategyEnumeration;
        this.jobstack = new LinkedList();
        this.workers = new PoolThread[0];
    }

    public void init() {
        if (this.workers == null || this.workers.length == 0) {
            this.workers = new PoolThread[this.size];
            for (int i = 0; i < this.workers.length; ++i) {
                this.workers[i] = new PoolThread(this);
                this.workers[i].start();
            }
            logger.info("size = {}, strategy = {}", (Object)this.size, (Object)this.strategy);
        }
        if (debug) {
            Thread.dumpStack();
        }
    }

    public String toString() {
        return "ThreadPool( size=" + this.getNumber() + ", idle=" + this.idleworkers + ", " + this.getStrategy() + ", jobs=" + this.jobstack.size() + ")";
    }

    public int getNumber() {
        return this.size;
    }

    public StrategyEnumeration getStrategy() {
        return this.strategy;
    }

    public void terminate() {
        while (this.hasJobs()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.workers == null) {
            return;
        }
        for (int i = 0; i < this.workers.length; ++i) {
            if (this.workers[i] == null) continue;
            try {
                while (this.workers[i].isAlive()) {
                    this.workers[i].interrupt();
                    this.workers[i].join(100L);
                }
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int cancel() {
        this.shutdown = true;
        int n = this.jobstack.size();
        if (this.hasJobs()) {
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                logger.info("jobs canceled: {}", this.jobstack);
                this.jobstack.clear();
                this.notifyAll();
            }
        }
        if (this.workers == null) {
            return n;
        }
        for (int i = 0; i < this.workers.length; ++i) {
            if (this.workers[i] == null) continue;
            try {
                while (this.workers[i].isAlive()) {
                    ThreadPool threadPool = this;
                    synchronized (threadPool) {
                        this.shutdown = true;
                        this.notifyAll();
                        this.workers[i].interrupt();
                    }
                    this.workers[i].join(100L);
                }
                continue;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        return n;
    }

    public synchronized void addJob(Runnable runnable) {
        if (this.workers == null || this.workers.length < this.size) {
            this.init();
        }
        this.jobstack.addLast(runnable);
        logger.debug("adding job");
        if (this.idleworkers > 0) {
            logger.debug("notifying a jobless worker");
            this.notifyAll();
        }
    }

    protected synchronized Runnable getJob() throws InterruptedException {
        while (this.jobstack.isEmpty()) {
            ++this.idleworkers;
            logger.debug("waiting");
            this.wait(1000L);
            --this.idleworkers;
            if (!this.shutdown) continue;
            throw new InterruptedException("shutdown in getJob");
        }
        if (this.strategy == StrategyEnumeration.LIFO) {
            return this.jobstack.removeLast();
        }
        return this.jobstack.removeFirst();
    }

    public boolean hasJobs() {
        if (this.jobstack.size() > 0) {
            return true;
        }
        for (int i = 0; i < this.workers.length; ++i) {
            if (this.workers[i] == null || !this.workers[i].isWorking) continue;
            return true;
        }
        return false;
    }

    public boolean hasJobs(int n) {
        int n2 = this.jobstack.size();
        if (n2 > 0 && n2 + this.workers.length > n) {
            return true;
        }
        int n3 = 0;
        for (int i = 0; i < this.workers.length; ++i) {
            if (this.workers[i] == null || !this.workers[i].isWorking) continue;
            ++n3;
        }
        return n2 + n3 > n;
    }
}

