/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.ufd;

import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolyUtil;
import edu.jas.structure.AbelianGroupElem;
import edu.jas.structure.Element;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.MonoidElem;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.GreatestCommonDivisor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class GreatestCommonDivisorAbstract<C extends GcdRingElem<C>>
implements GreatestCommonDivisor<C> {
    private static final Logger logger = LogManager.getLogger(GreatestCommonDivisorAbstract.class);
    private static final boolean debug = logger.isDebugEnabled();

    public String toString() {
        return this.getClass().getName();
    }

    public C baseContent(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genPolynomial.isZERO()) {
            return (C)((GcdRingElem)genPolynomial.ring.getZEROCoefficient());
        }
        AbelianGroupElem abelianGroupElem = null;
        for (GcdRingElem gcdRingElem : genPolynomial.getMap().values()) {
            if (!(abelianGroupElem = abelianGroupElem == null ? gcdRingElem : abelianGroupElem.gcd(gcdRingElem)).isONE()) continue;
            return (C)abelianGroupElem;
        }
        if (abelianGroupElem.signum() < 0) {
            abelianGroupElem = (GcdRingElem)abelianGroupElem.negate();
        }
        return (C)abelianGroupElem;
    }

    public GenPolynomial<C> basePrimitivePart(GenPolynomial<C> genPolynomial) {
        GenPolynomial<C> genPolynomial2;
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        C c = this.baseContent(genPolynomial);
        if (c.isONE()) {
            return genPolynomial;
        }
        GenPolynomial<C> genPolynomial3 = genPolynomial.divide(c);
        if (debug && !(genPolynomial2 = genPolynomial3.multiply(c)).equals(genPolynomial)) {
            throw new ArithmeticException("pp(p)*cont(p) != p: ");
        }
        return genPolynomial3;
    }

    public List<GenPolynomial<C>> basePrimitivePart(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size());
        for (GenPolynomial<C> genPolynomial : list) {
            GenPolynomial<C> genPolynomial2 = this.basePrimitivePart(genPolynomial);
            arrayList.add(genPolynomial2);
        }
        return arrayList;
    }

    public abstract GenPolynomial<C> baseGcd(GenPolynomial<C> var1, GenPolynomial<C> var2);

    public GenPolynomial<C> recursiveContent(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genPolynomial.isZERO()) {
            return (GenPolynomial)genPolynomial.ring.getZEROCoefficient();
        }
        GenPolynomial<C> genPolynomial2 = null;
        for (GenPolynomial<C> genPolynomial3 : genPolynomial.getMap().values()) {
            if (!(genPolynomial2 = genPolynomial2 == null ? genPolynomial3 : this.gcd(genPolynomial2, genPolynomial3)).isONE()) continue;
            return genPolynomial2;
        }
        return genPolynomial2.abs();
    }

    public GenPolynomial<GenPolynomial<C>> recursivePrimitivePart(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomial<C> genPolynomial2 = this.recursiveContent(genPolynomial);
        if (genPolynomial2.isONE()) {
            return genPolynomial;
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial3 = PolyUtil.recursiveDivide(genPolynomial, genPolynomial2);
        return genPolynomial3;
    }

    public List<GenPolynomial<GenPolynomial<C>>> recursivePrimitivePart(List<GenPolynomial<GenPolynomial<C>>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        ArrayList<GenPolynomial<GenPolynomial<C>>> arrayList = new ArrayList<GenPolynomial<GenPolynomial<C>>>(list.size());
        for (GenPolynomial<GenPolynomial<C>> genPolynomial : list) {
            GenPolynomial<GenPolynomial<C>> genPolynomial2 = this.recursivePrimitivePart(genPolynomial);
            arrayList.add(genPolynomial2);
        }
        return arrayList;
    }

    public C baseRecursiveContent(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genPolynomial.isZERO()) {
            GenPolynomialRing genPolynomialRing = (GenPolynomialRing)genPolynomial.ring.coFac;
            return (C)((GcdRingElem)genPolynomialRing.coFac.getZERO());
        }
        AbelianGroupElem abelianGroupElem = null;
        for (GenPolynomial<C> genPolynomial2 : genPolynomial.getMap().values()) {
            C c = this.baseContent(genPolynomial2);
            if (!(abelianGroupElem = abelianGroupElem == null ? c : this.gcd(abelianGroupElem, c)).isONE()) continue;
            return (C)abelianGroupElem;
        }
        if (abelianGroupElem.signum() < 0) {
            abelianGroupElem = (GcdRingElem)abelianGroupElem.negate();
        }
        return (C)abelianGroupElem;
    }

    public GenPolynomial<GenPolynomial<C>> baseRecursivePrimitivePart(GenPolynomial<GenPolynomial<C>> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        if (genPolynomial.isZERO()) {
            return genPolynomial;
        }
        C c = this.baseRecursiveContent(genPolynomial);
        if (c.isONE()) {
            return genPolynomial;
        }
        GenPolynomial<GenPolynomial<C>> genPolynomial2 = PolyUtil.baseRecursiveDivide(genPolynomial, c);
        return genPolynomial2;
    }

    public GenPolynomial<GenPolynomial<C>> recursiveGcd(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<GenPolynomial<C>> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial.ring.nvar <= 1) {
            return this.recursiveUnivariateGcd(genPolynomial, genPolynomial2);
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        RingFactory ringFactory = genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)ringFactory;
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.extend(genPolynomialRing.nvar);
        GenPolynomial genPolynomial3 = PolyUtil.distribute(genPolynomialRing3, genPolynomial);
        GenPolynomial genPolynomial4 = PolyUtil.distribute(genPolynomialRing3, genPolynomial2);
        GenPolynomial genPolynomial5 = this.gcd(genPolynomial3, genPolynomial4);
        GenPolynomial genPolynomial6 = PolyUtil.recursive(genPolynomialRing, genPolynomial5);
        return genPolynomial6;
    }

    public abstract GenPolynomial<GenPolynomial<C>> recursiveUnivariateGcd(GenPolynomial<GenPolynomial<C>> var1, GenPolynomial<GenPolynomial<C>> var2);

    @Override
    public GenPolynomial<C> content(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " use baseContent for univariate polynomials");
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomial genPolynomial2 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        GenPolynomial genPolynomial3 = this.recursiveContent(genPolynomial2);
        return genPolynomial3;
    }

    @Override
    public GenPolynomial<C> primitivePart(GenPolynomial<C> genPolynomial) {
        return this.contentPrimitivePart(genPolynomial)[1];
    }

    public GenPolynomial<C>[] contentPrimitivePart(GenPolynomial<C> genPolynomial) {
        if (genPolynomial == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " P != null");
        }
        GenPolynomial[] genPolynomialArray = new GenPolynomial[2];
        GenPolynomialRing<C> genPolynomialRing = genPolynomial.ring;
        if (genPolynomial.isZERO()) {
            genPolynomialArray[0] = genPolynomialRing.getZERO();
            genPolynomialArray[1] = genPolynomialRing.getZERO();
            return genPolynomialArray;
        }
        if (genPolynomialRing.nvar <= 1) {
            C c = this.baseContent(genPolynomial);
            GenPolynomial<C> genPolynomial2 = genPolynomial;
            if (!c.isONE()) {
                genPolynomial2 = genPolynomial.divide(c);
            }
            genPolynomialArray[0] = genPolynomialRing.valueOf(c);
            genPolynomialArray[1] = genPolynomial2;
            return genPolynomialArray;
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomial genPolynomial3 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        GenPolynomial genPolynomial4 = this.recursiveContent(genPolynomial3);
        GenPolynomial genPolynomial5 = genPolynomial3;
        if (!genPolynomial4.isONE()) {
            genPolynomial5 = PolyUtil.recursiveDivide(genPolynomial3, genPolynomial4);
        }
        GenPolynomial genPolynomial6 = PolyUtil.distribute(genPolynomialRing, genPolynomial5);
        genPolynomialArray[0] = genPolynomial4;
        genPolynomialArray[1] = genPolynomial6;
        return genPolynomialArray;
    }

    public GenPolynomial<C> divide(GenPolynomial<C> genPolynomial, C c) {
        if (c == null || c.isZERO()) {
            throw new IllegalArgumentException("division by zero");
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        return genPolynomial.divide(c);
    }

    public C gcd(C c, C c2) {
        if (c2 == null || c2.isZERO()) {
            return c;
        }
        if (c == null || c.isZERO()) {
            return c2;
        }
        return (C)((GcdRingElem)c.gcd(c2));
    }

    @Override
    public GenPolynomial<C> gcd(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial2;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            GenPolynomial<C> genPolynomial3 = this.baseGcd(genPolynomial, genPolynomial2);
            return genPolynomial3;
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        GenPolynomial genPolynomial5 = PolyUtil.recursive(genPolynomialRing2, genPolynomial2);
        GenPolynomial genPolynomial6 = this.recursiveUnivariateGcd(genPolynomial4, genPolynomial5);
        GenPolynomial genPolynomial7 = PolyUtil.distribute(genPolynomialRing, genPolynomial6);
        return genPolynomial7;
    }

    @Override
    public GenPolynomial<C> lcm(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomial<C> genPolynomial3 = this.gcd(genPolynomial, genPolynomial2);
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = genPolynomial.multiply(genPolynomial2);
        return PolyUtil.basePseudoDivide(genPolynomial4, genPolynomial3);
    }

    public GenPolynomial<C> gcd(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("A may not be empty");
        }
        GenPolynomial<C> genPolynomial = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            GenPolynomial<C> genPolynomial2 = list.get(i);
            genPolynomial = this.gcd(genPolynomial, genPolynomial2);
        }
        return genPolynomial;
    }

    public GenPolynomial<C> baseResultant(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        throw new UnsupportedOperationException("not implmented");
    }

    public GenPolynomial<GenPolynomial<C>> recursiveUnivariateResultant(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<GenPolynomial<C>> genPolynomial2) {
        throw new UnsupportedOperationException("not implmented");
    }

    public GenPolynomial<GenPolynomial<C>> recursiveResultant(GenPolynomial<GenPolynomial<C>> genPolynomial, GenPolynomial<GenPolynomial<C>> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        GenPolynomialRing genPolynomialRing2 = (GenPolynomialRing)genPolynomialRing.coFac;
        GenPolynomialRing genPolynomialRing3 = genPolynomialRing2.extend(genPolynomialRing.getVars());
        GenPolynomial genPolynomial3 = PolyUtil.distribute(genPolynomialRing3, genPolynomial);
        GenPolynomial genPolynomial4 = PolyUtil.distribute(genPolynomialRing3, genPolynomial2);
        GenPolynomial genPolynomial5 = this.resultant(genPolynomial3, genPolynomial4);
        GenPolynomial genPolynomial6 = PolyUtil.recursive(genPolynomialRing, genPolynomial5);
        return genPolynomial6;
    }

    @Override
    public GenPolynomial<C> resultant(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            return genPolynomial2;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            return genPolynomial;
        }
        GenPolynomialRing genPolynomialRing = genPolynomial.ring;
        if (genPolynomialRing.nvar <= 1) {
            return this.baseResultant(genPolynomial, genPolynomial2);
        }
        GenPolynomialRing genPolynomialRing2 = genPolynomialRing.recursive(1);
        GenPolynomial genPolynomial3 = PolyUtil.recursive(genPolynomialRing2, genPolynomial);
        GenPolynomial genPolynomial4 = PolyUtil.recursive(genPolynomialRing2, genPolynomial2);
        GenPolynomial genPolynomial5 = this.recursiveUnivariateResultant(genPolynomial3, genPolynomial4);
        GenPolynomial genPolynomial6 = PolyUtil.distribute(genPolynomialRing, genPolynomial5);
        return genPolynomial6;
    }

    @Override
    public List<GenPolynomial<C>> coPrime(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        List<GenPolynomial<C>> list2 = new ArrayList<GenPolynomial<C>>(list.size());
        AbelianGroupElem<GenPolynomial<C>> abelianGroupElem = list.get(0);
        if (!abelianGroupElem.isZERO() && !abelianGroupElem.isConstant()) {
            for (int i = 1; i < list.size(); ++i) {
                GenPolynomial<C> genPolynomial = list.get(i);
                AbelianGroupElem abelianGroupElem2 = this.gcd((GenPolynomial<C>)abelianGroupElem, genPolynomial).abs();
                if (!abelianGroupElem2.isONE()) {
                    abelianGroupElem = PolyUtil.basePseudoDivide(abelianGroupElem, abelianGroupElem2);
                    genPolynomial = PolyUtil.basePseudoDivide(genPolynomial, abelianGroupElem2);
                    AbelianGroupElem abelianGroupElem3 = this.gcd((GenPolynomial<C>)abelianGroupElem, (GenPolynomial<C>)abelianGroupElem2).abs();
                    while (!((GenPolynomial)abelianGroupElem3).isONE()) {
                        abelianGroupElem = PolyUtil.basePseudoDivide(abelianGroupElem, abelianGroupElem3);
                        abelianGroupElem2 = PolyUtil.basePseudoDivide(abelianGroupElem2, abelianGroupElem3);
                        list2.add((GenPolynomial<C>)abelianGroupElem2);
                        abelianGroupElem2 = abelianGroupElem3;
                        abelianGroupElem3 = this.gcd((GenPolynomial<C>)abelianGroupElem, (GenPolynomial<C>)abelianGroupElem3).abs();
                    }
                    if (!abelianGroupElem2.isZERO() && !abelianGroupElem2.isConstant()) {
                        list2.add((GenPolynomial<C>)abelianGroupElem2);
                    }
                }
                if (genPolynomial.isZERO() || genPolynomial.isConstant()) continue;
                list2.add(genPolynomial);
            }
        } else {
            list2.addAll(list.subList(1, list.size()));
        }
        list2 = this.coPrime(list2);
        if (!abelianGroupElem.isZERO() && !abelianGroupElem.isConstant()) {
            abelianGroupElem = abelianGroupElem.abs();
            list2.add((GenPolynomial<C>)abelianGroupElem);
        }
        return list2;
    }

    public List<GenPolynomial<C>> coPrimeRec(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        List<GenPolynomial<C>> list2 = new ArrayList<GenPolynomial<C>>();
        for (GenPolynomial<C> genPolynomial : list) {
            list2 = this.coPrime(genPolynomial, list2);
        }
        return list2;
    }

    public List<GenPolynomial<C>> coPrime(GenPolynomial<C> genPolynomial, List<GenPolynomial<C>> list) {
        if (genPolynomial == null || genPolynomial.isZERO() || genPolynomial.isConstant()) {
            return list;
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size() + 1);
        for (int i = 0; i < list.size(); ++i) {
            GenPolynomial<C> genPolynomial2 = list.get(i);
            AbelianGroupElem abelianGroupElem = this.gcd(genPolynomial, genPolynomial2).abs();
            if (!((GenPolynomial)abelianGroupElem).isONE()) {
                genPolynomial = PolyUtil.basePseudoDivide(genPolynomial, abelianGroupElem);
                genPolynomial2 = PolyUtil.basePseudoDivide(genPolynomial2, abelianGroupElem);
                AbelianGroupElem abelianGroupElem2 = this.gcd(genPolynomial, (GenPolynomial<C>)abelianGroupElem).abs();
                while (!((GenPolynomial)abelianGroupElem2).isONE()) {
                    genPolynomial = PolyUtil.basePseudoDivide(genPolynomial, abelianGroupElem2);
                    if (!((GenPolynomial)(abelianGroupElem = PolyUtil.basePseudoDivide(abelianGroupElem, abelianGroupElem2))).isZERO() && !((GenPolynomial)abelianGroupElem).isConstant()) {
                        arrayList.add((GenPolynomial<C>)abelianGroupElem);
                    }
                    abelianGroupElem = abelianGroupElem2;
                    abelianGroupElem2 = this.gcd(genPolynomial, (GenPolynomial<C>)abelianGroupElem2).abs();
                }
                abelianGroupElem2 = this.gcd(genPolynomial2, (GenPolynomial<C>)abelianGroupElem).abs();
                while (!((GenPolynomial)abelianGroupElem2).isONE()) {
                    genPolynomial2 = PolyUtil.basePseudoDivide(genPolynomial2, abelianGroupElem2);
                    if (!((GenPolynomial)(abelianGroupElem = PolyUtil.basePseudoDivide(abelianGroupElem, abelianGroupElem2))).isZERO() && !((GenPolynomial)abelianGroupElem).isConstant()) {
                        arrayList.add((GenPolynomial<C>)abelianGroupElem);
                    }
                    abelianGroupElem = abelianGroupElem2;
                    abelianGroupElem2 = this.gcd(genPolynomial2, (GenPolynomial<C>)abelianGroupElem2).abs();
                }
                if (!((GenPolynomial)abelianGroupElem).isZERO() && !((GenPolynomial)abelianGroupElem).isConstant()) {
                    arrayList.add((GenPolynomial<C>)abelianGroupElem);
                }
            }
            if (genPolynomial2.isZERO() || genPolynomial2.isConstant()) continue;
            arrayList.add(genPolynomial2);
        }
        if (!genPolynomial.isZERO() && !genPolynomial.isConstant()) {
            arrayList.add(genPolynomial);
        }
        return arrayList;
    }

    @Override
    public boolean isCoPrime(List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        if (list.size() == 1) {
            return true;
        }
        for (int i = 0; i < list.size(); ++i) {
            GenPolynomial<C> genPolynomial = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                GenPolynomial<C> genPolynomial2 = list.get(j);
                GenPolynomial<C> genPolynomial3 = this.gcd(genPolynomial, genPolynomial2);
                if (genPolynomial3.isONE()) continue;
                System.out.println("not co-prime, a: " + genPolynomial);
                System.out.println("not co-prime, b: " + genPolynomial2);
                System.out.println("not co-prime, g: " + genPolynomial3);
                return false;
            }
        }
        return true;
    }

    public boolean isCoPrime(List<GenPolynomial<C>> list, List<GenPolynomial<C>> list2) {
        if (!this.isCoPrime(list)) {
            return false;
        }
        if (list2 == null || list2.isEmpty()) {
            return true;
        }
        for (GenPolynomial<C> genPolynomial : list2) {
            if (genPolynomial.isZERO() || genPolynomial.isConstant()) continue;
            boolean bl = false;
            for (GenPolynomial<C> genPolynomial2 : list) {
                GenPolynomial<C> genPolynomial3 = PolyUtil.baseSparsePseudoRemainder(genPolynomial, genPolynomial2);
                if (!genPolynomial3.isZERO()) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            System.out.println("no divisor for: " + genPolynomial);
            return false;
        }
        return true;
    }

    public GenPolynomial<C>[] baseExtendedGcd(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        GenPolynomial<C>[] genPolynomialArray = this.baseHalfExtendedGcd(genPolynomial, genPolynomial2);
        GenPolynomial[] genPolynomialArray2 = new GenPolynomial[3];
        genPolynomialArray2[0] = genPolynomialArray[0];
        genPolynomialArray2[1] = genPolynomialArray[1];
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial3 = genPolynomialArray[0].subtract(genPolynomialArray[1].multiply(genPolynomial));
        GenPolynomial<GenPolynomial<GenPolynomial<C>>>[] genPolynomialArray3 = PolyUtil.basePseudoQuotientRemainder(genPolynomial3, genPolynomial2);
        genPolynomialArray2[2] = genPolynomialArray3[0];
        return genPolynomialArray2;
    }

    public GenPolynomial<C>[] baseHalfExtendedGcd(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
        RingElem<Object> ringElem;
        Object object;
        GenPolynomial[] genPolynomialArray = new GenPolynomial[]{null, null};
        if (genPolynomial2 == null || genPolynomial2.isZERO()) {
            genPolynomialArray[0] = genPolynomial;
            genPolynomialArray[1] = genPolynomial.ring.getONE();
            return genPolynomialArray;
        }
        if (genPolynomial == null || genPolynomial.isZERO()) {
            genPolynomialArray[0] = genPolynomial2;
            genPolynomialArray[1] = genPolynomial2.ring.getZERO();
            return genPolynomialArray;
        }
        if (genPolynomial.ring.nvar != 1) {
            throw new IllegalArgumentException(this.getClass().getName() + " not univariate polynomials " + genPolynomial.ring);
        }
        GenPolynomial genPolynomial3 = genPolynomial;
        Object object2 = genPolynomial2;
        GenPolynomial<GcdRingElem> genPolynomial4 = ((GenPolynomial)genPolynomial.ring.getONE()).copy();
        Element element = ((GenPolynomial)genPolynomial.ring.getZERO()).copy();
        while (!((GenPolynomial)object2).isZERO()) {
            object = PolyUtil.basePseudoQuotientRemainder(genPolynomial3, object2);
            genPolynomial3 = object[0];
            ringElem = genPolynomial4.subtract((GcdRingElem)((Object)genPolynomial3.multiply((GcdRingElem)element)));
            genPolynomial4 = element;
            element = ringElem;
            genPolynomial3 = object2;
            object2 = object[1];
        }
        object = (GcdRingElem)genPolynomial3.leadingBaseCoefficient();
        if (object.isUnit()) {
            ringElem = (GcdRingElem)object.inverse();
            genPolynomial3 = genPolynomial3.multiply(ringElem);
            genPolynomial4 = genPolynomial4.multiply((GcdRingElem)ringElem);
        }
        genPolynomialArray[0] = genPolynomial3;
        genPolynomialArray[1] = genPolynomial4;
        return genPolynomialArray;
    }

    public GenPolynomial<C>[] baseGcdDiophant(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, GenPolynomial<C> genPolynomial3) {
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> genPolynomial4;
        GenPolynomial<C>[] genPolynomialArray = this.baseExtendedGcd(genPolynomial, genPolynomial2);
        GenPolynomial<C> genPolynomial5 = genPolynomialArray[0];
        GenPolynomial<Object>[] genPolynomialArray2 = PolyUtil.basePseudoQuotientRemainder(genPolynomial3, genPolynomial5);
        if (!genPolynomialArray2[1].isZERO()) {
            throw new ArithmeticException("not solvable, r = " + genPolynomialArray2[1] + ", c = " + genPolynomial3 + ", g = " + genPolynomial5);
        }
        GenPolynomial<C> genPolynomial6 = genPolynomialArray2[0];
        GenPolynomial<Object> genPolynomial7 = genPolynomialArray[1].multiply(genPolynomial6);
        GenPolynomial<GenPolynomial<GenPolynomial<Object>>> genPolynomial8 = genPolynomialArray[2].multiply(genPolynomial6);
        if (!genPolynomial7.isZERO() && genPolynomial7.degree(0) >= genPolynomial2.degree(0)) {
            genPolynomialArray2 = PolyUtil.basePseudoQuotientRemainder(genPolynomial7, genPolynomial2);
            genPolynomial7 = genPolynomialArray2[1];
            genPolynomial8 = genPolynomial8.sum((GenPolynomial<GenPolynomial<Object>>)((GenPolynomial<GenPolynomial<GenPolynomial<Object>>>)genPolynomial.multiply(genPolynomialArray2[0])));
        }
        GenPolynomial[] genPolynomialArray3 = new GenPolynomial[]{genPolynomial7, genPolynomial8};
        if (debug && !(genPolynomial4 = genPolynomialArray3[0].multiply(genPolynomial).sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)genPolynomialArray3[1].multiply(genPolynomial2))).equals(genPolynomial3)) {
            System.out.println("P  = " + genPolynomial);
            System.out.println("S  = " + genPolynomial2);
            System.out.println("c  = " + genPolynomial3);
            System.out.println("a  = " + genPolynomial7);
            System.out.println("b  = " + genPolynomial8);
            System.out.println("y  = " + genPolynomial4);
            throw new ArithmeticException("not diophant, x = " + genPolynomial4.subtract((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)genPolynomial3));
        }
        return genPolynomialArray3;
    }

    public GenPolynomial<C>[] basePartialFraction(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, GenPolynomial<C> genPolynomial3) {
        GenPolynomial[] genPolynomialArray = new GenPolynomial[]{null, null, null};
        GenPolynomial<GenPolynomial<C>> genPolynomial4 = genPolynomial2.multiply(genPolynomial3);
        GenPolynomial<GenPolynomial<C>>[] genPolynomialArray2 = PolyUtil.basePseudoQuotientRemainder(genPolynomial, genPolynomial4);
        genPolynomialArray[0] = genPolynomialArray2[0];
        GenPolynomial<GenPolynomial<C>> genPolynomial5 = genPolynomialArray2[1];
        GenPolynomial<GenPolynomial<C>>[] genPolynomialArray3 = this.baseGcdDiophant(genPolynomial3, genPolynomial2, genPolynomial5);
        genPolynomialArray[1] = genPolynomialArray3[0];
        genPolynomialArray[2] = genPolynomialArray3[1];
        if (genPolynomialArray[1].degree(0) >= genPolynomial2.degree(0)) {
            genPolynomialArray2 = PolyUtil.basePseudoQuotientRemainder(genPolynomialArray[1], genPolynomial2);
            genPolynomialArray[0] = genPolynomialArray[0].sum(genPolynomialArray2[0]);
            genPolynomialArray[1] = genPolynomialArray2[1];
        }
        if (genPolynomialArray[2].degree(0) >= genPolynomial3.degree(0)) {
            genPolynomialArray2 = PolyUtil.basePseudoQuotientRemainder(genPolynomialArray[2], genPolynomial3);
            genPolynomialArray[0] = genPolynomialArray[0].sum(genPolynomialArray2[0]);
            genPolynomialArray[2] = genPolynomialArray2[1];
        }
        return genPolynomialArray;
    }

    public List<GenPolynomial<C>> basePartialFraction(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, int n) {
        if (genPolynomial == null || genPolynomial2 == null || n == 0) {
            throw new IllegalArgumentException("null A, P or e = 0 not allowed");
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(n);
        if (genPolynomial.isZERO()) {
            for (int i = 0; i < n; ++i) {
                arrayList.add(genPolynomial);
            }
            return arrayList;
        }
        if (n == 1) {
            GenPolynomial<C>[] genPolynomialArray = PolyUtil.basePseudoQuotientRemainder(genPolynomial, genPolynomial2);
            arrayList.add(genPolynomialArray[0]);
            arrayList.add(genPolynomialArray[1]);
            return arrayList;
        }
        GenPolynomial<C> genPolynomial3 = genPolynomial;
        for (int i = n; i > 0; --i) {
            GenPolynomial<C>[] genPolynomialArray = PolyUtil.basePseudoQuotientRemainder(genPolynomial3, genPolynomial2);
            genPolynomial3 = genPolynomialArray[0];
            arrayList.add(0, genPolynomialArray[1]);
        }
        arrayList.add(0, genPolynomial3);
        return arrayList;
    }

    public List<GenPolynomial<C>> basePartialFraction(GenPolynomial<C> genPolynomial, List<GenPolynomial<C>> list) {
        if (list == null || genPolynomial == null) {
            throw new IllegalArgumentException("null A or D not allowed");
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list.size() + 1);
        if (genPolynomial.isZERO() || list.size() == 0) {
            arrayList.add(genPolynomial);
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(genPolynomial);
            }
            return arrayList;
        }
        ArrayList<GenPolynomial<C>> arrayList2 = new ArrayList<GenPolynomial<C>>(list.size() - 1);
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial3 = genPolynomial.ring.getONE();
        GenPolynomial<C> genPolynomial4 = null;
        for (GenPolynomial<C> genPolynomial22 : list) {
            if (genPolynomial4 == null) {
                genPolynomial4 = genPolynomial22;
                continue;
            }
            genPolynomial3 = genPolynomial3.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial22);
            arrayList2.add(genPolynomial22);
        }
        GenPolynomial<Object>[] genPolynomialArray = PolyUtil.basePseudoQuotientRemainder(genPolynomial, genPolynomial3.multiply((GenPolynomial<GenPolynomial<C>>)genPolynomial4));
        GenPolynomial<Object> genPolynomial2 = genPolynomialArray[0];
        GenPolynomial<Object> genPolynomial5 = genPolynomialArray[1];
        if (list.size() == 1) {
            arrayList.add(genPolynomial2);
            arrayList.add(genPolynomial5);
            return arrayList;
        }
        GenPolynomial<Object>[] genPolynomialArray2 = this.baseGcdDiophant(genPolynomial3, genPolynomial4, genPolynomial5);
        GenPolynomial<Object> genPolynomial6 = genPolynomialArray2[0];
        GenPolynomial<Object> genPolynomial7 = genPolynomialArray2[1];
        List<GenPolynomial<Object>> list2 = this.basePartialFraction(genPolynomial7, arrayList2);
        GenPolynomial<GenPolynomial<Object>> genPolynomial8 = genPolynomial2.sum(list2.remove(0));
        arrayList.add(genPolynomial8);
        arrayList.add(genPolynomial6);
        arrayList.addAll(list2);
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isBasePartialFraction(GenPolynomial<C> genPolynomial, List<GenPolynomial<C>> list, List<GenPolynomial<C>> list2) {
        void var6_8;
        if (list == null || genPolynomial == null || list2 == null) {
            throw new IllegalArgumentException("null A, F or D not allowed");
        }
        if (list.size() != list2.size() - 1) {
            return false;
        }
        MonoidElem<GenPolynomial<GenPolynomial<C>>> monoidElem = genPolynomial.ring.getONE();
        for (GenPolynomial<C> genPolynomial22 : list) {
            monoidElem = ((GenPolynomial)monoidElem).multiply(genPolynomial22);
        }
        ArrayList<GenPolynomial<C>> arrayList = new ArrayList<GenPolynomial<C>>(list2);
        GenPolynomial<GenPolynomial<GenPolynomial<C>>> genPolynomial2 = ((GenPolynomial)arrayList.remove(0)).multiply(monoidElem);
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            GenPolynomial genPolynomial3 = (GenPolynomial)iterator.next();
            monoidElem = genPolynomial.ring.getONE();
            int n2 = 0;
            for (GenPolynomial<C> genPolynomial4 : list) {
                if (n2 != n) {
                    monoidElem = ((GenPolynomial)monoidElem).multiply(genPolynomial4);
                }
                ++n2;
            }
            GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> genPolynomial5 = var6_8.sum(genPolynomial3.multiply(monoidElem));
            ++n;
        }
        boolean bl = genPolynomial.equals(var6_8);
        if (!bl) {
            System.out.println("not isPartFrac = " + (GenPolynomial)var6_8);
        }
        return bl;
    }

    public boolean isBasePartialFraction(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2, int n, List<GenPolynomial<C>> list) {
        if (genPolynomial == null || genPolynomial2 == null || list == null || n == 0) {
            throw new IllegalArgumentException("null A, P, F or e = 0 not allowed");
        }
        GenPolynomial<C> genPolynomial3 = this.basePartialFractionValue(genPolynomial2, n, list);
        boolean bl = genPolynomial.equals(genPolynomial3);
        if (!bl) {
            System.out.println("not isPartFrac = " + genPolynomial3);
        }
        return bl;
    }

    public GenPolynomial<C> basePartialFractionValue(GenPolynomial<C> genPolynomial, int n, List<GenPolynomial<C>> list) {
        if (genPolynomial == null || list == null || n == 0) {
            throw new IllegalArgumentException("null P, F or e = 0 not allowed");
        }
        GenPolynomial<GenPolynomial<GenPolynomial<GenPolynomial<C>>>> genPolynomial2 = genPolynomial.ring.getZERO();
        for (GenPolynomial<C> genPolynomial3 : list) {
            genPolynomial2 = genPolynomial2.multiply((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)genPolynomial);
            genPolynomial2 = genPolynomial2.sum((GenPolynomial<GenPolynomial<GenPolynomial<C>>>)genPolynomial3);
        }
        return genPolynomial2;
    }
}

