/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.structure.ElemFactory;
import edu.jas.structure.Element;
import edu.jas.structure.RingElem;
import java.util.Map;

public final class Monomial<C extends RingElem<C>>
implements Element<Monomial<C>> {
    public final ExpVector e;
    public final C c;

    public Monomial(Map.Entry<ExpVector, C> entry) {
        this(entry.getKey(), (RingElem)entry.getValue());
    }

    public Monomial(ExpVector expVector, C c) {
        this.e = expVector;
        this.c = c;
    }

    public ExpVector exponent() {
        return this.e;
    }

    public C coefficient() {
        return this.c;
    }

    @Override
    public Monomial<C> copy() {
        return new Monomial<C>(this.e, this.c);
    }

    public String toString() {
        return this.c.toString() + " " + this.e.toString();
    }

    @Override
    public String toScript() {
        if (this.c.isZERO()) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.c.isONE()) {
            stringBuffer.append(this.c.toScript());
            if (this.e.signum() != 0) {
                stringBuffer.append(" * ");
            }
        }
        stringBuffer.append(this.e.toScript());
        return stringBuffer.toString();
    }

    @Override
    public String toScriptFactory() {
        throw new UnsupportedOperationException("no factory for Monomial");
    }

    @Override
    public ElemFactory<Monomial<C>> factory() {
        throw new UnsupportedOperationException("no factory for Monomial");
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Monomial)) {
            return false;
        }
        Monomial monomial = (Monomial)object;
        return this.compareTo(monomial) == 0;
    }

    @Override
    public int hashCode() {
        int n = this.e.hashCode();
        n = (n << 4) + this.c.hashCode();
        return n;
    }

    @Override
    public int compareTo(Monomial<C> monomial) {
        if (monomial == null) {
            return 1;
        }
        int n = this.e.compareTo(monomial.e);
        if (n != 0) {
            return n;
        }
        return this.c.compareTo(monomial.c);
    }
}

