/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigRational;
import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.gb.GroebnerBaseParallel;
import edu.jas.gb.GroebnerBaseSeq;
import edu.jas.gb.ReductionAbstract;
import edu.jas.gb.ReductionSeq;
import edu.jas.kern.ComputerThreads;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.ModuleList;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.poly.TermOrderByName;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ModGroebnerBaseTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    PolynomialList<BigRational> F;
    List<GenPolynomial<BigRational>> G;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    TermOrder tord;
    List<List<GenPolynomial<BigRational>>> L;
    List<GenPolynomial<BigRational>> V;
    ModuleList<BigRational> M;
    ModuleList<BigRational> N;
    ModuleList<BigRational> K;
    ModuleList<BigRational> I;
    GroebnerBaseAbstract<BigRational> mbb;
    ReductionAbstract<BigRational> red;
    int rl = 3;
    int kl = 7;
    int ll = 5;
    int el = 2;
    float q = 0.2f;
    BigRational coeff;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ModGroebnerBaseTest.suite());
        ComputerThreads.terminate();
    }

    public ModGroebnerBaseTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ModGroebnerBaseTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.coeff = new BigRational();
        this.tord = TermOrderByName.DEFAULT;
        this.fac = new GenPolynomialRing<BigRational>(this.coeff, this.rl, this.tord);
        this.mbb = new GroebnerBaseSeq<BigRational>();
        this.red = new ReductionSeq<BigRational>();
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        do {
            this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
            this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
            this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
            this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        } while (this.a.isZERO() || this.b.isZERO() || this.c.isZERO() || this.d.isZERO());
        this.e = this.d;
    }

    protected void tearDown() {
        this.mbb.terminate();
        this.mbb = null;
        this.red = null;
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.tord = null;
    }

    public void testSequentialModGB() {
        this.L = new ArrayList<List<GenPolynomial<BigRational>>>();
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.V.add((GenPolynomial<BigRational>)this.fac.getONE());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        ModGroebnerBaseTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.mbb.isGB(this.M));
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"is( { (a,0,1) } )", (boolean)this.mbb.isGB(this.N));
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add((GenPolynomial<BigRational>)this.fac.getONE());
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"isGB( { (a,0,1),(b,1,0) } )", (boolean)this.mbb.isGB(this.N));
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"isGB( { (a,),(b,),(c,) } )", (boolean)this.mbb.isGB(this.N));
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"isGB( { (a,b,c,d) } )", (boolean)this.mbb.isGB(this.N));
    }

    public void testParallelModGB() {
        this.mbb = new GroebnerBaseParallel<BigRational>();
        this.L = new ArrayList<List<GenPolynomial<BigRational>>>();
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.V.add((GenPolynomial<BigRational>)this.fac.getONE());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        ModGroebnerBaseTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.mbb.isGB(this.M));
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"is( { (a,0,1) } )", (boolean)this.mbb.isGB(this.N));
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add((GenPolynomial<BigRational>)this.fac.getONE());
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"isGB( { (a,0,1),(b,1,0) } )", (boolean)this.mbb.isGB(this.N));
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.c);
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"isGB( { (a,),(b,),(c,) } )", (boolean)this.mbb.isGB(this.N));
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.d);
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"isGB( { (a,b,c,d) } )", (boolean)this.mbb.isGB(this.N));
    }

    public void testSequentialModTOPGB() {
        this.L = new ArrayList<List<GenPolynomial<BigRational>>>();
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.a);
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.V.add((GenPolynomial<BigRational>)this.fac.getONE());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        ModGroebnerBaseTest.assertTrue((String)"isGB( { (a,0,1) } )", (boolean)this.mbb.isGB(this.M));
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"is( { (a,0,1) } )", (boolean)this.mbb.isGB(this.N));
        this.K = this.mbb.GB(this.M, true);
        ModGroebnerBaseTest.assertTrue((String)"is( { (a,0,1) } )", (boolean)this.mbb.isGB(this.K, true));
        ModGroebnerBaseTest.assertEquals((String)"N == K", this.N, this.K);
        this.V = new ArrayList<GenPolynomial<BigRational>>();
        this.V.add(this.b);
        this.V.add((GenPolynomial<BigRational>)this.fac.getONE());
        this.V.add((GenPolynomial<BigRational>)this.fac.getZERO());
        this.L.add(this.V);
        this.M = new ModuleList<BigRational>(this.fac, this.L);
        this.N = this.mbb.GB(this.M);
        ModGroebnerBaseTest.assertTrue((String)"isGB( { (a,0,1),(b,1,0) } )", (boolean)this.mbb.isGB(this.N));
        this.K = this.mbb.GB(this.M, true);
        ModGroebnerBaseTest.assertTrue((String)"is( { (a,0,1) } )", (boolean)this.mbb.isGB(this.K, true));
        this.I = this.red.normalform(this.K, this.N, true);
        ModGroebnerBaseTest.assertTrue((String)"K.nf(N) == (0)", (boolean)this.I.isZERO());
        this.I = this.red.normalform(this.N, this.K);
        ModGroebnerBaseTest.assertTrue((String)"N.nf(K) == (0)", (boolean)this.I.isZERO());
    }
}

