/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.arith;

import edu.jas.arith.BigInteger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BigIntegerTest
extends TestCase {
    private static final int bitlen = 100;
    BigInteger a;
    BigInteger b;
    BigInteger c;
    BigInteger d;
    BigInteger e;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)BigIntegerTest.suite());
    }

    public BigIntegerTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(BigIntegerTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
    }

    public void testConstants() {
        this.a = BigInteger.ZERO;
        this.b = BigInteger.ONE;
        this.c = BigInteger.IDIF(this.b, this.b);
        BigIntegerTest.assertEquals((String)"1-1 = 0", (Object)this.c, (Object)this.a);
        BigIntegerTest.assertTrue((String)"1-1 = 0", (boolean)this.c.isZERO());
        BigIntegerTest.assertTrue((String)"1 = 1", (boolean)this.b.isONE());
    }

    public void testBitLength() {
        this.a = BigInteger.ZERO;
        this.b = BigInteger.ONE;
        this.c = BigInteger.IDIF(this.b, this.b);
        this.d = BigInteger.IRAND(500);
        BigIntegerTest.assertEquals((String)"len(0) = 1", (long)1L, (long)this.a.bitLength());
        BigIntegerTest.assertEquals((String)"len(1) = 2", (long)2L, (long)this.b.bitLength());
        BigIntegerTest.assertEquals((String)"len(-1) = 2", (long)2L, (long)this.b.negate().bitLength());
        BigIntegerTest.assertTrue((String)"len(random) >= 1", (1L <= this.d.bitLength() ? 1 : 0) != 0);
    }

    public void testConstructor() {
        this.a = new BigInteger("34");
        this.b = new BigInteger("34");
        BigIntegerTest.assertEquals((String)"34 = 34", (Object)this.a, (Object)this.b);
        this.a = new BigInteger("-4");
        this.b = new BigInteger("-4");
        BigIntegerTest.assertEquals((String)"-4 = -4", (Object)this.a, (Object)this.b);
        String string = "1111111111111111111111111111111111111111111";
        this.a = new BigInteger(string);
        String string2 = this.a.toString();
        BigIntegerTest.assertEquals((String)"stringConstr = toString", (String)string, (String)string2);
        this.a = new BigInteger(1L);
        this.b = new BigInteger(-1L);
        this.c = BigInteger.ISUM(this.b, this.a);
        BigIntegerTest.assertTrue((String)"1 = 1", (boolean)this.a.isONE());
        BigIntegerTest.assertEquals((String)"1+(-1) = 0", (Object)this.c, (Object)BigInteger.ZERO);
    }

    public void testRandom() {
        this.a = BigInteger.IRAND(500);
        this.b = new BigInteger("" + this.a);
        this.c = BigInteger.IDIF(this.b, this.a);
        BigIntegerTest.assertEquals((String)"a-b = 0", (Object)this.c, (Object)BigInteger.ZERO);
        this.d = new BigInteger(this.b.getVal());
        BigIntegerTest.assertEquals((String)"sign(a-a) = 0", (int)0, (int)this.b.compareTo(this.d));
    }

    public void testAddition() {
        this.a = BigInteger.IRAND(100);
        this.b = BigInteger.ISUM(this.a, this.a);
        this.c = BigInteger.IDIF(this.b, this.a);
        BigIntegerTest.assertEquals((String)"a+a-a = a", (Object)this.c, (Object)this.a);
        BigIntegerTest.assertEquals((String)"a+a-a = a", (int)0, (int)this.c.compareTo(this.a));
        this.d = BigInteger.ISUM(this.a, BigInteger.ZERO);
        BigIntegerTest.assertEquals((String)"a+0 = a", (Object)this.d, (Object)this.a);
        this.d = BigInteger.IDIF(this.a, BigInteger.ZERO);
        BigIntegerTest.assertEquals((String)"a-0 = a", (Object)this.d, (Object)this.a);
        this.d = BigInteger.IDIF(this.a, this.a);
        BigIntegerTest.assertEquals((String)"a-a = 0", (Object)this.d, (Object)BigInteger.ZERO);
    }

    public void testMultiplication() {
        this.a = BigInteger.IRAND(100);
        this.b = BigInteger.IPROD(this.a, this.a);
        this.c = BigInteger.IQ(this.b, this.a);
        BigIntegerTest.assertEquals((String)"a*a/a = a", (Object)this.c, (Object)this.a);
        BigIntegerTest.assertEquals((String)"a*a/a = a", (int)0, (int)BigInteger.ICOMP(this.c, this.a));
        this.d = BigInteger.IPROD(this.a, BigInteger.ONE);
        BigIntegerTest.assertEquals((String)"a*1 = a", (Object)this.d, (Object)this.a);
        this.d = BigInteger.IQ(this.a, BigInteger.ONE);
        BigIntegerTest.assertEquals((String)"a/1 = a", (Object)this.d, (Object)this.a);
        this.a = BigInteger.IRAND(200);
        this.b = BigInteger.IRAND(100);
        BigInteger[] bigIntegerArray = BigInteger.IQR(this.a, this.b);
        this.c = BigInteger.IPROD(bigIntegerArray[0], this.b);
        this.c = BigInteger.ISUM(this.c, bigIntegerArray[1]);
        BigIntegerTest.assertEquals((String)"a = q*b+r)", (Object)this.a, (Object)this.c);
    }

    public void testDistributive() {
        BigInteger bigInteger = new BigInteger();
        this.a = bigInteger.random(100);
        this.b = bigInteger.random(100);
        this.c = bigInteger.random(100);
        this.d = this.a.multiply(this.b.sum(this.c));
        this.e = this.a.multiply(this.b).sum(this.a.multiply(this.c));
        BigIntegerTest.assertEquals((String)"a(b+c) = ab+ac", (Object)this.d, (Object)this.e);
    }

    public void testGcd() {
        this.a = BigInteger.IRAND(100);
        this.b = BigInteger.IRAND(100);
        this.c = BigInteger.IGCD(this.a, this.b);
        BigInteger[] bigIntegerArray = BigInteger.IQR(this.a, this.c);
        this.d = BigInteger.IPROD(bigIntegerArray[0], this.c);
        BigIntegerTest.assertEquals((String)"a = gcd(a,b)*q1", (Object)this.a, (Object)this.d);
        BigIntegerTest.assertEquals((String)"a/gcd(a,b) = q*x + 0", (Object)bigIntegerArray[1], (Object)BigInteger.ZERO);
        bigIntegerArray = BigInteger.IQR(this.b, this.c);
        this.d = BigInteger.IPROD(bigIntegerArray[0], this.c);
        BigIntegerTest.assertEquals((String)"b = gcd(a,b)*q1", (Object)this.b, (Object)this.d);
        BigIntegerTest.assertEquals((String)"b/gcd(a,b) = q*x + 0", (Object)bigIntegerArray[1], (Object)BigInteger.ZERO);
        this.c = BigInteger.IRAND(400);
        this.a = BigInteger.IPROD(this.a, this.c);
        this.b = BigInteger.IPROD(this.b, this.c);
        this.c = BigInteger.IGCD(this.a, this.b);
        bigIntegerArray = BigInteger.IQR(this.a, this.c);
        this.d = BigInteger.IPROD(bigIntegerArray[0], this.c);
        BigIntegerTest.assertEquals((String)"a = gcd(a,b)*q1", (Object)this.a, (Object)this.d);
        BigIntegerTest.assertEquals((String)"a/gcd(a,b) = q*x + 0", (Object)bigIntegerArray[1], (Object)BigInteger.ZERO);
        bigIntegerArray = BigInteger.IQR(this.b, this.c);
        this.d = BigInteger.IPROD(bigIntegerArray[0], this.c);
        BigIntegerTest.assertEquals((String)"b = gcd(a,b)*q1", (Object)this.b, (Object)this.d);
        BigIntegerTest.assertEquals((String)"b/gcd(a,b) = q*x + 0", (Object)bigIntegerArray[1], (Object)BigInteger.ZERO);
    }

    public void testIterator() {
        int n = 0;
        BigInteger bigInteger = new BigInteger();
        bigInteger.setAllIterator();
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        for (BigInteger bigInteger4 : bigInteger) {
            if (++n < 20) continue;
            bigInteger2 = bigInteger4;
            break;
        }
        bigInteger3 = new BigInteger(10L);
        BigIntegerTest.assertEquals((String)"j == 10 ", bigInteger2, (Object)bigInteger3);
    }

    public void testNNIterator() {
        int n = 0;
        BigInteger bigInteger = new BigInteger();
        bigInteger.setNonNegativeIterator();
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        for (BigInteger bigInteger4 : bigInteger) {
            if (++n <= 20) continue;
            bigInteger2 = bigInteger4;
            break;
        }
        bigInteger3 = new BigInteger(20L);
        BigIntegerTest.assertEquals((String)"j == 10 ", bigInteger2, (Object)bigInteger3);
    }
}

