/*
 * Decompiled with CFR 0.152.
 */
package com.sri.yices;

import com.sri.yices.BigRational;
import com.sri.yices.Constructor;
import com.sri.yices.Profiler;
import com.sri.yices.Types;
import com.sri.yices.Yices;
import com.sri.yices.YicesException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class Terms {
    public static final int NULL_TERM = -1;
    public static final int TRUE = Yices.mkTrue();
    public static final int FALSE = Yices.mkFalse();
    public static final int ZERO = Yices.zero();
    public static final int ONE = Yices.mkIntConstant(1L);
    public static final int MINUS_ONE = Yices.mkIntConstant(-1L);

    public static int mkTrue() {
        return TRUE;
    }

    public static int mkFalse() {
        return FALSE;
    }

    public static int mkBoolConst(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static int mkConst(int n, int n2) throws YicesException {
        int n3 = Yices.mkConstant(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvConst(int n, long l) throws YicesException {
        int n2 = Yices.bvConst(n, l);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int bvZero(int n) throws YicesException {
        if (n < 0) {
            throw new IllegalArgumentException("negative bitvector size");
        }
        int n2 = Yices.bvZero(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int bvOne(int n) throws YicesException {
        if (n < 0) {
            throw new IllegalArgumentException("negative bitvector size");
        }
        int n2 = Yices.bvOne(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int bvMinusOne(int n) throws YicesException {
        if (n < 0) {
            throw new IllegalArgumentException("negative bitvector size");
        }
        int n2 = Yices.bvMinusOne(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int bvConst(int ... nArray) throws YicesException {
        int n = Yices.bvConstFromIntArray(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int bvConst(List<Integer> list) throws YicesException {
        return Terms.bvConst(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int bvConst(boolean ... blArray) throws YicesException {
        int[] nArray = new int[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            nArray[i] = blArray[i] ? 1 : 0;
        }
        return Terms.bvConst(nArray);
    }

    public static int parseBvBin(String string) throws YicesException {
        int n = Yices.parseBvBin(string);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int parseBvHex(String string) throws YicesException {
        int n = Yices.parseBvHex(string);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int zero() {
        return ZERO;
    }

    public static int one() {
        return ONE;
    }

    public static int minusOne() {
        return MINUS_ONE;
    }

    public static int intConst(long l) {
        return Yices.mkIntConstant(l);
    }

    public static int intConst(BigInteger bigInteger) {
        return Yices.mkIntConstant(bigInteger);
    }

    public static int rationalConst(long l, long l2) throws YicesException {
        int n;
        if (l2 < 0L) {
            if (l2 == Long.MIN_VALUE || l == Long.MIN_VALUE) {
                throw new IllegalArgumentException("arithmetic overflow");
            }
            l2 = -l2;
            l = -l;
        }
        if ((n = Yices.mkRationalConstant(l, l2)) < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int rationalConst(BigInteger bigInteger, BigInteger bigInteger2) {
        return Yices.mkRationalConstant(bigInteger, bigInteger2);
    }

    public static int rationalConst(BigRational bigRational) {
        return Yices.mkRationalConstant(bigRational);
    }

    public static int rationalConst(BigDecimal bigDecimal) {
        return Yices.mkRationalConstant(new BigRational(bigDecimal));
    }

    public static int parseRational(String string) throws YicesException {
        int n = Yices.parseRational(string);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int parseFloat(String string) throws YicesException {
        int n = Yices.parseFloat(string);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int newUninterpretedTerm(int n) throws YicesException {
        int n2 = Yices.newUninterpretedTerm(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int newUninterpretedFunction(int ... nArray) throws YicesException {
        return Terms.newUninterpretedTerm(Types.functionType(nArray));
    }

    public static int newUninterpretedFunction(List<Integer> list) throws YicesException {
        return Terms.newUninterpretedFunction(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int newUninterpretedPredicate(int ... nArray) throws YicesException {
        return Terms.newUninterpretedTerm(Types.predicateType(nArray));
    }

    public static int newUninterpretedPredicate(List<Integer> list) throws YicesException {
        return Terms.newUninterpretedPredicate(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int newUninterpretedTerm(String string, int n) throws YicesException {
        int n2 = Terms.newUninterpretedTerm(n);
        Yices.setTermName(n2, string);
        return n2;
    }

    public static int newUninterpretedFunction(String string, int ... nArray) throws YicesException {
        int n = Terms.newUninterpretedFunction(nArray);
        Yices.setTermName(n, string);
        return n;
    }

    public static int newUninterpretedFunction(String string, List<Integer> list) throws YicesException {
        return Terms.newUninterpretedFunction(string, list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int newUninterpretedPredicate(String string, int ... nArray) throws YicesException {
        int n = Terms.newUninterpretedPredicate(nArray);
        Yices.setTermName(n, string);
        return n;
    }

    public static int newUninterpretedPredicate(String string, List<Integer> list) throws YicesException {
        return Terms.newUninterpretedPredicate(string, list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static void declareUninterpretedTerm(String string, int n) throws YicesException {
        Yices.setTermName(Terms.newUninterpretedTerm(n), string);
    }

    public static void declareUninterpretedFunction(String string, int ... nArray) throws YicesException {
        Yices.setTermName(Terms.newUninterpretedFunction(nArray), string);
    }

    public static void declareUninterpretedFunction(String string, List<Integer> list) throws YicesException {
        Terms.declareUninterpretedFunction(string, list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static void declareUninterpretedPredicate(String string, int ... nArray) throws YicesException {
        Yices.setTermName(Terms.newUninterpretedPredicate(nArray), string);
    }

    public static void declareUninterpretedPredicate(String string, List<Integer> list) throws YicesException {
        Terms.declareUninterpretedPredicate(string, list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int newVariable(int n) throws YicesException {
        int n2 = Yices.newVariable(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int newVariable(String string, int n) throws YicesException {
        int n2 = Terms.newVariable(n);
        Yices.setTermName(n2, string);
        return n2;
    }

    public static void declareVariable(String string, int n) throws YicesException {
        Yices.setTermName(Terms.newVariable(n), string);
    }

    public static int ifThenElse(int n, int n2, int n3) throws YicesException {
        int n4 = Yices.ifThenElse(n, n2, n3);
        if (n4 < 0) {
            throw new YicesException();
        }
        return n4;
    }

    public static int eq(int n, int n2) throws YicesException {
        int n3 = Yices.eq(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int neq(int n, int n2) throws YicesException {
        int n3 = Yices.neq(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int distinct(int ... nArray) throws YicesException {
        int n = Yices.distinct(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int distinct(List<Integer> list) throws YicesException {
        return Terms.distinct(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int forall(int[] nArray, int n) throws YicesException {
        int n2 = Yices.forall(nArray, n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int forall(List<Integer> list, int n) throws YicesException {
        int[] nArray = list.stream().mapToInt(Integer::intValue).toArray();
        int n2 = Yices.forall(nArray, n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int exists(int[] nArray, int n) throws YicesException {
        int n2 = Yices.exists(nArray, n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int exists(List<Integer> list, int n) throws YicesException {
        int[] nArray = list.stream().mapToInt(Integer::intValue).toArray();
        int n2 = Yices.exists(nArray, n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int lambda(int[] nArray, int n) throws YicesException {
        int n2 = Yices.lambda(nArray, n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int lambda(List<Integer> list, int n) throws YicesException {
        int[] nArray = list.stream().mapToInt(Integer::intValue).toArray();
        int n2 = Yices.lambda(nArray, n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int tuple(int ... nArray) throws YicesException {
        int n = Yices.tuple(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int tuple(List<Integer> list) throws YicesException {
        return Terms.tuple(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int select(int n, int n2) throws YicesException {
        int n3 = Yices.select(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int tupleUpdate(int n, int n2, int n3) throws YicesException {
        int n4 = Yices.tupleUpdate(n, n2, n3);
        if (n4 < 0) {
            throw new YicesException();
        }
        return n4;
    }

    public static int funApplication(int n, int ... nArray) throws YicesException {
        int n2;
        if (Profiler.enabled) {
            long l = System.nanoTime();
            n2 = Yices.funApplication(n, nArray);
            long l2 = System.nanoTime();
            Profiler.delta("Yices.funApplication", l, l2);
        } else {
            n2 = Yices.funApplication(n, nArray);
        }
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int funApplication(int n, List<Integer> list) throws YicesException {
        return Terms.funApplication(n, list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int functionUpdate(int n, int[] nArray, int n2) throws YicesException {
        int n3 = Yices.functionUpdate(n, nArray, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int functionUpdate(int n, List<Integer> list, int n2) throws YicesException {
        int n3 = Yices.functionUpdate(n, list.stream().mapToInt(Integer::intValue).toArray(), n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int functionUpdate1(int n, int n2, int n3) throws YicesException {
        int n4 = Yices.functionUpdate1(n, n2, n3);
        if (n4 < 0) {
            throw new YicesException();
        }
        return n4;
    }

    public static int not(int n) throws YicesException {
        int n2 = Yices.not(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int and(int ... nArray) throws YicesException {
        int n = Yices.and(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int and(List<Integer> list) throws YicesException {
        return Terms.and(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int or(int ... nArray) throws YicesException {
        int n = Yices.or(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int or(List<Integer> list) throws YicesException {
        return Terms.or(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int xor(int ... nArray) throws YicesException {
        int n = Yices.xor(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int xor(List<Integer> list) throws YicesException {
        return Terms.xor(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int iff(int n, int n2) throws YicesException {
        int n3 = Yices.iff(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int implies(int n, int n2) throws YicesException {
        int n3 = Yices.implies(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int add(int n, int n2) throws YicesException {
        int n3 = Yices.add(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int sub(int n, int n2) throws YicesException {
        int n3 = Yices.sub(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int neg(int n) throws YicesException {
        int n2 = Yices.neg(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int mul(int n, int n2) throws YicesException {
        int n3 = Yices.mul(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int square(int n) throws YicesException {
        int n2 = Yices.square(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int power(int n, int n2) throws YicesException {
        if (n2 < 0) {
            throw new IllegalArgumentException("exponent can't be negative");
        }
        int n3 = Yices.power(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int add(int ... nArray) throws YicesException {
        int n = Yices.add(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int add(List<Integer> list) throws YicesException {
        return Terms.add(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int mul(int ... nArray) throws YicesException {
        int n = Yices.mul(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int mul(List<Integer> list) throws YicesException {
        return Terms.mul(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int div(int n, int n2) throws YicesException {
        int n3 = Yices.div(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int idiv(int n, int n2) throws YicesException {
        int n3 = Yices.idiv(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int imod(int n, int n2) throws YicesException {
        int n3 = Yices.imod(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int abs(int n) throws YicesException {
        int n2 = Yices.abs(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int floor(int n) throws YicesException {
        int n2 = Yices.floor(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int ceil(int n) throws YicesException {
        int n2 = Yices.ceil(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int intPoly(long[] lArray, int[] nArray) throws YicesException {
        if (lArray.length != nArray.length) {
            throw new IllegalArgumentException("coeff and term arrays must have the same length");
        }
        int n = Yices.intPoly(lArray, nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int intPoly(List<Long> list, List<Integer> list2) throws YicesException {
        long[] lArray = list.stream().mapToLong(Long::longValue).toArray();
        int[] nArray = list2.stream().mapToInt(Integer::intValue).toArray();
        return Terms.intPoly(lArray, nArray);
    }

    public static int rationalPoly(long[] lArray, long[] lArray2, int[] nArray) throws YicesException {
        if (lArray.length != lArray2.length || lArray.length != nArray.length) {
            throw new IllegalArgumentException("coeff and term arrays must have the same length");
        }
        int n = Yices.rationalPoly(lArray, lArray2, nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int rationalPoly(List<Long> list, List<Long> list2, List<Integer> list3) throws YicesException {
        long[] lArray = list.stream().mapToLong(Long::longValue).toArray();
        long[] lArray2 = list2.stream().mapToLong(Long::longValue).toArray();
        int[] nArray = list3.stream().mapToInt(Integer::intValue).toArray();
        return Terms.rationalPoly(lArray, lArray2, nArray);
    }

    public static int divides(int n, int n2) throws YicesException {
        int n3 = Yices.divides(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int isInt(int n) throws YicesException {
        int n2 = Yices.isInt(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int arithEq(int n, int n2) throws YicesException {
        int n3 = Yices.arithEq(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int arithNeq(int n, int n2) throws YicesException {
        int n3 = Yices.arithNeq(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int arithGeq(int n, int n2) throws YicesException {
        int n3 = Yices.arithGeq(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int arithLeq(int n, int n2) throws YicesException {
        int n3 = Yices.arithLeq(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int arithGt(int n, int n2) throws YicesException {
        int n3 = Yices.arithGt(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int arithLt(int n, int n2) throws YicesException {
        int n3 = Yices.arithLt(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int arithEq0(int n) throws YicesException {
        int n2 = Yices.arithEq0(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int arithNeq0(int n) throws YicesException {
        int n2 = Yices.arithNeq0(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int arithGeq0(int n) throws YicesException {
        int n2 = Yices.arithGeq0(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int arithLeq0(int n) throws YicesException {
        int n2 = Yices.arithLeq0(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int arithGt0(int n) throws YicesException {
        int n2 = Yices.arithGt0(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int arithLt0(int n) throws YicesException {
        int n2 = Yices.arithLt0(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int bvAdd(int n, int n2) throws YicesException {
        int n3 = Yices.bvAdd(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvSub(int n, int n2) throws YicesException {
        int n3 = Yices.bvSub(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvNeg(int n) throws YicesException {
        int n2 = Yices.bvNeg(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int bvMul(int n, int n2) throws YicesException {
        int n3 = Yices.bvMul(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvSquare(int n) throws YicesException {
        int n2 = Yices.bvSquare(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int bvPower(int n, int n2) throws YicesException {
        if (n2 < 0) {
            throw new IllegalArgumentException("exponent can't be negative");
        }
        int n3 = Yices.bvPower(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvDiv(int n, int n2) throws YicesException {
        int n3 = Yices.bvDiv(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvRem(int n, int n2) throws YicesException {
        int n3 = Yices.bvRem(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvSDiv(int n, int n2) throws YicesException {
        int n3 = Yices.bvSDiv(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvSRem(int n, int n2) throws YicesException {
        int n3 = Yices.bvSRem(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvSMod(int n, int n2) throws YicesException {
        int n3 = Yices.bvSMod(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvNot(int n) throws YicesException {
        int n2 = Yices.bvNot(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int bvAnd(int n, int n2) throws YicesException {
        int n3 = Yices.bvAnd(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvOr(int n, int n2) throws YicesException {
        int n3 = Yices.bvOr(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvXor(int n, int n2) throws YicesException {
        int n3 = Yices.bvXor(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvNand(int n, int n2) throws YicesException {
        int n3 = Yices.bvNand(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvNor(int n, int n2) throws YicesException {
        int n3 = Yices.bvNor(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvXNor(int n, int n2) throws YicesException {
        int n3 = Yices.bvXNor(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvShl(int n, int n2) throws YicesException {
        int n3 = Yices.bvShl(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvLshr(int n, int n2) throws YicesException {
        int n3 = Yices.bvLshr(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvAshr(int n, int n2) throws YicesException {
        int n3 = Yices.bvAshr(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvAdd(int ... nArray) throws YicesException {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("empty input");
        }
        int n = Yices.bvAdd(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int bvAdd(List<Integer> list) throws YicesException {
        return Terms.bvAdd(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int bvAnd(int ... nArray) throws YicesException {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("empty input");
        }
        int n = Yices.bvAnd(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int bvAnd(List<Integer> list) throws YicesException {
        return Terms.bvAnd(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int bvOr(int ... nArray) throws YicesException {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("empty input");
        }
        int n = Yices.bvOr(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int bvOr(List<Integer> list) throws YicesException {
        return Terms.bvOr(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int bvXor(int ... nArray) throws YicesException {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("empty input");
        }
        int n = Yices.bvXor(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int bvXor(List<Integer> list) throws YicesException {
        return Terms.bvXor(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int bvShiftLeft0(int n, int n2) throws YicesException {
        if (n2 < 0) {
            throw new IllegalArgumentException("shift amount can't be negative");
        }
        int n3 = Yices.bvShiftLeft0(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvShiftLeft1(int n, int n2) throws YicesException {
        if (n2 < 0) {
            throw new IllegalArgumentException("shift amount can't be negative");
        }
        int n3 = Yices.bvShiftLeft1(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvShiftRight0(int n, int n2) throws YicesException {
        if (n2 < 0) {
            throw new IllegalArgumentException("shift amount can't be negative");
        }
        int n3 = Yices.bvShiftRight0(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvShiftRight1(int n, int n2) throws YicesException {
        if (n2 < 0) {
            throw new IllegalArgumentException("shift amount can't be negative");
        }
        int n3 = Yices.bvShiftRight1(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvAShiftRight(int n, int n2) throws YicesException {
        if (n2 < 0) {
            throw new IllegalArgumentException("shift amount can't be negative");
        }
        int n3 = Yices.bvAShiftRight(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvRotateLeft(int n, int n2) throws YicesException {
        if (n2 < 0) {
            throw new IllegalArgumentException("shift amount can't be negative");
        }
        int n3 = Yices.bvRotateLeft(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvRotateRight(int n, int n2) throws YicesException {
        if (n2 < 0) {
            throw new IllegalArgumentException("shift amount can't be negative");
        }
        int n3 = Yices.bvRotateRight(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvExtract(int n, int n2, int n3) throws YicesException {
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("negative bit-vector index");
        }
        int n4 = Yices.bvExtract(n, n2, n3);
        if (n4 < 0) {
            throw new YicesException();
        }
        return n4;
    }

    public static int bvExtractBit(int n, int n2) throws YicesException {
        if (n2 < 0) {
            throw new IllegalArgumentException("negative bit-vector index");
        }
        int n3 = Yices.bvExtractBit(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvFromBoolArray(int ... nArray) throws YicesException {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("empty boolean array");
        }
        int n = Yices.bvFromBoolArray(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int bvFromBoolArray(List<Integer> list) throws YicesException {
        return Terms.bvFromBoolArray(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int bvConcat(int n, int n2) throws YicesException {
        int n3 = Yices.bvConcat(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvConcat(int ... nArray) throws YicesException {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("empty input");
        }
        int n = Yices.bvConcat(nArray);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int bvConcat(List<Integer> list) throws YicesException {
        return Terms.bvConcat(list.stream().mapToInt(Integer::intValue).toArray());
    }

    public static int bvRepeat(int n, int n2) throws YicesException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        int n3 = Yices.bvRepeat(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvSignExtend(int n, int n2) throws YicesException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        int n3 = Yices.bvSignExtend(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvZeroExtend(int n, int n2) throws YicesException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        int n3 = Yices.bvZeroExtend(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvRedAnd(int n) throws YicesException {
        int n2 = Yices.bvRedAnd(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int bvRedOr(int n) throws YicesException {
        int n2 = Yices.bvRedOr(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int bvRedComp(int n, int n2) throws YicesException {
        int n3 = Yices.bvRedComp(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvEq(int n, int n2) throws YicesException {
        int n3 = Yices.bvEq(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvNeq(int n, int n2) throws YicesException {
        int n3 = Yices.bvNeq(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvGe(int n, int n2) throws YicesException {
        int n3 = Yices.bvGe(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvGt(int n, int n2) throws YicesException {
        int n3 = Yices.bvGt(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvLe(int n, int n2) throws YicesException {
        int n3 = Yices.bvLe(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvLt(int n, int n2) throws YicesException {
        int n3 = Yices.bvLt(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvSGe(int n, int n2) throws YicesException {
        int n3 = Yices.bvSGe(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvSGt(int n, int n2) throws YicesException {
        int n3 = Yices.bvSGt(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvSLe(int n, int n2) throws YicesException {
        int n3 = Yices.bvSLe(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int bvSLt(int n, int n2) throws YicesException {
        int n3 = Yices.bvSLt(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int typeOf(int n) throws YicesException {
        int n2 = Yices.typeOfTerm(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static boolean isBool(int n) {
        return Yices.termIsBool(n);
    }

    public static boolean isInteger(int n) {
        return Yices.termIsInt(n);
    }

    public static boolean isReal(int n) {
        return Yices.termIsReal(n);
    }

    public static boolean isArithmetic(int n) {
        return Yices.termIsArithmetic(n);
    }

    public static boolean isBitvector(int n) {
        boolean bl;
        if (Profiler.enabled) {
            long l = System.nanoTime();
            bl = Yices.termIsBitvector(n);
            long l2 = System.nanoTime();
            Profiler.delta("Yices.termIsBitvector", l, l2);
        } else {
            bl = Yices.termIsBitvector(n);
        }
        return bl;
    }

    public static boolean isTuple(int n) {
        return Yices.termIsTuple(n);
    }

    public static boolean isFunction(int n) {
        return Yices.termIsFunction(n);
    }

    public static boolean isScalar(int n) {
        return Yices.termIsScalar(n);
    }

    public static int bitSize(int n) throws YicesException {
        int n2 = Yices.termBitSize(n);
        if (n2 == 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static boolean isGround(int n) {
        return Yices.termIsGround(n);
    }

    public static boolean isAtomic(int n) {
        return Yices.termIsAtomic(n);
    }

    public static boolean isComposite(int n) {
        return Yices.termIsComposite(n);
    }

    public static boolean isProjection(int n) {
        return Yices.termIsProjection(n);
    }

    public static boolean isSum(int n) {
        return Yices.termIsSum(n);
    }

    public static boolean isBvSum(int n) {
        return Yices.termIsBvSum(n);
    }

    public static boolean isProduct(int n) {
        return Yices.termIsProduct(n);
    }

    public static Constructor constructor(int n) {
        return Constructor.idToConstructor(Yices.termConstructor(n));
    }

    public static int numChildren(int n) throws YicesException {
        int n2 = Yices.termNumChildren(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int[] children(int n) throws YicesException {
        int[] nArray = Yices.termChildren(n);
        if (nArray == null) {
            throw new YicesException();
        }
        return nArray;
    }

    public static int child(int n, int n2) throws YicesException {
        int n3 = Yices.termChild(n, n2);
        if (n3 < 0) {
            throw new YicesException();
        }
        return n3;
    }

    public static int projIndex(int n) throws YicesException {
        int n2 = Yices.termProjIndex(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int projArg(int n) throws YicesException {
        int n2 = Yices.termProjArg(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static boolean isBoolConstant(int n) throws YicesException {
        return Terms.constructor(n) == Constructor.BOOL_CONSTANT;
    }

    public static boolean isArithConstant(int n) throws YicesException {
        return Terms.constructor(n) == Constructor.ARITH_CONSTANT;
    }

    public static boolean isBvConstant(int n) throws YicesException {
        return Terms.constructor(n) == Constructor.BV_CONSTANT;
    }

    public static boolean isScalarConstant(int n) throws YicesException {
        return Terms.constructor(n) == Constructor.SCALAR_CONSTANT;
    }

    public static boolean isUninterpreted(int n) throws YicesException {
        return Terms.constructor(n) == Constructor.UNINTERPRETED_TERM;
    }

    public static boolean boolConstValue(int n) throws YicesException {
        int n2 = Yices.boolConstValue(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2 != 0;
    }

    public static int scalarConstantIndex(int n) throws YicesException {
        int n2 = Yices.scalarConstantIndex(n);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static boolean[] bvConstValue(int n) throws YicesException {
        boolean[] blArray = Yices.bvConstValue(n);
        if (blArray == null) {
            throw new YicesException();
        }
        return blArray;
    }

    public static BigRational arithConstValue(int n) throws YicesException {
        BigRational bigRational = Yices.rationalConstValue(n);
        if (bigRational == null) {
            throw new YicesException();
        }
        return bigRational;
    }

    public static long arithConstLongValue(int n) throws YicesException {
        BigRational bigRational = Terms.arithConstValue(n);
        if (!bigRational.fitsLong()) {
            throw new IllegalArgumentException("Yices constant can't be converted to long");
        }
        return bigRational.longValue();
    }

    public static int arithConstIntValue(int n) throws YicesException {
        BigRational bigRational = Terms.arithConstValue(n);
        if (!bigRational.fitsInt()) {
            throw new IllegalArgumentException("Yices constant can't be converted to int");
        }
        return bigRational.intValue();
    }

    public static void setName(int n, String string) throws YicesException {
        int n2 = Yices.setTermName(n, string);
        if (n2 < 0) {
            throw new YicesException();
        }
    }

    public static String getName(int n) {
        return Yices.getTermName(n);
    }

    public static int getByName(String string) {
        return Yices.getTermByName(string);
    }

    public static void removeName(String string) {
        Yices.removeTermName(string);
    }

    public static String toString(int n) throws YicesException {
        String string = Yices.termToString(n);
        if (string == null) {
            throw new YicesException();
        }
        return string;
    }

    public static String toString(int n, int n2, int n3) throws YicesException {
        String string = Yices.termToString(n, n2, n3);
        if (string == null) {
            throw new YicesException();
        }
        return string;
    }

    public static int parse(String string) throws YicesException {
        int n = Yices.parseTerm(string);
        if (n < 0) {
            throw new YicesException();
        }
        return n;
    }

    public static int subst(int n, int[] nArray, int[] nArray2) throws YicesException {
        if (nArray.length != nArray2.length) {
            throw new IllegalArgumentException("bad substitution");
        }
        int n2 = Yices.substTerm(n, nArray, nArray2);
        if (n2 < 0) {
            throw new YicesException();
        }
        return n2;
    }

    public static int subst(int n, List<Integer> list, List<Integer> list2) throws YicesException {
        int[] nArray = list.stream().mapToInt(Integer::intValue).toArray();
        int[] nArray2 = list2.stream().mapToInt(Integer::intValue).toArray();
        return Terms.subst(n, nArray, nArray2);
    }

    public static void substArray(int[] nArray, int[] nArray2, int[] nArray3) throws YicesException {
        if (nArray2.length != nArray3.length) {
            throw new IllegalArgumentException("bad substitution");
        }
        int n = Yices.substTermArray(nArray, nArray2, nArray3);
        if (n < 0) {
            throw new YicesException();
        }
    }

    public static void substArray(List<Integer> list, List<Integer> list2, List<Integer> list3) throws YicesException {
        int[] nArray = list.stream().mapToInt(Integer::intValue).toArray();
        int[] nArray2 = list2.stream().mapToInt(Integer::intValue).toArray();
        int[] nArray3 = list3.stream().mapToInt(Integer::intValue).toArray();
        Terms.substArray(nArray, nArray2, nArray3);
        for (int i = 0; i < nArray.length; ++i) {
            list.set(i, nArray[i]);
        }
    }
}

