/*
 * Decompiled with CFR 0.152.
 */
package parma_polyhedra_library;

import javax.management.RuntimeErrorException;
import parma_polyhedra_library.Coefficient;
import parma_polyhedra_library.Grid_Generator_Type;
import parma_polyhedra_library.Linear_Expression;

public class Grid_Generator {
    private Grid_Generator_Type gt;
    private Linear_Expression le;
    private Coefficient div;

    private Grid_Generator(Linear_Expression linear_Expression, Coefficient coefficient, Grid_Generator_Type grid_Generator_Type) {
        this.le = linear_Expression.clone();
        this.div = new Coefficient(coefficient);
        this.gt = grid_Generator_Type;
    }

    public static Grid_Generator grid_line(Linear_Expression linear_Expression) {
        return new Grid_Generator(linear_Expression, new Coefficient(0), Grid_Generator_Type.LINE);
    }

    public static Grid_Generator parameter(Linear_Expression linear_Expression, Coefficient coefficient) {
        return new Grid_Generator(linear_Expression, coefficient, Grid_Generator_Type.PARAMETER);
    }

    public static Grid_Generator grid_point(Linear_Expression linear_Expression, Coefficient coefficient) {
        return new Grid_Generator(linear_Expression, coefficient, Grid_Generator_Type.POINT);
    }

    public Grid_Generator_Type type() {
        return this.gt;
    }

    public Linear_Expression linear_expression() {
        return this.le;
    }

    public Coefficient divisor() {
        if (this.gt != Grid_Generator_Type.LINE) {
            return this.div;
        }
        Error error = new Error("parma_polyhedra_library.Grid_Generator::divisor:\nthis is neither a grid point nor a parameter.");
        throw new RuntimeErrorException(error);
    }

    public native String ascii_dump();

    public native String toString();

    private static native void initIDs();

    static {
        Grid_Generator.initIDs();
    }
}

