/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.fd;

import edu.jas.fd.GreatestCommonDivisorAbstract;
import edu.jas.gb.SolvableGroebnerBaseSeq;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenSolvablePolynomial;
import edu.jas.structure.GcdRingElem;
import edu.jas.structure.RingFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GreatestCommonDivisorSyzygy<C extends GcdRingElem<C>>
extends GreatestCommonDivisorAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GreatestCommonDivisorSyzygy.class);
    private static final boolean debug = true;

    public GreatestCommonDivisorSyzygy(RingFactory<C> ringFactory) {
        super(ringFactory);
    }

    @Override
    public GenSolvablePolynomial<C> leftBaseGcd(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        return this.leftGcd(genSolvablePolynomial, genSolvablePolynomial2);
    }

    @Override
    public GenSolvablePolynomial<C> rightBaseGcd(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        return this.rightGcd(genSolvablePolynomial, genSolvablePolynomial2);
    }

    @Override
    public GenSolvablePolynomial<C> leftGcd(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.isConstant()) {
            return genSolvablePolynomial.ring.getONE();
        }
        if (genSolvablePolynomial2.isConstant()) {
            return genSolvablePolynomial.ring.getONE();
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(genSolvablePolynomial);
        arrayList.add(genSolvablePolynomial2);
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq();
        logger.info("left syzGcd computing GB: " + arrayList);
        List list = solvableGroebnerBaseSeq.rightGB(arrayList);
        logger.info("G = " + list);
        if (list.size() == 1) {
            return list.get(0);
        }
        logger.info("gcd not determined, set to 1: " + list);
        return genSolvablePolynomial.ring.getONE();
    }

    @Override
    public GenSolvablePolynomial<C> rightGcd(GenSolvablePolynomial<C> genSolvablePolynomial, GenSolvablePolynomial<C> genSolvablePolynomial2) {
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.isConstant()) {
            return genSolvablePolynomial.ring.getONE();
        }
        if (genSolvablePolynomial2.isConstant()) {
            return genSolvablePolynomial.ring.getONE();
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(genSolvablePolynomial);
        arrayList.add(genSolvablePolynomial2);
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq();
        logger.info("left syzGcd computing GB: " + arrayList);
        List list = solvableGroebnerBaseSeq.leftGB(arrayList);
        logger.info("G = " + list);
        if (list.size() == 1) {
            return list.get(0);
        }
        logger.info("gcd not determined, set to 1: " + list);
        return genSolvablePolynomial.ring.getONE();
    }

    @Override
    public GenSolvablePolynomial<GenPolynomial<C>> leftRecursiveUnivariateGcd(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.ring.nvar > 1) {
            throw new IllegalArgumentException("no univariate polynomial");
        }
        if (genSolvablePolynomial.isConstant()) {
            return genSolvablePolynomial.ring.getONE();
        }
        if (genSolvablePolynomial2.isConstant()) {
            return genSolvablePolynomial.ring.getONE();
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(genSolvablePolynomial);
        arrayList.add(genSolvablePolynomial2);
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq();
        logger.info("left syzGcd computing GB: " + arrayList);
        List list = solvableGroebnerBaseSeq.rightGB(arrayList);
        logger.info("G = " + list);
        if (list.size() == 1) {
            return list.get(0);
        }
        logger.info("gcd not determined, set to 1: " + list);
        return genSolvablePolynomial.ring.getONE();
    }

    @Override
    public GenSolvablePolynomial<GenPolynomial<C>> rightRecursiveUnivariateGcd(GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial, GenSolvablePolynomial<GenPolynomial<C>> genSolvablePolynomial2) {
        if (genSolvablePolynomial2 == null || genSolvablePolynomial2.isZERO()) {
            return genSolvablePolynomial;
        }
        if (genSolvablePolynomial == null || genSolvablePolynomial.isZERO()) {
            return genSolvablePolynomial2;
        }
        if (genSolvablePolynomial.ring.nvar > 1) {
            throw new IllegalArgumentException("no univariate polynomial");
        }
        if (genSolvablePolynomial.isConstant()) {
            return genSolvablePolynomial.ring.getONE();
        }
        if (genSolvablePolynomial2.isConstant()) {
            return genSolvablePolynomial.ring.getONE();
        }
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(genSolvablePolynomial);
        arrayList.add(genSolvablePolynomial2);
        SolvableGroebnerBaseSeq solvableGroebnerBaseSeq = new SolvableGroebnerBaseSeq();
        logger.info("right syzGcd computing GB: " + arrayList);
        List list = solvableGroebnerBaseSeq.leftGB(arrayList);
        logger.info("G = " + list);
        if (list.size() == 1) {
            return list.get(0);
        }
        logger.info("gcd not determined, set to 1: " + list);
        return genSolvablePolynomial.ring.getONE();
    }
}

