/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import parser.type.Type;
import prism.PrismException;
import prism.UndefinedConstants;
import userinterface.GUIPrism;
import userinterface.properties.ConstantHeader;
import userinterface.properties.ConstantLine;
import userinterface.properties.ConstantPickerList;

public class GUIExperimentPicker
extends JDialog {
    public static final int NO_VALUES = 0;
    public static final int VALUES_DONE = 1;
    public static final int CANCELLED = 2;
    public static final int VALUES_DONE_SHOW_GRAPH = 3;
    public static final int VALUES_DONE_SHOW_GRAPH_AND_SIMULATE = 4;
    public static final int VALUES_DONE_SIMULATE = 5;
    static ArrayList remember;
    static boolean lastGraph;
    static boolean lastSimulation;
    private boolean cancelled = true;
    private ConstantPickerList propTable;
    private ConstantPickerList modelTable;
    private boolean areModel;
    private boolean areProp;
    private Action okAction;
    private Action cancelAction;
    private JButton okayButton;
    private UndefinedConstants undef;
    private GUIPrism gui;
    JCheckBox createGraphCheck;
    JPanel topPanel;
    JCheckBox useSimulationCheck;

    public GUIExperimentPicker(GUIPrism gUIPrism, UndefinedConstants undefinedConstants, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(gUIPrism, "Define Constants", true);
        this.areModel = bl;
        this.areProp = bl2;
        this.undef = undefinedConstants;
        this.gui = gUIPrism;
        this.propTable = new ConstantPickerList();
        this.modelTable = new ConstantPickerList();
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okayButton);
        if (bl3) {
            this.createGraphCheck.setEnabled(true);
            this.createGraphCheck.setSelected(lastGraph);
        } else {
            this.createGraphCheck.setEnabled(false);
            this.createGraphCheck.setSelected(false);
        }
        if (bl4) {
            this.useSimulationCheck.setEnabled(true);
            this.useSimulationCheck.setSelected(lastSimulation);
        } else {
            this.useSimulationCheck.setEnabled(false);
            this.useSimulationCheck.setSelected(false);
        }
        this.initTables(bl, bl2);
        this.initValues(undefinedConstants);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JLabel jLabel = new JLabel();
        this.topPanel = new JPanel();
        this.createGraphCheck = new JCheckBox();
        this.useSimulationCheck = new JCheckBox();
        JPanel jPanel6 = new JPanel();
        this.okayButton = new JButton();
        JButton jButton = new JButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUIExperimentPicker.this.closeDialog(windowEvent);
            }
        });
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        jPanel.add((Component)jPanel5, gridBagConstraints);
        jLabel.setText("Please define the following constants:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.topPanel, gridBagConstraints);
        this.createGraphCheck.setText("Create Graph");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.createGraphCheck, gridBagConstraints);
        this.useSimulationCheck.setText("Use Simulation");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.useSimulationCheck, gridBagConstraints);
        this.getContentPane().add((Component)jPanel, "Center");
        jPanel6.setLayout(new FlowLayout(2));
        this.okayButton.setText("Okay");
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIExperimentPicker.this.okayButtonActionPerformed(actionEvent);
            }
        });
        jPanel6.add(this.okayButton);
        jButton.setText("Cancel");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIExperimentPicker.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        jPanel6.add(jButton);
        this.getContentPane().add((Component)jPanel6, "South");
        this.pack();
    }

    private void initTables(boolean bl, boolean bl2) {
        if (bl && bl2) {
            this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
            JPanel jPanel = new JPanel();
            jPanel.setBorder(new TitledBorder("Model Constants"));
            jPanel.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.modelTable);
            jPanel.add(jScrollPane);
            jPanel.add((Component)new ConstantHeader(), "North");
            JPanel jPanel2 = new JPanel();
            jPanel2.setBorder(new TitledBorder("Property Constants"));
            jPanel2.setLayout(new BorderLayout());
            JScrollPane jScrollPane2 = new JScrollPane();
            jScrollPane2.setViewportView(this.propTable);
            jPanel2.add(jScrollPane2);
            jPanel2.add((Component)new ConstantHeader(), "North");
            this.topPanel.add(jPanel);
            this.topPanel.add(jPanel2);
        } else if (bl) {
            this.topPanel.setBorder(new TitledBorder("Model Constants"));
            this.topPanel.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.modelTable);
            this.topPanel.add(jScrollPane);
            this.topPanel.add((Component)new ConstantHeader(), "North");
        } else if (bl2) {
            this.topPanel.setBorder(new TitledBorder("Property Constants"));
            this.topPanel.setLayout(new BorderLayout());
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.setViewportView(this.propTable);
            this.topPanel.add(jScrollPane);
            this.topPanel.add((Component)new ConstantHeader(), "North");
        }
        this.topPanel.setPreferredSize(new Dimension(500, 300));
    }

    private void initValues(UndefinedConstants undefinedConstants) {
        Object object;
        int n;
        for (n = 0; n < undefinedConstants.getMFNumUndefined(); ++n) {
            object = new ConstantLine(undefinedConstants.getMFUndefinedName(n), undefinedConstants.getMFUndefinedType(n));
            this.modelTable.addConstant((ConstantLine)object);
        }
        for (n = 0; n < undefinedConstants.getPFNumUndefined(); ++n) {
            object = new ConstantLine(undefinedConstants.getPFUndefinedName(n), undefinedConstants.getPFUndefinedType(n));
            this.propTable.addConstant((ConstantLine)object);
        }
        for (n = 0; n < remember.size(); ++n) {
            ConstantLine constantLine;
            int n2;
            object = (Rememberance)remember.get(n);
            for (n2 = 0; n2 < this.propTable.getNumConstants(); ++n2) {
                constantLine = this.propTable.getConstantLine(n2);
                if (!constantLine.getName().equals(((Rememberance)object).varName) || constantLine.getType() != ((Rememberance)object).type) continue;
                constantLine.setSingleValue(((Rememberance)object).singleValue);
                constantLine.setStartValue(((Rememberance)object).start);
                constantLine.setEndValue(((Rememberance)object).end);
                constantLine.setStepValue(((Rememberance)object).step);
                constantLine.setIsRange(((Rememberance)object).isRange);
            }
            for (n2 = 0; n2 < this.modelTable.getNumConstants(); ++n2) {
                constantLine = this.modelTable.getConstantLine(n2);
                if (!constantLine.getName().equals(((Rememberance)object).varName) || constantLine.getType() != ((Rememberance)object).type) continue;
                constantLine.setSingleValue(((Rememberance)object).singleValue);
                constantLine.setStartValue(((Rememberance)object).start);
                constantLine.setEndValue(((Rememberance)object).end);
                constantLine.setStepValue(((Rememberance)object).step);
                constantLine.setIsRange(((Rememberance)object).isRange);
            }
        }
    }

    public static int defineConstantsWithDialog(GUIPrism gUIPrism, UndefinedConstants undefinedConstants, boolean bl, boolean bl2) {
        boolean bl3;
        boolean bl4 = undefinedConstants.getMFNumUndefined() > 0;
        boolean bl5 = bl3 = undefinedConstants.getPFNumUndefined() > 0;
        if (bl4 || bl3) {
            return new GUIExperimentPicker(gUIPrism, undefinedConstants, bl4, bl3, bl, bl2).defineValues();
        }
        return 0;
    }

    public int defineValues() {
        this.show();
        if (this.cancelled) {
            return 2;
        }
        if (this.createGraphCheck.isSelected()) {
            if (this.useSimulationCheck.isSelected()) {
                return 4;
            }
            return 3;
        }
        if (this.useSimulationCheck.isSelected()) {
            return 5;
        }
        return 1;
    }

    public void rememberValues() {
        Rememberance rememberance;
        int n;
        Rememberance rememberance2;
        ConstantLine constantLine;
        int n2;
        for (n2 = 0; n2 < this.propTable.getNumConstants(); ++n2) {
            constantLine = this.propTable.getConstantLine(n2);
            rememberance2 = new Rememberance();
            rememberance2.varName = constantLine.getName();
            rememberance2.type = constantLine.getType();
            rememberance2.isRange = constantLine.isRange();
            rememberance2.singleValue = constantLine.getSingleValue();
            rememberance2.end = constantLine.getEndValue();
            rememberance2.start = constantLine.getStartValue();
            rememberance2.step = constantLine.getStepValue();
            for (n = 0; n < remember.size(); ++n) {
                rememberance = (Rememberance)remember.get(n);
                if (!constantLine.getName().equals(rememberance.varName) || constantLine.getType() != rememberance.type) continue;
                remember.set(n, rememberance2);
                break;
            }
            if (n != remember.size()) continue;
            remember.add(rememberance2);
        }
        for (n2 = 0; n2 < this.modelTable.getNumConstants(); ++n2) {
            constantLine = this.modelTable.getConstantLine(n2);
            rememberance2 = new Rememberance();
            rememberance2.varName = constantLine.getName();
            rememberance2.type = constantLine.getType();
            rememberance2.isRange = constantLine.isRange();
            rememberance2.singleValue = constantLine.getSingleValue();
            rememberance2.end = constantLine.getEndValue();
            rememberance2.start = constantLine.getStartValue();
            rememberance2.step = constantLine.getStepValue();
            for (n = 0; n < remember.size(); ++n) {
                rememberance = (Rememberance)remember.get(n);
                if (!constantLine.getName().equals(rememberance.varName) || constantLine.getType() != rememberance.type) continue;
                remember.set(n, rememberance2);
                break;
            }
            if (n != remember.size()) continue;
            remember.add(rememberance2);
        }
    }

    private void okayButtonActionPerformed(ActionEvent actionEvent) {
        try {
            ConstantLine constantLine;
            int n;
            int n2 = this.modelTable.getNumConstants();
            for (n = 0; n < n2; ++n) {
                constantLine = this.modelTable.getConstantLine(n);
                constantLine.checkValid();
                if (constantLine.isRange()) {
                    this.undef.defineConstant(constantLine.getName(), constantLine.getStartValue(), constantLine.getEndValue(), constantLine.getStepValue());
                    continue;
                }
                this.undef.defineConstant(constantLine.getName(), constantLine.getSingleValue());
            }
            n2 = this.propTable.getNumConstants();
            for (n = 0; n < n2; ++n) {
                constantLine = this.propTable.getConstantLine(n);
                constantLine.checkValid();
                if (constantLine.isRange()) {
                    this.undef.defineConstant(constantLine.getName(), constantLine.getStartValue(), constantLine.getEndValue(), constantLine.getStepValue());
                    continue;
                }
                this.undef.defineConstant(constantLine.getName(), constantLine.getSingleValue());
            }
            this.undef.checkAllDefined();
            this.undef.initialiseIterators();
            this.cancelled = false;
            this.rememberValues();
            lastGraph = this.createGraphCheck.isSelected();
            lastSimulation = this.useSimulationCheck.isSelected();
            this.dispose();
        }
        catch (PrismException prismException) {
            this.gui.errorDialog(prismException.getMessage());
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    static {
        lastGraph = true;
        lastSimulation = false;
        remember = new ArrayList();
    }

    static class Rememberance {
        String varName;
        Type type;
        boolean isRange;
        String singleValue;
        String start;
        String end;
        String step;

        Rememberance() {
        }

        public String toString() {
            return this.varName + "(" + this.type.getTypeString() + ") : " + this.isRange + "," + this.singleValue;
        }
    }
}

