/*
 * Decompiled with CFR 0.152.
 */
package userinterface.model.computation;

import io.ModelExportTask;
import javax.swing.SwingUtilities;
import userinterface.GUIComputationThread;
import userinterface.model.GUIMultiModelHandler;
import userinterface.util.GUIComputationEvent;

public class ComputeTransientThread
extends GUIComputationThread {
    private GUIMultiModelHandler handler;
    private String transientTimeSpec;
    private ModelExportTask exportTask;

    public ComputeTransientThread(GUIMultiModelHandler gUIMultiModelHandler, String string, ModelExportTask modelExportTask) {
        super(gUIMultiModelHandler.getGUIPlugin());
        this.handler = gUIMultiModelHandler;
        this.transientTimeSpec = string;
        this.exportTask = modelExportTask;
    }

    @Override
    public void run() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComputeTransientThread.this.plug.startProgress();
                ComputeTransientThread.this.plug.notifyEventListeners(new GUIComputationEvent(0, ComputeTransientThread.this.plug));
                ComputeTransientThread.this.plug.setTaskBarText("Computing transient probabilities...");
            }
        });
        try {
            this.prism.exportTransientProbabilities(this.transientTimeSpec, this.exportTask.getFile(), this.exportTask.getExportOptions(), null);
        }
        catch (Throwable throwable) {
            this.error(throwable);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ComputeTransientThread.this.plug.notifyEventListeners(new GUIComputationEvent(2, ComputeTransientThread.this.plug));
                    ComputeTransientThread.this.plug.setTaskBarText("Computing transient probabilities... error.");
                    ComputeTransientThread.this.plug.stopProgress();
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ComputeTransientThread.this.plug.setTaskBarText("Computing transient probabilities... done.");
                ComputeTransientThread.this.plug.notifyEventListeners(new GUIComputationEvent(1, ComputeTransientThread.this.plug));
                ComputeTransientThread.this.plug.stopProgress();
            }
        });
    }
}

