/*
 * Decompiled with CFR 0.152.
 */
package userinterface.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import javax.swing.JComponent;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.util.ShapeUtilities;
import org.w3c.dom.Element;
import settings.BooleanSetting;
import settings.ChoiceSetting;
import settings.ColorSetting;
import settings.DoubleSetting;
import settings.RangeConstraint;
import settings.Setting;
import settings.SettingDisplay;
import settings.SettingException;
import settings.SettingOwner;
import settings.SingleLineStringSetting;
import userinterface.graph.Graph;

public class SeriesSettings
extends Observable
implements SettingOwner {
    public static final int CIRCLE = 0;
    public static final int SQUARE = 1;
    public static final int TRIANGLE = 2;
    public static final int RECTANGLE_H = 3;
    public static final int RECTANGLE_V = 4;
    public static final int NONE = 5;
    public static final int SOLID = 0;
    public static final int DASHED = 1;
    public static final int DOT_DASHED = 2;
    public static final int BLUE = 0;
    public static final int GREEN = 1;
    public static final int RED = 2;
    public static final int CYAN = 3;
    public static final int PURPLE = 4;
    public static final int YELLOW = 5;
    public static final int BROWN = 5;
    public static final Shape[] DEFAULT_SHAPE_SEQUENCE = new Shape[]{DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE[1], DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE[0], DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE[2], DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE[4], DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE[8]};
    protected static int[] triPointsX = new int[]{-2, 2, 0};
    protected static int[] triPointsY = new int[]{-2, -2, 2};
    protected static final Shape[] SHAPES = new Shape[]{new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0), new Rectangle2D.Double(-2.0, -2.0, 4.0, 4.0), new Polygon(triPointsX, triPointsY, 3), new Rectangle2D.Double(-2.0, -1.0, 4.0, 2.0), new Rectangle2D.Double(-1.0, -2.0, 2.0, 4.0), new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0)};
    protected static final Shape[] DEFAULT_SHAPES = new Shape[]{SHAPES[0], SHAPES[1], SHAPES[2], SHAPES[3], SHAPES[4]};
    protected static final Paint[] DEFAULT_PAINTS = new Paint[]{Color.blue, new Color(0, 127, 0), Color.red, new Color(0, 191, 191), new Color(191, 0, 191), new Color(191, 191, 0), new Color(0.6f, 0.2f, 0.0f)};
    private Graph graph;
    private JFreeChart chart;
    private XYPlot plot;
    private Graph.SeriesKey key;
    private XYLineAndShapeRenderer renderer;
    private SingleLineStringSetting seriesHeading;
    private ColorSetting seriesColour;
    private BooleanSetting showPoints;
    private ChoiceSetting seriesShape;
    private BooleanSetting showLines;
    private DoubleSetting lineWidth;
    private ChoiceSetting lineStyle;
    private SettingDisplay display;
    private GraphSeriesIcon icon;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeriesSettings(Graph graph, Graph.SeriesKey seriesKey) {
        this.graph = graph;
        this.key = seriesKey;
        this.chart = graph.getChart();
        this.plot = this.chart.getXYPlot();
        this.renderer = (XYLineAndShapeRenderer)this.plot.getRenderer();
        this.seriesHeading = new SingleLineStringSetting("heading", "heading", "The heading for this series, as displayed in the legend.", (SettingOwner)this, true);
        this.seriesColour = new ColorSetting("colour", Color.black, "The colour for all lines and points in this series.", (SettingOwner)this, true);
        this.showPoints = new BooleanSetting("show points", true, "Should points be displayed for this series?", (SettingOwner)this, true);
        String[] stringArray = new String[]{"Circle", "Square", "Triangle", "Horizontal Rectangle", "Vertical Rectangle", "None"};
        this.seriesShape = new ChoiceSetting("point shape", stringArray, stringArray[0], "The shape of points for this series.", this, true);
        this.showLines = new BooleanSetting("show lines", true, "Should lines be displayed for this series?", (SettingOwner)this, true);
        this.lineWidth = new DoubleSetting("line width", 1.0, "The line width for this series.", (SettingOwner)this, true, new RangeConstraint("0.0,"));
        String[] stringArray2 = new String[]{"---------", "- - - - -", "- -- - --"};
        this.lineStyle = new ChoiceSetting("line style", stringArray2, stringArray2[0], "The line style for this series.", this, true);
        Object object = graph.getSeriesLock();
        synchronized (object) {
            int n = graph.getJFreeChartIndex(seriesKey);
            if (n >= 0) {
                Object object2;
                if (this.renderer.lookupSeriesPaint(n) instanceof Color) {
                    try {
                        this.seriesColour.setValue((Color)this.renderer.getSeriesPaint(n));
                    }
                    catch (SettingException settingException) {
                        // empty catch block
                    }
                }
                try {
                    this.seriesHeading.setValue(graph.getXYSeries(seriesKey).getKey());
                }
                catch (SettingException settingException) {
                    // empty catch block
                }
                try {
                    object2 = true;
                    this.showPoints.setValue(object2 == null || ((Boolean)object2).booleanValue());
                }
                catch (SettingException settingException) {
                    // empty catch block
                }
                object2 = this.renderer.lookupSeriesShape(n);
                try {
                    boolean bl = false;
                    for (int i = 0; i < 5; ++i) {
                        if (!ShapeUtilities.equal((Shape)object2, (Shape)SHAPES[i])) continue;
                        this.seriesShape.setSelectedIndex(i);
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.seriesShape.setSelectedIndex(5);
                    }
                }
                catch (SettingException settingException) {
                    settingException.printStackTrace();
                }
                try {
                    Boolean bl = true;
                    this.showLines.setValue(bl == null || bl != false);
                }
                catch (SettingException settingException) {
                    // empty catch block
                }
            }
        }
        this.updateSeries();
    }

    @Override
    public SettingDisplay getDisplay() {
        return this.display;
    }

    @Override
    public int getNumSettings() {
        return 7;
    }

    @Override
    public Setting getSetting(int n) {
        switch (n) {
            case 0: {
                return this.seriesHeading;
            }
            case 1: {
                return this.seriesColour;
            }
            case 2: {
                return this.showPoints;
            }
            case 3: {
                return this.seriesShape;
            }
            case 4: {
                return this.showLines;
            }
            case 5: {
                return this.lineWidth;
            }
            case 6: {
                return this.lineStyle;
            }
        }
        return null;
    }

    @Override
    public String getSettingOwnerClassName() {
        return "Series";
    }

    @Override
    public int getSettingOwnerID() {
        return 19;
    }

    @Override
    public String getSettingOwnerName() {
        return this.seriesHeading.getStringValue();
    }

    @Override
    public void notifySettingChanged(Setting setting) {
        this.updateSeries();
        this.setChanged();
        this.notifyObservers(this);
    }

    @Override
    public void setDisplay(SettingDisplay settingDisplay) {
        this.display = settingDisplay;
    }

    public int compareTo(Object object) {
        if (object instanceof SettingOwner) {
            SettingOwner settingOwner = (SettingOwner)object;
            if (this.getSettingOwnerID() < settingOwner.getSettingOwnerID()) {
                return -1;
            }
            if (this.getSettingOwnerID() > settingOwner.getSettingOwnerID()) {
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public String getSeriesHeading() {
        return this.seriesHeading.getStringValue();
    }

    public void setSeriesHeading(String string) {
        try {
            this.seriesHeading.setValue(string);
            this.updateSeries();
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public Color getSeriesColour() {
        return this.seriesColour.getColorValue();
    }

    public void setSeriesColour(Color color) {
        try {
            this.seriesColour.setValue(color);
            this.updateSeries();
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public boolean showPoints() {
        return this.showPoints.getBooleanValue();
    }

    public void showPoints(boolean bl) {
        try {
            this.showPoints.setValue(bl);
            this.updateSeries();
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public int getSeriesShape() {
        return this.seriesShape.getCurrentIndex();
    }

    public void setSeriesShape(int n) throws SettingException {
        this.seriesShape.setSelectedIndex(n);
        this.updateSeries();
        this.setChanged();
        this.notifyObservers(this);
    }

    public boolean showLines() {
        return this.showLines.getBooleanValue();
    }

    public void showLines(boolean bl) {
        try {
            this.showLines.setValue(bl);
            this.updateSeries();
            this.setChanged();
            this.notifyObservers(this);
        }
        catch (SettingException settingException) {
            // empty catch block
        }
    }

    public double getLineWidth() {
        return this.lineWidth.getDoubleValue();
    }

    public void setLineWidth(double d) throws SettingException {
        this.lineWidth.setValue(d);
        this.updateSeries();
        this.setChanged();
        this.notifyObservers();
    }

    public int getLineStyle() {
        return this.lineStyle.getCurrentIndex();
    }

    public void setLineStyle(int n) throws SettingException {
        this.lineStyle.setSelectedIndex(n);
        this.updateSeries();
        this.setChanged();
        this.notifyObservers(this);
    }

    public String toString() {
        return this.seriesHeading.getStringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSeries() {
        Object object = this.graph.getSeriesLock();
        synchronized (object) {
            int n = this.graph.getJFreeChartIndex(this.key);
            if (n >= 0) {
                Boolean bl;
                int n2;
                Shape shape;
                Boolean bl2;
                if (this.renderer.getSeriesPaint(n) == null || !this.renderer.getSeriesPaint(n).equals(this.seriesColour)) {
                    this.renderer.setSeriesPaint(n, (Paint)this.seriesColour.getColorValue());
                }
                if (!this.graph.getXYSeries(this.key).getKey().equals(this.seriesHeading.getStringValue())) {
                    this.graph.changeSeriesName(this.key, this.seriesHeading.getStringValue());
                    try {
                        this.seriesHeading.setValue(this.graph.getXYSeries(this.key).getKey());
                    }
                    catch (SettingException settingException) {
                        // empty catch block
                    }
                }
                if ((bl2 = this.renderer.getSeriesShapesVisible(n)) == null || bl2.booleanValue() != this.showPoints.getBooleanValue()) {
                    this.renderer.setSeriesShapesVisible(n, this.showPoints.getBooleanValue());
                }
                if (!ShapeUtilities.equal((Shape)(shape = this.renderer.getSeriesShape(n)), (Shape)SHAPES[n2 = this.seriesShape.getCurrentIndex()])) {
                    this.renderer.setSeriesShape(n, SHAPES[n2]);
                }
                if ((bl = this.renderer.getSeriesLinesVisible(n)) == null || bl.booleanValue() != this.showLines.getBooleanValue()) {
                    this.renderer.setSeriesLinesVisible(n, this.showLines.getBooleanValue());
                }
                if (this.lineStyle.getCurrentIndex() == 0) {
                    BasicStroke basicStroke = new BasicStroke((float)this.lineWidth.getDoubleValue(), 1, 1, 10.0f);
                    this.renderer.setSeriesStroke(n, (Stroke)basicStroke);
                } else if (this.lineStyle.getCurrentIndex() == 1) {
                    float[] fArray = new float[]{2.0f, 3.0f};
                    BasicStroke basicStroke = new BasicStroke((float)this.lineWidth.getDoubleValue(), 1, 1, 10.0f, fArray, 1.0f);
                    this.renderer.setSeriesStroke(n, (Stroke)basicStroke);
                } else {
                    float[] fArray = new float[]{1.0f, 3.0f, 5.0f, 3.0f};
                    BasicStroke basicStroke = new BasicStroke((float)this.lineWidth.getDoubleValue(), 1, 1, 10.0f, fArray, 0.0f);
                    this.renderer.setSeriesStroke(n, (Stroke)basicStroke);
                }
            }
            this.icon = new GraphSeriesIcon(this.renderer.getSeriesShape(n), this.renderer.getSeriesStroke(n), this.seriesColour.getColorValue(), this.showLines.getBooleanValue(), this.showPoints.getBooleanValue());
            this.icon.setOpaque(false);
            this.icon.setMinimumSize(new Dimension(20, 10));
            this.icon.setMaximumSize(new Dimension(50, 20));
            this.icon.setPreferredSize(new Dimension(30, 10));
        }
    }

    public Graph.SeriesKey getSeriesKey() {
        return this.key;
    }

    public JComponent getIcon() {
        return this.icon;
    }

    public void save(Element element) throws SettingException {
        element.setAttribute("seriesHeading", this.getSeriesHeading());
        element.setAttribute("lineWidth", "" + this.getLineWidth());
        Color color = this.getSeriesColour();
        element.setAttribute("seriesColourR", "" + color.getRed());
        element.setAttribute("seriesColourG", "" + color.getGreen());
        element.setAttribute("seriesColourB", "" + color.getBlue());
        element.setAttribute("showPoints", this.showPoints() ? "true" : "false");
        element.setAttribute("showLines", this.showLines() ? "true" : "false");
        int n = this.getLineStyle();
        switch (n) {
            case 1: {
                element.setAttribute("lineStyle", "dashed");
                break;
            }
            case 2: {
                element.setAttribute("lineStyle", "dotDashed");
                break;
            }
            default: {
                element.setAttribute("lineStyle", "normal");
            }
        }
        int n2 = this.getSeriesShape();
        switch (n2) {
            case 0: {
                element.setAttribute("seriesShape", "circle");
                break;
            }
            case 1: {
                element.setAttribute("seriesShape", "square");
                break;
            }
            case 2: {
                element.setAttribute("seriesShape", "triangle");
                break;
            }
            case 3: {
                element.setAttribute("seriesShape", "rectangle_h");
                break;
            }
            case 4: {
                element.setAttribute("seriesShape", "rectangle_v");
                break;
            }
            default: {
                element.setAttribute("seriesShape", "none");
            }
        }
    }

    public void load(Element element) throws SettingException {
        this.setSeriesHeading(element.getAttribute("seriesHeading"));
        double d = Graph.parseDouble(element.getAttribute("lineWidth"));
        if (!Double.isNaN(d)) {
            this.setLineWidth(d);
        }
        String string = element.getAttribute("seriesColourR");
        String string2 = element.getAttribute("seriesColourG");
        String string3 = element.getAttribute("seriesColourB");
        Color color = Graph.parseColor(string, string2, string3);
        this.setSeriesColour(color);
        this.showPoints(Graph.parseBoolean(element.getAttribute("showPoints")));
        this.showLines(Graph.parseBoolean(element.getAttribute("showLines")));
        String string4 = element.getAttribute("lineStyle");
        if (string4.equals("dashed")) {
            this.setLineStyle(1);
        } else if (string4.equals("dotDashed")) {
            this.setLineStyle(2);
        } else {
            this.setLineStyle(0);
        }
        String string5 = element.getAttribute("seriesShape");
        if (string5.equals("circle")) {
            this.setSeriesShape(0);
        } else if (string5.equals("square")) {
            this.setSeriesShape(1);
        } else if (string5.equals("triangle")) {
            this.setSeriesShape(2);
        } else if (string5.equals("rectangle_h")) {
            this.setSeriesShape(3);
        } else if (string5.equals("rectangle_v")) {
            this.setSeriesShape(4);
        } else {
            this.setSeriesShape(5);
        }
    }

    private class GraphSeriesIcon
    extends JComponent {
        private Shape shape;
        private Stroke stroke;
        private Color color;
        private boolean showLines;
        private boolean showShapes;

        public GraphSeriesIcon(Shape shape, Stroke stroke, Color color, boolean bl, boolean bl2) {
            this.shape = shape;
            this.stroke = stroke;
            this.color = color;
            this.showLines = bl;
            this.showShapes = bl2;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            float f = this.getWidth();
            float f2 = this.getHeight();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(this.color);
            graphics2D.setStroke(this.stroke);
            graphics2D.translate(f / 2.0f, f2 / 2.0f);
            if (this.showLines) {
                graphics2D.drawLine(-((int)f) / 2, 0, (int)f / 2, 0);
            }
            if (this.showShapes) {
                graphics2D.fill(this.shape);
            }
            graphics2D.dispose();
        }
    }
}

