/*
 * Decompiled with CFR 0.152.
 */
package simulator.method;

import prism.PrismException;
import simulator.method.APMCMethod;
import simulator.method.SimulationMethod;

public class APMCiterations
extends APMCMethod {
    public APMCiterations(double d, double d2) {
        this.confidence = d;
        this.approximation = d2;
    }

    @Override
    public void computeMissingParameterBeforeSim() throws PrismException {
        double d = Math.ceil(0.5 * Math.log(2.0 / this.confidence) / (this.approximation * this.approximation));
        if (!(d < 2.147483647E9)) {
            throw new PrismException("Overflow in APMC method: required number of iterations is too high");
        }
        this.numSamples = (int)d;
        this.missingParameterComputed = true;
    }

    @Override
    public Object getMissingParameter() throws PrismException {
        if (!this.missingParameterComputed) {
            this.computeMissingParameterBeforeSim();
        }
        return this.numSamples;
    }

    @Override
    public String getParametersString() {
        if (!this.missingParameterComputed) {
            return "approximation=" + this.approximation + ", confidence=" + this.confidence + ", number of samples=unknown";
        }
        return "approximation=" + this.approximation + ", confidence=" + this.confidence + ", number of samples=" + this.numSamples;
    }

    @Override
    public SimulationMethod clone() {
        APMCiterations aPMCiterations = new APMCiterations(this.confidence, this.approximation);
        aPMCiterations.numSamples = this.numSamples;
        aPMCiterations.missingParameterComputed = this.missingParameterComputed;
        aPMCiterations.prOp = this.prOp;
        aPMCiterations.theta = this.theta;
        return aPMCiterations;
    }
}

