/*
 * Decompiled with CFR 0.152.
 */
package simulator.method;

import prism.PrismException;
import simulator.method.APMCMethod;
import simulator.method.SimulationMethod;

public class APMCconfidence
extends APMCMethod {
    public APMCconfidence(double d, int n) {
        this.approximation = d;
        this.numSamples = n;
    }

    @Override
    public void computeMissingParameterBeforeSim() throws PrismException {
        if (this.approximation * this.approximation * (double)this.numSamples < Math.log(2.0) / 2.0) {
            Object object = "For APMC, samples (N) and approximation (eps) must satisfy N*eps^2 >= ln(2)/2";
            object = (String)object + ". Increase samples and/or approximation";
            throw new PrismException((String)object);
        }
        this.confidence = 2.0 / Math.exp((double)this.numSamples * this.approximation * this.approximation * 2.0);
        this.missingParameterComputed = true;
    }

    @Override
    public Object getMissingParameter() throws PrismException {
        if (!this.missingParameterComputed) {
            this.computeMissingParameterBeforeSim();
        }
        return this.confidence;
    }

    @Override
    public String getParametersString() {
        if (!this.missingParameterComputed) {
            return "approximation=" + this.approximation + ", confidence=unknown, number of samples=" + this.numSamples;
        }
        return "approximation=" + this.approximation + ", confidence=" + this.confidence + ", number of samples=" + this.numSamples;
    }

    @Override
    public SimulationMethod clone() {
        APMCconfidence aPMCconfidence = new APMCconfidence(this.approximation, this.numSamples);
        aPMCconfidence.confidence = this.confidence;
        aPMCconfidence.missingParameterComputed = this.missingParameterComputed;
        aPMCconfidence.prOp = this.prOp;
        aPMCconfidence.theta = this.theta;
        return aPMCconfidence;
    }
}

