/*
 * Decompiled with CFR 0.152.
 */
package pta;

import explicit.Distribution;
import explicit.DistributionSet;
import explicit.QuantAbstractRefine;
import explicit.STPGAbstrSimple;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import prism.ModelType;
import prism.PrismComponent;
import prism.PrismException;
import pta.Constraint;
import pta.DBM;
import pta.DBMList;
import pta.Edge;
import pta.ForwardsReach;
import pta.LocZone;
import pta.NCZone;
import pta.PTA;
import pta.ReachabilityGraph;
import pta.SymbolicTransition;
import pta.Transition;
import pta.Zone;

public class PTAAbstractRefine
extends QuantAbstractRefine {
    protected PTA pta = null;
    protected BitSet targetLocs;
    protected Constraint targetConstraint;
    protected ReachabilityGraph graph;
    boolean storeValidZones = true;

    public PTAAbstractRefine(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
        this.setModelType(ModelType.MDP);
        this.setPropertyType(QuantAbstractRefine.PropertyType.PROB_REACH);
    }

    public double forwardsReachAbstractRefine(PTA pTA, BitSet bitSet, Constraint constraint, boolean bl) throws PrismException {
        this.pta = pTA;
        this.targetLocs = bitSet;
        this.targetConstraint = constraint;
        return this.abstractRefine(bl);
    }

    @Override
    protected void initialise() throws PrismException {
        ForwardsReach forwardsReach = new ForwardsReach(this.mainLog);
        this.graph = forwardsReach.buildForwardsGraph(this.pta, this.targetLocs, this.targetConstraint);
        this.target = forwardsReach.getTarget();
        List<Integer> list = forwardsReach.getInitialStates();
        this.graph.computeAllValidities();
        if (this.verbosity >= 5) {
            this.mainLog.println("\nStates: ");
            this.graph.printStates(this.mainLog);
            this.mainLog.println("\nGraph: " + String.valueOf(this.graph));
            this.mainLog.println("Target states: " + String.valueOf(this.target));
        }
        this.abstraction = new STPGAbstrSimple();
        int n = this.graph.states.size();
        this.abstraction.addStates(n);
        for (int n2 : list) {
            this.abstraction.addInitialState(n2);
        }
        for (int i = 0; i < n; ++i) {
            this.buildSTPGState(i);
        }
    }

    @Override
    protected void rebuildAbstraction(Set<Integer> set) throws PrismException {
        for (int n : set) {
            this.abstraction.clearState(n);
            this.buildSTPGState(n);
        }
    }

    protected void buildSTPGState(int n) throws PrismException {
        LocZone locZone = this.graph.states.get(n);
        int n2 = this.graph.trans.get(n).size();
        if (n2 == 0) {
            if (!this.target.get(n)) {
                this.mainLog.printWarning("Building STPG state (" + n + ") with no transitions");
            }
            return;
        }
        ArrayList<NCZone> arrayList = new ArrayList<NCZone>(n2);
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            SymbolicTransition symbolicTransition = this.graph.trans.get(n).get(i);
            NCZone nCZone = (NCZone)symbolicTransition.valid;
            if (nCZone.isEmpty()) {
                throw new PrismException("Found invalid symbolic transition");
            }
            nArray[i] = arrayList.indexOf(nCZone);
            if (nArray[i] != -1) continue;
            nArray[i] = arrayList.size();
            arrayList.add(nCZone);
        }
        int n3 = arrayList.size();
        this.buildSTPGStateRec(n, new DBMList(locZone.zone), new BitSet(n3), arrayList, nArray, 0, n3);
        if (this.abstraction.getNumChoices(n) == 0) {
            throw new PrismException("STPG has deadlock in state #" + n + ":" + String.valueOf(this.graph.states.get(n)));
        }
    }

    protected void buildSTPGStateRec(int n, NCZone nCZone, BitSet bitSet, ArrayList<NCZone> arrayList, int[] nArray, int n2, int n3) throws PrismException {
        BitSet bitSet2 = null;
        STPGAbstrSimple sTPGAbstrSimple = (STPGAbstrSimple)this.abstraction;
        if (n2 == n3) {
            if (!nCZone.isEmpty()) {
                if (bitSet.cardinality() == 0) {
                    return;
                }
                DistributionSet distributionSet = sTPGAbstrSimple.newDistributionSet(null);
                ArrayList<SymbolicTransition> arrayList2 = this.graph.trans.get(n);
                if (!this.storeValidZones) {
                    bitSet2 = new BitSet(arrayList2.size());
                }
                int n4 = 0;
                for (SymbolicTransition symbolicTransition : arrayList2) {
                    if (bitSet.get(nArray[n4])) {
                        Distribution<Double> distribution = Distribution.ofDouble();
                        int n5 = 0;
                        for (Edge edge : symbolicTransition.tr.getEdges()) {
                            int n6 = symbolicTransition.dests[n5];
                            if (n6 != -1) {
                                distribution.add(n6, edge.getProbability());
                            }
                            ++n5;
                        }
                        if (!distribution.isEmpty()) {
                            distributionSet.add(distribution);
                        }
                        if (!this.storeValidZones) {
                            bitSet2.set(n4);
                        }
                    }
                    ++n4;
                }
                if (this.storeValidZones) {
                    distributionSet.setAction(nCZone);
                } else {
                    distributionSet.setAction(bitSet2);
                }
                sTPGAbstrSimple.addDistributionSet(n, distributionSet);
            }
        } else {
            NCZone nCZone2 = nCZone.deepCopy();
            nCZone2.intersectComplement(arrayList.get(n2));
            bitSet.set(n2, false);
            if (!nCZone2.isEmpty()) {
                this.buildSTPGStateRec(n, nCZone2, bitSet, arrayList, nArray, n2 + 1, n3);
            }
            nCZone2 = nCZone.deepCopy();
            nCZone2.intersect(arrayList.get(n2));
            bitSet.set(n2, true);
            if (!nCZone2.isEmpty()) {
                this.buildSTPGStateRec(n, nCZone2, bitSet, arrayList, nArray, n2 + 1, n3);
            }
        }
    }

    @Override
    protected int splitState(int n, List<List<Integer>> list, Set<Integer> set, Set<Integer> set2) throws PrismException {
        Object object;
        int n2;
        LocZone locZone = this.graph.states.get(n);
        if (this.verbosity >= 1) {
            this.mainLog.println("Splitting: #" + n + "=" + String.valueOf(locZone));
        }
        ArrayList<DBMList> arrayList = new ArrayList<DBMList>();
        int n3 = 0;
        for (List<Integer> linkedHashSet2 : list) {
            n3 += linkedHashSet2.size();
            DBMList dBMList = new DBMList(this.pta);
            for (int n4 : linkedHashSet2) {
                DBMList dBMList2;
                Object object2 = ((STPGAbstrSimple)this.abstraction).getChoice((int)n, (int)n4).action;
                if (!this.storeValidZones) {
                    BitSet bitSet = (BitSet)object2;
                    List list2 = this.graph.trans.get(n);
                    int n5 = list2.size();
                    LinkedHashSet<DBMList> linkedHashSet = new LinkedHashSet<DBMList>();
                    LinkedHashSet linkedHashSet3 = new LinkedHashSet();
                    for (n2 = 0; n2 < n5; ++n2) {
                        Iterator iterator = (SymbolicTransition)list2.get(n2);
                        (bitSet.get(n2) ? linkedHashSet : linkedHashSet3).add((DBMList)((SymbolicTransition)((Object)iterator)).valid);
                    }
                    dBMList2 = new DBMList(DBM.createTrue(this.pta));
                    for (Zone zone : linkedHashSet) {
                        dBMList2.intersect(zone);
                    }
                    for (NCZone nCZone : linkedHashSet3) {
                        dBMList2.intersectComplement(nCZone);
                    }
                    dBMList2.intersect(locZone.zone);
                } else {
                    dBMList2 = (DBMList)object2;
                }
                dBMList.addDBMs(dBMList2);
            }
            arrayList.add(dBMList);
        }
        if (n3 < this.abstraction.getNumChoices(n)) {
            object = new DBMList(this.pta);
            for (DBMList dBMList : arrayList) {
                ((DBMList)object).addDBMs(dBMList.deepCopy());
            }
            DBMList dBMList = new DBMList(locZone.zone);
            dBMList.intersectComplement((Zone)object);
            if (!dBMList.isEmpty()) {
                arrayList.add(dBMList);
            }
        }
        if (arrayList.size() <= 1) {
            this.mainLog.printWarning("failed to split state #" + n + "=" + String.valueOf(locZone));
            return 1;
        }
        int n5 = arrayList.size();
        int[] nArray = new int[n5];
        for (n2 = 0; n2 < n5; ++n2) {
            if (n2 == 0) {
                this.graph.states.set(n, new LocZone(locZone.loc, (Zone)arrayList.get(n2)));
                nArray[n2] = n;
                continue;
            }
            this.graph.states.add(new LocZone(locZone.loc, (Zone)arrayList.get(n2)));
            nArray[n2] = this.graph.states.size() - 1;
            this.graph.copyState(n);
        }
        if (this.verbosity >= 1) {
            this.mainLog.println("Splitting: #" + n + "=" + String.valueOf(locZone));
            this.mainLog.println("into " + n5 + ":");
            for (n2 = 0; n2 < n5; ++n2) {
                this.mainLog.println("#" + nArray[n2] + "=" + String.valueOf(arrayList.get(n2)));
            }
        }
        if (this.verbosity >= 5) {
            this.mainLog.println("New states: " + String.valueOf(this.graph.states));
        }
        this.abstraction.addStates(n5 - 1);
        if (this.abstraction.isInitialState(n)) {
            for (n2 = 1; n2 < n5; ++n2) {
                this.abstraction.addInitialState(nArray[n2]);
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            object = this.graph.states.get(nArray[n2]);
            this.target.set(nArray[n2], this.isTarget((LocZone)object));
        }
        object = new LinkedHashSet();
        LinkedHashSet<SymbolicTransition> linkedHashSet = new LinkedHashSet<SymbolicTransition>();
        int n6 = this.graph.states.size();
        for (n2 = 0; n2 < n6; ++n2) {
            object.clear();
            linkedHashSet.clear();
            boolean bl = false;
            if (n2 == n || n2 > n6 - n5) {
                for (SymbolicTransition symbolicTransition : this.graph.trans.get(n2)) {
                    object.add(symbolicTransition);
                    this.splitSymbolicTransition(n2, symbolicTransition, n, nArray, linkedHashSet);
                }
                bl = true;
            } else {
                for (SymbolicTransition symbolicTransition : this.graph.trans.get(n2)) {
                    if (!symbolicTransition.hasSuccessor(n)) continue;
                    object.add(symbolicTransition);
                    this.splitSymbolicTransition(n2, symbolicTransition, n, nArray, linkedHashSet);
                    bl = true;
                }
            }
            if (!bl) continue;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                SymbolicTransition symbolicTransition;
                symbolicTransition = (SymbolicTransition)iterator.next();
                this.graph.trans.get(n2).remove(symbolicTransition);
            }
            for (SymbolicTransition symbolicTransition : linkedHashSet) {
                this.graph.trans.get(n2).add(symbolicTransition);
            }
            if (this.verbosity >= 1 && !object.isEmpty()) {
                this.mainLog.print("Replacing symbolic transitions: " + n2 + ":" + String.valueOf(object));
                this.mainLog.println(" with: " + n2 + ":" + String.valueOf(linkedHashSet));
            }
            this.abstraction.clearState(n2);
            this.buildSTPGState(n2);
            set.add(n2);
        }
        if (this.verbosity >= 5) {
            this.mainLog.println("New graph: " + String.valueOf(this.graph));
        }
        return n5;
    }

    private void splitSymbolicTransition(int n, SymbolicTransition symbolicTransition, int n2, int[] nArray, Set<SymbolicTransition> set) {
        SymbolicTransition symbolicTransition2 = new SymbolicTransition(symbolicTransition);
        this.splitSymbolicTransition(n, symbolicTransition2, n2, nArray, set, 0, symbolicTransition.dests.length);
    }

    private void splitSymbolicTransition(int n, SymbolicTransition symbolicTransition, int n2, int[] nArray, Set<SymbolicTransition> set, int n3, int n4) {
        if (n3 == n4) {
            Zone zone = this.graph.computeValidity(n, symbolicTransition.tr, symbolicTransition.dests);
            if (!zone.isEmpty()) {
                SymbolicTransition symbolicTransition2 = new SymbolicTransition(symbolicTransition);
                symbolicTransition2.valid = zone;
                set.add(symbolicTransition2);
            }
        } else if (symbolicTransition.dests[n3] == n2) {
            int n5 = nArray.length;
            for (int i = 0; i < n5; ++i) {
                symbolicTransition.dests[n3] = nArray[i];
                this.splitSymbolicTransition(n, symbolicTransition, n2, nArray, set, n3 + 1, n4);
            }
            symbolicTransition.dests[n3] = n2;
        } else {
            this.splitSymbolicTransition(n, symbolicTransition, n2, nArray, set, n3 + 1, n4);
        }
    }

    private Zone valid2new(LocZone locZone, Transition transition, int[] nArray) {
        DBMList dBMList = new DBMList(DBM.createTrue(this.pta));
        int n = 0;
        for (Edge object : transition.getEdges()) {
            Zone zone = this.graph.states.get((int)nArray[n]).zone.deepCopy();
            for (Map.Entry<Integer, Integer> entry : object.getResets()) {
                zone.backReset(entry.getKey(), entry.getValue());
            }
            ((Zone)dBMList).intersect(zone);
            ++n;
        }
        for (Constraint constraint : transition.getGuardConstraints()) {
            ((Zone)dBMList).addConstraint(constraint);
        }
        dBMList.down();
        ((Zone)dBMList).intersect(locZone.zone);
        return dBMList;
    }

    private boolean isTarget(LocZone locZone) {
        return this.targetLocs.get(locZone.loc) && (this.targetConstraint == null || locZone.zone.isSatisfied(this.targetConstraint));
    }
}

