/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import parser.EvaluateContext;
import parser.Values;
import parser.VarList;
import parser.ast.ASTElement;
import parser.ast.DeclarationType;
import parser.type.Type;
import prism.ActionList;
import prism.ModelType;
import prism.PrismException;
import prism.PrismLangException;

public interface ModelInfo {
    public ModelType getModelType();

    default public void setSomeUndefinedConstants(EvaluateContext evaluateContext) throws PrismException {
        if (evaluateContext != null && evaluateContext.getConstantValues() != null && evaluateContext.getConstantValues().getNumValues() > 0) {
            throw new PrismLangException("This model has no constants to set");
        }
        if (evaluateContext != null && evaluateContext.getEvaluationMode() != EvaluateContext.EvalMode.FP) {
            throw new PrismLangException("Evaluation mode " + String.valueOf((Object)evaluateContext.getEvaluationMode()) + " not supported");
        }
    }

    default public void setSomeUndefinedConstants(Values values) throws PrismException {
        this.setSomeUndefinedConstants(EvaluateContext.create(values));
    }

    @Deprecated
    default public void setSomeUndefinedConstants(Values values, boolean bl) throws PrismException {
        this.setSomeUndefinedConstants(EvaluateContext.create(values, bl));
    }

    default public Values getConstantValues() {
        return this.getEvaluateContext().getConstantValues();
    }

    default public EvaluateContext getEvaluateContext() {
        return EvaluateContext.create(new Values());
    }

    default public List<Object> getActions() {
        return null;
    }

    default public List<String> getActionStrings() {
        return this.getActions() == null ? null : this.getActions().stream().map(ActionList::actionString).collect(Collectors.toList());
    }

    default public List<String> getBracketedActionStrings() {
        return this.getActions() == null ? null : this.getActions().stream().map(object -> "[" + ActionList.actionString(object) + "]").collect(Collectors.toList());
    }

    default public boolean containsUnboundedVariables() {
        return false;
    }

    default public int getNumVars() {
        return this.getVarNames().size();
    }

    public List<String> getVarNames();

    default public int getVarIndex(String string) {
        return this.getVarNames().indexOf(string);
    }

    default public String getVarName(int n) {
        return this.getVarNames().get(n);
    }

    public List<Type> getVarTypes();

    default public Type getVarType(int n) throws PrismException {
        return this.getVarTypes().get(n);
    }

    default public DeclarationType getVarDeclarationType(int n) throws PrismException {
        try {
            return this.getVarType(n).defaultDeclarationType();
        }
        catch (PrismLangException prismLangException) {
            throw new PrismException("No default declaration available for type " + String.valueOf(this.getVarType(n)));
        }
    }

    default public int getVarModuleIndex(int n) {
        return -1;
    }

    default public String getModuleName(int n) {
        return null;
    }

    default public VarList createVarList() throws PrismException {
        return new VarList(this);
    }

    default public boolean isVarObservable(int n) {
        return false;
    }

    default public int getNumObservableVars() {
        int n = 0;
        int n2 = this.getNumVars();
        for (int i = 0; i < n2; ++i) {
            if (!this.isVarObservable(i)) continue;
            ++n;
        }
        return n;
    }

    default public int getNumUnobservableVars() {
        return this.getNumVars() - this.getNumObservableVars();
    }

    default public List<String> getObservableVars() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getNumVars();
        for (int i = 0; i < n; ++i) {
            if (!this.isVarObservable(i)) continue;
            arrayList.add(this.getVarName(i));
        }
        return arrayList;
    }

    default public List<String> getUnobservableVars() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.getNumVars();
        for (int i = 0; i < n; ++i) {
            if (this.isVarObservable(i)) continue;
            arrayList.add(this.getVarName(i));
        }
        return arrayList;
    }

    default public String getActionStringDescription() {
        return "Action";
    }

    default public int getNumLabels() {
        return this.getLabelNames().size();
    }

    default public List<String> getLabelNames() {
        return Collections.emptyList();
    }

    default public String getLabelName(int n) throws PrismException {
        try {
            return this.getLabelNames().get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new PrismException("Label number " + n + " not defined");
        }
    }

    default public int getLabelIndex(String string) {
        return this.getLabelNames().indexOf(string);
    }

    default public int getNumObservables() {
        return this.getObservableNames().size();
    }

    default public List<String> getObservableNames() {
        return Collections.emptyList();
    }

    default public String getObservableName(int n) throws PrismException {
        try {
            return this.getObservableNames().get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new PrismException("Observable number " + n + " not defined");
        }
    }

    default public int getObservableIndex(String string) {
        return this.getObservableNames().indexOf(string);
    }

    default public List<Type> getObservableTypes() {
        return Collections.emptyList();
    }

    default public Type getObservableType(int n) {
        return this.getObservableTypes().get(n);
    }

    default public int getNumPlayers() {
        return this.getPlayerNames().size();
    }

    default public List<String> getPlayerNames() {
        if (this.getModelType().nondeterministic()) {
            return Collections.singletonList("");
        }
        return Collections.emptyList();
    }

    default public int getPlayerIndex(String string) {
        return this.getPlayerNames().indexOf(string);
    }

    default public String getPlayerName(int n) {
        return this.getPlayerNames().get(n);
    }

    default public boolean isIdentUsed(String string) {
        if (this.getVarIndex(string) != -1) {
            return true;
        }
        Values values = this.getConstantValues();
        return values != null & values.contains(string);
    }

    default public void checkIdent(String string, ASTElement aSTElement, String string2) throws PrismLangException {
        if (this.isIdentUsed(string)) {
            throw new PrismLangException("Identifier " + string + " is already used in the model", aSTElement);
        }
    }

    default public boolean isQuotedIdentUsed(String string) {
        return this.getLabelIndex(string) != -1;
    }

    default public void checkQuotedIdent(String string, ASTElement aSTElement, String string2) throws PrismLangException {
        if (this.isQuotedIdentUsed(string)) {
            throw new PrismLangException("Identifier \"" + string + "\" is already used in the model", aSTElement);
        }
    }
}

