/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import java.util.ArrayList;
import java.util.List;
import parser.ast.Command;
import parser.ast.Declaration;
import parser.ast.ExpressionExists;
import parser.ast.ExpressionForAll;
import parser.ast.ExpressionFunc;
import parser.ast.ExpressionIdent;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionSS;
import parser.ast.ExpressionStrategy;
import parser.ast.ExpressionTemporal;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.ast.PropertiesFile;
import parser.ast.RenamedModule;
import parser.ast.Update;
import parser.visitor.ASTTraverseModify;
import prism.PrismLangException;

public class Rename
extends ASTTraverseModify {
    private RenamedModule rm;

    public Rename(RenamedModule renamedModule) {
        this.rm = renamedModule;
    }

    @Override
    public void visitPost(ModulesFile modulesFile) throws PrismLangException {
        throw new PrismLangException("ModulesFile should never be renamed");
    }

    @Override
    public void visitPost(PropertiesFile propertiesFile) throws PrismLangException {
        throw new PrismLangException("PropertiesFile should never be renamed");
    }

    @Override
    public void visitPost(Declaration declaration) throws PrismLangException {
        String string = this.rm.getNewName(declaration.getName());
        if (string == null) {
            throw new PrismLangException("Definition of module \"" + this.rm.getName() + "\" must rename variable \"" + declaration.getName() + "\"", this.rm);
        }
        declaration.setName(string);
    }

    @Override
    public void visitPost(Module module) throws PrismLangException {
        module.setName(this.rm.getName());
    }

    @Override
    public void visitPost(Command command) throws PrismLangException {
        List<String> list = command.getSynchs();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String string2 = this.rm.getNewName(string);
            arrayList.add(string2 == null ? string : string2);
        }
        command.setSynchs(arrayList);
    }

    @Override
    public void visitPost(Update update) throws PrismLangException {
        int n = update.getNumElements();
        for (int i = 0; i < n; ++i) {
            String string = this.rm.getNewName(update.getVar(i));
            if (string == null) continue;
            update.setVar(i, new ExpressionIdent(string));
        }
    }

    @Override
    public void visitPost(ExpressionTemporal expressionTemporal) throws PrismLangException {
        throw new PrismLangException("Temporal operators should never be renamed");
    }

    @Override
    public void visitPost(ExpressionFunc expressionFunc) throws PrismLangException {
        String string = this.rm.getNewName(expressionFunc.getName());
        if (string != null) {
            expressionFunc.setName(string);
        }
    }

    @Override
    public void visitPost(ExpressionIdent expressionIdent) throws PrismLangException {
        String string = this.rm.getNewName(expressionIdent.getName());
        if (string != null) {
            expressionIdent.setName(string);
        }
    }

    @Override
    public void visitPost(ExpressionProb expressionProb) throws PrismLangException {
        throw new PrismLangException("P operator should never be renamed");
    }

    @Override
    public void visitPost(ExpressionReward expressionReward) throws PrismLangException {
        throw new PrismLangException("R operator should never be renamed");
    }

    @Override
    public void visitPost(ExpressionSS expressionSS) throws PrismLangException {
        throw new PrismLangException("S operator should never be renamed");
    }

    @Override
    public void visitPost(ExpressionExists expressionExists) throws PrismLangException {
        throw new PrismLangException("E operator should never be renamed");
    }

    @Override
    public void visitPost(ExpressionForAll expressionForAll) throws PrismLangException {
        throw new PrismLangException("A operator should never be renamed");
    }

    @Override
    public void visitPost(ExpressionStrategy expressionStrategy) throws PrismLangException {
        throw new PrismLangException(expressionStrategy.getOperatorString() + " operator should never be renamed");
    }
}

