/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import parser.ast.Expression;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionProp;
import parser.ast.LabelList;
import parser.ast.PropertiesFile;
import parser.ast.Property;
import parser.type.Type;
import parser.visitor.ASTTraverseModify;
import prism.PrismLangException;

public class ExpandPropRefsAndLabels
extends ASTTraverseModify {
    private PropertiesFile propertiesFile;
    private LabelList labelList;

    public ExpandPropRefsAndLabels(PropertiesFile propertiesFile, LabelList labelList) {
        this.propertiesFile = propertiesFile;
        this.labelList = labelList;
    }

    @Override
    public Object visit(ExpressionLabel expressionLabel) throws PrismLangException {
        if (this.labelList == null) {
            return expressionLabel;
        }
        int n = this.labelList.getLabelIndex(expressionLabel.getName());
        if (n != -1) {
            Expression expression = this.labelList.getLabel(n).deepCopy();
            expression = (Expression)expression.accept(this);
            Type type = expression.getType();
            expression = Expression.Parenth(expression);
            expression.setType(type);
            return expression;
        }
        return expressionLabel;
    }

    @Override
    public Object visit(ExpressionProp expressionProp) throws PrismLangException {
        if (this.propertiesFile == null) {
            return expressionProp;
        }
        Property property = this.propertiesFile.lookUpPropertyObjectByName(expressionProp.getName());
        if (property != null) {
            Expression expression = property.getExpression().deepCopy();
            expression = (Expression)expression.accept(this);
            Type type = expression.getType();
            expression = Expression.Parenth(expression);
            expression.setType(type);
            return expression;
        }
        return expressionProp;
    }
}

