/*
 * Decompiled with CFR 0.152.
 */
package jltl2dstar;

import java.io.PrintStream;
import java.util.Iterator;
import jltl2ba.MyBitSet;

public class SafraTreeNode
implements Iterable<SafraTreeNode> {
    private int _id;
    private MyBitSet _labeling;
    private boolean _final_flag;
    private SafraTreeNode _parent;
    private SafraTreeNode _olderBrother;
    private SafraTreeNode _youngerBrother;
    private SafraTreeNode _oldestChild;
    private SafraTreeNode _youngestChild;
    private int _childCount;

    public SafraTreeNode(int n) {
        this._id = n;
        this._final_flag = false;
        this._parent = null;
        this._olderBrother = null;
        this._youngerBrother = null;
        this._oldestChild = null;
        this._youngestChild = null;
        this._childCount = 0;
        this._labeling = new MyBitSet();
    }

    public int getID() {
        return this._id;
    }

    public boolean hasFinalFlag() {
        return this._final_flag;
    }

    public int getChildCount() {
        return this._childCount;
    }

    public MyBitSet getLabeling() {
        return this._labeling;
    }

    public SafraTreeNode getOlderBrother() {
        return this._olderBrother;
    }

    public SafraTreeNode getYoungerBrother() {
        return this._youngerBrother;
    }

    public SafraTreeNode getOldestChild() {
        return this._oldestChild;
    }

    public SafraTreeNode getYoungestChild() {
        return this._youngestChild;
    }

    public SafraTreeNode getParent() {
        return this._parent;
    }

    public void setFinalFlag(boolean bl) {
        this._final_flag = bl;
    }

    public void setLabeling(MyBitSet myBitSet) {
        this._labeling = myBitSet;
    }

    private boolean null_or_eq(SafraTreeNode safraTreeNode, SafraTreeNode safraTreeNode2) {
        return safraTreeNode == null && safraTreeNode2 == null || safraTreeNode != null && safraTreeNode2 != null && safraTreeNode.getID() == safraTreeNode2.getID();
    }

    public boolean equals(SafraTreeNode safraTreeNode) {
        if (this._id != safraTreeNode._id) {
            return false;
        }
        if (this._final_flag != safraTreeNode._final_flag) {
            return false;
        }
        if (this._childCount != safraTreeNode._childCount) {
            return false;
        }
        if (!this._labeling.equals(safraTreeNode._labeling)) {
            return false;
        }
        if (!this.null_or_eq(this._parent, safraTreeNode._parent)) {
            return false;
        }
        if (!this.null_or_eq(this._olderBrother, safraTreeNode._olderBrother)) {
            return false;
        }
        if (!this.null_or_eq(this._youngerBrother, safraTreeNode._youngerBrother)) {
            return false;
        }
        if (!this.null_or_eq(this._oldestChild, safraTreeNode._oldestChild)) {
            return false;
        }
        return this.null_or_eq(this._youngestChild, safraTreeNode._youngestChild);
    }

    public boolean equals(Object object) {
        if (object instanceof SafraTreeNode) {
            return this.equals((SafraTreeNode)object);
        }
        return false;
    }

    public boolean structuralEquals(SafraTreeNode safraTreeNode) {
        if (this._final_flag != safraTreeNode._final_flag) {
            return false;
        }
        if (this._childCount != safraTreeNode._childCount) {
            return false;
        }
        if (!this._labeling.equals(safraTreeNode._labeling)) {
            return false;
        }
        if (this._childCount > 0) {
            SafraTreeNode safraTreeNode2 = this.getOldestChild();
            SafraTreeNode safraTreeNode3 = safraTreeNode.getOldestChild();
            do {
                if (!safraTreeNode2.structuralEquals(safraTreeNode3)) {
                    return false;
                }
                safraTreeNode2 = safraTreeNode2.getYoungerBrother();
                safraTreeNode3 = safraTreeNode3.getYoungerBrother();
            } while (safraTreeNode2 != null && safraTreeNode3 != null);
            assert (safraTreeNode2 == null && safraTreeNode3 == null);
        }
        return true;
    }

    private int null_or_cmpID(SafraTreeNode safraTreeNode, SafraTreeNode safraTreeNode2) {
        if (safraTreeNode == null) {
            if (safraTreeNode2 == null) {
                return 0;
            }
            return -1;
        }
        if (safraTreeNode2 == null) {
            return 1;
        }
        return safraTreeNode.getID() - safraTreeNode2.getID();
    }

    public boolean lessThan(SafraTreeNode safraTreeNode) {
        if (this._id < safraTreeNode._id) {
            return true;
        }
        if (!this._final_flag && safraTreeNode._final_flag) {
            return true;
        }
        if (this._childCount < safraTreeNode._childCount) {
            return true;
        }
        if (this._labeling.compareTo(safraTreeNode._labeling) < 0) {
            return true;
        }
        if (this.null_or_cmpID(this._parent, safraTreeNode._parent) != 0) {
            return this.null_or_cmpID(this._parent, safraTreeNode._parent) < 0;
        }
        if (this.null_or_cmpID(this._olderBrother, safraTreeNode._olderBrother) != 0) {
            return this.null_or_cmpID(this._olderBrother, safraTreeNode._olderBrother) < 0;
        }
        if (this.null_or_cmpID(this._youngerBrother, safraTreeNode._youngerBrother) != 0) {
            return this.null_or_cmpID(this._youngerBrother, safraTreeNode._youngerBrother) < 0;
        }
        if (this.null_or_cmpID(this._oldestChild, safraTreeNode._oldestChild) != 0) {
            return this.null_or_cmpID(this._oldestChild, safraTreeNode._oldestChild) < 0;
        }
        if (this.null_or_cmpID(this._youngestChild, safraTreeNode._youngestChild) != 0) {
            return this.null_or_cmpID(this._youngestChild, safraTreeNode._youngestChild) < 0;
        }
        return false;
    }

    public boolean structuralLessThan(SafraTreeNode safraTreeNode) {
        return this.compareTo(safraTreeNode) < 0;
    }

    public int compareTo(SafraTreeNode safraTreeNode) {
        if (this._final_flag ^ safraTreeNode._final_flag) {
            return this._final_flag ? 1 : -1;
        }
        int n = this._childCount - safraTreeNode._childCount;
        if (n != 0) {
            return n;
        }
        n = this._labeling.compareTo(safraTreeNode._labeling);
        if (n != 0) {
            return n;
        }
        if (this._childCount > 0) {
            SafraTreeNode safraTreeNode2 = this.getOldestChild();
            SafraTreeNode safraTreeNode3 = safraTreeNode.getOldestChild();
            do {
                if ((n = safraTreeNode2.compareTo(safraTreeNode3)) != 0) {
                    return n;
                }
                safraTreeNode2 = safraTreeNode2.getYoungerBrother();
                safraTreeNode3 = safraTreeNode3.getYoungerBrother();
            } while (safraTreeNode2 != null && safraTreeNode3 != null);
            assert (safraTreeNode2 == null && safraTreeNode3 == null);
        }
        return 0;
    }

    public void addAsYoungestChild(SafraTreeNode safraTreeNode) {
        assert (safraTreeNode != null);
        assert (safraTreeNode.getParent() == null);
        assert (safraTreeNode.getOlderBrother() == null);
        assert (safraTreeNode.getYoungerBrother() == null);
        if (this._youngestChild != null) {
            assert (this._youngestChild._youngerBrother == null);
            this._youngestChild._youngerBrother = safraTreeNode;
            safraTreeNode._olderBrother = this._youngestChild;
        }
        safraTreeNode._parent = this;
        this._youngestChild = safraTreeNode;
        if (this._oldestChild == null) {
            this._oldestChild = safraTreeNode;
        }
        ++this._childCount;
    }

    public void addAsOldestChild(SafraTreeNode safraTreeNode) {
        assert (safraTreeNode.getParent() == null);
        assert (safraTreeNode.getOlderBrother() == null);
        assert (safraTreeNode.getYoungerBrother() == null);
        if (this._oldestChild != null) {
            assert (this._oldestChild._olderBrother == null);
            this._oldestChild._olderBrother = safraTreeNode;
            safraTreeNode._youngerBrother = this._oldestChild;
        }
        safraTreeNode._parent = this;
        this._oldestChild = safraTreeNode;
        if (this._youngestChild == null) {
            this._youngestChild = safraTreeNode;
        }
        ++this._childCount;
    }

    public void removeFromTree() {
        assert (this._childCount == 0);
        if (this._parent == null) {
            return;
        }
        if (this._olderBrother != null) {
            this._olderBrother._youngerBrother = this._youngerBrother;
        }
        if (this._youngerBrother != null) {
            this._youngerBrother._olderBrother = this._olderBrother;
        }
        if (this._parent._oldestChild == this) {
            this._parent._oldestChild = this._youngerBrother;
        }
        if (this._parent._youngestChild == this) {
            this._parent._youngestChild = this._olderBrother;
        }
        --this._parent._childCount;
        this._youngerBrother = null;
        this._olderBrother = null;
        this._parent = null;
    }

    public void swapChildren(SafraTreeNode safraTreeNode, SafraTreeNode safraTreeNode2) {
        assert (safraTreeNode.getParent() == safraTreeNode2.getParent() && safraTreeNode.getParent() == this);
        if (safraTreeNode == safraTreeNode2) {
            return;
        }
        if (this._oldestChild == safraTreeNode) {
            this._oldestChild = safraTreeNode2;
        } else if (this._oldestChild == safraTreeNode2) {
            this._oldestChild = safraTreeNode;
        }
        if (this._youngestChild == safraTreeNode) {
            this._youngestChild = safraTreeNode2;
        } else if (this._youngestChild == safraTreeNode2) {
            this._youngestChild = safraTreeNode;
        }
        SafraTreeNode safraTreeNode3 = safraTreeNode._olderBrother;
        SafraTreeNode safraTreeNode4 = safraTreeNode2._olderBrother;
        SafraTreeNode safraTreeNode5 = safraTreeNode._youngerBrother;
        SafraTreeNode safraTreeNode6 = safraTreeNode2._youngerBrother;
        if (safraTreeNode3 != null) {
            safraTreeNode3._youngerBrother = safraTreeNode2;
        }
        if (safraTreeNode4 != null) {
            safraTreeNode4._youngerBrother = safraTreeNode;
        }
        if (safraTreeNode5 != null) {
            safraTreeNode5._olderBrother = safraTreeNode2;
        }
        if (safraTreeNode6 != null) {
            safraTreeNode6._olderBrother = safraTreeNode;
        }
        safraTreeNode._olderBrother = safraTreeNode4;
        safraTreeNode._youngerBrother = safraTreeNode6;
        safraTreeNode2._olderBrother = safraTreeNode3;
        safraTreeNode2._youngerBrother = safraTreeNode5;
        if (safraTreeNode5 == safraTreeNode2) {
            safraTreeNode._olderBrother = safraTreeNode2;
            safraTreeNode2._youngerBrother = safraTreeNode;
        } else if (safraTreeNode6 == safraTreeNode) {
            safraTreeNode._youngerBrother = safraTreeNode2;
            safraTreeNode2._olderBrother = safraTreeNode;
        }
    }

    @Override
    public Iterator<SafraTreeNode> iterator() {
        return new SafraTreeNodeIterator(this);
    }

    public int treeHeight() {
        int n = 0;
        if (this.getChildCount() > 0) {
            for (SafraTreeNode safraTreeNode : this) {
                int n2 = safraTreeNode.treeHeight();
                if (n2 <= n) continue;
                n = n2;
            }
        }
        return n + 1;
    }

    public int treeWidth() {
        int n = 0;
        if (this.getChildCount() > 0) {
            for (SafraTreeNode safraTreeNode : this) {
                n += safraTreeNode.treeWidth();
            }
        } else {
            n = 1;
        }
        return n;
    }

    public int hashCode() {
        int n = 1;
        n += this.hasFinalFlag() ? 1 : 0;
        n = n * 31 + this.getLabeling().hashCode();
        if (this.getChildCount() > 0) {
            for (SafraTreeNode safraTreeNode : this) {
                n = n * 31 + safraTreeNode.hashCode();
            }
        }
        return n;
    }

    public void print(PrintStream printStream) {
        printStream.print(this._id + " ");
        this._labeling.print(printStream);
        if (this._final_flag) {
            printStream.print(" !");
        }
    }

    public void toHTML(PrintStream printStream) {
        printStream.print(this.toHTMLString());
    }

    public String toHTMLString() {
        StringBuffer stringBuffer = new StringBuffer("<TABLE><TR>");
        if (this.getChildCount() <= 1) {
            stringBuffer.append("<TD>");
        } else {
            stringBuffer.append("<TD COLSPAN=\"");
            stringBuffer.append(this.getChildCount());
            stringBuffer.append("\">");
        }
        stringBuffer.append(this.getID());
        stringBuffer.append(" ");
        stringBuffer.append(this._labeling);
        if (this._final_flag) {
            stringBuffer.append("!");
        }
        stringBuffer.append("</TD></TR>");
        if (this.getChildCount() > 0) {
            stringBuffer.append("<TR>");
            for (SafraTreeNode safraTreeNode : this) {
                stringBuffer.append("<TD>");
                stringBuffer.append(safraTreeNode.toHTMLString());
                stringBuffer.append("</TD>");
            }
            stringBuffer.append("</TR>");
        }
        stringBuffer.append("</TABLE>");
        return stringBuffer.toString();
    }

    public static class SafraTreeNodeIterator
    implements Iterator<SafraTreeNode> {
        private SafraTreeNode _current;

        public SafraTreeNodeIterator(SafraTreeNode safraTreeNode) {
            this._current = safraTreeNode.getOldestChild();
        }

        @Override
        public SafraTreeNode next() {
            SafraTreeNode safraTreeNode = this._current;
            this._current = this._current.getYoungerBrother();
            return safraTreeNode;
        }

        @Override
        public boolean hasNext() {
            return this._current != null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

