/*
 * Decompiled with CFR 0.152.
 */
package jltl2ba;

import jltl2ba.SimpleLTL;

public class LTLFragments {
    private boolean syntacticSafety;
    private boolean syntacticGuarantee;
    private boolean syntacticObligation;
    private boolean syntacticRecurrence;
    private boolean syntacticPersistence;

    private LTLFragments() {
        this.syntacticSafety = true;
        this.syntacticGuarantee = true;
        this.syntacticObligation = true;
        this.syntacticRecurrence = true;
        this.syntacticPersistence = true;
    }

    private LTLFragments(LTLFragments lTLFragments) {
        this.syntacticSafety = lTLFragments.syntacticSafety;
        this.syntacticGuarantee = lTLFragments.syntacticGuarantee;
        this.syntacticObligation = lTLFragments.syntacticObligation;
        this.syntacticRecurrence = lTLFragments.syntacticRecurrence;
        this.syntacticPersistence = lTLFragments.syntacticPersistence;
    }

    public boolean isSyntacticSafety() {
        return this.syntacticSafety;
    }

    public boolean isSyntacticGuarantee() {
        return this.syntacticGuarantee;
    }

    public boolean isSyntacticObligation() {
        return this.syntacticObligation;
    }

    public boolean isSyntacticRecurrence() {
        return this.syntacticRecurrence;
    }

    public boolean isSyntacticPersistence() {
        return this.syntacticPersistence;
    }

    public String toString() {
        Object object = "[";
        boolean bl = true;
        if (this.isSyntacticSafety()) {
            if (!bl) {
                object = (String)object + ",";
            }
            bl = false;
            object = (String)object + "syntactic safety";
        }
        if (this.isSyntacticGuarantee()) {
            if (!bl) {
                object = (String)object + ",";
            }
            bl = false;
            object = (String)object + "syntactic guarantee";
        }
        if (this.isSyntacticObligation()) {
            if (!bl) {
                object = (String)object + ",";
            }
            bl = false;
            object = (String)object + "syntactic obligation";
        }
        if (this.isSyntacticRecurrence()) {
            if (!bl) {
                object = (String)object + ",";
            }
            bl = false;
            object = (String)object + "syntactic recurrence";
        }
        if (this.isSyntacticPersistence()) {
            if (!bl) {
                object = (String)object + ",";
            }
            bl = false;
            object = (String)object + "syntactic persistence";
        }
        return (String)object + "]";
    }

    private LTLFragments and(LTLFragments lTLFragments) {
        LTLFragments lTLFragments2 = new LTLFragments(this);
        lTLFragments2.syntacticSafety &= lTLFragments.syntacticSafety;
        lTLFragments2.syntacticGuarantee &= lTLFragments.syntacticGuarantee;
        lTLFragments2.syntacticObligation &= lTLFragments.syntacticObligation;
        lTLFragments2.syntacticRecurrence &= lTLFragments.syntacticRecurrence;
        lTLFragments2.syntacticPersistence &= lTLFragments.syntacticPersistence;
        return lTLFragments2;
    }

    private LTLFragments or(LTLFragments lTLFragments) {
        LTLFragments lTLFragments2 = new LTLFragments(this);
        lTLFragments2.syntacticSafety &= lTLFragments.syntacticSafety;
        lTLFragments2.syntacticGuarantee &= lTLFragments.syntacticGuarantee;
        lTLFragments2.syntacticObligation &= lTLFragments.syntacticObligation;
        lTLFragments2.syntacticRecurrence &= lTLFragments.syntacticRecurrence;
        lTLFragments2.syntacticPersistence &= lTLFragments.syntacticPersistence;
        return lTLFragments2;
    }

    private LTLFragments not() {
        LTLFragments lTLFragments = new LTLFragments();
        lTLFragments.syntacticSafety = this.syntacticGuarantee;
        lTLFragments.syntacticGuarantee = this.syntacticSafety;
        lTLFragments.syntacticObligation = this.syntacticObligation;
        lTLFragments.syntacticRecurrence = this.syntacticPersistence;
        lTLFragments.syntacticPersistence = this.syntacticRecurrence;
        return lTLFragments;
    }

    private LTLFragments nextstep() {
        return new LTLFragments(this);
    }

    private LTLFragments eventually() {
        LTLFragments lTLFragments = new LTLFragments(this);
        lTLFragments.syntacticSafety = false;
        lTLFragments.syntacticObligation = this.syntacticGuarantee;
        lTLFragments.syntacticRecurrence = this.syntacticGuarantee;
        return lTLFragments;
    }

    private LTLFragments always() {
        LTLFragments lTLFragments = new LTLFragments(this);
        lTLFragments.syntacticGuarantee = false;
        lTLFragments.syntacticObligation = this.syntacticSafety;
        lTLFragments.syntacticPersistence = this.syntacticSafety;
        return lTLFragments;
    }

    private LTLFragments until(LTLFragments lTLFragments) {
        LTLFragments lTLFragments2 = new LTLFragments();
        lTLFragments2.syntacticSafety = false;
        lTLFragments2.syntacticGuarantee = this.syntacticGuarantee & lTLFragments.syntacticGuarantee;
        lTLFragments2.syntacticObligation = this.syntacticObligation & lTLFragments.syntacticGuarantee;
        lTLFragments2.syntacticRecurrence = this.syntacticRecurrence & lTLFragments.syntacticGuarantee;
        lTLFragments2.syntacticPersistence = this.syntacticPersistence & lTLFragments.syntacticPersistence;
        return lTLFragments2;
    }

    private LTLFragments release(LTLFragments lTLFragments) {
        LTLFragments lTLFragments2 = new LTLFragments();
        lTLFragments2.syntacticSafety = this.syntacticSafety & lTLFragments.syntacticSafety;
        lTLFragments2.syntacticGuarantee = false;
        lTLFragments2.syntacticObligation = this.syntacticObligation & lTLFragments.syntacticSafety;
        lTLFragments2.syntacticRecurrence = this.syntacticRecurrence & lTLFragments.syntacticRecurrence;
        lTLFragments2.syntacticPersistence = this.syntacticPersistence & lTLFragments.syntacticSafety;
        return lTLFragments2;
    }

    private LTLFragments equiv(LTLFragments lTLFragments) {
        LTLFragments lTLFragments2 = this.and(lTLFragments);
        LTLFragments lTLFragments3 = this.not().and(lTLFragments.not());
        return lTLFragments2.or(lTLFragments3);
    }

    private LTLFragments implies(LTLFragments lTLFragments) {
        LTLFragments lTLFragments2 = this.not().or(lTLFragments);
        return lTLFragments2;
    }

    public static LTLFragments analyse(SimpleLTL simpleLTL) {
        switch (simpleLTL.kind) {
            case TRUE: 
            case FALSE: {
                return new LTLFragments();
            }
            case AP: {
                return new LTLFragments();
            }
            case NOT: {
                return LTLFragments.analyse(simpleLTL.left).not();
            }
            case AND: {
                return LTLFragments.analyse(simpleLTL.left).and(LTLFragments.analyse(simpleLTL.right));
            }
            case OR: {
                return LTLFragments.analyse(simpleLTL.left).or(LTLFragments.analyse(simpleLTL.right));
            }
            case FINALLY: {
                return LTLFragments.analyse(simpleLTL.left).eventually();
            }
            case GLOBALLY: {
                return LTLFragments.analyse(simpleLTL.left).always();
            }
            case NEXT: {
                return LTLFragments.analyse(simpleLTL.left).nextstep();
            }
            case UNTIL: {
                return LTLFragments.analyse(simpleLTL.left).until(LTLFragments.analyse(simpleLTL.right));
            }
            case RELEASE: {
                return LTLFragments.analyse(simpleLTL.left).release(LTLFragments.analyse(simpleLTL.right));
            }
            case EQUIV: {
                return LTLFragments.analyse(simpleLTL.left).equiv(LTLFragments.analyse(simpleLTL.right));
            }
            case IMPLIES: {
                return LTLFragments.analyse(simpleLTL.left).implies(LTLFragments.analyse(simpleLTL.right));
            }
        }
        throw new UnsupportedOperationException();
    }
}

