/*
 * Decompiled with CFR 0.152.
 */
package jdd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import prism.Prism;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;

public class DebugJDD {
    public static boolean debugEnabled = false;
    public static boolean traceAll = false;
    public static boolean traceFollowCopies = false;
    public static boolean warningsAreFatal = false;
    public static boolean warningsOff = false;
    protected static LinkedHashMap<Long, DebugJDDNode> nodes = new LinkedHashMap();
    protected static HashMap<Long, Integer> javaRefs = new HashMap();
    protected static HashSet<Long> traceIDs = null;
    protected static boolean raisedError = false;

    public static void enable() {
        debugEnabled = true;
    }

    public static void enableTracingForID(long l) {
        if (traceIDs == null) {
            traceIDs = new HashSet();
        }
        traceIDs.add(l);
        System.out.println("DebugJDD: Enable tracing for ID " + l);
        DebugJDD.enable();
    }

    private static boolean isTraced(DebugJDDNode debugJDDNode) {
        if (traceAll) {
            return true;
        }
        return traceIDs != null && traceIDs.contains(debugJDDNode.getID());
    }

    private static void addToSet(DebugJDDNode debugJDDNode) {
        if (nodes.put(debugJDDNode.getID(), debugJDDNode) != null) {
            DebugJDD.reportError("DebugJDD: Internal error, adding the same JDDNode multiple times, ID=" + debugJDDNode.getID());
        }
    }

    public static void endLifeCycle() {
        if (raisedError) {
            System.out.println("There was a fatal error, skipping DDNode leak checking...");
            return;
        }
        Map<Long, Integer> map = DebugJDD.getExternalRefCounts();
        if (map.size() == 0) {
            return;
        }
        System.out.println("\nWarning: Found " + map.size() + " leaked JDDNode references.");
        System.out.flush();
        for (Map.Entry<Long, Integer> entry : map.entrySet()) {
            long l = entry.getKey();
            ArrayList<DebugJDDNode> arrayList = new ArrayList<DebugJDDNode>();
            ArrayList<DebugJDDNode> arrayList2 = new ArrayList<DebugJDDNode>();
            for (DebugJDDNode debugJDDNode : nodes.values()) {
                if (debugJDDNode.ptr() != l) continue;
                arrayList.add(debugJDDNode);
                if (debugJDDNode.getNodeRefs() <= 0) continue;
                arrayList2.add(debugJDDNode);
            }
            System.out.println("DdNode ptr=0x" + Long.toHexString(l) + ", " + DebugJDD.nodeInfo(l) + " has " + String.valueOf(entry.getValue()) + " remaining external references.");
            if (arrayList2.size() > 0) {
                System.out.println(" Candidates:");
                for (DebugJDDNode debugJDDNode : arrayList2) {
                    System.out.println("  ID=" + debugJDDNode.getID() + " with " + debugJDDNode.getNodeRefs() + " references  (" + debugJDDNode.toStringVerbose() + ")");
                }
                continue;
            }
            System.out.println(" No candidates, here are all JDDNodes for that DdNode:");
            for (DebugJDDNode debugJDDNode : arrayList) {
                System.out.println("  ID=" + debugJDDNode.getID() + " with " + debugJDDNode.getNodeRefs() + " references  (" + debugJDDNode.toStringVerbose() + ")");
            }
        }
        nodes.clear();
        javaRefs.clear();
        DebugJDDNode.nextId = 0L;
        if (warningsAreFatal) {
            DebugJDD.reportError("DebugJDD: Leaked references");
        }
    }

    private static void reportError(String string) {
        raisedError = true;
        throw new RuntimeException(string);
    }

    public static int getRefCount(JDDNode jDDNode) {
        return JDD.DebugJDD_GetRefCount(jDDNode.ptr());
    }

    public static int getJavaRefCount(long l) {
        Integer n = javaRefs.get(l);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static Map<Long, Integer> getExternalRefCounts() {
        TreeMap<Long, Integer> treeMap = new TreeMap<Long, Integer>();
        long[] lArray = JDD.DebugJDD_GetExternalRefCounts();
        int n = 0;
        while (n < lArray.length) {
            long l = lArray[n++];
            int n2 = (int)lArray[n++];
            treeMap.put(l, n2);
        }
        return treeMap;
    }

    private static String nodeInfo(long l) {
        if (JDDNode.DDN_IsConstant(l)) {
            return "constant(" + JDDNode.DDN_GetValue(l) + "), CUDD refs=" + JDD.DebugJDD_GetRefCount(l);
        }
        return "var(" + JDDNode.DDN_GetIndex(l) + "), CUDD refs=" + JDD.DebugJDD_GetRefCount(l);
    }

    private static void trace(String string, DebugJDDNode debugJDDNode) {
        System.out.println("\ntrace(" + string + ", ID=" + debugJDDNode.getID() + ") => " + debugJDDNode.getNodeRefs() + " refs for this JDDNode\n " + debugJDDNode.toStringVerbose());
        DebugJDD.printStack(0);
    }

    private static void printStack(int n) {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        boolean bl = false;
        int n2 = 0;
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string = stackTraceElement.toString();
            if (!bl) {
                if (string.startsWith("java.lang") || string.startsWith("jdd.DebugJDD")) continue;
                bl = true;
            }
            if (n > 0 && n2++ >= n) {
                System.out.println("  ...");
                break;
            }
            System.out.println("  at " + string);
        }
        System.out.println();
        System.out.flush();
    }

    protected static void Ref(JDDNode jDDNode) {
        if (jDDNode instanceof DebugJDDNodeLight) {
            DebugJDD.reportError("DebugJDD: Illegal operation, trying to reference a light-weight JDDNode (obtained from getThen()/getElse()) directly. Use copy() instead");
        }
        if (!(jDDNode instanceof DebugJDDNode)) {
            DebugJDD.reportError("DebugJDD: Internal error, encountered a node object of type " + jDDNode.getClass().getName() + " in debug mode");
        }
        DebugJDDNode debugJDDNode = (DebugJDDNode)jDDNode;
        debugJDDNode.incRef();
        JDD.DD_Ref(jDDNode.ptr());
        if (DebugJDD.isTraced(debugJDDNode)) {
            DebugJDD.trace("Ref", debugJDDNode);
        }
    }

    protected static void Deref(JDDNode jDDNode) {
        int n;
        DebugJDDNode debugJDDNode;
        if (jDDNode instanceof DebugJDDNodeLight) {
            DebugJDD.reportError("DebugJDD: Illegal operation, trying to dereference a light-weight JDDNode (obtained from getThen()/getElse()) directly");
        }
        if (!(jDDNode instanceof DebugJDDNode)) {
            DebugJDD.reportError("DebugJDD: Internal error, encountered a node object of type " + jDDNode.getClass().getName() + " in debug mode");
        }
        if ((debugJDDNode = (DebugJDDNode)jDDNode).getNodeRefs() <= 0 && DebugJDD.getJavaRefCount(jDDNode.ptr()) > 0) {
            String string = "DebugJDD: Deref of a JDDNode with non-positive ref count:\n " + debugJDDNode.toStringVerbose();
            if (!warningsOff && !warningsAreFatal) {
                System.out.println("Warning, " + string);
                DebugJDD.printStack(0);
            } else if (!warningsOff && warningsAreFatal) {
                DebugJDD.reportError(string);
            }
        }
        if (DebugJDD.getJavaRefCount(jDDNode.ptr()) <= 0) {
            DebugJDD.reportError("DebugJDD: Trying to Deref a JDDNode with non-positive Java ref count:\n " + debugJDDNode.toStringVerbose());
        }
        if ((n = JDD.DebugJDD_GetRefCount(jDDNode.ptr())) <= 0) {
            DebugJDD.reportError("DebugJDD: Trying to Deref a JDDNode with a non-positive CUDD ref count\n " + debugJDDNode.toStringVerbose());
        }
        debugJDDNode.decRef();
        JDD.DD_Deref(jDDNode.ptr());
        if (DebugJDD.isTraced(debugJDDNode)) {
            DebugJDD.trace("Deref", debugJDDNode);
        }
    }

    protected static JDDNode Copy(JDDNode jDDNode) {
        DebugJDDNode debugJDDNode;
        if (jDDNode instanceof DebugJDDNodeLight) {
            DebugJDDNode debugJDDNode2 = new DebugJDDNode(jDDNode.ptr(), true);
            JDD.DD_Ref(debugJDDNode2.ptr());
            if (DebugJDD.isTraced(debugJDDNode2)) {
                DebugJDD.trace("Copied from light-weight node", debugJDDNode2);
            }
            return debugJDDNode2;
        }
        if (!(jDDNode instanceof DebugJDDNode)) {
            DebugJDD.reportError("DebugJDD: Internal error, encountered a node object of type " + jDDNode.getClass().getName() + " in debug mode");
        }
        if ((debugJDDNode = (DebugJDDNode)jDDNode).getNodeRefs() <= 0) {
            DebugJDD.reportError("DebugJDD: Trying to copy a JDDNode with non-positive ref count:\n " + debugJDDNode.toStringVerbose());
        }
        if (DebugJDD.getRefCount(debugJDDNode) <= 0) {
            DebugJDD.reportError("DebugJDD: Trying to copy a JDDNode with non-positive CUDD ref count:\n " + debugJDDNode.toStringVerbose());
        }
        DebugJDDNode debugJDDNode3 = new DebugJDDNode(debugJDDNode.ptr(), true);
        JDD.DD_Ref(debugJDDNode3.ptr());
        if (DebugJDD.isTraced(debugJDDNode)) {
            DebugJDD.trace("Copy to " + debugJDDNode3.getID(), debugJDDNode);
        }
        if (!traceAll && traceFollowCopies && DebugJDD.isTraced(debugJDDNode)) {
            DebugJDD.enableTracingForID(debugJDDNode3.getID());
        }
        if (DebugJDD.isTraced(debugJDDNode3)) {
            DebugJDD.trace("Copied from " + debugJDDNode.getID(), debugJDDNode3);
        }
        return debugJDDNode3;
    }

    protected static JDDNode ptrToNode(long l) {
        DebugJDDNode debugJDDNode = new DebugJDDNode(l, true);
        if (DebugJDD.isTraced(debugJDDNode)) {
            DebugJDD.trace("ptrToNode", debugJDDNode);
        }
        return debugJDDNode;
    }

    private static void useNode(DebugJDDNode debugJDDNode) {
        int n;
        DebugJDDNode debugJDDNode2 = debugJDDNode;
        if (debugJDDNode2.getNodeRefs() <= 0 && DebugJDD.getJavaRefCount(debugJDDNode.ptr()) > 0) {
            String string = "DebugJDD: Trying to use a JDDNode with non-positive ref count:\n " + debugJDDNode2.toStringVerbose();
            if (!warningsOff && !warningsAreFatal) {
                System.out.println("Warning, " + string);
                DebugJDD.printStack(0);
            } else if (!warningsOff && warningsAreFatal) {
                DebugJDD.reportError(string);
            }
        }
        if (DebugJDD.getJavaRefCount(debugJDDNode.ptr()) <= 0) {
            DebugJDD.reportError("DebugJDD: Trying to use a JDDNode with non-positive Java ref count in a method call:\n " + debugJDDNode2.toStringVerbose());
        }
        if ((n = JDD.DebugJDD_GetRefCount(debugJDDNode.ptr())) <= 0) {
            DebugJDD.reportError("DebugJDD: Trying to use a JDDNode with a non-positive CUDD ref count in a method call:\n " + debugJDDNode2.toStringVerbose());
        }
    }

    protected static void DD_Method_Argument(JDDNode jDDNode) {
        if (jDDNode instanceof DebugJDDNodeLight) {
            DebugJDD.reportError("DebugJDD: Illegal operation, trying to use a light-weight JDDNode (obtained from getThen()/getElse()) in a method call");
        }
        if (!(jDDNode instanceof DebugJDDNode)) {
            DebugJDD.reportError("DebugJDD: Internal error, encountered a node object of type " + jDDNode.getClass().getName() + " in debug mode");
        }
        DebugJDDNode debugJDDNode = (DebugJDDNode)jDDNode;
        DebugJDD.useNode(debugJDDNode);
        debugJDDNode.decRef();
        if (DebugJDD.isTraced(debugJDDNode)) {
            DebugJDD.trace("Deref (as method argument)", debugJDDNode);
        }
    }

    protected static JDDNode nodeGetThen(JDDNode jDDNode) {
        if (jDDNode instanceof DebugJDDNode) {
            DebugJDDNode debugJDDNode = (DebugJDDNode)jDDNode;
            DebugJDD.useNode(debugJDDNode);
        } else if (!(jDDNode instanceof DebugJDDNodeLight)) {
            DebugJDD.reportError("DebugJDD: Internal error, encountered a node object of type " + jDDNode.getClass().getName() + " in debug mode");
        }
        long l = JDDNode.DDN_GetThen(jDDNode.ptr());
        if (l == 0L) {
            if (jDDNode.isConstant()) {
                DebugJDD.reportError("Trying to access the 'then' child of a constant MTBDD node");
            } else {
                DebugJDD.reportError("getThen: CUDD returned NULL, but node is not a constant node. Out of memory or corrupted MTBDD?");
            }
        }
        return new DebugJDDNodeLight(l);
    }

    protected static JDDNode nodeGetElse(JDDNode jDDNode) {
        if (jDDNode instanceof DebugJDDNode) {
            DebugJDDNode debugJDDNode = (DebugJDDNode)jDDNode;
            DebugJDD.useNode(debugJDDNode);
        } else if (!(jDDNode instanceof DebugJDDNodeLight)) {
            DebugJDD.reportError("DebugJDD: Internal error, encountered a node object of type " + jDDNode.getClass().getName() + " in debug mode");
        }
        long l = JDDNode.DDN_GetElse(jDDNode.ptr());
        if (l == 0L) {
            if (jDDNode.isConstant()) {
                DebugJDD.reportError("Trying to access the 'else' child of a constant MTBDD node");
            } else {
                DebugJDD.reportError("getElse: CUDD returned NULL, but node is not a constant node. Out of memory or corrupted MTBDD?");
            }
        }
        return new DebugJDDNodeLight(l);
    }

    protected static double nodeGetValue(JDDNode jDDNode) {
        if (jDDNode instanceof DebugJDDNode) {
            DebugJDDNode debugJDDNode = (DebugJDDNode)jDDNode;
            DebugJDD.useNode(debugJDDNode);
        } else if (!(jDDNode instanceof DebugJDDNodeLight)) {
            DebugJDD.reportError("DebugJDD: Internal error, encountered a node object of type " + jDDNode.getClass().getName() + " in debug mode");
        }
        if (!jDDNode.isConstant()) {
            DebugJDD.reportError("Trying to get value of MTBDD node, but is not a constant node");
        }
        return JDDNode.DDN_GetValue(jDDNode.ptr());
    }

    private static void test_1() {
        JDDNode jDDNode = JDD.Constant(2.0);
    }

    private static void test_2() {
        JDDNode jDDNode = JDD.Constant(2.0);
        JDD.Deref(jDDNode);
        JDD.Deref(jDDNode);
    }

    private static void test_3() {
        JDDNode jDDNode = JDD.Constant(2.0);
        JDD.Deref(jDDNode);
        JDDNode jDDNode2 = JDD.ITE(JDD.Constant(1.0), jDDNode, JDD.Constant(0.0));
        JDD.Deref(jDDNode2);
    }

    private static void test_4() {
        JDDNode jDDNode = JDD.Constant(2.0);
        JDDNode jDDNode2 = jDDNode.copy();
        JDD.Deref(jDDNode);
        JDDNode jDDNode3 = JDD.ITE(JDD.Constant(1.0), jDDNode, JDD.Constant(0.0));
        JDD.Deref(jDDNode3);
    }

    private static void test_5() {
        JDDNode jDDNode = JDD.Var(0);
        JDDVars jDDVars = new JDDVars();
        jDDVars.addVar(jDDNode);
        JDDNode jDDNode2 = JDD.ITE(jDDNode.copy(), JDD.Constant(2.0), JDD.Constant(1.0));
        JDDNode jDDNode3 = JDD.Constant(2.0);
        jDDNode2 = JDD.Times(jDDNode2, jDDNode3);
        jDDNode2 = JDD.SumAbstract(jDDNode2, jDDVars);
        JDD.Deref(jDDNode2);
        jDDVars.derefAll();
    }

    private static void test_6() {
        JDDNode jDDNode = JDD.Constant(2.0);
        JDDNode jDDNode2 = jDDNode.getThen();
    }

    private static void test_7() {
        JDDNode jDDNode = JDD.Constant(2.0);
        JDDNode jDDNode2 = jDDNode.getElse();
    }

    private static void test_8() {
        JDDNode jDDNode = JDD.Var(0);
        double d = jDDNode.getValue();
    }

    private static void test_9() {
        JDDNode jDDNode = JDD.Var(0);
        JDDNode jDDNode2 = JDD.Apply(6, jDDNode.getThen(), jDDNode.getElse());
        JDD.Deref(jDDNode2);
    }

    private static void test_10() {
        JDDNode jDDNode = JDD.Var(0);
        JDD.Deref(jDDNode.getThen());
        JDD.Deref(jDDNode);
    }

    private static void test_11() {
        JDDNode jDDNode = JDD.Var(0);
        JDDNode jDDNode2 = jDDNode.getThen();
        JDD.Ref(jDDNode2);
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode);
    }

    private static void test_12() {
        JDDNode jDDNode = JDD.Var(0);
        JDDNode jDDNode2 = JDD.Apply(6, jDDNode.getThen().copy(), jDDNode.getElse().copy());
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode);
    }

    private static void usage() {
        System.out.println("\nUsage: PRISM_MAINCLASS=jdd.DebugJDD prism [arguments] [test cases]");
        System.out.println("\nExample: PRISM_MAINCLASS=jdd.DebugJDD prism -dddebug 1 4");
        System.out.println("   Run test cases 1 and 4, with debugging enabled");
        System.out.println("\nArguments:");
        System.out.println(" -dddebug                 Enabled JDD debugging");
        System.out.println(" -ddtraceall              Trace all JDD nodes");
        System.out.println(" -ddtracefollowcopies     Trace copies of traced JDD nodes as well");
        System.out.println(" -dddebugwarnfatal        Treat warnings as errors");
        System.out.println(" -dddebugwarnoff          Turn off warnings");
        System.out.println(" -ddtrace n               Trace JDDNode with ID=n");
        System.out.println("\nFor the test cases, look at the source code in jdd/DebugJDD.java");
    }

    private static void errorAndExit(String string) {
        System.out.println(string);
        DebugJDD.usage();
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Object object;
        System.out.println("PRISM [jdd.DebugJDD test bed / demonstrator]");
        System.out.println("============================================\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() > 0 && stringArray[i].charAt(0) == '-') {
                object = stringArray[i].substring(1);
                if (((String)object).length() == 0) {
                    DebugJDD.errorAndExit("Invalid empty switch");
                }
                if (((String)object).charAt(0) == '-') {
                    object = ((String)object).substring(1);
                }
                if (((String)object).equals("dddebug")) {
                    DebugJDD.enable();
                    continue;
                }
                if (((String)object).equals("ddtraceall")) {
                    traceAll = true;
                    continue;
                }
                if (((String)object).equals("ddtracefollowcopies")) {
                    traceFollowCopies = true;
                    continue;
                }
                if (((String)object).equals("dddebugwarnfatal")) {
                    warningsAreFatal = true;
                    continue;
                }
                if (((String)object).equals("dddebugwarnoff")) {
                    warningsOff = true;
                    continue;
                }
                if (((String)object).equals("ddtrace")) {
                    if (i < stringArray.length - 1) {
                        String string = stringArray[++i];
                        try {
                            int n = Integer.parseInt(string);
                            DebugJDD.enableTracingForID(n);
                        }
                        catch (NumberFormatException numberFormatException) {
                            DebugJDD.errorAndExit("The -" + (String)object + " switch requires an integer argument (JDDNode ID)");
                        }
                        continue;
                    }
                    DebugJDD.errorAndExit("The -" + (String)object + " switch requires an additional argument (JDDNode ID)");
                    continue;
                }
                DebugJDD.errorAndExit("Unknown switch: -" + (String)object);
                continue;
            }
            arrayList.add(stringArray[i]);
        }
        try {
            PrismFileLog prismFileLog = new PrismFileLog("stdout");
            prismFileLog.println("\n[Initializing PRISM]\n");
            object = new Prism(prismFileLog);
            ((Prism)object).initialise();
            int n = 1;
            block33: for (String string : arrayList) {
                ((PrismLog)prismFileLog).print("\n[Running test case " + string);
                if (arrayList.size() > 1) {
                    ((PrismLog)prismFileLog).print(" (" + n + "/" + arrayList.size() + ")");
                }
                prismFileLog.println("]\n");
                ++n;
                switch (string) {
                    case "1": {
                        DebugJDD.test_1();
                        continue block33;
                    }
                    case "2": {
                        DebugJDD.test_2();
                        continue block33;
                    }
                    case "3": {
                        DebugJDD.test_3();
                        continue block33;
                    }
                    case "4": {
                        DebugJDD.test_4();
                        continue block33;
                    }
                    case "5": {
                        DebugJDD.test_5();
                        continue block33;
                    }
                    case "6": {
                        DebugJDD.test_6();
                        continue block33;
                    }
                    case "7": {
                        DebugJDD.test_7();
                        continue block33;
                    }
                    case "8": {
                        DebugJDD.test_8();
                        continue block33;
                    }
                    case "9": {
                        DebugJDD.test_9();
                        continue block33;
                    }
                    case "10": {
                        DebugJDD.test_10();
                        continue block33;
                    }
                    case "11": {
                        DebugJDD.test_11();
                        continue block33;
                    }
                    case "12": {
                        DebugJDD.test_12();
                        continue block33;
                    }
                }
                DebugJDD.errorAndExit("Unknown test case: " + string);
            }
            prismFileLog.println("\n[Closing down PRISM/CUDD]\n");
            ((Prism)object).closeDown(true);
            ((PrismLog)prismFileLog).println();
            ((PrismLog)prismFileLog).close();
        }
        catch (PrismException prismException) {
            prismException.printStackTrace();
            System.exit(1);
        }
    }

    protected static class DebugJDDNode
    extends JDDNode {
        private static long nextId = 0L;
        private long id = nextId++;
        private int nodeRefs = 0;

        public DebugJDDNode(long l, boolean bl) {
            super(l);
            if (bl) {
                this.incRef();
            }
            DebugJDD.addToSet(this);
        }

        public long getID() {
            return this.id;
        }

        public void incRef() {
            ++this.nodeRefs;
            int n = DebugJDD.getJavaRefCount(this.ptr());
            javaRefs.put(this.ptr(), n + 1);
        }

        public void decRef() {
            --this.nodeRefs;
            int n = DebugJDD.getJavaRefCount(this.ptr()) - 1;
            javaRefs.put(this.ptr(), n);
            if (n < 0) {
                DebugJDD.reportError("DebugJDD: The number of Java references is negative for\n " + this.toStringVerbose());
            }
            if (n > JDD.DebugJDD_GetRefCount(this.ptr())) {
                DebugJDD.reportError("DebugJDD: More Java refs than CUDD refs for\n " + this.toStringVerbose());
            }
            if (n < this.getNodeRefs()) {
                DebugJDD.reportError("DebugJDD: JDDNode has more refs than Java refs in total?!\n " + this.toStringVerbose());
            }
        }

        public int getNodeRefs() {
            return this.nodeRefs;
        }

        public String toStringVerbose() {
            return "ID = " + this.getID() + ", CUDD ptr = " + this.ptrAsHex() + ", refs for this JDDNode = " + this.getNodeRefs() + ", refs from Java = " + DebugJDD.getJavaRefCount(this.ptr()) + ", refs from CUDD (including internal MTBDD refs) = " + JDD.DebugJDD_GetRefCount(this.ptr());
        }

        public String ptrAsHex() {
            return "0x" + Long.toHexString(this.ptr());
        }
    }

    protected static class DebugJDDNodeLight
    extends JDDNode {
        public DebugJDDNodeLight(long l) {
            super(l);
        }
    }
}

