/*
 * Decompiled with CFR 0.152.
 */
package io;

import io.ModelExportOptions;
import java.util.Objects;
import prism.Evaluator;

public class Transition<V>
implements Comparable<Transition<V>> {
    protected int target;
    protected V value;
    protected Object action;
    protected Evaluator<V> evaluator;

    public Transition(int n, V v, Object object, Evaluator<V> evaluator) {
        this.target = n;
        this.value = v;
        this.action = object;
        this.evaluator = evaluator;
    }

    public boolean isZero() {
        return this.evaluator.isZero(this.value);
    }

    @Override
    public int compareTo(Transition<V> transition) {
        int n = Integer.compare(this.target, transition.target);
        if (n != 0) {
            return n;
        }
        return Objects.compare(Objects.toString(this.action), Objects.toString(transition.action), String::compareTo);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Transition transition = (Transition)object;
        return this.target == transition.target && Objects.equals(this.value, transition.value) && Objects.equals(this.action, transition.action);
    }

    public int hashCode() {
        return Objects.hash(this.target, this.value, this.action);
    }

    public String toString() {
        String string = this.target + ", " + String.valueOf(this.value);
        if (this.action != null) {
            string = string + ", " + String.valueOf(this.action);
        }
        return string;
    }

    public String toString(ModelExportOptions modelExportOptions) {
        return this.evaluator.toStringExport(this.value, modelExportOptions.getModelPrecision());
    }
}

