/*
 * Decompiled with CFR 0.152.
 */
package explicit.rewards;

import explicit.Product;
import explicit.rewards.RewardsExplicit;
import java.util.Arrays;

public class StateRewardsArray
extends RewardsExplicit<Double> {
    protected double[] stateRewards;

    public StateRewardsArray(int n) {
        this.stateRewards = new double[n];
    }

    public StateRewardsArray(StateRewardsArray stateRewardsArray) {
        this.stateRewards = Arrays.copyOf(stateRewardsArray.stateRewards, stateRewardsArray.stateRewards.length);
    }

    @Override
    public void setStateReward(int n, Double d) {
        this.stateRewards[n] = d;
    }

    @Override
    public void addToStateReward(int n, Double d) {
        int n2 = n;
        this.stateRewards[n2] = this.stateRewards[n2] + d;
    }

    @Override
    public boolean hasTransitionRewards() {
        return false;
    }

    @Override
    public Double getStateReward(int n) {
        return this.stateRewards[n];
    }

    public StateRewardsArray liftFromModel(Product<?> product) {
        Object obj = product.getProductModel();
        int n = obj.getNumStates();
        StateRewardsArray stateRewardsArray = new StateRewardsArray(n);
        for (int i = 0; i < n; ++i) {
            stateRewardsArray.setStateReward(i, this.stateRewards[product.getModelState(i)]);
        }
        return stateRewardsArray;
    }
}

