/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceReach;
import acceptance.AcceptanceType;
import automata.DA;
import automata.DASimplifyAcceptance;
import explicit.CSG;
import explicit.CSGModelCheckerEquilibria;
import explicit.CSGSimple;
import explicit.Distribution;
import explicit.LTLModelChecker;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.ModelExplicit;
import explicit.ProbModelChecker;
import explicit.rewards.CSGRewards;
import explicit.rewards.CSGRewardsSimple;
import explicit.rewards.StateRewardsConstant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import lpsolve.LpSolve;
import lpsolve.LpSolveException;
import org.apache.commons.math3.util.Precision;
import parser.State;
import parser.ast.Coalition;
import parser.ast.ExpressionTemporal;
import prism.IntegerBound;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismUtils;
import strat.CSGStrategy;

public class CSGModelChecker
extends ProbModelChecker {
    public static final int R_INFINITY = 0;
    public static final int R_CUMULATIVE = 1;
    public static final int R_ZERO = 2;
    protected double scaleFactor = this.getSettings().getDouble("prism.lpscalefactor");
    protected int numPlayers;
    protected int numCoalitions;
    protected BitSet[] coalitionIndexes;
    protected BitSet[] actionIndexes;
    protected int maxRows;
    protected int maxCols;
    protected int[] maxNumActions;
    protected double[] avgNumActions;
    protected ArrayList<ArrayList<String>> actions;
    protected ArrayList<ArrayList<Integer>> strategies;
    protected HashMap<BitSet, ArrayList<Double>> utilities = new HashMap();
    protected HashMap<BitSet, ArrayList<Distribution<Double>>> probabilities = new HashMap();
    protected int varIndex;
    protected double minEntry;
    protected boolean allEqual;
    protected long timerVal;
    protected HashMap<Integer, Integer> map_state;
    protected List<State> list_state;

    public CSGModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
        this.actions = new ArrayList();
        this.strategies = new ArrayList();
    }

    public ModelCheckerResult computeNextProbs(CSG<Double> cSG, BitSet bitSet, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        LpSolve lpSolve;
        int n;
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        ArrayList<ArrayList<Double>> arrayList = new ArrayList();
        HashMap<Integer, BitSet> hashMap = null;
        ArrayList<List<List<Map<BitSet, Double>>>> arrayList2 = null;
        ArrayList<Map<BitSet, Double>> arrayList3 = null;
        double[] dArray = new double[cSG.getNumStates()];
        if (this.genStrat) {
            hashMap = new HashMap<Integer, BitSet>();
            arrayList3 = new ArrayList<Map<BitSet, Double>>();
            arrayList2 = new ArrayList<List<List<Map<BitSet, Double>>>>(1);
            arrayList2.add(0, new ArrayList());
            ((List)arrayList2.get(0)).add(0, new ArrayList());
            for (int i = 0; i < cSG.getNumStates(); ++i) {
                ((List)((List)arrayList2.get(0)).get(0)).add(i, null);
                arrayList3.add(i, null);
            }
        }
        long l = System.currentTimeMillis();
        this.buildCoalitions(cSG, coalition, bl);
        for (n = 0; n < cSG.getNumStates(); ++n) {
            dArray[n] = bitSet.get(n) ? 1.0 : 0.0;
        }
        try {
            lpSolve = LpSolve.makeLp((int)(this.maxCols + 1), (int)(this.maxRows + 1));
            lpSolve.setVerbose(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PrismException(exception.toString());
        }
        for (n = 0; n < cSG.getNumStates(); ++n) {
            arrayList = this.buildMatrixGame(cSG, null, hashMap, dArray, n, bl);
            dArray[n] = this.val(lpSolve, arrayList, arrayList3, hashMap, n, true, bl);
            if (!this.genStrat) continue;
            this.updateStrategy(arrayList3, arrayList2, 0, n, false);
        }
        l = System.currentTimeMillis() - l;
        modelCheckerResult.soln = dArray;
        modelCheckerResult.lastSoln = null;
        modelCheckerResult.numIters = 1;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        if (this.genStrat) {
            modelCheckerResult.strat = new CSGStrategy(cSG, arrayList2, new BitSet(), bitSet, new BitSet(), CSGStrategy.CSGStrategyType.ZERO_SUM);
        }
        return modelCheckerResult;
    }

    public ModelCheckerResult computeBoundedReachProbs(CSG<Double> cSG, BitSet bitSet, BitSet bitSet2, int n, boolean bl, boolean bl2, Coalition coalition, boolean bl3) throws PrismException {
        ModelCheckerResult modelCheckerResult = null;
        BitSet bitSet3 = new BitSet();
        BitSet bitSet4 = new BitSet();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting bounded probabilistic reachability...");
        }
        this.buildCoalitions(cSG, coalition, bl);
        bitSet3.set(0, cSG.getNumStates());
        bitSet3.andNot(bitSet2);
        bitSet3.andNot(bitSet);
        bitSet4.or(bitSet2);
        switch (this.solnMethod) {
            case VALUE_ITERATION: {
                modelCheckerResult = this.computeReachProbsValIter(cSG, bitSet3, bitSet4, n, true, bl);
                break;
            }
            default: {
                throw new PrismException("Unknown CSG solution method " + String.valueOf((Object)this.solnMethod));
            }
        }
        return modelCheckerResult;
    }

    public ModelCheckerResult computeUntilProbs(CSG<Double> cSG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        return this.computeUntilProbs(cSG, bitSet, bitSet2, this.maxIters, bl, bl2, coalition);
    }

    public ModelCheckerResult computeBoundedUntilProbs(CSG<Double> cSG, BitSet bitSet, BitSet bitSet2, int n, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        return this.computeUntilProbs(cSG, bitSet, bitSet2, n, bl, bl2, coalition);
    }

    public ModelCheckerResult computeReachProbs(CSG<Double> cSG, BitSet bitSet, boolean bl, boolean bl2, int n, Coalition coalition, boolean bl3) throws PrismException {
        boolean bl4;
        ModelCheckerResult modelCheckerResult = null;
        boolean bl5 = bl4 = n != this.maxIters;
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting probabilistic reachability...");
        }
        int n2 = cSG.getNumStates();
        BitSet bitSet2 = new BitSet();
        bitSet2.set(0, cSG.getNumStates());
        BitSet bitSet3 = new BitSet();
        BitSet bitSet4 = new BitSet();
        bitSet4.or(bitSet);
        this.buildCoalitions(cSG, coalition, !bl);
        long l = System.currentTimeMillis();
        if (!bl4 && this.precomp && this.prob0) {
            bitSet3.or(bitSet);
            bitSet3.flip(0, n2);
            bitSet3 = this.G(cSG, bitSet3);
        }
        l = System.currentTimeMillis() - l;
        this.buildCoalitions(cSG, coalition, bl);
        long l2 = System.currentTimeMillis();
        if (!bl4 && this.precomp && this.prob1) {
            if (!this.genStrat) {
                bitSet4.or(this.AF(cSG, bitSet));
            } else {
                this.mainLog.println("Disabling Prob1 precomputation to allow strategy generation");
            }
        }
        l2 = System.currentTimeMillis() - l2;
        int n3 = bitSet4.cardinality();
        int n4 = bitSet3.cardinality();
        if (this.verbosity >= 1) {
            this.mainLog.println("target=" + bitSet.cardinality() + ", yes=" + n3 + ", no=" + n4 + ", maybe=" + (n2 - (n3 + n4)));
        }
        switch (this.solnMethod) {
            case VALUE_ITERATION: {
                modelCheckerResult = this.computeReachProbsValIter(cSG, bitSet3, bitSet4, n, false, bl);
                break;
            }
            default: {
                throw new PrismException("Unknown CSG solution method " + String.valueOf((Object)this.solnMethod));
            }
        }
        modelCheckerResult.timeProb0 = (double)l / 1000.0;
        modelCheckerResult.timePre = (double)(l + l2) / 1000.0;
        if (this.verbosity >= 1) {
            this.mainLog.println("Precomputation took " + modelCheckerResult.timePre / 1000.0 + " seconds.");
        }
        return modelCheckerResult;
    }

    public ModelCheckerResult computeUntilProbs(CSG<Double> cSG, BitSet bitSet, BitSet bitSet2, int n, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        boolean bl3;
        ModelCheckerResult modelCheckerResult = null;
        boolean bl4 = bl3 = n != this.maxIters;
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting probabilistic reachability (until)...");
        }
        int n2 = cSG.getNumStates();
        BitSet bitSet3 = new BitSet();
        bitSet3.set(0, cSG.getNumStates());
        BitSet bitSet4 = new BitSet();
        BitSet bitSet5 = new BitSet();
        BitSet bitSet6 = new BitSet();
        bitSet5 = (BitSet)bitSet3.clone();
        bitSet5.andNot(bitSet2);
        bitSet5.andNot(bitSet);
        this.buildCoalitions(cSG, coalition, !bl);
        long l = System.currentTimeMillis();
        if (!bl3 && this.precomp && this.prob0) {
            bitSet4.or(bitSet2);
            bitSet4.flip(0, n2);
            bitSet4 = this.G(cSG, bitSet4);
        }
        l = System.currentTimeMillis() - l;
        bitSet4.or(bitSet5);
        bitSet5.clear();
        bitSet5.set(0, n2);
        bitSet5.andNot(bitSet);
        bitSet5.andNot(bitSet2);
        bitSet4.or(bitSet5);
        this.buildCoalitions(cSG, coalition, bl);
        long l2 = System.currentTimeMillis();
        if (!bl3 && this.precomp && this.prob1) {
            if (!this.genStrat) {
                bitSet6.or(this.AF(cSG, bitSet, bitSet2));
            } else {
                this.mainLog.println("Disabling Prob1 precomputation to allow strategy generation");
            }
        }
        l2 = System.currentTimeMillis() - l2;
        bitSet6.or(bitSet2);
        int n3 = bitSet6.cardinality();
        int n4 = bitSet4.cardinality();
        if (this.verbosity >= 1) {
            this.mainLog.println("target=" + bitSet2.cardinality() + ", yes=" + n3 + ", no=" + n4 + ", maybe=" + (n2 - (n3 + n4)));
        }
        switch (this.solnMethod) {
            case VALUE_ITERATION: {
                modelCheckerResult = this.computeReachProbsValIter(cSG, bitSet4, bitSet6, n, false, bl);
                break;
            }
            default: {
                throw new PrismException("Unknown CSG solution method " + String.valueOf((Object)this.solnMethod));
            }
        }
        modelCheckerResult.timeProb0 = (double)l / 1000.0;
        modelCheckerResult.timePre = (double)(l + l2) / 1000.0;
        if (this.verbosity >= 1) {
            this.mainLog.println("Precomputation took " + modelCheckerResult.timePre + " seconds.");
        }
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachProbsValIter(CSG<Double> cSG, BitSet bitSet, BitSet bitSet2, int n, boolean bl, boolean bl2) throws PrismException {
        int n2;
        LpSolve lpSolve;
        int n3;
        if (this.genStrat && bl) {
            throw new PrismException("Strategy synthesis for bounded properties is not supported yet.");
        }
        ArrayList<List<List<Map<BitSet, Double>>>> arrayList = null;
        ArrayList<Map<BitSet, Double>> arrayList2 = null;
        HashMap<Integer, BitSet> hashMap = null;
        BitSet bitSet3 = new BitSet();
        double[] dArray = new double[cSG.getNumStates()];
        double[] dArray2 = new double[cSG.getNumStates()];
        boolean bl3 = false;
        if (this.genStrat) {
            int n4;
            hashMap = new HashMap<Integer, BitSet>();
            arrayList2 = new ArrayList<Map<BitSet, Double>>();
            arrayList = new ArrayList<List<List<Map<BitSet, Double>>>>();
            arrayList.add(0, new ArrayList());
            ((List)arrayList.get(0)).add(0, new ArrayList());
            for (n4 = 0; n4 < cSG.getNumStates(); ++n4) {
                ((List)((List)arrayList.get(0)).get(0)).add(n4, null);
                arrayList2.add(n4, null);
            }
            if (bl) {
                for (n3 = 1; n3 < n; ++n3) {
                    ((List)arrayList.get(0)).add(n3, new ArrayList());
                    for (n4 = 0; n4 < cSG.getNumStates(); ++n4) {
                        ((List)((List)arrayList.get(0)).get(n3)).add(n4, null);
                    }
                }
            }
        }
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting value iteration...");
        }
        try {
            lpSolve = LpSolve.makeLp((int)(this.maxCols + 1), (int)(this.maxRows + 1));
            lpSolve.setVerbose(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PrismException(exception.toString());
        }
        bitSet3.or(bitSet);
        bitSet3.or(bitSet2);
        for (n2 = 0; n2 < cSG.getNumStates(); ++n2) {
            dArray2[n2] = bitSet.get(n2) ? 0.0 : (bitSet2.get(n2) ? 1.0 : 0.0);
            dArray[n2] = dArray2[n2];
        }
        n3 = 0;
        while (!bl3) {
            for (n2 = 0; n2 < cSG.getNumStates(); ++n2) {
                if (!bitSet3.get(n2)) {
                    ArrayList<ArrayList<Double>> arrayList3 = this.buildMatrixGame(cSG, null, hashMap, dArray2, n2, bl2);
                    dArray[n2] = this.val(lpSolve, arrayList3, arrayList2, hashMap, n2, false, bl2);
                    if (!this.genStrat) continue;
                    this.updateStrategy(arrayList2, arrayList, n3, n2, bl);
                    continue;
                }
                if (!this.genStrat) continue;
                ((List)((List)arrayList.get(0)).get(0)).add(n2, null);
            }
            bl3 = PrismUtils.doublesAreClose(dArray, dArray2, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.RELATIVE);
            if (!bl3 && ++n3 == this.maxIters) {
                throw new PrismException("Could not converge after " + this.maxIters + " iterations");
            }
            if (n3 == n) {
                bl3 = true;
                continue;
            }
            dArray2 = Arrays.copyOf(dArray, dArray.length);
        }
        this.mainLog.println("\nValue iteration converged after " + n3 + " iterations.");
        l = System.currentTimeMillis() - l;
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.numIters = n3;
        if (this.genStrat) {
            modelCheckerResult.strat = new CSGStrategy(cSG, arrayList, bitSet, bitSet2, new BitSet(), CSGStrategy.CSGStrategyType.ZERO_SUM);
        }
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeInstantaneousRewards(CSG<Double> cSG, CSGRewards<Double> cSGRewards, Coalition coalition, int n, boolean bl, boolean bl2) throws PrismException {
        LpSolve lpSolve;
        int n2;
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        ArrayList<ArrayList<Double>> arrayList = new ArrayList();
        ArrayList<Map<BitSet, Double>> arrayList2 = this.genStrat ? new ArrayList<Map<BitSet, Double>>() : null;
        this.mainLog.println("\nStarting backwards instantaneous rewards computation...");
        int n3 = cSG.getNumStates();
        long l = System.currentTimeMillis();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2] = (Double)cSGRewards.getStateReward(n2);
        }
        this.buildCoalitions(cSG, coalition, bl);
        try {
            lpSolve = LpSolve.makeLp((int)(this.maxCols + 1), (int)(this.maxRows + 1));
            lpSolve.setVerbose(3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PrismException(exception.toString());
        }
        for (n2 = 0; n2 < n; ++n2) {
            for (int i = 0; i < cSG.getNumStates(); ++i) {
                arrayList.clear();
                arrayList = this.buildMatrixGame(cSG, null, null, dArray, i, bl);
                try {
                    dArray2[i] = this.val(lpSolve, arrayList, arrayList2, null, i, true, bl);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new PrismException(exception.toString());
                }
            }
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Backwards transient instantaneous rewards computation took " + n2 + " iters and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.soln = dArray;
        modelCheckerResult.lastSoln = dArray2;
        modelCheckerResult.numIters = n2;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeCumulativeRewards(CSG<Double> cSG, CSGRewards<Double> cSGRewards, Coalition coalition, int n, boolean bl, boolean bl2, boolean bl3) throws PrismException {
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        this.buildCoalitions(cSG, coalition, bl);
        switch (this.solnMethod) {
            case VALUE_ITERATION: {
                modelCheckerResult = this.computeReachRewardsValIter(cSG, cSGRewards, new BitSet(), new BitSet(), new BitSet(), null, n, true, bl);
                break;
            }
            default: {
                throw new PrismException("Unknown CSG solution method " + String.valueOf((Object)this.solnMethod));
            }
        }
        return modelCheckerResult;
    }

    public ModelCheckerResult computeTotalRewards(CSG<Double> cSG, CSGRewards<Double> cSGRewards, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting total expected reward...");
        }
        long l = System.currentTimeMillis();
        int n = cSG.getNumStates();
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        bitSet2.set(0, n);
        for (int i = 0; i < n; ++i) {
            if ((Double)cSGRewards.getStateReward(i) != 0.0) {
                bitSet.set(i);
            }
            int n2 = 0;
            int n3 = 0;
            for (int j = 0; j < cSG.getNumChoices(i); ++j) {
                double d = (Double)cSGRewards.getTransitionReward(i, j);
                if (d > 0.0 && d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
                    ++n2;
                    bitSet.set(i);
                    continue;
                }
                if (d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) continue;
                ++n3;
            }
            if (n2 == 0 || n2 == cSG.getNumChoices(i) - n3) continue;
            this.mainLog.println(cSG.getStatesList().get(i));
            for (int j = 0; j < cSG.getNumChoices(i); ++j) {
                this.mainLog.println(String.valueOf(cSG.getAction(i, j)) + ": " + String.valueOf(cSGRewards.getTransitionReward(i, j)));
            }
            throw new PrismException("If a transition reward is nonzero, all reward transitions going from the state must be");
        }
        bitSet.flip(0, n);
        long l2 = System.currentTimeMillis();
        this.buildCoalitions(cSG, coalition, !bl);
        BitSet bitSet3 = this.AFG(cSG, bitSet);
        bitSet3.flip(0, n);
        l2 = System.currentTimeMillis() - l2;
        this.buildCoalitions(cSG, coalition, bl);
        switch (this.solnMethod) {
            case VALUE_ITERATION: {
                modelCheckerResult = this.computeReachRewardsValIter(cSG, cSGRewards, new BitSet(), null, bitSet3, null, this.maxIters, false, bl);
                break;
            }
            default: {
                throw new PrismException("Unknown CSG solution method " + String.valueOf((Object)this.solnMethod));
            }
        }
        l = System.currentTimeMillis() - l;
        modelCheckerResult.timeTaken = l;
        if (this.verbosity >= 1) {
            this.mainLog.println("Precomputation took " + (double)l2 / 1000.0 + " seconds.");
        }
        this.mainLog.println("Expected total reward took " + (double)l / 1000.0 + " seconds.");
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewards(CSG<Double> cSG, CSGRewards<Double> cSGRewards, BitSet bitSet, int n, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        switch (n) {
            case 0: {
                return this.computeReachRewardsInfinity(cSG, coalition, cSGRewards, bitSet, bl, bl2);
            }
            case 1: {
                return this.computeReachRewardsCumulative(cSG, coalition, cSGRewards, bitSet, bl, bl2, false);
            }
            case 2: {
                throw new PrismException("F0 is not yet supported for CSGs.");
            }
        }
        throw new PrismException("Unknown semantics for runs unreaching the target in CSGModelChecker: " + n);
    }

    public ModelCheckerResult computeReachRewardsInfinity(CSG<Double> cSG, Coalition coalition, CSGRewards<Double> cSGRewards, BitSet bitSet, boolean bl, boolean bl2) throws PrismException {
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting expected reachability...");
        }
        long l = 0L;
        long l2 = System.currentTimeMillis();
        int n = cSG.getNumStates();
        BitSet bitSet2 = new BitSet();
        bitSet2.set(0, n);
        double[] dArray = new double[n];
        long l3 = System.currentTimeMillis();
        this.buildCoalitions(cSG, coalition, !bl);
        BitSet bitSet3 = this.AF(cSG, bitSet);
        bitSet3.flip(0, n);
        l3 = System.currentTimeMillis() - l3;
        this.buildCoalitions(cSG, coalition, bl);
        int n2 = bitSet.cardinality();
        int n3 = bitSet3.cardinality();
        if (this.verbosity >= 1) {
            this.mainLog.println("target=" + n2 + ", inf=" + n3 + ", rest=" + (n - (n2 + n3)));
        }
        double d = Double.POSITIVE_INFINITY;
        double d2 = 0.0;
        boolean bl3 = true;
        for (int i = 0; i < n; ++i) {
            double d3 = (Double)cSGRewards.getStateReward(i);
            if (d3 > 0.0 && d3 < d) {
                d = d3;
            }
            if (d3 > d2) {
                d2 = d3;
            }
            bl3 = bl3 && d3 > 0.0;
            for (int j = 0; j < cSG.getNumChoices(i); ++j) {
                d3 = (Double)cSGRewards.getTransitionReward(i, j);
                if (d3 > 0.0 && d3 < d) {
                    d = d3;
                }
                if (d3 > d2) {
                    d2 = d3;
                }
                bl3 = bl3 && (Double)cSGRewards.getTransitionReward(i, j) > 0.0;
            }
        }
        if (!bl3 && !(cSGRewards instanceof StateRewardsConstant)) {
            l = System.currentTimeMillis();
            double d4 = Math.min(d, d2 * 0.01);
            if (this.verbosity >= 1) {
                this.mainLog.println("Computing the upper bound where " + d4 + " is used instead of 0.0");
            }
            switch (this.solnMethod) {
                case VALUE_ITERATION: {
                    dArray = this.computeReachRewardsValIter(cSG, this.replaceZeroRewards(cSGRewards, (double)d4), (BitSet)bitSet, null, (BitSet)bitSet3, null, (int)this.maxIters, (boolean)false, (boolean)bl).soln;
                    break;
                }
                default: {
                    throw new PrismException("Unknown CSG solution method " + String.valueOf((Object)this.solnMethod));
                }
            }
            l = System.currentTimeMillis() - l;
            if (this.verbosity >= 1) {
                this.mainLog.println("Computed an over-approximation of the solution (in " + (double)l / 1000.0 + " seconds), this will now be used to get the solution");
            }
        }
        switch (this.solnMethod) {
            case VALUE_ITERATION: {
                modelCheckerResult = this.computeReachRewardsValIter(cSG, cSGRewards, bitSet, null, bitSet3, dArray, this.maxIters, false, bl);
                break;
            }
            default: {
                throw new PrismException("Unknown CSG solution method " + String.valueOf((Object)this.solnMethod));
            }
        }
        l2 = System.currentTimeMillis() - l2;
        if (this.verbosity >= 1) {
            this.mainLog.println("Expected reachability took " + (double)l2 / 1000.0 + " seconds.");
        }
        modelCheckerResult.timeTaken = (double)l2 / 1000.0;
        modelCheckerResult.timePre = (double)(l3 + l) / 1000.0;
        if (this.verbosity >= 1) {
            this.mainLog.println("Precomputation took " + (double)l3 / 1000.0 + " seconds.");
        }
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewardsCumulative(CSG<Double> cSG, Coalition coalition, CSGRewards<Double> cSGRewards, BitSet bitSet, boolean bl, boolean bl2, boolean bl3) throws PrismException {
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting expected reachability...");
        }
        long l = System.currentTimeMillis();
        int n = cSG.getNumStates();
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        bitSet3.set(0, n);
        for (int i = 0; i < n; ++i) {
            if (bitSet.get(i)) continue;
            if ((Double)cSGRewards.getStateReward(i) != 0.0) {
                bitSet2.set(i);
            }
            int n2 = 0;
            int n3 = 0;
            for (int j = 0; j < cSG.getNumChoices(i); ++j) {
                double d = (Double)cSGRewards.getTransitionReward(i, j);
                if (d > 0.0 && d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) {
                    ++n2;
                    bitSet2.set(i);
                    continue;
                }
                if (d != Double.POSITIVE_INFINITY && d != Double.NEGATIVE_INFINITY) continue;
                ++n3;
            }
            if (n2 == 0 || n2 == cSG.getNumChoices(i) - n3) continue;
            this.mainLog.println(cSG.getStatesList().get(i));
            for (int j = 0; j < cSG.getNumChoices(i); ++j) {
                this.mainLog.println(String.valueOf(cSG.getAction(i, j)) + ": " + String.valueOf(cSGRewards.getTransitionReward(i, j)));
            }
            throw new PrismException("If a transition reward is nonzero, all reward transitions going from the state must be");
        }
        bitSet2.flip(0, n);
        long l2 = System.currentTimeMillis();
        this.buildCoalitions(cSG, coalition, !bl);
        BitSet bitSet4 = this.AFG(cSG, bitSet2);
        bitSet4.flip(0, n);
        l2 = System.currentTimeMillis() - l2;
        int n4 = bitSet.cardinality();
        int n5 = bitSet4.cardinality();
        if (this.verbosity >= 1) {
            this.mainLog.println("target=" + n4 + ", inf=" + n5 + ", rest=" + (n - (n4 + n5)));
        }
        this.buildCoalitions(cSG, coalition, bl);
        switch (this.solnMethod) {
            case VALUE_ITERATION: {
                modelCheckerResult = this.computeReachRewardsValIter(cSG, cSGRewards, bitSet, null, bitSet4, null, this.maxIters, false, bl);
                break;
            }
            default: {
                throw new PrismException("Unknown CSG solution method " + String.valueOf((Object)this.solnMethod));
            }
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.println("Precomputation took " + (double)l2 / 1000.0 + " seconds.");
        }
        this.mainLog.println("Expected total reward took " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = l;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewardsValIter(CSG<Double> cSG, CSGRewards<Double> cSGRewards, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, double[] dArray, int n, boolean bl, boolean bl2) throws PrismException {
        LpSolve lpSolve;
        int n2;
        int n3;
        if (this.genStrat && bl) {
            throw new PrismException("Strategy synthesis for bounded properties is not supported yet.");
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        ArrayList<ArrayList<Double>> arrayList = new ArrayList();
        ArrayList<List<List<Map<BitSet, Double>>>> arrayList2 = null;
        ArrayList<Map<BitSet, Double>> arrayList3 = null;
        HashMap<Integer, BitSet> hashMap = null;
        BitSet bitSet4 = new BitSet();
        double[] dArray2 = new double[cSG.getNumStates()];
        double[] dArray3 = new double[cSG.getNumStates()];
        boolean bl3 = false;
        if (this.genStrat) {
            hashMap = new HashMap<Integer, BitSet>();
            arrayList3 = new ArrayList<Map<BitSet, Double>>();
            arrayList2 = new ArrayList<List<List<Map<BitSet, Double>>>>();
            arrayList2.add(0, new ArrayList());
            ((List)arrayList2.get(0)).add(0, new ArrayList());
            for (n3 = 0; n3 < cSG.getNumStates(); ++n3) {
                ((List)((List)arrayList2.get(0)).get(0)).add(n3, null);
                arrayList3.add(n3, null);
            }
            if (bl) {
                for (n2 = 1; n2 < n; ++n2) {
                    ((List)arrayList2.get(0)).add(n2, new ArrayList());
                    for (n3 = 0; n3 < cSG.getNumStates(); ++n3) {
                        ((List)((List)arrayList2.get(0)).get(n2)).add(n3, null);
                    }
                }
            }
        }
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("\nStarting value iteration...");
        }
        try {
            lpSolve = LpSolve.makeLp((int)(this.maxCols + 1), (int)(this.maxRows + 1));
            lpSolve.setVerbose(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new PrismException(exception.toString());
        }
        if (dArray != null) {
            if (bitSet2 != null) {
                for (n3 = 0; n3 < cSG.getNumStates(); ++n3) {
                    dArray3[n3] = bitSet2.get(n3) ? dArray[n3] : (bitSet.get(n3) ? 0.0 : (bitSet3.get(n3) ? Double.POSITIVE_INFINITY : dArray[n3]));
                    dArray2[n3] = dArray3[n3];
                }
            } else {
                for (n3 = 0; n3 < cSG.getNumStates(); ++n3) {
                    dArray3[n3] = bitSet.get(n3) ? 0.0 : (bitSet3.get(n3) ? Double.POSITIVE_INFINITY : dArray[n3]);
                    dArray2[n3] = dArray3[n3];
                }
            }
        } else {
            for (n3 = 0; n3 < cSG.getNumStates(); ++n3) {
                dArray3[n3] = bitSet.get(n3) ? 0.0 : (bitSet3.get(n3) ? Double.POSITIVE_INFINITY : 0.0);
                dArray2[n3] = dArray3[n3];
            }
        }
        bitSet4.set(0, cSG.getNumStates());
        bitSet4.andNot(bitSet);
        bitSet4.andNot(bitSet3);
        n2 = 0;
        while (!bl3) {
            for (int i = 0; i < cSG.getNumStates(); ++i) {
                if (!bitSet4.get(i)) continue;
                arrayList = this.buildMatrixGame(cSG, cSGRewards, hashMap, dArray3, i, bl2);
                dArray2[i] = this.val(lpSolve, arrayList, arrayList3, hashMap, i, true, bl2);
                int n4 = i;
                dArray2[n4] = dArray2[n4] + (Double)cSGRewards.getStateReward(i);
                if (!this.genStrat) continue;
                this.updateStrategy(arrayList3, arrayList2, n2, i, bl);
            }
            bl3 = PrismUtils.doublesAreClose(dArray2, dArray3, this.termCritParam, this.termCrit == ProbModelChecker.TermCrit.RELATIVE);
            if (!bl3 && ++n2 == this.maxIters) {
                throw new PrismException("Could not converge after " + this.maxIters + " iterations");
            }
            if (n2 == n) {
                bl3 = true;
                continue;
            }
            dArray3 = Arrays.copyOf(dArray2, dArray2.length);
        }
        this.mainLog.println("\nValue iteration converged after " + n2 + " iterations.");
        l = System.currentTimeMillis() - l;
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.numIters = n2;
        if (this.genStrat) {
            modelCheckerResult.strat = new CSGStrategy(cSG, arrayList2, new BitSet(), bitSet, bitSet3, CSGStrategy.CSGStrategyType.ZERO_SUM);
        }
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeProbBoundedEquilibria(CSG<Double> cSG, List<Coalition> list, List<ExpressionTemporal> list2, BitSet[] bitSetArray, BitSet[] bitSetArray2, int[] nArray, int n, int n2, boolean bl) throws PrismException {
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        CSGModelCheckerEquilibria cSGModelCheckerEquilibria = new CSGModelCheckerEquilibria(this);
        cSGModelCheckerEquilibria.inheritSettings(this);
        modelCheckerResult = cSGModelCheckerEquilibria.computeBoundedEquilibria(cSG, list, null, list2, bitSetArray, bitSetArray2, nArray, n, n2, bl);
        return modelCheckerResult;
    }

    public ModelCheckerResult computeProbReachEquilibria(CSG<Double> cSG, List<Coalition> list, BitSet[] bitSetArray, BitSet[] bitSetArray2, int n, int n2, boolean bl) throws PrismException {
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        CSGModelCheckerEquilibria cSGModelCheckerEquilibria = new CSGModelCheckerEquilibria(this);
        cSGModelCheckerEquilibria.inheritSettings(this);
        modelCheckerResult = cSGModelCheckerEquilibria.computeReachEquilibria(cSG, list, null, bitSetArray, bitSetArray2, n, n2, bl);
        return modelCheckerResult;
    }

    public ModelCheckerResult computeRewBoundedEquilibria(CSG<Double> cSG, List<Coalition> list, List<CSGRewards<Double>> list2, List<ExpressionTemporal> list3, int[] nArray, int n, int n2, boolean bl) throws PrismException {
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        CSGModelCheckerEquilibria cSGModelCheckerEquilibria = new CSGModelCheckerEquilibria(this);
        cSGModelCheckerEquilibria.inheritSettings(this);
        modelCheckerResult = cSGModelCheckerEquilibria.computeBoundedEquilibria(cSG, list, list2, list3, null, null, nArray, n, n2, bl);
        return modelCheckerResult;
    }

    public ModelCheckerResult computeRewReachEquilibria(CSG<Double> cSG, List<Coalition> list, List<CSGRewards<Double>> list2, BitSet[] bitSetArray, int n, int n2, boolean bl) throws PrismException {
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        CSGModelCheckerEquilibria cSGModelCheckerEquilibria = new CSGModelCheckerEquilibria(this);
        cSGModelCheckerEquilibria.inheritSettings(this);
        modelCheckerResult = cSGModelCheckerEquilibria.computeReachEquilibria(cSG, list, list2, bitSetArray, null, n, n2, bl);
        return modelCheckerResult;
    }

    public ModelCheckerResult computeMixedEquilibria(CSG<Double> cSG, List<Coalition> list, List<CSGRewards<Double>> list2, List<ExpressionTemporal> list3, BitSet bitSet, BitSet[] bitSetArray, BitSet[] bitSetArray2, int[] nArray, int n, int n2, boolean bl) throws PrismException {
        int n3;
        LTLModelChecker.LTLProduct<CSG<Double>> lTLProduct;
        Object object;
        Object object2;
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        CSGModelCheckerEquilibria cSGModelCheckerEquilibria = new CSGModelCheckerEquilibria(this);
        cSGModelCheckerEquilibria.inheritSettings(this);
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        ArrayList<CSGRewards<Double>> arrayList = new ArrayList<CSGRewards<Double>>();
        boolean bl2 = list2 != null;
        int n4 = bitSet.nextSetBit(0);
        Object[] objectArray = new BitSet[bitSetArray2.length];
        BitSet[] bitSetArray3 = new BitSet[bitSetArray.length];
        Arrays.fill(objectArray, null);
        AcceptanceType[] acceptanceTypeArray = new AcceptanceType[]{AcceptanceType.RABIN, AcceptanceType.REACH, AcceptanceType.BUCHI, AcceptanceType.STREETT, AcceptanceType.GENERIC};
        if (bl2) {
            object2 = new BitSet();
            ((BitSet)object2).set(0, cSG.getNumStates());
            object = null;
            Vector<BitSet> vector = new Vector<BitSet>();
            vector.add(0, (BitSet)object2);
            bitSetArray[n4] = object2;
            switch (list3.get(n4).getOperator()) {
                case 12: {
                    object = CSGModelChecker.constructDRAForInstant("L0", new IntegerBound(null, false, nArray[n4] + 1, false));
                    break;
                }
                case 11: {
                    object = CSGModelChecker.constructDRAForInstant("L0", new IntegerBound(null, false, nArray[n4], false));
                }
            }
            DASimplifyAcceptance.simplifyAcceptance(this, object, new AcceptanceType[]{AcceptanceType.REACH});
            this.mainLog.println("\nConstructing CSG-" + ((DA)object).getAutomataType() + " product...");
            lTLProduct = lTLModelChecker.constructProductModel((DA<BitSet, ? extends AcceptanceOmega>)object, cSG, vector, null);
            this.mainLog.print("\n" + ((CSG)lTLProduct.getProductModel()).infoStringTable());
        } else {
            lTLProduct = lTLModelChecker.constructProductCSG(this, cSG, list3.get(n4), null, acceptanceTypeArray);
        }
        ((ModelExplicit)lTLProduct.productModel).clearInitialStates();
        ((ModelExplicit)lTLProduct.productModel).addInitialState(lTLProduct.getModelState(cSG.getFirstInitialState()));
        if (lTLProduct.getAcceptance() instanceof AcceptanceReach) {
            this.mainLog.println("\nSkipping BSCC computation since acceptance is defined via goal states...");
            bitSetArray3[n4] = ((AcceptanceReach)lTLProduct.getAcceptance()).getGoalStates();
        } else {
            this.mainLog.println("\nFinding accepting BSCCs...");
            bitSetArray3[n4] = lTLModelChecker.findAcceptingBSCCs((Model<?>)lTLProduct.getProductModel(), lTLProduct.getAcceptance());
        }
        for (n3 = 0; n3 < bitSetArray.length; ++n3) {
            if (n3 == n4) continue;
            bitSetArray3[n3] = lTLProduct.liftFromModel(bitSetArray[n3]);
        }
        for (n3 = 0; n3 < bitSetArray2.length; ++n3) {
            if (bitSetArray2[n3] == null) continue;
            objectArray[n3] = lTLProduct.liftFromModel(bitSetArray2[n3]);
        }
        if (bl2) {
            for (n3 = 0; n3 < list.size(); ++n3) {
                int n5;
                int n6;
                object2 = new CSGRewardsSimple(((CSG)lTLProduct.productModel).getNumStates());
                if (n3 != n4) {
                    for (n6 = 0; n6 < ((CSG)lTLProduct.productModel).getNumStates(); ++n6) {
                        ((CSGRewardsSimple)object2).addToStateReward(n6, (Double)list2.get(n3).getStateReward(lTLProduct.getModelState(n6)));
                        for (n5 = 0; n5 < ((CSG)lTLProduct.productModel).getNumChoices(n6); ++n5) {
                            ((CSGRewardsSimple)object2).addToTransitionReward(n6, n5, (Double)list2.get(n3).getTransitionReward(lTLProduct.getModelState(n6), n5));
                        }
                    }
                } else {
                    switch (list3.get(n4).getOperator()) {
                        case 12: {
                            for (n6 = 0; n6 < ((CSG)lTLProduct.productModel).getNumStates(); ++n6) {
                                for (n5 = 0; n5 < ((CSG)lTLProduct.productModel).getNumChoices(n6); ++n5) {
                                    object = ((CSG)lTLProduct.productModel).getSuccessorsIterator(n6, n5);
                                    while (object.hasNext()) {
                                        int n7 = (Integer)object.next();
                                        if (!bitSetArray3[n4].get(n7)) continue;
                                        ((CSGRewardsSimple)object2).addToStateReward(n6, (Double)list2.get(n3).getStateReward(lTLProduct.getModelState(n6)));
                                    }
                                    ((CSGRewardsSimple)object2).addToTransitionReward(n6, n5, 0.0);
                                }
                            }
                            break;
                        }
                        case 11: {
                            for (n6 = 0; n6 < ((CSG)lTLProduct.productModel).getNumStates(); ++n6) {
                                if (!bitSetArray3[n4].get(n6)) {
                                    ((CSGRewardsSimple)object2).addToStateReward(n6, (Double)list2.get(n3).getStateReward(lTLProduct.getModelState(n6)));
                                    for (n5 = 0; n5 < ((CSG)lTLProduct.productModel).getNumChoices(n6); ++n5) {
                                        ((CSGRewardsSimple)object2).addToTransitionReward(n6, n5, (Double)list2.get(n3).getTransitionReward(lTLProduct.getModelState(n6), n5));
                                    }
                                    continue;
                                }
                                ((CSGRewardsSimple)object2).addToStateReward(n6, 0.0);
                                for (n5 = 0; n5 < ((CSG)lTLProduct.productModel).getNumChoices(n6); ++n5) {
                                    ((CSGRewardsSimple)object2).addToTransitionReward(n6, n5, 0.0);
                                }
                            }
                            break;
                        }
                    }
                }
                arrayList.add(n3, (CSGRewards<Double>)object2);
            }
            modelCheckerResult = cSGModelCheckerEquilibria.computeReachEquilibria((CSG)lTLProduct.productModel, list, arrayList, bitSetArray3, null, n, n2, bl);
        } else {
            modelCheckerResult = cSGModelCheckerEquilibria.computeReachEquilibria((CSG)lTLProduct.productModel, list, null, bitSetArray3, (BitSet[])objectArray, n, n2, bl);
        }
        return modelCheckerResult;
    }

    public BitSet A(ArrayList<ArrayList<Distribution<Double>>> arrayList, BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = new BitSet();
        for (int i = 0; i < arrayList.size(); ++i) {
            boolean bl = true;
            for (int j = 0; j < arrayList.get(i).size(); ++j) {
                bl = bl && (arrayList.get(i).get(j).isSubsetOf(bitSet2) || bitSet.get(j));
            }
            if (!bl) continue;
            bitSet3.set(i);
        }
        return bitSet3;
    }

    public BitSet B(ArrayList<ArrayList<Distribution<Double>>> arrayList, BitSet bitSet, BitSet bitSet2) {
        BitSet bitSet3 = new BitSet();
        block0: for (int i = 0; i < arrayList.get(0).size(); ++i) {
            boolean bl = false;
            int n = bitSet.nextSetBit(0);
            while (n >= 0) {
                bl = arrayList.get(n).get(i).containsOneOf(bitSet2);
                if (bl) {
                    bitSet3.set(i);
                    continue block0;
                }
                n = bitSet.nextSetBit(n + 1);
            }
        }
        return bitSet3;
    }

    public BitSet apreXY(CSG<Double> cSG, BitSet bitSet, BitSet bitSet2) throws PrismException {
        BitSet bitSet3 = new BitSet();
        for (int i = 0; i < cSG.getNumStates(); ++i) {
            ArrayList<ArrayList<Distribution<Double>>> arrayList = this.buildMatrixDist(cSG, i);
            bitSet3.set(i, this.B(arrayList, this.A(arrayList, new BitSet(), bitSet2), bitSet).cardinality() == arrayList.get(0).size());
        }
        return bitSet3;
    }

    public BitSet AF(CSG<Double> cSG, BitSet bitSet) throws PrismException {
        int n = cSG.getNumStates();
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        bitSet3.set(0, n);
        BitSet bitSet4 = new BitSet();
        boolean bl = false;
        while (!bl) {
            boolean bl2 = false;
            bitSet2.clear();
            while (!bl2) {
                bitSet4.clear();
                bitSet4.or(this.apreXY(cSG, bitSet2, bitSet3));
                bitSet4.or(bitSet);
                bl2 = bitSet2.equals(bitSet4);
                bitSet2.clear();
                bitSet2.or(bitSet4);
            }
            bl = bitSet3.equals(bitSet2);
            bitSet3.clear();
            bitSet3.or(bitSet2);
        }
        return bitSet3;
    }

    public BitSet AF(CSG<Double> cSG, BitSet bitSet, BitSet bitSet2) throws PrismException {
        int n = cSG.getNumStates();
        BitSet bitSet3 = new BitSet();
        BitSet bitSet4 = new BitSet();
        bitSet4.set(0, n);
        BitSet bitSet5 = new BitSet();
        boolean bl = false;
        while (!bl) {
            boolean bl2 = false;
            bitSet3.clear();
            while (!bl2) {
                bitSet5.clear();
                bitSet5.or(this.apreXY(cSG, bitSet3, bitSet4));
                bitSet5.and(bitSet);
                bitSet5.or(bitSet2);
                bl2 = bitSet3.equals(bitSet5);
                bitSet3.clear();
                bitSet3.or(bitSet5);
            }
            bl = bitSet4.equals(bitSet3);
            bitSet4.clear();
            bitSet4.or(bitSet3);
        }
        return bitSet4;
    }

    public boolean apreXYZ(ArrayList<ArrayList<Distribution<Double>>> arrayList, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        BitSet bitSet4 = new BitSet();
        BitSet bitSet5 = new BitSet();
        BitSet bitSet6 = new BitSet();
        BitSet bitSet7 = new BitSet();
        bitSet7.set(0, arrayList.size());
        boolean bl = false;
        while (!bl) {
            bitSet5.clear();
            bitSet6.clear();
            bitSet5.or(this.A(arrayList, bitSet4, bitSet3));
            bitSet6.or(this.A(arrayList, this.B(arrayList, bitSet7, bitSet), bitSet2));
            bitSet5.and(bitSet6);
            bl = bitSet7.equals(bitSet5);
            bitSet7.clear();
            bitSet7.or(bitSet5);
        }
        return !bitSet7.isEmpty();
    }

    public BitSet apreXYZ(CSG<Double> cSG, BitSet bitSet, BitSet bitSet2, BitSet bitSet3) throws PrismException {
        BitSet bitSet4 = new BitSet();
        for (int i = 0; i < cSG.getNumStates(); ++i) {
            ArrayList<ArrayList<Distribution<Double>>> arrayList = this.buildMatrixDist(cSG, i);
            bitSet4.set(i, this.apreXYZ(arrayList, bitSet, bitSet2, bitSet3));
        }
        return bitSet4;
    }

    public BitSet AFG(CSG<Double> cSG, BitSet bitSet) throws PrismException {
        int n = cSG.getNumStates();
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        BitSet bitSet4 = new BitSet();
        BitSet bitSet5 = new BitSet();
        BitSet bitSet6 = new BitSet();
        boolean bl = false;
        bitSet4.set(0, n);
        while (!bl) {
            boolean bl2 = false;
            bitSet2.clear();
            while (!bl2) {
                boolean bl3 = false;
                bitSet3.clear();
                bitSet3.set(0, n);
                while (!bl3) {
                    bitSet5.clear();
                    bitSet6.clear();
                    bitSet5 = this.apreXYZ(cSG, bitSet2, bitSet3, bitSet4);
                    bitSet5.and(bitSet);
                    bitSet6.or(bitSet);
                    bitSet6.flip(0, n);
                    bitSet6.and(this.apreXY(cSG, bitSet2, bitSet4));
                    bitSet5.or(bitSet6);
                    bl3 = bitSet3.equals(bitSet5);
                    bitSet3.clear();
                    bitSet3.or(bitSet5);
                }
                bl2 = bitSet2.equals(bitSet3);
                bitSet2.clear();
                bitSet2.or(bitSet3);
            }
            bl = bitSet4.equals(bitSet2);
            bitSet4.clear();
            bitSet4.or(bitSet2);
        }
        return bitSet4;
    }

    public boolean pre1(ArrayList<ArrayList<Distribution<Double>>> arrayList, BitSet bitSet) {
        boolean bl = false;
        for (int i = 0; i < arrayList.size(); ++i) {
            bl = true;
            for (int j = 0; j < arrayList.get(i).size(); ++j) {
                bl = bl && arrayList.get(i).get(j).isSubsetOf(bitSet);
            }
            if (!bl) continue;
            return true;
        }
        return bl;
    }

    public void pre1(CSG<Double> cSG, BitSet bitSet, BitSet bitSet2) throws PrismException {
        for (int i = 0; i < cSG.getNumStates(); ++i) {
            ArrayList<ArrayList<Distribution<Double>>> arrayList = this.buildMatrixDist(cSG, i);
            bitSet2.set(i, this.pre1(arrayList, bitSet));
        }
    }

    public BitSet G(CSG<Double> cSG, BitSet bitSet) throws PrismException {
        int n = cSG.getNumStates();
        BitSet bitSet2 = new BitSet();
        BitSet bitSet3 = new BitSet();
        boolean bl = false;
        bitSet3.set(0, n);
        while (!bl) {
            bitSet2.clear();
            this.pre1(cSG, bitSet3, bitSet2);
            bitSet2.and(bitSet);
            bl = bitSet3.equals(bitSet2);
            bitSet3.clear();
            bitSet3.or(bitSet2);
        }
        return bitSet3;
    }

    public void buildCoalitions(CSG<Double> cSG, Coalition coalition, boolean bl) throws PrismException {
        int n;
        if (coalition == null || coalition.isEmpty()) {
            throw new PrismException("Coalitions must not be empty");
        }
        this.numPlayers = cSG.getNumPlayers();
        this.numCoalitions = 2;
        this.coalitionIndexes = new BitSet[2];
        this.actionIndexes = new BitSet[2];
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        for (n = 0; n < this.numPlayers; ++n) {
            hashMap.put(n + 1, cSG.getPlayerName(n));
        }
        for (n = 0; n < 2; ++n) {
            this.coalitionIndexes[n] = new BitSet();
            this.actionIndexes[n] = new BitSet();
        }
        for (n = 0; n < this.numPlayers; ++n) {
            if (bl) {
                if (coalition.isPlayerIndexInCoalition(n, hashMap)) {
                    this.coalitionIndexes[1].set(n);
                    this.actionIndexes[1].or(cSG.getIndexes()[n]);
                    this.actionIndexes[1].set(cSG.getIdleForPlayer(n));
                    continue;
                }
                this.coalitionIndexes[0].set(n);
                this.actionIndexes[0].or(cSG.getIndexes()[n]);
                this.actionIndexes[0].set(cSG.getIdleForPlayer(n));
                continue;
            }
            if (coalition.isPlayerIndexInCoalition(n, hashMap)) {
                this.coalitionIndexes[0].set(n);
                this.actionIndexes[0].or(cSG.getIndexes()[n]);
                this.actionIndexes[0].set(cSG.getIdleForPlayer(n));
                continue;
            }
            this.coalitionIndexes[1].set(n);
            this.actionIndexes[1].or(cSG.getIndexes()[n]);
            this.actionIndexes[1].set(cSG.getIdleForPlayer(n));
        }
        this.findMaxRowsCols(cSG);
    }

    public void findMaxRowsCols(CSG<Double> cSG) {
        this.maxRows = 0;
        this.maxCols = 0;
        this.avgNumActions = new double[this.numCoalitions];
        Arrays.fill(this.avgNumActions, 0.0);
        for (int i = 0; i < cSG.getNumStates(); ++i) {
            int n = 1;
            int n2 = 1;
            int n3 = this.coalitionIndexes[0].nextSetBit(0);
            while (n3 >= 0) {
                n2 *= cSG.getIndexesForPlayer(i, n3).cardinality();
                n3 = this.coalitionIndexes[0].nextSetBit(n3 + 1);
            }
            this.avgNumActions[0] = this.avgNumActions[0] + (double)n2;
            n3 = this.coalitionIndexes[1].nextSetBit(0);
            while (n3 >= 0) {
                n *= cSG.getIndexesForPlayer(i, n3).cardinality();
                n3 = this.coalitionIndexes[1].nextSetBit(n3 + 1);
            }
            this.avgNumActions[1] = this.avgNumActions[1] + (double)n;
            this.maxRows = this.maxRows < n2 ? n2 : this.maxRows;
            this.maxCols = this.maxCols < n ? n : this.maxCols;
        }
        this.avgNumActions[0] = this.avgNumActions[0] / (double)cSG.getNumStates();
        this.avgNumActions[1] = this.avgNumActions[1] / (double)cSG.getNumStates();
        this.mainLog.println("Max/avg (actions): (" + this.maxRows + "," + this.maxCols + ")/(" + PrismUtils.formatDouble2dp(this.avgNumActions[0]) + "," + PrismUtils.formatDouble2dp(this.avgNumActions[1]) + ")");
    }

    public ArrayList<ArrayList<Distribution<Double>>> buildMatrixDist(CSG<Double> cSG, int n) throws PrismException {
        ArrayList<ArrayList<Distribution<Double>>> arrayList = new ArrayList<ArrayList<Distribution<Double>>>();
        BitSet bitSet = new BitSet();
        this.buildStepGame(cSG, null, null, null, n);
        for (int i = 0; i < this.strategies.get(0).size(); ++i) {
            arrayList.add(i, new ArrayList());
            bitSet.clear();
            bitSet.set(this.strategies.get(0).get(i));
            for (int j = 0; j < this.strategies.get(1).size(); ++j) {
                bitSet.set(this.strategies.get(1).get(j));
                if (!this.probabilities.containsKey(bitSet)) {
                    throw new PrismException("Error in building distribution matrix");
                }
                arrayList.get(i).add(j, this.probabilities.get(bitSet).get(0));
                bitSet.clear(this.strategies.get(1).get(j));
            }
        }
        return arrayList;
    }

    public ArrayList<ArrayList<Double>> buildMatrixGame(CSG<Double> cSG, CSGRewards<Double> cSGRewards, Map<Integer, BitSet> map, double[] dArray, int n, boolean bl) throws PrismException {
        int n2;
        int n3;
        ArrayList<ArrayList<Double>> arrayList = new ArrayList<ArrayList<Double>>();
        ArrayList<CSGRewards<Double>> arrayList2 = null;
        HashMap<BitSet, Integer> hashMap = new HashMap<BitSet, Integer>();
        BitSet bitSet = new BitSet();
        if (cSGRewards != null) {
            arrayList2 = new ArrayList<CSGRewards<Double>>();
            arrayList2.add(0, cSGRewards);
        }
        this.buildStepGame(cSG, arrayList2, hashMap, dArray, n);
        Map<Integer, BitSet> map2 = hashMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        if (map != null) {
            if (bl) {
                for (n3 = 0; n3 < this.strategies.get(1).size(); ++n3) {
                    map.put(n3, map2.get(this.strategies.get(1).get(n3)));
                }
            } else {
                for (n2 = 0; n2 < this.strategies.get(0).size(); ++n2) {
                    map.put(n2, map2.get(this.strategies.get(0).get(n2)));
                }
            }
        }
        for (n2 = 0; n2 < this.strategies.get(0).size(); ++n2) {
            arrayList.add(n2, new ArrayList());
            bitSet.clear();
            bitSet.set(this.strategies.get(0).get(n2));
            for (n3 = 0; n3 < this.strategies.get(1).size(); ++n3) {
                bitSet.set(this.strategies.get(1).get(n3));
                if (!this.utilities.containsKey(bitSet)) {
                    throw new PrismException("Error in building matrix game");
                }
                arrayList.get(n2).add(n3, this.utilities.get(bitSet).get(0));
                bitSet.clear(this.strategies.get(1).get(n3));
            }
        }
        return arrayList;
    }

    public void buildStepGame(CSG<Double> cSG, List<CSGRewards<Double>> list, Map<BitSet, Integer> map, double[] dArray, int n) throws PrismException {
        int n2;
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        this.actions.clear();
        this.strategies.clear();
        this.utilities.clear();
        this.probabilities.clear();
        this.varIndex = 0;
        this.minEntry = Double.POSITIVE_INFINITY;
        this.allEqual = true;
        double d = Double.NaN;
        if (map != null) {
            map.clear();
        } else {
            map = new HashMap<BitSet, Integer>();
        }
        for (n2 = 0; n2 < this.numCoalitions; ++n2) {
            this.actions.add(n2, new ArrayList());
            this.strategies.add(n2, new ArrayList());
        }
        for (int i = 0; i < cSG.getNumChoices(n); ++i) {
            double d2;
            BitSet bitSet3 = new BitSet();
            int[] nArray = cSG.getIndexes(n, i);
            bitSet.clear();
            for (int j = 0; j < this.numPlayers; ++j) {
                if (nArray[j] != -1) {
                    bitSet.set(nArray[j]);
                    continue;
                }
                bitSet.set(cSG.getIdleForPlayer(j));
            }
            for (n2 = 0; n2 < 2; ++n2) {
                d2 = 0.0;
                bitSet2.clear();
                bitSet2.or(this.actionIndexes[n2]);
                bitSet2.and(bitSet);
                if (bitSet2.cardinality() != this.coalitionIndexes[n2].cardinality()) {
                    throw new PrismException("Error in coalition");
                }
                if (!map.keySet().contains(bitSet2)) {
                    Object object = "";
                    this.strategies.get(n2).add(this.varIndex);
                    int n3 = bitSet2.nextSetBit(0);
                    while (n3 >= 0) {
                        object = (String)object + "[" + String.valueOf(cSG.getActions().get(n3 - 1)) + "]";
                        n3 = bitSet2.nextSetBit(n3 + 1);
                    }
                    this.actions.get(n2).add((String)object);
                    bitSet3.set(this.varIndex);
                    map.put((BitSet)bitSet2.clone(), this.varIndex);
                    ++this.varIndex;
                    continue;
                }
                bitSet3.set(map.get(bitSet2));
            }
            this.utilities.put(bitSet3, new ArrayList());
            this.probabilities.put(bitSet3, new ArrayList());
            d2 = 0.0;
            if (dArray != null) {
                Iterator iterator = cSG.getTransitionsIterator(n, i);
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    d2 += (Double)entry.getValue() * dArray[entry.getKey()];
                }
            }
            if (list != null) {
                d2 += ((Double)list.get(0).getTransitionReward(n, i)).doubleValue();
            }
            if (d != Double.NaN) {
                this.allEqual = this.allEqual && Double.compare(d, d2) == 0;
            }
            this.utilities.get(bitSet3).add(0, d2);
            this.probabilities.get(bitSet3).add(0, cSG.getChoice(n, i));
            this.minEntry = this.minEntry > d2 ? d2 : this.minEntry;
            d = d2;
        }
    }

    public double val(LpSolve lpSolve, ArrayList<ArrayList<Double>> arrayList, List<Map<BitSet, Double>> list, Map<Integer, BitSet> map, int n, boolean bl, boolean bl2) throws PrismException {
        double d;
        long l;
        block28: {
            l = System.currentTimeMillis();
            int n2 = arrayList.size();
            int n3 = arrayList.get(0).size();
            d = Double.NaN;
            HashMap<BitSet, Double> hashMap = new HashMap<BitSet, Double>();
            if (this.allEqual) {
                if (this.genStrat) {
                    hashMap.put(map.get(0), 1.0);
                    list.set(n, hashMap);
                }
                return this.minEntry;
            }
            if (n2 == 1) {
                int n4 = 0;
                d = Double.POSITIVE_INFINITY;
                for (int i = 0; i < n3; ++i) {
                    if (!(d > arrayList.get(0).get(i))) continue;
                    d = arrayList.get(0).get(i);
                    n4 = bl2 ? i : 0;
                }
                if (this.genStrat) {
                    hashMap.put(map.get(n4), 1.0);
                    list.set(n, hashMap);
                }
                return d;
            }
            if (n3 == 1) {
                int n5 = 0;
                d = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < n2; ++i) {
                    if (!(d < arrayList.get(i).get(0))) continue;
                    d = arrayList.get(i).get(0);
                    n5 = bl2 ? 0 : i;
                }
                if (this.genStrat) {
                    hashMap.put(map.get(n5), 1.0);
                    list.set(n, hashMap);
                }
                return d;
            }
            int n6 = this.valInfinity(arrayList);
            if (n6 != -1) {
                d = Double.POSITIVE_INFINITY;
                if (this.genStrat) {
                    hashMap.put(map.get(n6), 1.0);
                }
                return d;
            }
            try {
                if (bl2) {
                    lpSolve.resizeLp(0, this.maxCols + 1);
                } else {
                    lpSolve.resizeLp(0, this.maxRows + 1);
                }
                this.buildLPLpsolve(lpSolve, arrayList, bl, bl2);
            }
            catch (LpSolveException lpSolveException) {
                throw new PrismException("Exception raised by lpSolve when building linear program for state  " + n);
            }
            try {
                int n7 = lpSolve.solve();
                if (n7 == 0) {
                    d = lpSolve.getObjective();
                    double[] dArray = bl2 ? new double[this.maxCols + 1] : new double[this.maxRows + 1];
                    lpSolve.getVariables(dArray);
                    if (this.genStrat) {
                        for (int i = 1; i <= n2; ++i) {
                            if (!(dArray[i] > 0.0)) continue;
                            hashMap.put(map.get(i - 1), dArray[i]);
                        }
                        list.set(n, hashMap);
                    }
                    break block28;
                }
                throw new PrismException("lpSolve could not find an optimal solution for state " + n);
            }
            catch (Exception exception) {
                block29: {
                    int n8;
                    this.mainLog.println("Exception raised by lpSolve when computing value for state " + n + ". lpSolve status: " + lpSolve.getStatustext(lpSolve.getStatus()));
                    this.mainLog.println("Rounding up entries...");
                    ArrayList<ArrayList<Double>> arrayList2 = new ArrayList<ArrayList<Double>>(arrayList);
                    arrayList.clear();
                    for (n8 = 0; n8 < n2; ++n8) {
                        arrayList.add(n8, new ArrayList());
                        for (int i = 0; i < n3; ++i) {
                            arrayList.get(n8).add(i, Precision.round((double)arrayList2.get(n8).get(i), (int)9, (int)3));
                        }
                    }
                    arrayList2.clear();
                    try {
                        if (bl2) {
                            lpSolve.resizeLp(0, this.maxCols + 1);
                        } else {
                            lpSolve.resizeLp(0, this.maxRows + 1);
                        }
                        this.buildLPLpsolve(lpSolve, arrayList, bl, bl2);
                        n8 = lpSolve.solve();
                        if (n8 == 0) {
                            d = lpSolve.getObjective();
                            double[] dArray = bl2 ? new double[this.maxCols + 1] : new double[this.maxRows + 1];
                            lpSolve.getVariables(dArray);
                            if (this.genStrat) {
                                for (int i = 1; i <= n2; ++i) {
                                    if (!(dArray[i] > 0.0)) continue;
                                    hashMap.put(map.get(i - 1), dArray[i]);
                                }
                                list.set(n, hashMap);
                            }
                            break block29;
                        }
                        throw new PrismException("Rounding up failed for state " + n + ". Failed to compute solution");
                    }
                    catch (LpSolveException lpSolveException) {
                        throw new PrismException("Rounding up failed for state " + n + ". Failed to compute solution");
                    }
                }
                return d;
            }
        }
        l = System.currentTimeMillis() - l;
        this.timerVal += l;
        return d;
    }

    public int valInfinity(ArrayList<ArrayList<Double>> arrayList) {
        int n;
        int n2;
        BitSet bitSet = new BitSet();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            boolean bl = true;
            for (n = 0; n < arrayList.get(0).size(); ++n) {
                if (arrayList.get(n2).get(n) == Double.POSITIVE_INFINITY) {
                    bitSet.set(n);
                    continue;
                }
                bl = false;
            }
            if (!bl) continue;
            return n2;
        }
        if (!bitSet.isEmpty()) {
            ArrayList<ArrayList<Double>> arrayList2 = new ArrayList<ArrayList<Double>>(arrayList);
            int n3 = 0;
            arrayList.clear();
            for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                arrayList.add(n3, new ArrayList());
                int n4 = 0;
                for (n = 0; n < arrayList2.get(0).size(); ++n) {
                    if (bitSet.get(n)) continue;
                    arrayList.get(n3).add(n4, arrayList2.get(n2).get(n));
                    ++n4;
                }
                ++n3;
            }
        }
        return -1;
    }

    public void buildLPLpsolve(LpSolve lpSolve, ArrayList<ArrayList<Double>> arrayList, boolean bl, boolean bl2) throws LpSolveException {
        int n;
        int n2 = bl2 ? arrayList.get(0).size() : arrayList.size();
        int n3 = bl2 ? arrayList.size() : arrayList.get(0).size();
        int[] nArray = new int[n2 + 1];
        double[] dArray = new double[n2 + 1];
        lpSolve.setColName(1, "v");
        for (n = 2; n <= n2 + 1; ++n) {
            if (bl2) {
                lpSolve.setColName(n, this.actions.get(1).get(n - 2));
            } else {
                lpSolve.setColName(n, this.actions.get(0).get(n - 2));
            }
            lpSolve.setBounds(n, 0.0, 1.0);
        }
        if (bl) {
            lpSolve.setBounds(1, -1.0 * lpSolve.getInfinite(), lpSolve.getInfinite());
        } else {
            lpSolve.setBounds(1, 0.0, 1.0);
        }
        lpSolve.setAddRowmode(true);
        n = 0;
        for (int i = 0; i < n3; ++i) {
            nArray[n] = 1;
            dArray[n] = this.scaleFactor;
            for (int j = 0; j < n2; ++j) {
                nArray[++n] = n + 1;
                dArray[n] = bl2 ? -1.0 * this.scaleFactor * arrayList.get(i).get(j) : -1.0 * this.scaleFactor * arrayList.get(j).get(i);
            }
            if (bl2) {
                lpSolve.addConstraintex(n2 + 1, dArray, nArray, 2, 0.0);
            } else {
                lpSolve.addConstraintex(n2 + 1, dArray, nArray, 1, 0.0);
            }
            n = 0;
        }
        for (n = 0; n < n3; ++n) {
            if (bl2) {
                lpSolve.setRowName(n + 1, this.actions.get(0).get(n));
                continue;
            }
            lpSolve.setRowName(n + 1, this.actions.get(1).get(n));
        }
        for (n = 0; n < n2 + 1; ++n) {
            nArray[n] = n + 1;
            dArray[n] = n > 0 ? 1.0 : 0.0;
        }
        lpSolve.addConstraintex(n, dArray, nArray, 3, 1.0);
        lpSolve.setAddRowmode(false);
        for (n = 0; n < n2 + 1; ++n) {
            nArray[n] = n + 1;
            dArray[n] = n == 0 ? 1.0 : 0.0;
        }
        lpSolve.setObjFnex(n, dArray, nArray);
        if (bl2) {
            lpSolve.setMinim();
        } else {
            lpSolve.setMaxim();
        }
    }

    public void updateStrategy(List<Map<BitSet, Double>> list, List<List<List<Map<BitSet, Double>>>> list2, int n, int n2, boolean bl) {
        if (bl) {
            if (list2.get(0).get(n).get(n2) == null || !list2.get(0).get(n - 1).get(n2).equals(list.get(n2))) {
                list2.get(0).get(n).set(n2, list.get(n2));
            } else {
                list2.get(0).get(n).set(n2, list2.get(0).get(n - 1).get(n2));
            }
        } else if (list2.get(0).get(0).get(n2) == null) {
            list2.get(0).get(0).set(n2, list.get(n2));
        } else if (!list2.get(0).get(0).get(n2).equals(list.get(n2))) {
            list2.get(0).get(0).set(n2, list.get(n2));
        }
    }

    public static DA<BitSet, AcceptanceRabin> constructDRAForInstant(String string, IntegerBound integerBound) {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = integerBound.getMaximalInterestingValue();
        int n2 = n + 2;
        arrayList.add(string);
        DA<BitSet, AcceptanceRabin> dA = new DA<BitSet, AcceptanceRabin>(n2);
        dA.setAcceptance(new AcceptanceRabin());
        dA.setAPList(arrayList);
        dA.setStartState(0);
        BitSet bitSet = new BitSet();
        BitSet bitSet2 = new BitSet();
        bitSet.set(0);
        int n3 = n2 - 1;
        for (int i = 0; i <= n; ++i) {
            int n4 = i + 1;
            if (n4 > n) {
                n4 = n;
            }
            if (integerBound.isInBounds(i)) {
                dA.addEdge(i, bitSet2, n4);
                if (i <= n - 2) {
                    dA.addEdge(i, bitSet, n4);
                    continue;
                }
                dA.addEdge(i, bitSet, n3);
                continue;
            }
            dA.addEdge(i, bitSet2, n4);
            dA.addEdge(i, bitSet, n4);
        }
        dA.addEdge(n3, bitSet2, n3);
        dA.addEdge(n3, bitSet, n3);
        BitSet bitSet3 = new BitSet();
        bitSet3.set(n);
        BitSet bitSet4 = new BitSet();
        bitSet4.set(n3);
        ((AcceptanceRabin)dA.getAcceptance()).add(new AcceptanceRabin.RabinPair(bitSet3, bitSet4));
        return dA;
    }

    public void filterStates(CSG<Double> cSG, CSGSimple<Double> cSGSimple, List<CSGRewards<Double>> list, List<CSGRewards<Double>> list2, int n3) {
        int n4;
        this.list_state.add(cSG.getStatesList().get(n3));
        for (n4 = 0; n4 < cSG.getNumChoices(n3); ++n4) {
            Distribution distribution = new Distribution();
            cSG.forEachTransition(n3, n4, (n, n2, d) -> {
                if (!this.map_state.keySet().contains(n2)) {
                    this.map_state.put(n2, cSGSimple.addState());
                    this.filterStates(cSG, cSGSimple, list, list2, n2);
                }
                distribution.add(this.map_state.get(n2), d);
            });
            int n5 = cSGSimple.addActionLabelledChoice((int)this.map_state.get(n3), distribution, cSG.getAction(n3, n4));
            cSGSimple.setIndexes(this.map_state.get(n3), n5, cSG.getIndexes(n3, n4));
            if (list == null || list2 == null) continue;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null || list2.get(i) == null) continue;
                ((CSGRewardsSimple)list2.get(i)).addToTransitionReward(this.map_state.get(n3), n5, (Double)list.get(i).getTransitionReward(n3, n4));
            }
        }
        if (list != null && list2 != null) {
            for (n4 = 0; n4 < list.size(); ++n4) {
                if (list.get(n4) == null || list2.get(n4) == null) continue;
                ((CSGRewardsSimple)list2.get(n4)).addToStateReward(this.map_state.get(n3), (Double)list.get(n4).getStateReward(n3));
            }
        }
    }
}

