/*
 * Decompiled with CFR 0.152.
 */
package acceptance;

import acceptance.AcceptanceGenericDD;
import acceptance.AcceptanceOmega;
import acceptance.AcceptanceOmegaDD;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceStreett;
import acceptance.AcceptanceType;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import jdd.JDDVars;
import prism.PrismException;
import prism.PrismNotSupportedException;

public class AcceptanceGeneric
implements AcceptanceOmega {
    private ElementType kind;
    private AcceptanceGeneric left = null;
    private AcceptanceGeneric right = null;
    private BitSet states = null;

    public AcceptanceGeneric(boolean bl) {
        this.kind = bl ? ElementType.TRUE : ElementType.FALSE;
    }

    public AcceptanceGeneric(ElementType elementType, BitSet bitSet) {
        this.kind = elementType;
        this.states = bitSet;
    }

    public AcceptanceGeneric(ElementType elementType, AcceptanceGeneric acceptanceGeneric, AcceptanceGeneric acceptanceGeneric2) {
        this.kind = elementType;
        this.left = acceptanceGeneric;
        this.right = acceptanceGeneric2;
    }

    public ElementType getKind() {
        return this.kind;
    }

    public AcceptanceGeneric getLeft() {
        return this.left;
    }

    public AcceptanceGeneric getRight() {
        return this.right;
    }

    public BitSet getStates() {
        return this.states;
    }

    @Override
    public boolean isBSCCAccepting(BitSet bitSet) {
        switch (this.kind) {
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case AND: {
                return this.left.isBSCCAccepting(bitSet) && this.right.isBSCCAccepting(bitSet);
            }
            case OR: {
                return this.left.isBSCCAccepting(bitSet) || this.right.isBSCCAccepting(bitSet);
            }
            case INF: {
                return bitSet.intersects(this.states);
            }
            case INF_NOT: {
                BitSet bitSet2 = (BitSet)bitSet.clone();
                bitSet2.andNot(this.states);
                return !bitSet2.isEmpty();
            }
            case FIN: {
                return !bitSet.intersects(this.states);
            }
            case FIN_NOT: {
                BitSet bitSet3 = (BitSet)bitSet.clone();
                bitSet3.and(this.states);
                return bitSet3.equals(bitSet);
            }
        }
        return false;
    }

    public List<AcceptanceGeneric> getLeafNodes() {
        switch (this.getKind()) {
            case AND: 
            case OR: {
                ArrayList<AcceptanceGeneric> arrayList = new ArrayList<AcceptanceGeneric>();
                arrayList.addAll(this.left.getLeafNodes());
                arrayList.addAll(this.right.getLeafNodes());
                return arrayList;
            }
            case TRUE: 
            case FALSE: {
                return Collections.emptyList();
            }
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                return Collections.singletonList(this);
            }
        }
        throw new UnsupportedOperationException("Unknown kind");
    }

    @Override
    public String getSignatureForState(int n) {
        List<AcceptanceGeneric> list = this.getLeafNodes();
        Object object = "";
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getStates().get(n)) continue;
            object = (String)object + (((String)object).isEmpty() ? "" : ",") + i;
        }
        object = "{" + (String)object + "}";
        return object;
    }

    @Override
    public String getSignatureForStateHOA(int n) {
        List<AcceptanceGeneric> list = this.getLeafNodes();
        Object object = "";
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).getStates().get(n)) continue;
            object = (String)object + (((String)object).isEmpty() ? "" : " ") + i;
        }
        if (!((String)object).isEmpty()) {
            object = "{" + (String)object + "}";
        }
        return object;
    }

    @Override
    public String getSizeStatistics() {
        return "generic acceptance with " + this.countAcceptanceSets() + " acceptance sets";
    }

    @Override
    public AcceptanceType getType() {
        return AcceptanceType.GENERIC;
    }

    @Override
    @Deprecated
    public String getTypeAbbreviated() {
        return this.getType().getNameAbbreviated();
    }

    @Override
    @Deprecated
    public String getTypeName() {
        return this.getType().getName();
    }

    @Override
    public AcceptanceGeneric clone() {
        switch (this.kind) {
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                return new AcceptanceGeneric(this.kind, this.states);
            }
            case AND: 
            case OR: {
                return new AcceptanceGeneric(this.kind, this.left.clone(), this.right.clone());
            }
            case FALSE: {
                return new AcceptanceGeneric(false);
            }
            case TRUE: {
                return new AcceptanceGeneric(true);
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in generic acceptance condition");
    }

    public AcceptanceGeneric and(AcceptanceGeneric acceptanceGeneric) {
        return new AcceptanceGeneric(ElementType.AND, this, acceptanceGeneric);
    }

    public AcceptanceGeneric or(AcceptanceGeneric acceptanceGeneric) {
        return new AcceptanceGeneric(ElementType.OR, this, acceptanceGeneric);
    }

    public AcceptanceGeneric complementToGeneric() {
        switch (this.kind) {
            case TRUE: {
                return new AcceptanceGeneric(false);
            }
            case FALSE: {
                return new AcceptanceGeneric(true);
            }
            case AND: {
                return new AcceptanceGeneric(ElementType.OR, this.getLeft().complementToGeneric(), this.getRight().complementToGeneric());
            }
            case OR: {
                return new AcceptanceGeneric(ElementType.AND, this.getLeft().complementToGeneric(), this.getRight().complementToGeneric());
            }
            case FIN: {
                return new AcceptanceGeneric(ElementType.INF, (BitSet)this.states.clone());
            }
            case FIN_NOT: {
                return new AcceptanceGeneric(ElementType.INF_NOT, (BitSet)this.states.clone());
            }
            case INF: {
                return new AcceptanceGeneric(ElementType.FIN, (BitSet)this.states.clone());
            }
            case INF_NOT: {
                return new AcceptanceGeneric(ElementType.FIN_NOT, (BitSet)this.states.clone());
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public AcceptanceOmega complement(int n, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.GENERIC)) {
            return this.complementToGeneric();
        }
        throw new PrismNotSupportedException("Can not complement " + String.valueOf((Object)this.getType()) + " acceptance to required acceptance type");
    }

    @Override
    public void lift(AcceptanceOmega.LiftBitSet liftBitSet) {
        switch (this.kind) {
            case TRUE: 
            case FALSE: {
                return;
            }
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                this.states = liftBitSet.lift(this.states);
                return;
            }
            case AND: 
            case OR: {
                this.left.lift(liftBitSet);
                this.right.lift(liftBitSet);
                return;
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in generic acceptance condition");
    }

    public int countAcceptanceSets() {
        switch (this.kind) {
            case TRUE: 
            case FALSE: {
                return 0;
            }
            case INF: 
            case INF_NOT: 
            case FIN: 
            case FIN_NOT: {
                return 1;
            }
            case AND: 
            case OR: {
                return this.left.countAcceptanceSets() + this.right.countAcceptanceSets();
            }
        }
        throw new UnsupportedOperationException("Unsupported operator in generic acceptance condition");
    }

    @Override
    public AcceptanceOmegaDD toAcceptanceDD(JDDVars jDDVars) {
        return new AcceptanceGenericDD(this, jDDVars);
    }

    @Override
    public AcceptanceGeneric toAcceptanceGeneric() {
        return this.clone();
    }

    public AcceptanceRabin toAcceptanceRabin(int n) {
        AcceptanceRabin acceptanceRabin = new AcceptanceRabin();
        List<AcceptanceGeneric> list = this.extractDisjuncts();
        for (AcceptanceGeneric acceptanceGeneric : list) {
            AcceptanceRabin.RabinPair rabinPair = acceptanceGeneric.toAcceptanceRabinPair(n);
            if (rabinPair == null) {
                return null;
            }
            acceptanceRabin.add(rabinPair);
        }
        return acceptanceRabin;
    }

    private AcceptanceRabin.RabinPair toAcceptanceRabinPair(int n) {
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        switch (this.getKind()) {
            case TRUE: {
                bitSet = new BitSet();
                bitSet2 = new BitSet();
                bitSet2.set(0, n);
                break;
            }
            case FALSE: {
                bitSet = new BitSet();
                bitSet.set(0, n);
                bitSet2 = new BitSet();
                break;
            }
            case AND: {
                AcceptanceGeneric acceptanceGeneric = this.getLeft();
                AcceptanceGeneric acceptanceGeneric2 = this.getRight();
                if (acceptanceGeneric.getKind() == ElementType.INF || acceptanceGeneric.getKind() == ElementType.INF_NOT) {
                    AcceptanceGeneric acceptanceGeneric3 = acceptanceGeneric;
                    acceptanceGeneric = acceptanceGeneric2;
                    acceptanceGeneric2 = acceptanceGeneric3;
                }
                switch (acceptanceGeneric.getKind()) {
                    case TRUE: 
                    case FALSE: 
                    case AND: 
                    case OR: 
                    case INF: 
                    case INF_NOT: {
                        return null;
                    }
                    case FIN: {
                        bitSet = (BitSet)acceptanceGeneric.getStates().clone();
                        break;
                    }
                    case FIN_NOT: {
                        bitSet = (BitSet)acceptanceGeneric.getStates().clone();
                        bitSet.flip(0, n);
                    }
                }
                switch (acceptanceGeneric2.getKind()) {
                    case TRUE: 
                    case FALSE: 
                    case AND: 
                    case OR: 
                    case FIN: 
                    case FIN_NOT: {
                        return null;
                    }
                    case INF: {
                        bitSet2 = (BitSet)acceptanceGeneric2.getStates().clone();
                        break;
                    }
                    case INF_NOT: {
                        bitSet2 = (BitSet)acceptanceGeneric2.getStates().clone();
                        bitSet2.flip(0, n);
                    }
                }
                break;
            }
            case FIN: {
                bitSet = (BitSet)this.getStates().clone();
                bitSet2 = new BitSet();
                bitSet2.set(0, n);
                break;
            }
            case FIN_NOT: {
                bitSet = (BitSet)this.getStates().clone();
                bitSet.flip(0, n);
                bitSet2 = new BitSet();
                bitSet2.set(0, n);
                break;
            }
            case INF: {
                bitSet = new BitSet();
                bitSet2 = (BitSet)this.getStates().clone();
                break;
            }
            case INF_NOT: {
                bitSet = new BitSet();
                bitSet2 = (BitSet)this.getStates().clone();
                bitSet2.flip(0, n);
                break;
            }
            case OR: {
                return null;
            }
        }
        return new AcceptanceRabin.RabinPair(bitSet, bitSet2);
    }

    public AcceptanceStreett toAcceptanceStreett(int n) {
        AcceptanceStreett acceptanceStreett = new AcceptanceStreett();
        List<AcceptanceGeneric> list = this.extractConjuncts();
        for (AcceptanceGeneric acceptanceGeneric : list) {
            AcceptanceStreett.StreettPair streettPair = acceptanceGeneric.toAcceptanceStreettPair(n);
            if (streettPair == null) {
                return null;
            }
            acceptanceStreett.add(streettPair);
        }
        return acceptanceStreett;
    }

    private AcceptanceStreett.StreettPair toAcceptanceStreettPair(int n) {
        BitSet bitSet = null;
        BitSet bitSet2 = null;
        switch (this.getKind()) {
            case TRUE: {
                bitSet = new BitSet();
                bitSet2 = new BitSet();
                break;
            }
            case FALSE: {
                bitSet = new BitSet();
                bitSet.set(0, n);
                bitSet2 = new BitSet();
                break;
            }
            case OR: {
                AcceptanceGeneric acceptanceGeneric = this.getLeft();
                AcceptanceGeneric acceptanceGeneric2 = this.getRight();
                if (acceptanceGeneric.getKind() == ElementType.INF || acceptanceGeneric.getKind() == ElementType.INF_NOT) {
                    AcceptanceGeneric acceptanceGeneric3 = acceptanceGeneric;
                    acceptanceGeneric = acceptanceGeneric2;
                    acceptanceGeneric2 = acceptanceGeneric3;
                }
                switch (acceptanceGeneric.getKind()) {
                    case TRUE: 
                    case FALSE: 
                    case AND: 
                    case OR: 
                    case INF: 
                    case INF_NOT: {
                        return null;
                    }
                    case FIN: {
                        bitSet = (BitSet)acceptanceGeneric.getStates().clone();
                        break;
                    }
                    case FIN_NOT: {
                        bitSet = (BitSet)acceptanceGeneric.getStates().clone();
                        bitSet.flip(0, n);
                    }
                }
                switch (acceptanceGeneric2.getKind()) {
                    case TRUE: 
                    case FALSE: 
                    case AND: 
                    case OR: 
                    case FIN: 
                    case FIN_NOT: {
                        return null;
                    }
                    case INF: {
                        bitSet2 = (BitSet)acceptanceGeneric2.getStates().clone();
                        break;
                    }
                    case INF_NOT: {
                        bitSet2 = (BitSet)acceptanceGeneric2.getStates().clone();
                        bitSet2.flip(0, n);
                    }
                }
                break;
            }
            case FIN: {
                bitSet = (BitSet)this.getStates().clone();
                bitSet2 = new BitSet();
                break;
            }
            case FIN_NOT: {
                bitSet = (BitSet)this.getStates().clone();
                bitSet.flip(0, n);
                bitSet2 = new BitSet();
                break;
            }
            case INF: {
                bitSet = new BitSet();
                bitSet.set(0, n);
                bitSet2 = (BitSet)this.getStates().clone();
                break;
            }
            case INF_NOT: {
                bitSet = new BitSet();
                bitSet.set(0, n);
                bitSet2 = (BitSet)this.getStates().clone();
                bitSet2.flip(0, n);
                break;
            }
            case AND: {
                return null;
            }
        }
        return new AcceptanceStreett.StreettPair(bitSet, bitSet2);
    }

    public List<AcceptanceGeneric> extractDisjuncts() {
        ArrayList<AcceptanceGeneric> arrayList = new ArrayList<AcceptanceGeneric>();
        Stack<AcceptanceGeneric> stack = new Stack<AcceptanceGeneric>();
        stack.add(this);
        while (!stack.isEmpty()) {
            AcceptanceGeneric acceptanceGeneric = (AcceptanceGeneric)stack.pop();
            switch (acceptanceGeneric.getKind()) {
                case TRUE: 
                case FALSE: 
                case AND: 
                case INF: 
                case INF_NOT: 
                case FIN: 
                case FIN_NOT: {
                    arrayList.add(acceptanceGeneric);
                    break;
                }
                case OR: {
                    stack.push(acceptanceGeneric.getRight());
                    stack.push(acceptanceGeneric.getLeft());
                }
            }
        }
        return arrayList;
    }

    public List<AcceptanceGeneric> extractConjuncts() {
        ArrayList<AcceptanceGeneric> arrayList = new ArrayList<AcceptanceGeneric>();
        Stack<AcceptanceGeneric> stack = new Stack<AcceptanceGeneric>();
        stack.add(this);
        while (!stack.isEmpty()) {
            AcceptanceGeneric acceptanceGeneric = (AcceptanceGeneric)stack.pop();
            switch (acceptanceGeneric.getKind()) {
                case TRUE: 
                case FALSE: 
                case OR: 
                case INF: 
                case INF_NOT: 
                case FIN: 
                case FIN_NOT: {
                    arrayList.add(acceptanceGeneric);
                    break;
                }
                case AND: {
                    stack.push(acceptanceGeneric.getRight());
                    stack.push(acceptanceGeneric.getLeft());
                }
            }
        }
        return arrayList;
    }

    public String toString() {
        switch (this.kind) {
            case TRUE: {
                return "true";
            }
            case FALSE: {
                return "false";
            }
            case AND: {
                return "(" + this.left.toString() + " & " + this.right.toString() + ")";
            }
            case OR: {
                return "(" + this.left.toString() + " | " + this.right.toString() + ")";
            }
            case INF: {
                return "Inf(" + this.states.toString() + ")";
            }
            case FIN: {
                return "Fin(" + this.states.toString() + ")";
            }
            case INF_NOT: {
                return "Inf(!" + this.states.toString() + ")";
            }
            case FIN_NOT: {
                return "Fin(!" + this.states.toString() + ")";
            }
        }
        return null;
    }

    @Override
    public void outputHOAHeader(PrintStream printStream) {
        List<AcceptanceGeneric> list = this.getLeafNodes();
        printStream.print("Acceptance: " + list.size() + " ");
        this.outputHOAFormula(printStream, 0);
        printStream.println();
    }

    private int outputHOAFormula(PrintStream printStream, int n) {
        switch (this.kind) {
            case AND: {
                printStream.print("(");
                n = this.left.outputHOAFormula(printStream, n);
                printStream.print(")&(");
                n = this.right.outputHOAFormula(printStream, n);
                printStream.print(")");
                return n;
            }
            case OR: {
                printStream.print("(");
                n = this.left.outputHOAFormula(printStream, n);
                printStream.print(")|(");
                n = this.right.outputHOAFormula(printStream, n);
                printStream.print(")");
                return n;
            }
            case TRUE: {
                printStream.print("t");
                return n;
            }
            case FALSE: {
                printStream.print("f");
                return n;
            }
            case FIN: {
                printStream.print("Fin(" + n + ")");
                return n + 1;
            }
            case FIN_NOT: {
                printStream.print("Fin(!" + n + ")");
                return n + 1;
            }
            case INF: {
                printStream.print("Inf(" + n + ")");
                return n + 1;
            }
            case INF_NOT: {
                printStream.print("Inf(!" + n + ")");
                return n + 1;
            }
        }
        throw new UnsupportedOperationException("Unknown kind");
    }

    public static enum ElementType {
        FALSE,
        TRUE,
        OR,
        AND,
        INF,
        FIN,
        INF_NOT,
        FIN_NOT;

    }
}

