/*
 * Decompiled with CFR 0.152.
 */
package symbolic.model;

import io.ModelExportOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import jdd.SanityJDD;
import mtbdd.PrismMTBDD;
import odd.ODDNode;
import odd.ODDUtils;
import parser.Values;
import parser.VarList;
import prism.Prism;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismUtils;
import symbolic.model.Model;
import symbolic.model.ModelVariablesDD;

public abstract class ModelSymbolic
implements Model {
    protected VarList varList;
    protected Values constantValues;
    protected int numSynchs;
    protected List<String> synchs;
    protected int numRewardStructs;
    protected String[] rewardStructNames = new String[0];
    protected double numStates;
    protected double numTransitions;
    protected double numStartStates;
    protected JDDNode trans;
    protected JDDNode trans01;
    protected JDDNode start;
    protected JDDNode reach;
    protected JDDNode deadlocks;
    protected JDDNode[] stateRewards = new JDDNode[0];
    protected JDDNode[] transRewards = new JDDNode[0];
    protected ModelVariablesDD modelVariables;
    protected JDDVars[] varDDRowVars;
    protected JDDVars[] varDDColVars;
    protected JDDVars allDDRowVars;
    protected JDDVars allDDColVars;
    protected Map<String, JDDNode> labelsDD = new TreeMap<String, JDDNode>();
    protected ODDNode odd;

    public ModelSymbolic(JDDNode jDDNode, JDDNode jDDNode2, JDDVars jDDVars, JDDVars jDDVars2, ModelVariablesDD modelVariablesDD, VarList varList, JDDVars[] jDDVarsArray, JDDVars[] jDDVarsArray2) {
        this.trans = jDDNode;
        this.start = jDDNode2;
        this.allDDRowVars = jDDVars;
        this.allDDColVars = jDDVars2;
        this.modelVariables = modelVariablesDD;
        this.varList = varList;
        this.varDDRowVars = jDDVarsArray;
        this.varDDColVars = jDDVarsArray2;
        JDD.Ref(jDDNode);
        this.trans01 = JDD.GreaterThan(jDDNode, 0.0);
        this.numStartStates = JDD.GetNumMinterms(jDDNode2, jDDVars.n());
    }

    public void setStart(JDDNode jDDNode) {
        if (this.start != null) {
            JDD.Deref(this.start);
        }
        this.start = jDDNode;
        this.numStartStates = JDD.GetNumMinterms(jDDNode, this.allDDRowVars.n());
    }

    public void setReach(JDDNode jDDNode) throws PrismException {
        if (this.reach != null) {
            JDD.Deref(this.reach);
        }
        this.reach = jDDNode;
        this.numStates = JDD.GetNumMinterms(jDDNode, this.allDDRowVars.n());
        if (this.odd != null) {
            ODDUtils.ClearODD(this.odd);
            this.odd = null;
        }
        this.odd = ODDUtils.BuildODD(jDDNode, this.allDDRowVars);
    }

    public void resetTrans(JDDNode jDDNode) {
        if (this.trans != null) {
            JDD.Deref(this.trans);
        }
        this.trans = jDDNode;
    }

    public void resetTrans01(JDDNode jDDNode) {
        if (this.trans01 != null) {
            JDD.Deref(this.trans01);
        }
        this.trans01 = jDDNode;
    }

    public void setSynchs(List<String> list) {
        this.synchs = list;
        this.numSynchs = list.size();
    }

    public void addLabelDD(String string, JDDNode jDDNode) {
        JDDNode jDDNode2 = this.labelsDD.put(string, jDDNode);
        if (jDDNode2 != null) {
            JDD.Deref(jDDNode2);
        }
    }

    public String addUniqueLabelDD(String string, JDDNode jDDNode, Set<String> set) {
        int n = 0;
        Object object = string;
        while (true) {
            boolean bl;
            boolean bl2 = bl = !this.hasLabelDD((String)object);
            if (set != null) {
                bl &= !set.contains(object);
            }
            if (bl) break;
            object = string + "_" + n;
            if (n == Integer.MAX_VALUE) {
                throw new UnsupportedOperationException("Integer overflow trying to add unique label");
            }
            ++n;
        }
        this.addLabelDD((String)object, jDDNode);
        return object;
    }

    public void setRewards(JDDNode[] jDDNodeArray, JDDNode[] jDDNodeArray2, String[] stringArray) {
        this.stateRewards = jDDNodeArray;
        this.transRewards = jDDNodeArray2;
        this.numRewardStructs = jDDNodeArray.length;
        this.rewardStructNames = stringArray;
    }

    public void resetTransRewards(int n, JDDNode jDDNode) {
        if (this.transRewards[n] != null) {
            JDD.Deref(this.transRewards[n]);
        }
        this.transRewards[n] = jDDNode;
    }

    public void resetStateRewards(int n, JDDNode jDDNode) {
        if (this.stateRewards[n] != null) {
            JDD.Deref(this.stateRewards[n]);
        }
        this.stateRewards[n] = jDDNode;
    }

    public void setConstantValues(Values values) {
        this.constantValues = values;
    }

    public void doReachability() throws PrismException {
        this.setReach(PrismMTBDD.Reachability(this.trans01, this.allDDRowVars, this.allDDColVars, this.start));
    }

    public void doReachability(JDDNode jDDNode) throws PrismException {
        if (SanityJDD.enabled) {
            SanityJDD.checkIsStateSet(jDDNode, this.getAllDDRowVars());
        }
        JDDNode jDDNode2 = JDD.Or(this.start.copy(), jDDNode);
        this.setReach(PrismMTBDD.Reachability(this.trans01, this.allDDRowVars, this.allDDColVars, jDDNode2));
        JDD.Deref(jDDNode2);
    }

    public void skipReachability() throws PrismException {
        this.reach = JDD.Constant(1.0);
        this.numStates = Math.pow(2.0, this.allDDRowVars.n());
        if (this.odd != null) {
            ODDUtils.ClearODD(this.odd);
            this.odd = null;
        }
        this.odd = ODDUtils.BuildODD(this.reach, this.allDDRowVars);
    }

    public void filterReachableStates() {
        JDD.Ref(this.reach);
        this.trans = JDD.Apply(3, this.reach, this.trans);
        JDD.Ref(this.reach);
        JDDNode jDDNode = JDD.PermuteVariables(this.reach, this.allDDRowVars, this.allDDColVars);
        this.trans = JDD.Apply(3, jDDNode, this.trans);
        JDD.Deref(this.trans01);
        JDD.Ref(this.trans);
        this.trans01 = JDD.GreaterThan(this.trans, 0.0);
        for (int i = 0; i < this.numRewardStructs; ++i) {
            JDD.Ref(this.reach);
            this.stateRewards[i] = JDD.Apply(3, this.reach, this.stateRewards[i]);
            JDD.Ref(this.reach);
            this.transRewards[i] = JDD.Apply(3, this.reach, this.transRewards[i]);
            JDD.Ref(this.reach);
            jDDNode = JDD.PermuteVariables(this.reach, this.allDDRowVars, this.allDDColVars);
            this.transRewards[i] = JDD.Apply(3, jDDNode, this.transRewards[i]);
        }
        JDD.Ref(this.reach);
        this.start = JDD.Apply(3, this.reach, this.start);
        this.numStartStates = JDD.GetNumMinterms(this.start, this.allDDRowVars.n());
        this.numTransitions = JDD.GetNumMinterms(this.trans01, this.getNumDDVarsInTrans());
    }

    public abstract void findDeadlocks(boolean var1);

    public void addDeadlocks(JDDNode jDDNode) {
        this.deadlocks = this.deadlocks == null ? jDDNode : JDD.Or(this.deadlocks, jDDNode);
    }

    @Override
    public List<Object> getActions() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(null);
        arrayList.addAll(this.synchs);
        return arrayList;
    }

    @Override
    public List<Object> findActionsUsed() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumStates() {
        return this.numStates > 2.147483647E9 ? -1 : (int)Math.round(this.numStates);
    }

    @Override
    public int getNumInitialStates() {
        return this.numStartStates > 2.147483647E9 ? -1 : (int)Math.round(this.numStartStates);
    }

    @Override
    public int getNumTransitions() {
        return this.numTransitions > 2.147483647E9 ? -1 : (int)Math.round(this.numTransitions);
    }

    @Override
    public boolean numStatesExceedsInt() {
        return this.numStates > 2.147483647E9;
    }

    @Override
    public String getNumStatesString() {
        return PrismUtils.bigIntToString(this.numStates);
    }

    @Override
    public String getNumInitialStatesString() {
        return PrismUtils.bigIntToString(this.numStartStates);
    }

    @Override
    public String getNumTransitionsString() {
        return PrismUtils.bigIntToString(this.numTransitions);
    }

    @Override
    public JDDNode getStart() {
        return this.start;
    }

    @Override
    public JDDNode getDeadlocks() {
        return this.deadlocks;
    }

    @Override
    public JDDNode getReach() {
        return this.reach;
    }

    @Override
    public ODDNode getODD() {
        return this.odd;
    }

    @Override
    public JDDNode getTrans() {
        return this.trans;
    }

    @Override
    public JDDNode getTrans01() {
        return this.trans01;
    }

    @Override
    public JDDNode getTransReln() {
        return this.trans01;
    }

    @Override
    public VarList getVarList() {
        return this.varList;
    }

    @Override
    public Values getConstantValues() {
        return this.constantValues;
    }

    @Override
    public List<String> getSynchs() {
        return this.synchs;
    }

    @Override
    public JDDNode getLabelDD(String string) {
        return this.labelsDD.get(string);
    }

    @Override
    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.labelsDD.keySet());
    }

    @Override
    public int getNumRewardStructs() {
        return this.numRewardStructs;
    }

    @Override
    public String getRewardStructName(int n) {
        return this.rewardStructNames[n];
    }

    @Override
    public JDDNode getStateRewards(int n) {
        return n >= 0 && n < this.numRewardStructs ? this.stateRewards[n] : null;
    }

    @Override
    public JDDNode getStateRewards(String string) {
        for (int i = 0; i < this.numRewardStructs; ++i) {
            if (!this.rewardStructNames[i].equals(string)) continue;
            return this.stateRewards[i];
        }
        return null;
    }

    @Override
    public JDDNode getTransRewards(int n) {
        return n >= 0 && n < this.numRewardStructs ? this.transRewards[n] : null;
    }

    @Override
    public JDDNode getTransRewards(String string) {
        for (int i = 0; i < this.numRewardStructs; ++i) {
            if (!this.rewardStructNames[i].equals(string)) continue;
            return this.transRewards[i];
        }
        return null;
    }

    @Override
    public ModelVariablesDD getModelVariables() {
        return this.modelVariables;
    }

    @Override
    public JDDVars getAllDDRowVars() {
        return this.allDDRowVars;
    }

    @Override
    public JDDVars getAllDDColVars() {
        return this.allDDColVars;
    }

    @Override
    public int getNumDDVarsInTrans() {
        return this.getNumDDRowVars() * 2;
    }

    @Override
    public JDDVars[] getVarDDRowVars() {
        return this.varDDRowVars;
    }

    @Override
    public JDDVars[] getVarDDColVars() {
        return this.varDDColVars;
    }

    @Override
    public JDDVars getVarDDRowVars(int n) {
        return this.varDDRowVars[n];
    }

    @Override
    public JDDVars getVarDDColVars(int n) {
        return this.varDDColVars[n];
    }

    @Override
    public void printTransInfo(PrismLog prismLog, boolean bl) {
        prismLog.print("States:      " + this.getNumStatesString() + " (" + this.getNumInitialStatesString() + " initial)\n");
        prismLog.print("Transitions: " + this.getNumTransitionsString() + "\n");
        prismLog.println();
        prismLog.print(this.getTransName() + ": " + JDD.GetInfoString(this.trans, this.getNumDDVarsInTrans()));
        prismLog.print(", vars: " + this.getTransDDVarSummary() + "\n");
        if (bl) {
            prismLog.print(this.getTransDDVarInfo() + "\n");
            prismLog.print(this.getTransName() + " terminals: " + JDD.GetTerminalsAndNumbersString(this.trans, this.getNumDDVarsInTrans()) + "\n");
            prismLog.print("Reach: " + JDD.GetNumNodes(this.reach) + " nodes\n");
            prismLog.print("ODD: " + ODDUtils.GetNumODDNodes() + " nodes\n");
            for (int i = 0; i < this.numRewardStructs; ++i) {
                if (this.stateRewards[i] != null && !this.stateRewards[i].equals(JDD.ZERO)) {
                    prismLog.print("State rewards (" + (i + 1) + (String)("".equals(this.rewardStructNames[i]) ? "" : ":\"" + this.rewardStructNames[i] + "\"") + "): ");
                    prismLog.print(JDD.GetNumNodes(this.stateRewards[i]) + " nodes (");
                    prismLog.print(JDD.GetNumTerminals(this.stateRewards[i]) + " terminal), ");
                    prismLog.print(JDD.GetNumMintermsString(this.stateRewards[i], this.getNumDDRowVars()) + " minterms\n");
                    if (bl) {
                        prismLog.print("State rewards terminals (" + (i + 1) + (String)("".equals(this.rewardStructNames[i]) ? "" : ":\"" + this.rewardStructNames[i] + "\"") + "): ");
                        prismLog.print(JDD.GetTerminalsAndNumbersString(this.stateRewards[i], this.getNumDDRowVars()) + "\n");
                    }
                }
                if (this.transRewards[i] == null || this.transRewards[i].equals(JDD.ZERO)) continue;
                prismLog.print("Transition rewards (" + (i + 1) + (String)("".equals(this.rewardStructNames[i]) ? "" : ":\"" + this.rewardStructNames[i] + "\"") + "): ");
                prismLog.print(JDD.GetNumNodes(this.transRewards[i]) + " nodes (");
                prismLog.print(JDD.GetNumTerminals(this.transRewards[i]) + " terminal), ");
                prismLog.print(JDD.GetNumMintermsString(this.transRewards[i], this.getNumDDVarsInTrans()) + " minterms\n");
                if (!bl) continue;
                prismLog.print("Transition rewards terminals (" + (i + 1) + (String)("".equals(this.rewardStructNames[i]) ? "" : ":\"" + this.rewardStructNames[i] + "\"") + "): ");
                prismLog.print(JDD.GetTerminalsAndNumbersString(this.transRewards[i], this.getNumDDVarsInTrans()) + "\n");
            }
        }
    }

    @Override
    public String getTransDDVarSummary() {
        return this.getNumDDRowVars() + "r/" + this.getNumDDColVars() + "c";
    }

    @Override
    public String getTransDDVarInfo() {
        Object object = "DD vars (r/c):";
        int n = this.allDDRowVars.getNumVars();
        for (int i = 0; i < n; ++i) {
            int n2 = this.allDDRowVars.getVarIndex(i);
            object = (String)object + " " + n2 + ":" + this.getDDVarNames().get(n2);
            n2 = this.allDDColVars.getVarIndex(i);
            object = (String)object + " " + n2 + ":" + this.getDDVarNames().get(n2);
        }
        return object;
    }

    @Override
    public void exportStateRewardsToFile(int n, int n2, File file, int n3, boolean bl) throws FileNotFoundException, PrismException {
        PrismMTBDD.ExportVector(this.stateRewards[n], "c" + (n + 1), this.allDDRowVars, this.odd, n2, file == null ? null : file.getPath(), n3, this.rewardStructNames[n], bl);
    }

    @Override
    public void exportStateRewardsToFile(int n, File file, ModelExportOptions modelExportOptions) throws FileNotFoundException, PrismException {
        int n2 = Prism.convertExportType(modelExportOptions);
        int n3 = modelExportOptions.getModelPrecision();
        boolean bl = !modelExportOptions.getPrintHeaders();
        PrismMTBDD.ExportVector(this.stateRewards[n], "c" + (n + 1), this.allDDRowVars, this.odd, n2, file == null ? null : file.getPath(), n3, this.rewardStructNames[n], bl);
    }

    @Override
    public void exportStates(int n, PrismLog prismLog) {
        if (n == 2) {
            prismLog.print("% ");
        }
        prismLog.print("(");
        int n2 = this.getNumVars();
        for (int i = 0; i < n2; ++i) {
            prismLog.print(this.getVarName(i));
            if (i >= n2 - 1) continue;
            prismLog.print(",");
        }
        prismLog.println(")");
        if (n == 2) {
            prismLog.println("states=[");
        }
        if (n != 2) {
            this.getReachableStates().print(prismLog);
        } else {
            this.getReachableStates().printMatlab(prismLog);
        }
        if (n == 2) {
            prismLog.println("];");
        }
    }

    @Override
    public void clear() {
        for (Map.Entry<String, JDDNode> entry : this.labelsDD.entrySet()) {
            JDD.Deref(entry.getValue());
        }
        this.labelsDD.clear();
        if (this.varDDRowVars != null) {
            JDDVars.derefAllArray(this.varDDRowVars);
        }
        if (this.varDDColVars != null) {
            JDDVars.derefAllArray(this.varDDColVars);
        }
        this.allDDRowVars.derefAll();
        this.allDDColVars.derefAll();
        JDD.Deref(this.trans);
        JDD.Deref(this.trans01);
        JDD.Deref(this.start);
        if (this.reach != null) {
            JDD.Deref(this.reach);
        }
        if (this.deadlocks != null) {
            JDD.Deref(this.deadlocks);
        }
        for (int i = 0; i < this.numRewardStructs; ++i) {
            JDD.Deref(this.stateRewards[i]);
            JDD.Deref(this.transRewards[i]);
        }
        if (this.odd != null) {
            ODDUtils.ClearODD(this.odd);
            this.odd = null;
        }
        if (this.modelVariables != null) {
            this.modelVariables.clear();
        }
    }

    public long getNumStatesLong() {
        return this.numStates > 9.223372036854776E18 ? -1L : Math.round(this.numStates);
    }

    public long getNumInitialStatesLong() {
        return this.numStartStates > 9.223372036854776E18 ? -1L : Math.round(this.numStartStates);
    }

    public long getNumTransitionsLong() {
        return this.numTransitions > 9.223372036854776E18 ? -1L : Math.round(this.numTransitions);
    }
}

