/*
 * Decompiled with CFR 0.152.
 */
package symbolic.build;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import parser.Values;
import parser.VarList;
import parser.ast.Command;
import parser.ast.Expression;
import parser.ast.Module;
import parser.ast.ModulesFile;
import parser.ast.RewardStruct;
import parser.ast.SystemBrackets;
import parser.ast.SystemDefn;
import parser.ast.SystemFullParallel;
import parser.ast.SystemHide;
import parser.ast.SystemInterleaved;
import parser.ast.SystemModule;
import parser.ast.SystemParallel;
import parser.ast.SystemReference;
import parser.ast.SystemRename;
import parser.ast.Update;
import parser.ast.Updates;
import prism.ModelType;
import prism.PlayerInfo;
import prism.Prism;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.PrismUtils;
import symbolic.comp.StateModelChecker;
import symbolic.model.GamesModel;
import symbolic.model.Model;
import symbolic.model.ModelSymbolic;
import symbolic.model.ModelVariablesDD;
import symbolic.model.NondetModel;
import symbolic.model.ProbModel;
import symbolic.model.StochModel;

public class Modules2MTBDD {
    private Prism prism;
    private StateModelChecker expr2mtbdd;
    private PrismLog mainLog;
    private ModulesFile modulesFile;
    private ModelType modelType;
    private int numModules;
    private String[] moduleNames;
    private int numVars;
    private VarList varList;
    private Values constantValues;
    private int numSynchs;
    private List<String> synchs;
    private int numPlayers;
    private int numRewardStructs;
    private String[] rewardStructNames;
    private JDDNode trans;
    private JDDNode range;
    private JDDNode start;
    private JDDNode[] stateRewards;
    private JDDNode[] transRewards;
    private JDDNode transActions;
    private JDDNode[] transPerAction;
    private JDDNode transInd;
    private JDDNode[] transSynch;
    private JDDVars allDDRowVars;
    private JDDVars allDDColVars;
    private JDDVars allDDSynchVars;
    private JDDVars allDDSchedVars;
    private JDDVars allDDChoiceVars;
    private JDDVars allDDNondetVars;
    private JDDVars allDDPlayerVars;
    private JDDVars globalDDRowVars;
    private JDDVars globalDDColVars;
    private JDDVars[] moduleDDRowVars;
    private JDDVars[] moduleDDColVars;
    private JDDNode[] moduleRangeDDs;
    private JDDNode[] moduleIdentities;
    private JDDVars[] varDDRowVars;
    private JDDVars[] varDDColVars;
    private JDDNode[] varRangeDDs;
    private JDDNode[] varColRangeDDs;
    private JDDNode[] varIdentities;
    private JDDNode[] ddSynchVars;
    private JDDNode[] ddSchedVars;
    private JDDNode[] ddChoiceVars;
    private JDDNode[] ddPlayerVars;
    private JDDNode[] ddPlayerCubes;
    private ModelVariablesDD modelVariables;
    private boolean[] varsUsed;
    private boolean doSymmetry;
    private JDDNode symm;
    private JDDNode[] nonSymms;
    private int numModulesBeforeSymm;
    private int numModulesAfterSymm;
    private int numSymmModules;
    private boolean storeTransParts = false;
    private boolean storeTransActions = true;
    private boolean modelWasBuilt = false;

    public Modules2MTBDD(Prism prism, ModulesFile modulesFile) {
        this.prism = prism;
        this.mainLog = prism.getMainLog();
        this.modulesFile = modulesFile;
        String string = this.prism.getSettings().getString("prism.symmRedParams");
        this.doSymmetry = string != null && string != "";
    }

    public Model translate() throws PrismException {
        ModelSymbolic modelSymbolic = null;
        this.varList = this.modulesFile.createVarList();
        if (this.modulesFile.containsUnboundedVariables()) {
            throw new PrismNotSupportedException("Cannot build a model that contains a variable with unbounded range (try the explicit engine instead)");
        }
        this.numVars = this.varList.getNumVars();
        this.constantValues = this.modulesFile.getConstantValues();
        this.modelType = this.modulesFile.getModelType();
        this.moduleNames = this.modulesFile.getModuleNames();
        this.numModules = this.modulesFile.getNumModules();
        this.synchs = this.modulesFile.getSynchs();
        this.numSynchs = this.synchs.size();
        this.numPlayers = this.modulesFile.getNumPlayers();
        if (this.modelType != ModelType.DTMC && this.modelType != ModelType.MDP && this.modelType != ModelType.CTMC && this.modelType != ModelType.SMG) {
            throw new PrismException("Symbolic construction of " + String.valueOf((Object)this.modelType) + "s not supported");
        }
        try {
            this.allocateDDVars();
            this.sortDDVars();
            this.sortIdentities();
            this.sortRanges();
            this.expr2mtbdd = new StateModelChecker(this.prism, this.varList, this.allDDRowVars, this.varDDRowVars, this.constantValues);
            this.translateModules();
            if (this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) {
                JDDNode jDDNode = JDD.GetSupport(this.trans);
                jDDNode = JDD.ThereExists(jDDNode, this.allDDRowVars);
                JDDNode jDDNode2 = jDDNode = JDD.ThereExists(jDDNode, this.allDDColVars);
                JDDVars jDDVars = new JDDVars();
                while (!jDDNode2.equals(JDD.ONE)) {
                    jDDVars.addVar(JDD.Var(jDDNode2.getIndex()));
                    jDDNode2 = jDDNode2.getThen();
                }
                JDD.Deref(jDDNode);
                this.allDDNondetVars.derefAll();
                this.allDDNondetVars = jDDVars;
            }
            if (this.modelType == ModelType.SMG) {
                this.buildDDGame();
            }
            if (this.prism.getExtraDDInfo()) {
                this.mainLog.print("Transition matrix (pre-reachability): ");
                this.mainLog.print(JDD.GetNumNodes(this.trans) + " nodes (");
                this.mainLog.print(JDD.GetNumTerminals(this.trans) + " terminal)\n");
            }
            this.buildInitialStates();
            this.rewardStructNames = new String[this.numRewardStructs];
            for (int i = 0; i < this.numRewardStructs; ++i) {
                this.rewardStructNames[i] = this.modulesFile.getRewardStruct(i).getName();
            }
            if (this.modelType == ModelType.DTMC) {
                modelSymbolic = new ProbModel(this.trans, this.start, this.allDDRowVars, this.allDDColVars, this.modelVariables, this.varList, this.varDDRowVars, this.varDDColVars);
            } else if (this.modelType == ModelType.MDP) {
                modelSymbolic = new NondetModel(this.trans, this.start, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.modelVariables, this.varList, this.varDDRowVars, this.varDDColVars);
            } else if (this.modelType == ModelType.CTMC) {
                modelSymbolic = new StochModel(this.trans, this.start, this.allDDRowVars, this.allDDColVars, this.modelVariables, this.varList, this.varDDRowVars, this.varDDColVars);
            } else if (this.modelType == ModelType.SMG) {
                PlayerInfo playerInfo = new PlayerInfo();
                for (int i = 0; i < this.numPlayers; ++i) {
                    playerInfo.addPlayer(this.modulesFile.getPlayer(i).getName());
                }
                modelSymbolic = new GamesModel(this.trans, this.start, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.modelVariables, this.varList, this.varDDRowVars, this.varDDColVars, this.allDDPlayerVars, this.ddPlayerCubes, playerInfo);
            }
            modelSymbolic.setRewards(this.stateRewards, this.transRewards, this.rewardStructNames);
            modelSymbolic.setConstantValues(this.constantValues);
            this.modelWasBuilt = true;
            modelSymbolic.setSynchs(new ArrayList<String>(this.synchs));
            if ((this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) && this.storeTransParts) {
                ((NondetModel)modelSymbolic).setTransInd(this.transInd);
                ((NondetModel)modelSymbolic).setTransSynch(this.transSynch);
            }
            if (this.storeTransActions) {
                if (this.modelType != ModelType.MDP && this.modelType != ModelType.SMG) {
                    ((ProbModel)modelSymbolic).setTransPerAction(this.transPerAction);
                } else {
                    ((NondetModel)modelSymbolic).setTransActions(this.transActions);
                }
            }
            if (this.prism.getDoReach()) {
                this.mainLog.print("\nComputing reachable states...\n");
                modelSymbolic.doReachability();
                modelSymbolic.filterReachableStates();
            } else {
                this.mainLog.print("\nSkipping reachable state computation.\n");
                modelSymbolic.skipReachability();
                modelSymbolic.filterReachableStates();
            }
            if (this.prism.getExtraDDInfo()) {
                this.mainLog.print("Reach: " + JDD.GetNumNodes(modelSymbolic.getReach()) + " nodes\n");
            }
            if (this.doSymmetry) {
                this.doSymmetry(modelSymbolic);
            }
            modelSymbolic.findDeadlocks(this.prism.getFixDeadlocks());
        }
        catch (Exception exception) {
            if (modelSymbolic != null) {
                modelSymbolic.clear();
            }
            throw exception;
        }
        finally {
            this.cleanup();
        }
        return modelSymbolic;
    }

    private void cleanup() {
        if (this.globalDDRowVars != null) {
            this.globalDDRowVars.derefAll();
        }
        if (this.globalDDColVars != null) {
            this.globalDDColVars.derefAll();
        }
        if (this.moduleDDRowVars != null) {
            JDDVars.derefAllArray(this.moduleDDRowVars);
        }
        if (this.moduleDDColVars != null) {
            JDDVars.derefAllArray(this.moduleDDColVars);
        }
        JDD.DerefArrayNonNull(this.moduleIdentities, this.numModules);
        JDD.DerefArrayNonNull(this.moduleRangeDDs, this.numModules);
        JDD.DerefArrayNonNull(this.varIdentities, this.numVars);
        JDD.DerefArrayNonNull(this.varRangeDDs, this.numVars);
        JDD.DerefArrayNonNull(this.varColRangeDDs, this.numVars);
        JDD.DerefNonNull(this.range);
        JDD.DerefArrayNonNull(this.ddSynchVars);
        JDD.DerefArrayNonNull(this.ddSchedVars);
        JDD.DerefArrayNonNull(this.ddChoiceVars);
        if (this.allDDSynchVars != null) {
            this.allDDSynchVars.derefAll();
        }
        if (this.allDDSchedVars != null) {
            this.allDDSchedVars.derefAll();
        }
        if (this.allDDChoiceVars != null) {
            this.allDDChoiceVars.derefAll();
        }
        JDD.DerefArrayNonNull(this.ddPlayerVars);
        if (this.doSymmetry) {
            JDD.Deref(this.symm);
            JDD.DerefArray(this.nonSymms, this.numSymmModules - 1);
        }
        if (!this.modelWasBuilt) {
            JDD.DerefNonNull(this.trans);
            JDD.DerefNonNull(this.start);
            JDD.DerefArrayNonNull(this.stateRewards, this.numRewardStructs);
            JDD.DerefArrayNonNull(this.transRewards, this.numRewardStructs);
            JDD.DerefNonNull(this.transActions);
            JDD.DerefArrayNonNull(this.transPerAction);
            JDD.DerefNonNull(this.transInd);
            JDD.DerefArrayNonNull(this.transSynch);
            if (this.allDDRowVars != null) {
                this.allDDRowVars.derefAll();
            }
            if (this.allDDColVars != null) {
                this.allDDColVars.derefAll();
            }
            if (this.allDDNondetVars != null) {
                this.allDDNondetVars.derefAll();
            }
            if (this.allDDPlayerVars != null) {
                this.allDDPlayerVars.derefAll();
            }
            JDDVars.derefAllArray(this.varDDRowVars);
            JDDVars.derefAllArray(this.varDDColVars);
            if (this.modelVariables != null) {
                this.modelVariables.clear();
            }
        }
        if (this.expr2mtbdd != null) {
            this.expr2mtbdd.clearDummyModel();
        }
    }

    private void allocateDDVars() {
        this.modelVariables = new ModelVariablesDD();
        if (this.modelType == ModelType.SMG) {
            this.ddPlayerVars = new JDDNode[this.numPlayers];
            for (int i = 0; i < this.numPlayers; ++i) {
                this.ddPlayerVars[i] = this.modelVariables.allocateVariable(this.modulesFile.getPlayer(i).getName() + ".p");
            }
        }
        switch (this.prism.getOrdering()) {
            case 1: {
                int n;
                int n2;
                this.modelVariables.preallocateExtraActionVariables(this.prism.getSettings().getInteger("prism.ddExtraActionVars"));
                if (this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) {
                    this.ddSynchVars = new JDDNode[this.numSynchs];
                    this.ddSchedVars = new JDDNode[this.numModules];
                    n2 = this.numModules;
                    for (n = 0; n < this.numModules; ++n) {
                        n2 += this.modulesFile.getModule(n).getNumCommands();
                    }
                    this.ddChoiceVars = new JDDNode[n2];
                }
                this.varDDRowVars = new JDDVars[this.numVars];
                this.varDDColVars = new JDDVars[this.numVars];
                for (n = 0; n < this.numVars; ++n) {
                    this.varDDRowVars[n] = new JDDVars();
                    this.varDDColVars[n] = new JDDVars();
                }
                if (this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) {
                    for (n = 0; n < this.numSynchs; ++n) {
                        this.ddSynchVars[n] = this.modelVariables.allocateVariable(this.synchs.get(n) + ".a");
                    }
                }
                if (this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) {
                    for (n = 0; n < this.numModules; ++n) {
                        this.ddSchedVars[n] = this.modelVariables.allocateVariable(this.moduleNames[n] + ".s");
                    }
                }
                if (this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) {
                    n2 = this.ddChoiceVars.length;
                    for (n = 0; n < n2; ++n) {
                        this.ddChoiceVars[n] = this.modelVariables.allocateVariable("l" + n);
                    }
                }
                this.modelVariables.preallocateExtraStateVariables(this.prism.getSettings().getInteger("prism.ddExtraStateVars"));
                for (n = 0; n < this.numVars; ++n) {
                    int n3 = this.varList.getRangeLogTwo(n);
                    for (int i = 0; i < n3; ++i) {
                        this.varDDRowVars[n].addVar(this.modelVariables.allocateVariable(this.varList.getName(n) + "." + i));
                        this.varDDColVars[n].addVar(this.modelVariables.allocateVariable(this.varList.getName(n) + "'." + i));
                    }
                }
                break;
            }
            case 2: {
                int n;
                int n4;
                int n5;
                this.modelVariables.preallocateExtraActionVariables(this.prism.getSettings().getInteger("prism.ddExtraActionVars"));
                if (this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) {
                    this.ddSynchVars = new JDDNode[this.numSynchs];
                    this.ddSchedVars = new JDDNode[this.numModules];
                    n5 = this.numModules;
                    for (n4 = 0; n4 < this.numModules; ++n4) {
                        n5 += this.modulesFile.getModule(n4).getNumCommands();
                    }
                    this.ddChoiceVars = new JDDNode[n5];
                }
                this.varDDRowVars = new JDDVars[this.numVars];
                this.varDDColVars = new JDDVars[this.numVars];
                for (n4 = 0; n4 < this.numVars; ++n4) {
                    this.varDDRowVars[n4] = new JDDVars();
                    this.varDDColVars[n4] = new JDDVars();
                }
                if (this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) {
                    for (n4 = 0; n4 < this.numSynchs; ++n4) {
                        this.ddSynchVars[n4] = this.modelVariables.allocateVariable(this.synchs.get(n4) + ".a");
                    }
                }
                if (this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) {
                    n5 = this.ddChoiceVars.length;
                    for (n4 = 0; n4 < n5; ++n4) {
                        this.ddChoiceVars[n4] = this.modelVariables.allocateVariable("l" + n4);
                    }
                }
                int n6 = -1;
                for (n4 = 0; n4 < this.numVars; ++n4) {
                    if ((this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) && n6 != this.varList.getModule(n4)) {
                        for (n = n6 + 1; n <= this.varList.getModule(n4); ++n) {
                            this.ddSchedVars[n] = this.modelVariables.allocateVariable(this.moduleNames[n] + ".s");
                        }
                        n6 = this.varList.getModule(n4);
                    }
                    int n7 = this.varList.getRangeLogTwo(n4);
                    for (n = 0; n < n7; ++n) {
                        this.varDDRowVars[n4].addVar(this.modelVariables.allocateVariable(this.varList.getName(n4) + "." + n));
                        this.varDDColVars[n4].addVar(this.modelVariables.allocateVariable(this.varList.getName(n4) + "'." + n));
                    }
                }
                if (this.modelType != ModelType.MDP && this.modelType != ModelType.SMG) break;
                for (n = n6 + 1; n < this.numModules; ++n) {
                    this.ddSchedVars[n] = this.modelVariables.allocateVariable(this.moduleNames[n] + ".s");
                }
                break;
            }
            default: {
                this.mainLog.printWarning("Invalid MTBDD ordering selected - it's all going to go wrong.");
            }
        }
    }

    private void sortDDVars() {
        int n;
        this.globalDDRowVars = new JDDVars();
        this.globalDDColVars = new JDDVars();
        this.moduleDDRowVars = new JDDVars[this.numModules];
        this.moduleDDColVars = new JDDVars[this.numModules];
        for (n = 0; n < this.numModules; ++n) {
            this.moduleDDRowVars[n] = new JDDVars();
            this.moduleDDColVars[n] = new JDDVars();
        }
        for (n = 0; n < this.numVars; ++n) {
            int n2 = this.varList.getModule(n);
            if (n2 == -1) {
                this.globalDDRowVars.copyVarsFrom(this.varDDRowVars[n]);
                this.globalDDColVars.copyVarsFrom(this.varDDColVars[n]);
                continue;
            }
            this.moduleDDRowVars[n2].copyVarsFrom(this.varDDRowVars[n]);
            this.moduleDDColVars[n2].copyVarsFrom(this.varDDColVars[n]);
        }
        this.allDDRowVars = new JDDVars();
        this.allDDColVars = new JDDVars();
        if (this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) {
            this.allDDSynchVars = new JDDVars();
            this.allDDSchedVars = new JDDVars();
            this.allDDChoiceVars = new JDDVars();
            this.allDDNondetVars = new JDDVars();
        }
        if (this.modelType == ModelType.SMG) {
            this.allDDPlayerVars = new JDDVars();
        }
        for (n = 0; n < this.numVars; ++n) {
            this.allDDRowVars.copyVarsFrom(this.varDDRowVars[n]);
            this.allDDColVars.copyVarsFrom(this.varDDColVars[n]);
        }
        if (this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) {
            for (n = 0; n < this.ddSynchVars.length; ++n) {
                this.allDDSynchVars.addVar(this.ddSynchVars[n].copy());
                this.allDDNondetVars.addVar(this.ddSynchVars[n].copy());
            }
            for (n = 0; n < this.ddSchedVars.length; ++n) {
                this.allDDSchedVars.addVar(this.ddSchedVars[n].copy());
                this.allDDNondetVars.addVar(this.ddSchedVars[n].copy());
            }
            for (n = 0; n < this.ddChoiceVars.length; ++n) {
                this.allDDChoiceVars.addVar(this.ddChoiceVars[n].copy());
                this.allDDNondetVars.addVar(this.ddChoiceVars[n].copy());
            }
        }
        if (this.modelType == ModelType.SMG) {
            for (n = 0; n < this.ddPlayerVars.length; ++n) {
                this.allDDPlayerVars.addVar(this.ddPlayerVars[n].copy());
            }
        }
    }

    private void sortIdentities() {
        int n;
        JDDNode jDDNode;
        int n2;
        this.varIdentities = new JDDNode[this.numVars];
        for (n2 = 0; n2 < this.numVars; ++n2) {
            jDDNode = JDD.Constant(0.0);
            for (n = 0; n < this.varList.getRange(n2); ++n) {
                jDDNode = JDD.SetMatrixElement(jDDNode, this.varDDRowVars[n2], this.varDDColVars[n2], n, n, 1.0);
            }
            this.varIdentities[n2] = jDDNode;
        }
        this.moduleIdentities = new JDDNode[this.numModules];
        for (n2 = 0; n2 < this.numModules; ++n2) {
            jDDNode = JDD.Constant(1.0);
            for (n = 0; n < this.numVars; ++n) {
                if (this.varList.getModule(n) != n2) continue;
                jDDNode = JDD.Apply(3, jDDNode, this.varIdentities[n].copy());
            }
            this.moduleIdentities[n2] = jDDNode;
        }
    }

    private void sortRanges() {
        int n;
        this.range = JDD.Constant(1.0);
        this.varRangeDDs = new JDDNode[this.numVars];
        this.varColRangeDDs = new JDDNode[this.numVars];
        for (n = 0; n < this.numVars; ++n) {
            this.varRangeDDs[n] = JDD.SumAbstract(this.varIdentities[n].copy(), this.varDDColVars[n]);
            this.varColRangeDDs[n] = JDD.SumAbstract(this.varIdentities[n].copy(), this.varDDRowVars[n]);
            this.range = JDD.Apply(3, this.range, this.varRangeDDs[n].copy());
        }
        this.moduleRangeDDs = new JDDNode[this.numModules];
        for (n = 0; n < this.numModules; ++n) {
            this.moduleRangeDDs[n] = JDD.SumAbstract(this.moduleIdentities[n].copy(), this.moduleDDColVars[n]);
        }
    }

    private void translateModules() throws PrismException {
        int n;
        this.varsUsed = new boolean[this.numVars];
        if (this.modulesFile.getSystemDefn() == null) {
            SystemFullParallel systemFullParallel = new SystemFullParallel();
            for (n = 0; n < this.numModules; ++n) {
                systemFullParallel.addOperand(new SystemModule(this.moduleNames[n]));
            }
            this.translateSystemDefn(systemFullParallel);
        } else {
            this.translateSystemDefn(this.modulesFile.getSystemDefn());
        }
        if (this.modelType == ModelType.DTMC) {
            JDDNode jDDNode = JDD.SumAbstract(this.trans.copy(), this.allDDColVars);
            this.trans = JDD.Apply(4, this.trans, jDDNode.copy());
            if (this.storeTransActions) {
                for (n = 0; n < this.numSynchs + 1; ++n) {
                    this.transPerAction[n] = JDD.Apply(4, this.transPerAction[n], jDDNode.copy());
                }
            }
            JDD.Deref(jDDNode);
        }
    }

    private void translateSystemDefn(SystemDefn systemDefn) throws PrismException {
        int n;
        JDDNode jDDNode;
        int n2;
        int[] nArray = new int[this.numSynchs];
        for (n2 = 0; n2 < this.numSynchs; ++n2) {
            nArray[n2] = 0;
        }
        SystemDDs systemDDs = this.translateSystemDefnRec(systemDefn, nArray);
        if (this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) {
            JDDNode jDDNode2;
            int n3 = systemDDs.ind.max;
            for (n2 = 0; n2 < this.numSynchs; ++n2) {
                if (systemDDs.synchs[n2].max <= n3) continue;
                n3 = systemDDs.synchs[n2].max;
            }
            if (n3 > systemDDs.ind.max) {
                jDDNode = JDD.Constant(1.0);
                for (n2 = systemDDs.ind.max; n2 < n3; ++n2) {
                    jDDNode2 = this.ddChoiceVars[this.ddChoiceVars.length - n2 - 1];
                    JDD.Ref(jDDNode2);
                    jDDNode = JDD.And(jDDNode, JDD.Not(jDDNode2));
                }
                systemDDs.ind.trans = JDD.Apply(3, systemDDs.ind.trans, jDDNode);
                systemDDs.ind.max = n3;
            }
            for (n2 = 0; n2 < this.numSynchs; ++n2) {
                if (n3 <= systemDDs.synchs[n2].max) continue;
                jDDNode = JDD.Constant(1.0);
                for (n = systemDDs.synchs[n2].max; n < n3; ++n) {
                    jDDNode2 = this.ddChoiceVars[this.ddChoiceVars.length - n - 1];
                    JDD.Ref(jDDNode2);
                    jDDNode = JDD.And(jDDNode, JDD.Not(jDDNode2));
                }
                systemDDs.synchs[n2].trans = JDD.Apply(3, systemDDs.synchs[n2].trans, jDDNode);
                systemDDs.synchs[n2].max = n3;
            }
            jDDNode = JDD.Constant(1.0);
            for (n2 = 0; n2 < this.numSynchs; ++n2) {
                jDDNode = JDD.And(jDDNode, JDD.Not(this.ddSynchVars[n2].copy()));
            }
            systemDDs.ind.trans = JDD.Apply(3, jDDNode, systemDDs.ind.trans);
            for (n2 = 0; n2 < this.numSynchs; ++n2) {
                jDDNode = JDD.Constant(1.0);
                for (n = 0; n < this.numSynchs; ++n) {
                    jDDNode = n == n2 ? JDD.And(jDDNode, this.ddSynchVars[n].copy()) : JDD.And(jDDNode, JDD.Not(this.ddSynchVars[n].copy()));
                }
                systemDDs.synchs[n2].trans = JDD.Apply(3, jDDNode, systemDDs.synchs[n2].trans);
            }
        }
        this.computeRewards(systemDDs);
        int n4 = this.modulesFile.getNumRewardStructs();
        this.trans = systemDDs.ind.trans.copy();
        for (n = 0; n < n4; ++n) {
            this.transRewards[n] = systemDDs.ind.rewards[n];
        }
        for (n2 = 0; n2 < this.numSynchs; ++n2) {
            this.trans = JDD.Apply(1, this.trans, systemDDs.synchs[n2].trans.copy());
            for (n = 0; n < n4; ++n) {
                this.transRewards[n] = JDD.Apply(1, this.transRewards[n], systemDDs.synchs[n2].rewards[n]);
            }
        }
        if (this.modelType != ModelType.MDP && this.modelType != ModelType.SMG) {
            n4 = this.modulesFile.getNumRewardStructs();
            for (n = 0; n < n4; ++n) {
                this.transRewards[n] = JDD.Apply(4, this.transRewards[n], this.trans.copy());
            }
        }
        if ((this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) && this.storeTransParts) {
            this.transInd = JDD.ThereExists(JDD.GreaterThan(systemDDs.ind.trans.copy(), 0.0), this.allDDColVars);
            this.transSynch = new JDDNode[this.numSynchs];
            for (n2 = 0; n2 < this.numSynchs; ++n2) {
                this.transSynch[n2] = JDD.ThereExists(JDD.GreaterThan(systemDDs.synchs[n2].trans.copy(), 0.0), this.allDDColVars);
            }
        }
        if (this.storeTransActions) {
            this.transActions = null;
            this.transPerAction = null;
            switch (this.modelType) {
                case MDP: 
                case SMG: {
                    this.transActions = JDD.Constant(0.0);
                    for (n2 = 0; n2 < this.numSynchs; ++n2) {
                        jDDNode = JDD.ThereExists(JDD.GreaterThan(systemDDs.synchs[n2].trans.copy(), 0.0), this.allDDColVars);
                        this.transActions = JDD.Apply(1, this.transActions, JDD.Apply(3, jDDNode, JDD.Constant(1 + n2)));
                    }
                    break;
                }
                case DTMC: 
                case CTMC: {
                    this.transPerAction = new JDDNode[this.numSynchs + 1];
                    this.transPerAction[0] = systemDDs.ind.trans.copy();
                    for (n2 = 0; n2 < this.numSynchs; ++n2) {
                        this.transPerAction[n2 + 1] = systemDDs.synchs[n2].trans.copy();
                    }
                    break;
                }
            }
        }
        JDD.Deref(systemDDs.ind.guards);
        JDD.Deref(systemDDs.ind.trans);
        for (n2 = 0; n2 < this.numSynchs; ++n2) {
            JDD.Deref(systemDDs.synchs[n2].guards);
            JDD.Deref(systemDDs.synchs[n2].trans);
        }
        JDD.Deref(systemDDs.id);
    }

    private SystemDDs translateSystemDefnRec(SystemDefn systemDefn, int[] nArray) throws PrismException {
        SystemDDs systemDDs;
        if (systemDefn instanceof SystemModule) {
            systemDDs = this.translateSystemModule((SystemModule)systemDefn, nArray);
        } else if (systemDefn instanceof SystemBrackets) {
            systemDDs = this.translateSystemDefnRec(((SystemBrackets)systemDefn).getOperand(), nArray);
        } else if (systemDefn instanceof SystemFullParallel) {
            systemDDs = this.translateSystemFullParallel((SystemFullParallel)systemDefn, nArray);
        } else if (systemDefn instanceof SystemInterleaved) {
            systemDDs = this.translateSystemInterleaved((SystemInterleaved)systemDefn, nArray);
        } else if (systemDefn instanceof SystemParallel) {
            systemDDs = this.translateSystemParallel((SystemParallel)systemDefn, nArray);
        } else if (systemDefn instanceof SystemHide) {
            systemDDs = this.translateSystemHide((SystemHide)systemDefn, nArray);
        } else if (systemDefn instanceof SystemRename) {
            systemDDs = this.translateSystemRename((SystemRename)systemDefn, nArray);
        } else if (systemDefn instanceof SystemReference) {
            String string = ((SystemReference)systemDefn).getName();
            SystemDefn systemDefn2 = this.modulesFile.getSystemDefnByName(string);
            if (systemDefn2 == null) {
                throw new PrismLangException("Reference to system " + String.valueOf(systemDefn) + " which does not exist", systemDefn);
            }
            systemDDs = this.translateSystemDefnRec(systemDefn2, nArray);
        } else {
            throw new PrismLangException("Unknown operator in model construction", systemDefn);
        }
        return systemDDs;
    }

    private SystemDDs translateSystemModule(SystemModule systemModule, int[] nArray) throws PrismException {
        SystemDDs systemDDs = new SystemDDs(this.numSynchs);
        int n = this.modulesFile.getModuleIndex(systemModule.getName());
        Module module = this.modulesFile.getModule(n);
        systemDDs.ind = this.translateModule(n, module, "", 0);
        for (int i = 0; i < this.numSynchs; ++i) {
            String string = this.synchs.get(i);
            systemDDs.synchs[i] = this.translateModule(n, module, string, nArray[i]);
        }
        systemDDs.id = this.moduleIdentities[n].copy();
        systemDDs.allSynchs.addAll(module.getAllSynchs());
        return systemDDs;
    }

    private SystemDDs translateSystemFullParallel(SystemFullParallel systemFullParallel, int[] nArray) throws PrismException {
        SystemDDs systemDDs = this.translateSystemDefnRec(systemFullParallel.getOperand(0), nArray);
        for (int i = 1; i < systemFullParallel.getNumOperands(); ++i) {
            int n;
            int[] nArray2 = new int[this.numSynchs];
            for (n = 0; n < this.numSynchs; ++n) {
                nArray2[n] = systemDDs.allSynchs.contains(this.synchs.get(n)) ? systemDDs.synchs[n].max : nArray[n];
            }
            SystemDDs systemDDs2 = this.translateSystemDefnRec(systemFullParallel.getOperand(i), nArray2);
            SystemDDs systemDDs3 = systemDDs;
            systemDDs = new SystemDDs(this.numSynchs);
            systemDDs.ind = this.translateNonSynchronising(systemDDs3.ind, systemDDs2.ind, systemDDs3.id, systemDDs2.id);
            for (n = 0; n < this.numSynchs; ++n) {
                systemDDs.synchs[n] = (systemDDs3.allSynchs.contains(this.synchs.get(n)) ? 1 : 0) + (systemDDs2.allSynchs.contains(this.synchs.get(n)) ? 1 : 0) == 1 ? this.translateNonSynchronising(systemDDs3.synchs[n], systemDDs2.synchs[n], systemDDs3.id, systemDDs2.id) : this.translateSynchronising(systemDDs3.synchs[n], systemDDs2.synchs[n]);
            }
            systemDDs.id = JDD.Apply(3, systemDDs3.id, systemDDs2.id);
            systemDDs.allSynchs.addAll(systemDDs3.allSynchs);
            systemDDs.allSynchs.addAll(systemDDs2.allSynchs);
        }
        return systemDDs;
    }

    private SystemDDs translateSystemInterleaved(SystemInterleaved systemInterleaved, int[] nArray) throws PrismException {
        SystemDDs systemDDs = this.translateSystemDefnRec(systemInterleaved.getOperand(0), nArray);
        for (int i = 1; i < systemInterleaved.getNumOperands(); ++i) {
            SystemDDs systemDDs2 = this.translateSystemDefnRec(systemInterleaved.getOperand(i), nArray);
            SystemDDs systemDDs3 = systemDDs;
            systemDDs = new SystemDDs(this.numSynchs);
            systemDDs.ind = this.translateNonSynchronising(systemDDs3.ind, systemDDs2.ind, systemDDs3.id, systemDDs2.id);
            for (int j = 0; j < this.numSynchs; ++j) {
                systemDDs.synchs[j] = this.translateNonSynchronising(systemDDs3.synchs[j], systemDDs2.synchs[j], systemDDs3.id, systemDDs2.id);
            }
            systemDDs.id = JDD.Apply(3, systemDDs3.id, systemDDs2.id);
            systemDDs.allSynchs.addAll(systemDDs3.allSynchs);
            systemDDs.allSynchs.addAll(systemDDs2.allSynchs);
        }
        return systemDDs;
    }

    private SystemDDs translateSystemParallel(SystemParallel systemParallel, int[] nArray) throws PrismException {
        int n;
        boolean[] blArray = new boolean[this.numSynchs];
        for (n = 0; n < this.numSynchs; ++n) {
            blArray[n] = systemParallel.containsAction(this.synchs.get(n));
        }
        SystemDDs systemDDs = this.translateSystemDefnRec(systemParallel.getOperand1(), nArray);
        int[] nArray2 = new int[this.numSynchs];
        for (n = 0; n < this.numSynchs; ++n) {
            nArray2[n] = blArray[n] ? systemDDs.synchs[n].max : nArray[n];
        }
        SystemDDs systemDDs2 = this.translateSystemDefnRec(systemParallel.getOperand2(), nArray2);
        SystemDDs systemDDs3 = new SystemDDs(this.numSynchs);
        systemDDs3.ind = this.translateNonSynchronising(systemDDs.ind, systemDDs2.ind, systemDDs.id, systemDDs2.id);
        for (n = 0; n < this.numSynchs; ++n) {
            systemDDs3.synchs[n] = blArray[n] ? this.translateSynchronising(systemDDs.synchs[n], systemDDs2.synchs[n]) : this.translateNonSynchronising(systemDDs.synchs[n], systemDDs2.synchs[n], systemDDs.id, systemDDs2.id);
        }
        systemDDs3.id = JDD.Apply(3, systemDDs.id, systemDDs2.id);
        systemDDs3.allSynchs.addAll(systemDDs.allSynchs);
        systemDDs3.allSynchs.addAll(systemDDs2.allSynchs);
        return systemDDs3;
    }

    private SystemDDs translateSystemHide(SystemHide systemHide, int[] nArray) throws PrismException {
        int n;
        int[] nArray2 = new int[this.numSynchs];
        for (n = 0; n < this.numSynchs; ++n) {
            nArray2[n] = systemHide.containsAction(this.synchs.get(n)) ? 0 : nArray[n];
        }
        SystemDDs systemDDs = this.translateSystemDefnRec(systemHide.getOperand(), nArray2);
        SystemDDs systemDDs2 = new SystemDDs(this.numSynchs);
        systemDDs2.ind = systemDDs.ind;
        for (n = 0; n < this.numSynchs; ++n) {
            if (systemHide.containsAction(this.synchs.get(n))) {
                systemDDs2.ind = this.combineComponentDDs(systemDDs2.ind, systemDDs.synchs[n]);
                systemDDs2.synchs[n] = new ComponentDDs();
                systemDDs2.synchs[n].guards = JDD.Constant(0.0);
                systemDDs2.synchs[n].trans = JDD.Constant(0.0);
                systemDDs2.synchs[n].min = 0;
                systemDDs2.synchs[n].max = 0;
                continue;
            }
            systemDDs2.synchs[n] = systemDDs.synchs[n];
        }
        systemDDs2.id = systemDDs.id;
        systemDDs2.allSynchs.addAll(systemDDs.allSynchs);
        for (n = 0; n < systemHide.getNumActions(); ++n) {
            systemDDs2.allSynchs.remove(systemHide.getAction(n));
        }
        return systemDDs2;
    }

    private SystemDDs translateSystemRename(SystemRename systemRename, int[] nArray) throws PrismException {
        int n;
        String string;
        int n2;
        int[] nArray2 = new int[this.numSynchs];
        for (n2 = 0; n2 < this.numSynchs; ++n2) {
            string = systemRename.getNewName(this.synchs.get(n2));
            n = this.synchs.indexOf(string);
            if (n == -1) {
                throw new PrismLangException("Invalid action name \"" + string + "\" in renaming", systemRename);
            }
            nArray2[n2] = nArray[n];
        }
        SystemDDs systemDDs = this.translateSystemDefnRec(systemRename.getOperand(), nArray2);
        SystemDDs systemDDs2 = new SystemDDs(this.numSynchs);
        systemDDs2.ind = systemDDs.ind;
        for (n2 = 0; n2 < this.numSynchs; ++n2) {
            systemDDs2.synchs[n2] = new ComponentDDs();
            systemDDs2.synchs[n2].guards = JDD.Constant(0.0);
            systemDDs2.synchs[n2].trans = JDD.Constant(0.0);
            systemDDs2.synchs[n2].min = 0;
            systemDDs2.synchs[n2].max = 0;
        }
        for (n2 = 0; n2 < this.numSynchs; ++n2) {
            string = systemRename.getNewName(this.synchs.get(n2));
            n = this.synchs.indexOf(string);
            if (n == -1) {
                throw new PrismLangException("Invalid action name \"" + string + "\" in renaming", systemRename);
            }
            systemDDs2.synchs[n] = this.combineComponentDDs(systemDDs2.synchs[n], systemDDs.synchs[n2]);
        }
        systemDDs2.id = systemDDs.id;
        Iterator<String> iterator = systemDDs.allSynchs.iterator();
        while (iterator.hasNext()) {
            systemDDs2.allSynchs.add(systemRename.getNewName(iterator.next()));
        }
        return systemDDs2;
    }

    private ComponentDDs translateSynchronising(ComponentDDs componentDDs, ComponentDDs componentDDs2) throws PrismException {
        ComponentDDs componentDDs3 = new ComponentDDs();
        JDD.Ref(componentDDs.guards);
        JDD.Ref(componentDDs2.guards);
        componentDDs3.guards = JDD.And(componentDDs.guards, componentDDs2.guards);
        JDD.Ref(componentDDs.trans);
        JDD.Ref(componentDDs2.trans);
        componentDDs3.trans = JDD.Apply(3, componentDDs.trans, componentDDs2.trans);
        componentDDs3.min = componentDDs.min < componentDDs2.min ? componentDDs.min : componentDDs2.min;
        componentDDs3.max = componentDDs.max > componentDDs2.max ? componentDDs.max : componentDDs2.max;
        JDD.Deref(componentDDs.guards);
        JDD.Deref(componentDDs2.guards);
        JDD.Deref(componentDDs.trans);
        JDD.Deref(componentDDs2.trans);
        return componentDDs3;
    }

    private ComponentDDs translateNonSynchronising(ComponentDDs componentDDs, ComponentDDs componentDDs2, JDDNode jDDNode, JDDNode jDDNode2) throws PrismException {
        JDD.Ref(jDDNode2);
        componentDDs.trans = JDD.Apply(3, componentDDs.trans, jDDNode2);
        JDD.Ref(jDDNode);
        componentDDs2.trans = JDD.Apply(3, componentDDs2.trans, jDDNode);
        ComponentDDs componentDDs3 = this.combineComponentDDs(componentDDs, componentDDs2);
        return componentDDs3;
    }

    private ComponentDDs combineComponentDDs(ComponentDDs componentDDs, ComponentDDs componentDDs2) throws PrismException {
        ComponentDDs componentDDs3 = new ComponentDDs();
        if (this.modelType != ModelType.MDP && this.modelType != ModelType.SMG) {
            componentDDs3.guards = JDD.Or(componentDDs.guards, componentDDs2.guards);
            componentDDs3.trans = JDD.Apply(1, componentDDs.trans, componentDDs2.trans);
            componentDDs3.min = 0;
            componentDDs3.max = 0;
        } else if (componentDDs.trans.equals(JDD.ZERO)) {
            JDD.Deref(componentDDs.guards);
            componentDDs3.guards = componentDDs2.guards;
            JDD.Deref(componentDDs.trans);
            componentDDs3.trans = componentDDs2.trans;
            componentDDs3.min = componentDDs2.min;
            componentDDs3.max = componentDDs2.max;
        } else if (componentDDs2.trans.equals(JDD.ZERO)) {
            JDD.Deref(componentDDs2.guards);
            componentDDs3.guards = componentDDs.guards;
            JDD.Deref(componentDDs2.trans);
            componentDDs3.trans = componentDDs.trans;
            componentDDs3.min = componentDDs.min;
            componentDDs3.max = componentDDs.max;
        } else {
            JDDNode jDDNode;
            if (componentDDs.max > componentDDs2.max) {
                JDDNode jDDNode2 = JDD.Constant(1.0);
                for (int i = componentDDs2.max; i < componentDDs.max; ++i) {
                    jDDNode = this.ddChoiceVars[this.ddChoiceVars.length - i - 1];
                    JDD.Ref(jDDNode);
                    jDDNode2 = JDD.And(jDDNode2, JDD.Not(jDDNode));
                }
                componentDDs2.trans = JDD.Apply(3, componentDDs2.trans, jDDNode2);
                componentDDs2.max = componentDDs.max;
            } else if (componentDDs2.max > componentDDs.max) {
                JDDNode jDDNode3 = JDD.Constant(1.0);
                for (int i = componentDDs.max; i < componentDDs2.max; ++i) {
                    jDDNode = this.ddChoiceVars[this.ddChoiceVars.length - i - 1];
                    JDD.Ref(jDDNode);
                    jDDNode3 = JDD.And(jDDNode3, JDD.Not(jDDNode));
                }
                componentDDs.trans = JDD.Apply(3, componentDDs.trans, jDDNode3);
                componentDDs.max = componentDDs2.max;
            }
            if (this.ddChoiceVars.length - componentDDs.max - 1 < 0) {
                throw new PrismException("Insufficient BDD variables allocated for nondeterminism - please report this as a bug. Thank you");
            }
            jDDNode = this.ddChoiceVars[this.ddChoiceVars.length - componentDDs.max - 1];
            componentDDs3.guards = JDD.Or(componentDDs.guards, componentDDs2.guards);
            JDD.Ref(jDDNode);
            componentDDs3.trans = JDD.ITE(jDDNode, componentDDs2.trans, componentDDs.trans);
            componentDDs3.min = componentDDs.min;
            componentDDs3.max = componentDDs.max + 1;
        }
        return componentDDs3;
    }

    private ComponentDDs translateModule(int n, Module module, String string, int n2) throws PrismException {
        ComponentDDs componentDDs;
        int n3 = module.getNumCommands();
        CommandDDs[] commandDDsArray = new CommandDDs[n3];
        for (int i = 0; i < n3; ++i) {
            Command command = module.getCommand(i);
            boolean bl = false;
            if (string == "") {
                if (command.getSynch() == "") {
                    bl = true;
                }
            } else if (command.getSynch().equals(string)) {
                bl = true;
            }
            commandDDsArray[i] = bl ? this.translateCommand(n, module, i, command) : new CommandDDs();
        }
        if (this.modelType == ModelType.DTMC) {
            componentDDs = this.combineCommandsProb(n, commandDDsArray);
        } else if (this.modelType == ModelType.MDP || this.modelType == ModelType.SMG) {
            componentDDs = this.combineCommandsNondet(n, commandDDsArray, n2);
        } else if (this.modelType == ModelType.CTMC) {
            componentDDs = this.combineCommandsStoch(n, commandDDsArray);
        } else {
            throw new PrismException("Unknown model type");
        }
        for (CommandDDs commandDDs : commandDDsArray) {
            commandDDs.clear();
        }
        return componentDDs;
    }

    private CommandDDs translateCommand(int n, Module module, int n2, Command command) throws PrismException {
        JDDNode jDDNode = null;
        JDDNode jDDNode2 = this.translateExpression(command.getGuard());
        jDDNode2 = JDD.Times(jDDNode2, this.range.copy());
        if (this.modelType == ModelType.SMG) {
            int n3 = command.getSynch().isEmpty() ? this.modulesFile.getPlayerForModule(command.getParent().getName()) : this.modulesFile.getPlayerForAction(command.getSynch());
            if (n3 != -1) {
                jDDNode2 = JDD.Apply(3, jDDNode2, this.ddPlayerVars[n3].copy());
            } else {
                for (int i = 0; i < this.numPlayers; ++i) {
                    jDDNode2 = JDD.Apply(3, jDDNode2, JDD.Not(this.ddPlayerVars[i].copy()));
                }
            }
        }
        if (jDDNode2.equals(JDD.ZERO)) {
            if (!Expression.isFalse(command.getGuard())) {
                String string = "Guard for command " + (n2 + 1) + " of module \"" + module.getName() + "\" is never satisfied.";
                this.mainLog.printWarning(string);
            }
            jDDNode = JDD.Constant(0.0);
        } else {
            UpdateDDs updateDDs = null;
            try {
                updateDDs = this.translateUpdates(n, n2, command.getUpdates(), command.getSynch() != "", jDDNode2);
                updateDDs.up = JDD.Times(updateDDs.up, jDDNode2.copy());
                jDDNode = updateDDs.up.copy();
                this.checkCommandProbRates(n, module, n2, command, jDDNode2, jDDNode);
            }
            catch (Throwable throwable) {
                JDD.DerefNonNull(jDDNode2, jDDNode);
                throw throwable;
            }
            finally {
                if (updateDDs != null) {
                    updateDDs.clear();
                }
            }
        }
        return new CommandDDs(jDDNode2, jDDNode);
    }

    private void checkCommandProbRates(int n, Module module, int n2, Command command, JDDNode jDDNode, JDDNode jDDNode2) throws PrismLangException {
        double d = JDD.FindMin(jDDNode2);
        if (d < 0.0) {
            Object object = this.modelType == ModelType.CTMC ? "Rates" : "Probabilities";
            object = (String)object + " in command " + (n2 + 1) + " of module \"" + module.getName() + "\" are negative";
            object = (String)object + " (" + d + ") for some states.\n";
            object = (String)object + "Perhaps the guard needs to be strengthened";
            throw new PrismLangException((String)object, command);
        }
        if (this.prism.getDoProbChecks()) {
            JDDNode jDDNode3 = JDD.SumAbstract(jDDNode2.copy(), this.moduleDDColVars[n]);
            jDDNode3 = JDD.SumAbstract(jDDNode3, this.globalDDColVars);
            jDDNode3 = JDD.ITE(jDDNode.copy(), jDDNode3, JDD.Constant(1.0));
            d = JDD.FindMin(jDDNode3);
            double d2 = JDD.FindMax(jDDNode3);
            if (Double.isNaN(d) || Double.isNaN(d2)) {
                JDD.Deref(jDDNode3);
                Object object = this.modelType == ModelType.CTMC ? "Rates" : "Probabilities";
                object = (String)object + " in command " + (n2 + 1) + " of module \"" + module.getName() + "\" have errors (NaN) for some states. ";
                object = (String)object + "Check for zeros in divide or modulo operations. ";
                object = (String)object + "Perhaps the guard needs to be strengthened";
                throw new PrismLangException((String)object, command);
            }
            if (this.modelType != ModelType.CTMC && !PrismUtils.doublesAreEqual(d, 1.0)) {
                JDD.Deref(jDDNode3);
                String string = "Probabilities in command " + (n2 + 1) + " of module \"" + module.getName() + "\" sum to less than one";
                string = string + " (e.g. " + d + ") for some states. ";
                string = string + "Perhaps some of the updates give out-of-range values. ";
                string = string + "One possible solution is to strengthen the guard";
                throw new PrismLangException(string, command);
            }
            if (this.modelType == ModelType.CTMC && d <= 0.0) {
                JDD.Deref(jDDNode3);
                String string = "Rates in command " + (n2 + 1) + " of module \"" + module.getName() + "\" sum to zero for some states. ";
                string = string + "Perhaps some of the updates give out-of-range values. ";
                string = string + "One possible solution is to strengthen the guard";
                throw new PrismLangException(string, command);
            }
            if (this.modelType != ModelType.CTMC && !PrismUtils.doublesAreEqual(d2, 1.0)) {
                JDD.Deref(jDDNode3);
                String string = "Probabilities in command " + (n2 + 1) + " of module \"" + module.getName() + "\" sum to more than one";
                string = string + " (e.g. " + d2 + ") for some states. ";
                string = string + "Perhaps the guard needs to be strengthened";
                throw new PrismLangException(string, command);
            }
            if (this.modelType == ModelType.CTMC && Double.isInfinite(d2)) {
                JDD.Deref(jDDNode3);
                String string = "Rates in command " + (n2 + 1) + " of module \"" + module.getName() + "\" sum to infinity for some states. ";
                string = string + "Perhaps the guard needs to be strengthened";
                throw new PrismLangException(string, command);
            }
            JDD.Deref(jDDNode3);
        }
    }

    private ComponentDDs combineCommandsProb(int n, CommandDDs[] commandDDsArray) {
        ComponentDDs componentDDs = new ComponentDDs();
        JDDNode jDDNode = JDD.Constant(0.0);
        JDDNode jDDNode2 = JDD.Constant(0.0);
        int n2 = commandDDsArray.length;
        for (int i = 0; i < n2; ++i) {
            JDDNode jDDNode3 = commandDDsArray[i].guard;
            JDDNode jDDNode4 = commandDDsArray[i].up;
            if (jDDNode3.equals(JDD.ZERO)) continue;
            JDDNode jDDNode5 = JDD.And(jDDNode3.copy(), jDDNode2.copy());
            if (!jDDNode5.equals(JDD.ZERO)) {
                this.mainLog.printWarning("Guard for command " + (i + 1) + " of module \"" + this.moduleNames[n] + "\" overlaps with previous commands.");
            }
            JDD.Deref(jDDNode5);
            jDDNode2 = JDD.Or(jDDNode2, jDDNode3.copy());
            jDDNode = JDD.Plus(jDDNode, JDD.Times(jDDNode3.copy(), jDDNode4.copy()));
        }
        componentDDs.guards = jDDNode2;
        componentDDs.trans = jDDNode;
        componentDDs.min = 0;
        componentDDs.max = 0;
        return componentDDs;
    }

    private ComponentDDs combineCommandsStoch(int n, CommandDDs[] commandDDsArray) {
        ComponentDDs componentDDs = new ComponentDDs();
        JDDNode jDDNode = JDD.Constant(0.0);
        JDDNode jDDNode2 = JDD.Constant(0.0);
        int n2 = commandDDsArray.length;
        for (int i = 0; i < n2; ++i) {
            JDDNode jDDNode3 = commandDDsArray[i].guard;
            JDDNode jDDNode4 = commandDDsArray[i].up;
            if (jDDNode3.equals(JDD.ZERO)) continue;
            jDDNode2 = JDD.Or(jDDNode2, jDDNode3.copy());
            jDDNode = JDD.Plus(jDDNode, JDD.Times(jDDNode3.copy(), jDDNode4.copy()));
        }
        componentDDs.guards = jDDNode2;
        componentDDs.trans = jDDNode;
        componentDDs.min = 0;
        componentDDs.max = 0;
        return componentDDs;
    }

    private ComponentDDs combineCommandsNondet(int n, CommandDDs[] commandDDsArray, int n2) throws PrismException {
        JDDNode jDDNode;
        int n3;
        ComponentDDs componentDDs = new ComponentDDs();
        JDDNode jDDNode2 = JDD.Constant(0.0);
        JDDNode jDDNode3 = JDD.Constant(0.0);
        int n4 = commandDDsArray.length;
        JDDNode jDDNode4 = JDD.Constant(0.0);
        for (n3 = 0; n3 < n4; ++n3) {
            jDDNode = commandDDsArray[n3].guard;
            jDDNode4 = JDD.Plus(jDDNode4, jDDNode.copy());
            jDDNode3 = JDD.Or(jDDNode3, jDDNode.copy());
        }
        int n5 = (int)Math.round(JDD.FindMax(jDDNode4));
        if (n5 == 0) {
            componentDDs.guards = jDDNode3;
            componentDDs.trans = jDDNode2;
            componentDDs.min = n2;
            componentDDs.max = n2;
            JDD.Deref(jDDNode4);
            return componentDDs;
        }
        if (n5 == 1) {
            for (n3 = 0; n3 < n4; ++n3) {
                jDDNode = commandDDsArray[n3].guard;
                JDDNode jDDNode5 = commandDDsArray[n3].up;
                jDDNode2 = JDD.Plus(jDDNode2, JDD.Times(jDDNode.copy(), jDDNode5.copy()));
            }
            componentDDs.guards = jDDNode3;
            componentDDs.trans = jDDNode2;
            componentDDs.min = n2;
            componentDDs.max = n2;
            JDD.Deref(jDDNode4);
            return componentDDs;
        }
        int n6 = (int)Math.ceil(PrismUtils.log2(n5));
        JDDVars jDDVars = new JDDVars();
        for (n3 = 0; n3 < n6; ++n3) {
            if (this.ddChoiceVars.length - n2 - n6 + n3 < 0) {
                throw new PrismException("Insufficient BDD variables allocated for nondeterminism - please report this as a bug. Thank you.");
            }
            jDDVars.addVar(this.ddChoiceVars[this.ddChoiceVars.length - n2 - n6 + n3]);
        }
        for (n3 = 1; n3 <= n5; ++n3) {
            JDDNode jDDNode6;
            int n7;
            JDDNode jDDNode7 = JDD.Equals(jDDNode4.copy(), n3);
            if (jDDNode7.equals(JDD.ZERO)) {
                JDD.Deref(jDDNode7);
                continue;
            }
            JDDNode[] jDDNodeArray = new JDDNode[n3];
            JDDNode[] jDDNodeArray2 = new JDDNode[n3];
            for (n7 = 0; n7 < n3; ++n7) {
                jDDNodeArray[n7] = JDD.Constant(0.0);
                jDDNodeArray2[n7] = jDDNode7.copy();
            }
            for (n7 = 0; n7 < n4; ++n7) {
                jDDNode = commandDDsArray[n7].guard;
                JDDNode jDDNode8 = commandDDsArray[n7].up;
                jDDNode6 = JDD.And(jDDNode.copy(), jDDNode7.copy());
                if (!jDDNode6.equals(JDD.ZERO)) {
                    JDDNode jDDNode9 = jDDNode6.copy();
                    for (int i = 0; i < n3; ++i) {
                        JDDNode jDDNode10 = JDD.And(jDDNode9.copy(), jDDNodeArray2[i].copy());
                        if (!jDDNode10.equals(JDD.ZERO)) {
                            jDDNodeArray2[i] = JDD.And(jDDNodeArray2[i], JDD.Not(jDDNode10.copy()));
                            jDDNodeArray[i] = JDD.Plus(jDDNodeArray[i], JDD.Times(jDDNode10.copy(), jDDNode8.copy()));
                        }
                        if ((jDDNode9 = JDD.And(jDDNode9, JDD.Not(jDDNode10))).equals(JDD.ZERO)) break;
                    }
                    JDD.Deref(jDDNode9);
                }
                JDD.Deref(jDDNode6);
            }
            for (n7 = 0; n7 < n3; ++n7) {
                jDDNode6 = JDD.SetVectorElement(JDD.Constant(0.0), jDDVars, n7, 1.0);
                jDDNode2 = JDD.Plus(jDDNode2, JDD.Times(jDDNode6, jDDNodeArray[n7]));
                JDD.Deref(jDDNodeArray2[n7]);
            }
            jDDNode4 = JDD.Times(jDDNode4, JDD.Not(jDDNode7));
        }
        JDD.Deref(jDDNode4);
        componentDDs.guards = jDDNode3;
        componentDDs.trans = jDDNode2;
        componentDDs.min = n2;
        componentDDs.max = n2 + n6;
        return componentDDs;
    }

    private UpdateDDs translateUpdates(int n, int n2, Updates updates, boolean bl, JDDNode jDDNode) throws PrismException {
        JDDNode jDDNode2 = null;
        JDDNode jDDNode3 = JDD.Constant(0.0);
        int n3 = updates.getNumUpdates();
        for (int i = 0; i < n3; ++i) {
            Expression expression;
            String string;
            JDDNode jDDNode4;
            try {
                UpdateDDs updateDDs = this.translateUpdate(n, updates.getUpdate(i), bl, jDDNode);
                jDDNode4 = updateDDs.up;
            }
            catch (Exception | StackOverflowError throwable) {
                JDD.Deref(jDDNode3);
                throw throwable;
            }
            boolean bl2 = false;
            if (jDDNode4.equals(JDD.ZERO)) {
                bl2 = true;
                string = "Update " + (i + 1) + " of command " + (n2 + 1);
                string = string + " of module \"" + this.moduleNames[n] + "\" doesn't do anything";
                this.mainLog.printWarning(new PrismLangException(string, updates.getUpdate(i)).getMessage());
            }
            if ((expression = updates.getProbability(i)) == null) {
                expression = Expression.Double(1.0);
            }
            try {
                jDDNode2 = this.translateExpression(expression);
            }
            catch (Exception | StackOverflowError throwable) {
                JDD.Deref(jDDNode3, jDDNode4);
                JDD.DerefNonNull(jDDNode2);
                throw throwable;
            }
            jDDNode4 = JDD.Times(jDDNode4, jDDNode2);
            if (!bl2 && jDDNode4.equals(JDD.ZERO)) {
                string = "Update " + (i + 1) + " of command " + (n2 + 1);
                string = string + " of module \"" + this.moduleNames[n] + "\" doesn't do anything";
                this.mainLog.printWarning(new PrismLangException(string, updates.getUpdate(i)).getMessage());
            }
            jDDNode3 = JDD.Plus(jDDNode3, jDDNode4);
        }
        return new UpdateDDs(jDDNode3);
    }

    private UpdateDDs translateUpdate(int n, Update update, boolean bl, JDDNode jDDNode) throws PrismException {
        int n2;
        for (int i = 0; i < this.numVars; ++i) {
            this.varsUsed[i] = false;
        }
        JDDNode jDDNode2 = JDD.Constant(1.0);
        int n3 = update.getNumElements();
        for (n2 = 0; n2 < n3; ++n2) {
            try {
                UpdateDDs updateDDs = this.translateUpdateElement(n, update, n2, bl, jDDNode);
                jDDNode2 = JDD.Times(jDDNode2, updateDDs.up);
                continue;
            }
            catch (Exception | StackOverflowError throwable) {
                JDD.Deref(jDDNode2);
                throw throwable;
            }
        }
        for (n2 = 0; n2 < this.numVars; ++n2) {
            if (this.varList.getModule(n2) != n && this.varList.getModule(n2) != -1 || this.varsUsed[n2]) continue;
            jDDNode2 = JDD.Times(jDDNode2, this.varIdentities[n2].copy());
        }
        return new UpdateDDs(jDDNode2);
    }

    private UpdateDDs translateUpdateElement(int n, Update update, int n2, boolean bl, JDDNode jDDNode) throws PrismException {
        String string = update.getVar(n2);
        int n3 = this.varList.getIndex(string);
        if (n3 == -1) {
            throw new PrismLangException("Unknown variable \"" + string + "\" in update", update.getVarIdent(n2));
        }
        this.varsUsed[n3] = true;
        if (this.varList.getModule(n3) != -1 && this.varList.getModule(n3) != n) {
            throw new PrismLangException("Cannot modify variable \"" + string + "\" from module \"" + this.moduleNames[n] + "\"", update.getVarIdent(n2));
        }
        int n4 = this.varList.getLow(n3);
        int n5 = this.varList.getHigh(n3);
        JDDNode jDDNode2 = JDD.Constant(0.0);
        for (int i = n4; i <= n5; ++i) {
            jDDNode2 = JDD.SetVectorElement(jDDNode2, this.varDDColVars[n3], i - n4, i);
        }
        JDDNode jDDNode3 = this.translateExpression(update.getExpression(n2));
        jDDNode3 = JDD.Times(jDDNode3, jDDNode.copy());
        JDDNode jDDNode4 = JDD.Apply(7, jDDNode2, jDDNode3);
        jDDNode4 = JDD.Times(jDDNode4, jDDNode.copy());
        jDDNode4 = JDD.Times(jDDNode4, this.varColRangeDDs[n3].copy());
        jDDNode4 = JDD.Times(jDDNode4, this.range.copy());
        return new UpdateDDs(jDDNode4);
    }

    private JDDNode translateExpression(Expression expression) throws PrismException {
        return this.expr2mtbdd.checkExpressionDD(expression, JDD.ONE.copy());
    }

    private void buildDDGame() throws PrismException {
        int n;
        int n2;
        this.ddPlayerCubes = new JDDNode[this.numPlayers];
        for (int i = 0; i < this.numPlayers; ++i) {
            this.ddPlayerCubes[i] = this.ddPlayerVars[i].copy();
            for (int j = 0; j < this.numPlayers; ++j) {
                if (i == j) continue;
                this.ddPlayerCubes[i] = JDD.And(this.ddPlayerCubes[i], JDD.Not(this.ddPlayerVars[j].copy()));
            }
        }
        JDDNode[] jDDNodeArray = new JDDNode[this.numPlayers];
        JDDNode[] jDDNodeArray2 = new JDDNode[this.numPlayers];
        for (int i = 0; i < this.numPlayers; ++i) {
            jDDNodeArray[i] = JDD.Restrict(this.trans.copy(), this.ddPlayerCubes[i].copy());
            jDDNodeArray2[i] = JDD.GreaterThan(jDDNodeArray[i].copy(), 0.0);
            jDDNodeArray2[i] = JDD.ThereExists(JDD.ThereExists(jDDNodeArray2[i], this.allDDNondetVars), this.allDDColVars);
        }
        JDDNode jDDNode = JDD.Constant(1.0);
        for (int i = 0; i < this.numPlayers; ++i) {
            jDDNode = JDD.And(jDDNode, JDD.Not(this.ddPlayerVars[i].copy()));
        }
        JDDNode jDDNode2 = JDD.Restrict(this.trans.copy(), jDDNode.copy());
        JDDNode jDDNode3 = JDD.GreaterThan(jDDNode2.copy(), 0.0);
        jDDNode3 = JDD.ThereExists(JDD.ThereExists(jDDNode3, this.allDDNondetVars), this.allDDColVars);
        JDDNode[][] jDDNodeArray3 = new JDDNode[this.numRewardStructs][this.numPlayers];
        JDDNode[] jDDNodeArray4 = new JDDNode[this.numRewardStructs];
        for (int i = 0; i < this.numRewardStructs; ++i) {
            jDDNodeArray3[i] = new JDDNode[this.numPlayers];
            for (n2 = 0; n2 < this.numPlayers; ++n2) {
                jDDNodeArray3[i][n2] = JDD.Restrict(this.transRewards[i].copy(), this.ddPlayerCubes[n2].copy());
            }
            jDDNodeArray4[i] = JDD.Restrict(this.transRewards[i].copy(), jDDNode.copy());
        }
        JDDNode jDDNode4 = JDD.Constant(0.0);
        for (n2 = 0; n2 < this.numPlayers; ++n2) {
            jDDNode4 = JDD.Plus(jDDNode4, jDDNodeArray2[n2].copy());
        }
        jDDNode4 = JDD.GreaterThan(jDDNode4, 1.0);
        JDD.Deref(jDDNode4);
        for (n2 = 0; n2 < this.numPlayers; ++n2) {
            jDDNodeArray[n2] = JDD.Plus(jDDNodeArray[n2], JDD.Times(jDDNode2.copy(), jDDNodeArray2[n2].copy()));
            jDDNode2 = JDD.Times(jDDNode2, JDD.Not(jDDNodeArray2[n2].copy()));
            for (n = 0; n < this.numRewardStructs; ++n) {
                jDDNodeArray3[n][n2] = JDD.Plus(jDDNodeArray3[n][n2], JDD.Times(jDDNodeArray4[n].copy(), jDDNodeArray2[n2].copy()));
                jDDNodeArray4[n] = JDD.Times(jDDNodeArray4[n], JDD.Not(jDDNodeArray2[n2].copy()));
            }
        }
        jDDNodeArray[0] = JDD.Plus(jDDNodeArray[0], jDDNode2.copy());
        for (n2 = 0; n2 < this.numRewardStructs; ++n2) {
            jDDNodeArray3[n2][0] = JDD.Plus(jDDNodeArray3[n2][0], jDDNodeArray4[n2].copy());
        }
        JDD.Deref(jDDNodeArray2[0]);
        jDDNodeArray2[0] = JDD.GreaterThan(jDDNodeArray[0].copy(), 0.0);
        jDDNodeArray2[0] = JDD.ThereExists(JDD.ThereExists(jDDNodeArray2[0], this.allDDNondetVars), this.allDDColVars);
        JDD.Deref(this.trans);
        this.trans = JDD.Constant(0.0);
        for (n2 = 0; n2 < this.numPlayers; ++n2) {
            this.trans = JDD.Plus(this.trans, JDD.Times(this.ddPlayerCubes[n2].copy(), jDDNodeArray[n2].copy()));
        }
        for (n2 = 0; n2 < this.numRewardStructs; ++n2) {
            JDD.Deref(this.transRewards[n2]);
            this.transRewards[n2] = JDD.Constant(0.0);
            for (n = 0; n < this.numPlayers; ++n) {
                this.transRewards[n2] = JDD.Plus(this.transRewards[n2], JDD.Times(this.ddPlayerCubes[n].copy(), jDDNodeArray3[n2][n].copy()));
            }
        }
        JDD.DerefArray(jDDNodeArray, this.numPlayers);
        JDD.DerefArray(jDDNodeArray2, this.numPlayers);
        JDD.Deref(jDDNode);
        JDD.Deref(jDDNode2);
        JDD.Deref(jDDNode3);
        for (n2 = 0; n2 < this.numRewardStructs; ++n2) {
            JDD.DerefArray(jDDNodeArray3[n2], this.numPlayers);
            JDD.Deref(jDDNodeArray4[n2]);
        }
    }

    private void computeRewards(SystemDDs systemDDs) throws PrismException {
        int n;
        int n2;
        this.numRewardStructs = this.modulesFile.getNumRewardStructs();
        this.stateRewards = new JDDNode[this.numRewardStructs];
        this.transRewards = new JDDNode[this.numRewardStructs];
        for (n2 = 0; n2 < this.numRewardStructs; ++n2) {
            this.stateRewards[n2] = JDD.Constant(0.0);
            systemDDs.ind.rewards[n2] = JDD.Constant(0.0);
            for (n = 0; n < this.numSynchs; ++n) {
                systemDDs.synchs[n].rewards[n2] = JDD.Constant(0.0);
            }
        }
        for (n2 = 0; n2 < this.numRewardStructs; ++n2) {
            RewardStruct rewardStruct = this.modulesFile.getRewardStruct(n2);
            int n3 = rewardStruct.getNumItems();
            for (n = 0; n < n3; ++n) {
                ComponentDDs componentDDs;
                double d;
                double d2;
                JDDNode jDDNode;
                JDDNode jDDNode2 = this.translateExpression(rewardStruct.getStates(n));
                JDDNode jDDNode3 = this.translateExpression(rewardStruct.getReward(n));
                String string = rewardStruct.getSynch(n);
                if (string == null) {
                    jDDNode = JDD.Times(jDDNode2, jDDNode3);
                    d2 = JDD.FindMin(jDDNode);
                    d = JDD.FindMax(jDDNode);
                    if (!Double.isFinite(d2)) {
                        String string2 = "Reward structure item contains non-finite rewards (" + d2 + ").";
                        string2 = string2 + "\nNote that these may correspond to states which are unreachable.";
                        string2 = string2 + "\nIf this is the case, try strengthening the predicate.";
                        throw new PrismLangException(string2, rewardStruct.getRewardStructItem(n));
                    }
                    if (!Double.isFinite(d)) {
                        String string3 = "Reward structure item contains non-finite rewards (" + d + ").";
                        string3 = string3 + "\nNote that these may correspond to states which are unreachable.";
                        string3 = string3 + "\nIf this is the case, try strengthening the predicate.";
                        throw new PrismLangException(string3, rewardStruct.getRewardStructItem(n));
                    }
                    this.stateRewards[n2] = JDD.Plus(this.stateRewards[n2], jDDNode);
                    continue;
                }
                if ("".equals(string)) {
                    componentDDs = systemDDs.ind;
                } else {
                    int n4 = this.synchs.indexOf(string);
                    if (n4 != -1) {
                        componentDDs = systemDDs.synchs[n4];
                    } else {
                        throw new PrismLangException("Invalid action name \"" + string + "\" in reward structure item", rewardStruct.getRewardStructItem(n));
                    }
                }
                jDDNode = this.modelType == ModelType.MDP || this.modelType == ModelType.SMG ? JDD.GreaterThan(componentDDs.trans.copy(), 0.0) : componentDDs.trans.copy();
                jDDNode = JDD.Times(jDDNode, jDDNode2);
                jDDNode = JDD.Times(jDDNode, jDDNode3);
                d2 = JDD.FindMin(jDDNode);
                d = JDD.FindMax(jDDNode);
                if (!Double.isFinite(d2)) {
                    String string4 = "Reward structure item contains non-finite rewards (" + d2 + ").";
                    string4 = string4 + "\nNote that these may correspond to states which are unreachable.";
                    string4 = string4 + "\nIf this is the case, try strengthening the predicate.";
                    throw new PrismLangException(string4, rewardStruct.getRewardStructItem(n));
                }
                if (!Double.isFinite(d)) {
                    String string5 = "Reward structure item contains non-finite rewards (" + d + ").";
                    string5 = string5 + "\nNote that these may correspond to states which are unreachable.";
                    string5 = string5 + "\nIf this is the case, try strengthening the predicate.";
                    throw new PrismLangException(string5, rewardStruct.getRewardStructItem(n));
                }
                componentDDs.rewards[n2] = JDD.Plus(componentDDs.rewards[n2], jDDNode);
            }
        }
    }

    private void buildInitialStates() throws PrismException {
        if (this.modulesFile.getInitialStates() != null) {
            this.start = this.translateExpression(this.modulesFile.getInitialStates());
            JDD.Ref(this.range);
            this.start = JDD.And(this.start, this.range);
            if (this.start.equals(JDD.ZERO)) {
                throw new PrismLangException("No initial states: \"init\" construct evaluates to false", this.modulesFile.getInitialStates());
            }
        } else {
            this.start = JDD.Constant(1.0);
            for (int i = 0; i < this.numVars; ++i) {
                Object object = this.modulesFile.getVarDeclaration(i).getStartOrDefault().evaluate(this.constantValues);
                try {
                    int n = this.varList.encodeToInt(i, object);
                    JDDNode jDDNode = JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[i], n, 1.0);
                    this.start = JDD.And(this.start, jDDNode);
                    continue;
                }
                catch (PrismLangException prismLangException) {
                    prismLangException.setASTElement(this.modulesFile.getVarDeclaration(i).getStart());
                    throw prismLangException;
                }
            }
        }
    }

    private void doSymmetry(ModelSymbolic modelSymbolic) throws PrismException {
        int n;
        int n2;
        String[] stringArray = this.prism.getSettings().getString("prism.symmRedParams").split(" ");
        if (stringArray.length != 2) {
            throw new PrismException("Invalid parameters for symmetry reduction");
        }
        try {
            this.numModulesBeforeSymm = Integer.parseInt(stringArray[0].trim());
            this.numModulesAfterSymm = Integer.parseInt(stringArray[1].trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new PrismException("Invalid parameters for symmetry reduction");
        }
        long l = System.currentTimeMillis();
        JDDNode jDDNode = modelSymbolic.getReach();
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = modelSymbolic.getTrans();
        JDD.Ref(jDDNode2);
        JDDNode[] jDDNodeArray = new JDDNode[this.numRewardStructs];
        for (n2 = 0; n2 < this.numRewardStructs; ++n2) {
            jDDNodeArray[n2] = modelSymbolic.getTransRewards(n2);
            JDD.Ref(jDDNodeArray[n2]);
        }
        this.mainLog.print("\nApplying symmetry reduction...\n");
        this.numSymmModules = this.numModules - (this.numModulesBeforeSymm + this.numModulesAfterSymm);
        this.computeSymmetryFilters(jDDNode);
        this.mainLog.println("\nNumber of states before before symmetry reduction: " + modelSymbolic.getNumStatesString());
        this.mainLog.println("DD sizes before symmetry reduction:");
        this.mainLog.print("trans: ");
        this.mainLog.println(JDD.GetInfoString(jDDNode2, this.modelType == ModelType.MDP ? this.allDDRowVars.n() * 2 + this.allDDNondetVars.n() : this.allDDRowVars.n() * 2));
        JDD.Ref(this.symm);
        jDDNode2 = JDD.Apply(3, jDDNode2, this.symm);
        for (n = 0; n < this.numRewardStructs; ++n) {
            this.mainLog.print("transrew[" + n + "]: ");
            this.mainLog.println(JDD.GetInfoString(jDDNodeArray[n], this.modelType == ModelType.MDP ? this.allDDRowVars.n() * 2 + this.allDDNondetVars.n() : this.allDDRowVars.n() * 2));
            JDD.Ref(this.symm);
            jDDNodeArray[n] = JDD.Apply(3, jDDNodeArray[n], this.symm);
        }
        this.mainLog.println("Starting quicksort...");
        boolean bl = false;
        int n3 = 0;
        for (n2 = this.numSymmModules; n2 > 1 && !bl; --n2) {
            JDD.Ref(jDDNode2);
            JDDNode jDDNode3 = jDDNode2;
            for (int i = 0; i < n2 - 1; ++i) {
                if (this.nonSymms[i].equals(JDD.ZERO)) continue;
                JDD.Ref(jDDNode3);
                JDD.Ref(this.nonSymms[i]);
                JDDNode jDDNode4 = JDD.Apply(3, jDDNode3, JDD.PermuteVariables(this.nonSymms[i], this.allDDRowVars, this.allDDColVars));
                if (jDDNode4.equals(JDD.ZERO)) {
                    JDD.Deref(jDDNode4);
                    continue;
                }
                ++n3;
                this.mainLog.println("Iteration " + (this.numSymmModules - n2 + 1) + "." + (i + 1));
                jDDNode4 = JDD.SwapVariables(jDDNode4, this.moduleDDColVars[this.numModulesBeforeSymm + i], this.moduleDDColVars[this.numModulesBeforeSymm + i + 1]);
                JDD.Ref(this.nonSymms[i]);
                JDD.Ref(jDDNode4);
                jDDNode3 = JDD.ITE(JDD.PermuteVariables(this.nonSymms[i], this.allDDRowVars, this.allDDColVars), JDD.Constant(0.0), JDD.Apply(1, jDDNode3, jDDNode4));
                JDD.Deref(jDDNode4);
                for (n = 0; n < this.numRewardStructs; ++n) {
                    JDD.Ref(jDDNodeArray[n]);
                    JDD.Ref(this.nonSymms[i]);
                    jDDNode4 = JDD.Apply(3, jDDNodeArray[n], JDD.PermuteVariables(this.nonSymms[i], this.allDDRowVars, this.allDDColVars));
                    jDDNode4 = JDD.SwapVariables(jDDNode4, this.moduleDDColVars[this.numModulesBeforeSymm + i], this.moduleDDColVars[this.numModulesBeforeSymm + i + 1]);
                    JDD.Ref(this.nonSymms[i]);
                    JDD.Ref(jDDNode4);
                    jDDNodeArray[n] = JDD.ITE(JDD.PermuteVariables(this.nonSymms[i], this.allDDRowVars, this.allDDColVars), JDD.Constant(0.0), JDD.Apply(1, jDDNodeArray[n], jDDNode4));
                    JDD.Deref(jDDNode4);
                }
            }
            if (jDDNode3.equals(jDDNode2)) {
                bl = true;
            }
            JDD.Deref(jDDNode2);
            jDDNode2 = jDDNode3;
        }
        modelSymbolic.resetTrans(jDDNode2);
        for (n2 = 0; n2 < this.numRewardStructs; ++n2) {
            modelSymbolic.resetTransRewards(n2, jDDNodeArray[n2]);
        }
        JDD.Ref(this.symm);
        jDDNode = JDD.And(jDDNode, this.symm);
        modelSymbolic.setReach(jDDNode);
        modelSymbolic.filterReachableStates();
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Symmetry complete: " + (this.numSymmModules - n2) + " iterations, " + n3 + " swaps, " + (double)l / 1000.0 + " seconds");
    }

    private void computeSymmetryFilters(JDDNode jDDNode) throws PrismException {
        this.nonSymms = new JDDNode[this.numSymmModules - 1];
        JDD.Ref(jDDNode);
        this.symm = jDDNode;
        for (int i = 0; i < this.numSymmModules - 1; ++i) {
            JDDNode jDDNode2 = JDD.VariablesLessThanEquals(this.moduleDDRowVars[this.numModulesBeforeSymm + i], this.moduleDDRowVars[this.numModulesBeforeSymm + i + 1]);
            JDD.Ref(jDDNode2);
            JDD.Ref(jDDNode);
            this.nonSymms[i] = JDD.And(JDD.Not(jDDNode2), jDDNode);
            this.symm = JDD.And(this.symm, jDDNode2);
        }
    }

    private static class SystemDDs {
        public ComponentDDs ind;
        public ComponentDDs[] synchs;
        public JDDNode id;
        public HashSet<String> allSynchs;

        public SystemDDs(int n) {
            this.synchs = new ComponentDDs[n];
            this.allSynchs = new HashSet();
        }
    }

    private class ComponentDDs {
        public JDDNode guards;
        public JDDNode trans;
        public JDDNode[] rewards;
        public int min;
        public int max;

        public ComponentDDs() {
            this.rewards = new JDDNode[Modules2MTBDD.this.modulesFile.getNumRewardStructs()];
        }
    }

    private static class CommandDDs {
        public JDDNode guard;
        public JDDNode up;

        public CommandDDs() {
            this.guard = JDD.Constant(0.0);
            this.up = JDD.Constant(0.0);
        }

        public CommandDDs(JDDNode jDDNode, JDDNode jDDNode2) {
            this.guard = jDDNode;
            this.up = jDDNode2;
        }

        public void clear() {
            JDD.DerefNonNull(this.guard);
            JDD.DerefNonNull(this.up);
        }
    }

    private static class UpdateDDs {
        public JDDNode up;

        public UpdateDDs(JDDNode jDDNode) {
            this.up = jDDNode;
        }

        public void clear() {
            JDD.DerefNonNull(this.up);
        }
    }
}

