/*
 * Decompiled with CFR 0.152.
 */
package symbolic.build;

import io.ExplicitModelImporter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import jdd.JDD;
import jdd.JDDNode;
import jdd.JDDVars;
import parser.VarList;
import parser.ast.DeclarationType;
import prism.Evaluator;
import prism.ModelInfo;
import prism.ModelType;
import prism.Prism;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import prism.ProgressDisplay;
import prism.RewardInfo;
import symbolic.model.Model;
import symbolic.model.ModelSymbolic;
import symbolic.model.ModelVariablesDD;
import symbolic.model.NondetModel;
import symbolic.model.ProbModel;
import symbolic.model.StochModel;

public class ExplicitFiles2MTBDD {
    private Prism prism;
    private PrismLog mainLog;
    private ExplicitModelImporter importer;
    private ModelInfo modelInfo;
    private ModelType modelType;
    private VarList varList;
    private int numVars;
    private int numStates;
    private int[][] statesArray = null;
    private RewardInfo rewardInfo;
    private ModelSymbolic model = null;
    private JDDNode trans;
    private JDDNode start;
    private JDDNode[] stateRewards;
    private JDDNode[] transRewards;
    private JDDVars allDDRowVars;
    private JDDVars allDDColVars;
    private JDDVars allDDNondetVars;
    private JDDVars[] varDDRowVars;
    private JDDVars[] varDDColVars;
    private ModelVariablesDD modelVariables;
    private Vector<String> synchs;
    private JDDNode transActions;
    private Vector<JDDNode> transPerAction;
    private int maxNumChoices = 0;
    private LinkedHashMap<String, JDDNode> labelsDD;
    private JDDNode labelDeadlock;
    private ProgressDisplay progress;
    private int transitionsImported;

    public ExplicitFiles2MTBDD(Prism prism) {
        this.prism = prism;
        this.mainLog = prism.getMainLog();
    }

    public Model build(ExplicitModelImporter explicitModelImporter) throws PrismException {
        this.importer = explicitModelImporter;
        this.modelInfo = explicitModelImporter.getModelInfo();
        this.modelType = this.modelInfo.getModelType();
        this.varList = this.modelInfo.createVarList();
        this.numVars = this.varList.getNumVars();
        this.numStates = explicitModelImporter.getNumStates();
        this.modelVariables = new ModelVariablesDD();
        this.rewardInfo = explicitModelImporter.getRewardInfo();
        if (explicitModelImporter.modelIsExact()) {
            throw new PrismException("Cannot import an exact model unless in exact mode");
        }
        switch (this.modelType) {
            case DTMC: 
            case CTMC: 
            case MDP: {
                break;
            }
            default: {
                throw new PrismNotSupportedException("Symbolic engine does not support import of " + String.valueOf((Object)this.modelType) + "s");
            }
        }
        explicitModelImporter.setTransitionRewardIndexing(ExplicitModelImporter.TransitionRewardIndexing.STATE);
        explicitModelImporter.setFixDeadlocks(false);
        if (explicitModelImporter.providesStates()) {
            this.readStatesFromFile();
        }
        return this.buildModel();
    }

    private void readStatesFromFile() throws PrismException {
        this.statesArray = new int[this.numStates][];
        for (int i = 0; i < this.numStates; ++i) {
            this.statesArray[i] = new int[this.numVars];
        }
        this.importer.extractStates((n, n2, object) -> {
            this.statesArray[n][n2] = this.varList.encodeToInt(n2, object);
        });
    }

    private Model buildModel() throws PrismException {
        if (this.modelType == ModelType.MDP) {
            this.maxNumChoices = this.importer.computeMaxNumChoices();
        }
        this.allocateDDVars();
        this.buildTrans();
        if (this.modelType == ModelType.MDP) {
            JDDNode jDDNode = JDD.GetSupport(this.trans);
            jDDNode = JDD.ThereExists(jDDNode, this.allDDRowVars);
            JDDNode jDDNode2 = jDDNode = JDD.ThereExists(jDDNode, this.allDDColVars);
            JDDVars jDDVars = new JDDVars();
            while (!jDDNode2.equals(JDD.ONE)) {
                jDDVars.addVar(JDD.Var(jDDNode2.getIndex()));
                jDDNode2 = jDDNode2.getThen();
            }
            JDD.Deref(jDDNode);
            this.allDDNondetVars.derefAll();
            this.allDDNondetVars = jDDVars;
        }
        this.buildLabelsAndInitialStates();
        boolean bl = true;
        String[] stringArray = new String[]{"M"};
        String[] stringArray2 = this.rewardInfo.getRewardStructNames().toArray(new String[0]);
        if (this.modelType == ModelType.DTMC) {
            this.model = new ProbModel(this.trans, this.start, this.allDDRowVars, this.allDDColVars, this.modelVariables, this.varList, this.varDDRowVars, this.varDDColVars);
        } else if (this.modelType == ModelType.MDP) {
            this.model = new NondetModel(this.trans, this.start, this.allDDRowVars, this.allDDColVars, this.allDDNondetVars, this.modelVariables, this.varList, this.varDDRowVars, this.varDDColVars);
        } else if (this.modelType == ModelType.CTMC) {
            this.model = new StochModel(this.trans, this.start, this.allDDRowVars, this.allDDColVars, this.modelVariables, this.varList, this.varDDRowVars, this.varDDColVars);
        }
        this.model.setConstantValues(this.modelInfo.getConstantValues());
        this.buildStateRewards();
        this.buildTransitionRewards();
        this.model.setRewards(this.stateRewards, this.transRewards, stringArray2);
        this.model.setSynchs(this.synchs);
        if (this.modelType != ModelType.MDP) {
            ((ProbModel)this.model).setTransPerAction(this.transPerAction.toArray(new JDDNode[0]));
        } else {
            ((NondetModel)this.model).setTransActions(this.transActions);
        }
        if (this.prism.getDoReach()) {
            this.mainLog.print("\nComputing reachable states...\n");
            this.model.doReachability();
            this.model.filterReachableStates();
        } else {
            this.mainLog.print("\nSkipping reachable state computation.\n");
            this.model.skipReachability();
            this.model.filterReachableStates();
        }
        if (this.prism.getExtraDDInfo()) {
            this.mainLog.print("Reach: " + JDD.GetNumNodes(this.model.getReach()) + " nodes\n");
        }
        this.model.findDeadlocks(this.prism.getFixDeadlocks());
        this.attachLabels(this.model);
        this.model.addDeadlocks(this.labelDeadlock);
        if (this.labelsDD != null) {
            for (JDDNode jDDNode : this.labelsDD.values()) {
                JDD.Deref(jDDNode);
            }
        }
        return this.model;
    }

    private void allocateDDVars() throws PrismException {
        int n;
        this.modelVariables = new ModelVariablesDD();
        this.modelVariables.preallocateExtraActionVariables(this.prism.getSettings().getInteger("prism.ddExtraActionVars"));
        this.varDDRowVars = new JDDVars[this.numVars];
        this.varDDColVars = new JDDVars[this.numVars];
        for (n = 0; n < this.numVars; ++n) {
            this.varDDRowVars[n] = new JDDVars();
            this.varDDColVars[n] = new JDDVars();
        }
        if (this.modelType == ModelType.MDP) {
            this.allDDNondetVars = new JDDVars();
            for (n = 0; n < this.maxNumChoices; ++n) {
                this.allDDNondetVars.addVar(this.modelVariables.allocateVariable("l" + n));
            }
        }
        this.allDDRowVars = new JDDVars();
        this.allDDColVars = new JDDVars();
        for (n = 0; n < this.numVars; ++n) {
            DeclarationType declarationType = this.varList.getDeclarationType(n);
            if (declarationType.isUnbounded()) {
                throw new PrismNotSupportedException("Cannot build a model that contains a variable with unbounded range (try the explicit engine instead)");
            }
            int n2 = this.varList.getRangeLogTwo(n);
            for (int i = 0; i < n2; ++i) {
                this.varDDRowVars[n].addVar(this.modelVariables.allocateVariable(this.varList.getName(n) + "." + i));
                this.varDDColVars[n].addVar(this.modelVariables.allocateVariable(this.varList.getName(n) + "'." + i));
            }
            this.allDDRowVars.copyVarsFrom(this.varDDRowVars[n]);
            this.allDDColVars.copyVarsFrom(this.varDDColVars[n]);
        }
    }

    private void buildTrans() throws PrismException {
        this.mainLog.print("Importing transitions... ");
        this.progress = new ProgressDisplay(this.mainLog);
        this.progress.start();
        this.progress.setTotalCount(this.importer.getNumTransitions());
        this.transitionsImported = 0;
        this.synchs = new Vector();
        this.trans = JDD.Constant(0.0);
        if (this.modelType != ModelType.MDP) {
            this.transPerAction = new Vector();
            this.transPerAction.add(JDD.Constant(0.0));
        } else {
            this.transActions = JDD.Constant(0.0);
        }
        if (this.modelType != ModelType.MDP) {
            this.importer.extractMCTransitions((n, n2, d, object) -> this.storeMCTransition(n, n2, (double)d, object));
        } else {
            this.importer.extractMDPTransitions((n, n2, n3, d, object) -> this.storeMDPTransition(n, n2, n3, (double)d, object));
        }
        this.progress.update(this.transitionsImported);
        this.progress.end();
    }

    protected void storeMCTransition(int n, int n2, double d, Object object) {
        JDDNode jDDNode;
        JDDNode jDDNode2 = this.encodeStatePair(n, n2);
        JDD.Ref(jDDNode2);
        this.trans = JDD.Apply(1, this.trans, JDD.Apply(3, JDD.Constant(d), jDDNode2));
        String string = object == null ? "" : object.toString();
        int n3 = 0;
        if (!"".equals(string)) {
            n3 = this.synchs.indexOf(string);
            if (n3 == -1) {
                this.synchs.add(string);
                n3 = this.synchs.size() - 1;
            }
            ++n3;
        }
        if (n3 < this.transPerAction.size()) {
            jDDNode = this.transPerAction.get(n3);
        } else {
            jDDNode = JDD.Constant(0.0);
            this.transPerAction.add(jDDNode);
        }
        JDD.Ref(jDDNode2);
        jDDNode = JDD.Apply(1, jDDNode, JDD.Apply(3, JDD.Constant(d), jDDNode2));
        this.transPerAction.set(n3, jDDNode);
        JDD.Deref(jDDNode2);
        this.progress.updateIfReady(++this.transitionsImported);
    }

    protected void storeMDPTransition(int n, int n2, int n3, double d, Object object) {
        JDDNode jDDNode = this.encodeStatePair(n, n3);
        jDDNode = JDD.Apply(3, jDDNode, JDD.SetVectorElement(JDD.Constant(0.0), this.allDDNondetVars, n2, 1.0));
        JDD.Ref(jDDNode);
        this.trans = JDD.Apply(1, this.trans, JDD.Apply(3, JDD.Constant(d), jDDNode));
        String string = object == null ? "" : object.toString();
        int n4 = 0;
        if (!"".equals(string)) {
            n4 = this.synchs.indexOf(string);
            if (n4 == -1) {
                this.synchs.add(string);
                n4 = this.synchs.size() - 1;
            }
            ++n4;
        }
        JDD.Ref(jDDNode);
        JDDNode jDDNode2 = JDD.ThereExists(jDDNode, this.allDDColVars);
        this.transActions = JDD.Apply(6, this.transActions, JDD.Apply(3, JDD.Constant(n4), jDDNode2));
        JDD.Deref(jDDNode);
        this.progress.updateIfReady(++this.transitionsImported);
    }

    private void buildLabelsAndInitialStates() throws PrismException {
        int n3;
        this.start = JDD.Constant(0.0);
        this.labelDeadlock = JDD.Constant(0.0);
        int n4 = this.modelInfo.getNumLabels();
        JDDNode[] jDDNodeArray = new JDDNode[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            jDDNodeArray[n3] = JDD.Constant(0.0);
        }
        this.importer.extractLabelsAndInitialStates((n, n2) -> {
            jDDNodeArray[n2.intValue()] = JDD.Or(jDDNodeArray[n2], this.encodeState((int)n));
        }, n -> {
            this.start = JDD.Or(this.start, this.encodeState((int)n));
        }, n -> {
            this.labelDeadlock = JDD.Or(this.labelDeadlock, this.encodeState((int)n));
        });
        if (this.start == null || this.start.equals(JDD.ZERO)) {
            throw new PrismException("No initial states found");
        }
        this.labelsDD = new LinkedHashMap();
        for (n3 = 0; n3 < n4; ++n3) {
            this.labelsDD.put(this.modelInfo.getLabelName(n3), jDDNodeArray[n3]);
        }
    }

    private void attachLabels(ModelSymbolic modelSymbolic) {
        if (this.labelsDD == null) {
            return;
        }
        for (Map.Entry<String, JDDNode> entry : this.labelsDD.entrySet()) {
            modelSymbolic.addLabelDD(entry.getKey(), entry.getValue().copy());
        }
    }

    private void buildStateRewards() throws PrismException {
        int n = this.rewardInfo.getNumRewardStructs();
        this.stateRewards = new JDDNode[n];
        for (int i = 0; i < n; ++i) {
            this.stateRewards[i] = JDD.Constant(0.0);
            int n3 = i;
            this.importer.extractStateRewards(i, (n2, d) -> this.storeStateReward(n3, (int)n2, (double)d));
        }
    }

    private void buildTransitionRewards() throws PrismException {
        int n = this.rewardInfo.getNumRewardStructs();
        this.transRewards = new JDDNode[n];
        for (int i = 0; i < n; ++i) {
            this.transRewards[i] = JDD.Constant(0.0);
            int n4 = i;
            if (!this.modelType.nondeterministic()) {
                this.importer.extractMCTransitionRewards(i, (n2, n3, d) -> this.storeMCTransitionReward(n4, n2, n3, (double)d), Evaluator.forDouble());
                continue;
            }
            this.importer.extractMDPTransitionRewards(i, (n2, n3, d) -> this.storeMDPTransitionReward(n4, n2, n3, (double)d));
        }
    }

    protected void storeStateReward(int n, int n2, double d) {
        JDDNode jDDNode = this.encodeState(n2);
        this.stateRewards[n] = JDD.Plus(this.stateRewards[n], JDD.Times(JDD.Constant(d), jDDNode));
    }

    protected void storeMCTransitionReward(int n, int n2, int n3, double d) {
        JDDNode jDDNode = this.encodeStatePair(n2, n3);
        this.transRewards[n] = JDD.Plus(this.transRewards[n], JDD.Times(JDD.Constant(d), jDDNode));
    }

    protected void storeMDPTransitionReward(int n, int n2, int n3, double d) {
        JDDNode jDDNode = this.encodeState(n2);
        jDDNode = JDD.Apply(3, jDDNode, JDD.SetVectorElement(JDD.Constant(0.0), this.allDDNondetVars, n3, 1.0));
        jDDNode = JDD.And(jDDNode, this.model.getTrans01().copy());
        this.transRewards[n] = JDD.Plus(this.transRewards[n], JDD.Times(JDD.Constant(d), jDDNode));
    }

    protected void storeMDPTransitionReward(int n, int n2, int n3, int n4, double d) {
        JDDNode jDDNode = this.encodeStatePair(n2, n4);
        jDDNode = JDD.Apply(3, jDDNode, JDD.SetVectorElement(JDD.Constant(0.0), this.allDDNondetVars, n3, 1.0));
        this.transRewards[n] = JDD.Plus(this.transRewards[n], JDD.Times(JDD.Constant(d), jDDNode));
    }

    private JDDNode encodeState(int n) {
        JDDNode jDDNode;
        if (this.statesArray == null) {
            jDDNode = JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[0], n, 1.0);
        } else {
            jDDNode = JDD.Constant(1.0);
            for (int i = 0; i < this.numVars; ++i) {
                jDDNode = JDD.Times(jDDNode, JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[i], this.statesArray[n][i], 1.0));
            }
        }
        return jDDNode;
    }

    private JDDNode encodeStatePair(int n, int n2) {
        JDDNode jDDNode;
        if (this.statesArray == null) {
            jDDNode = JDD.SetMatrixElement(JDD.Constant(0.0), this.varDDRowVars[0], this.varDDColVars[0], n, n2, 1.0);
        } else {
            jDDNode = JDD.Constant(1.0);
            for (int i = 0; i < this.numVars; ++i) {
                jDDNode = JDD.Apply(3, jDDNode, JDD.SetVectorElement(JDD.Constant(0.0), this.varDDRowVars[i], this.statesArray[n][i], 1.0));
                jDDNode = JDD.Apply(3, jDDNode, JDD.SetVectorElement(JDD.Constant(0.0), this.varDDColVars[i], this.statesArray[n2][i], 1.0));
            }
        }
        return jDDNode;
    }
}

