/*
 * Decompiled with CFR 0.152.
 */
package strat;

import explicit.NondetModel;
import prism.Model;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import strat.Strategy;
import strat.StrategyExplicit;
import strat.StrategyExportOptions;
import strat.StrategyInfo;

public class StepBoundedDeterministicStrategy<Value>
extends StrategyExplicit<Value> {
    protected int memory;
    protected int bound;
    protected int[][] choices;
    protected int chSize;
    protected String info = "No information available";

    public StepBoundedDeterministicStrategy(NondetModel<Value> nondetModel, int[][] nArray, int n) {
        super(nondetModel);
        this.choices = nArray;
        if (n < 0) {
            throw new IllegalArgumentException("The bound should be positive.");
        }
        this.bound = n;
        this.chSize = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = n;
            for (int j = 0; j < nArray[i].length; ++j) {
                ++this.chSize;
                if (nArray[i][j] < 0) {
                    throw new IllegalArgumentException("The format of choices is invalid: array cannot contain negative numbers.");
                }
                if (j % 2 == 0 && nArray[i][j] > n) {
                    nArray[i][j] = n;
                    n2 = n;
                } else if (j == 0 && nArray[i][j] < n) {
                    throw new IllegalArgumentException("The format of choices is invalid: the first pivot has to be >= than the bound.");
                }
                if (j % 2 != 0) continue;
                if (nArray[i][j] > n2) {
                    throw new IllegalArgumentException("The format of choices is invalid: pivots have to be in decreasing order.");
                }
                n2 = nArray[i][j];
            }
        }
    }

    @Override
    public StrategyInfo.Memory memory() {
        return StrategyInfo.Memory.FINITE;
    }

    @Override
    public Object getChoiceAction(int n, int n2) {
        int n3 = this.getChoiceIndex(n, n2);
        return n3 >= 0 ? this.model.getAction(n, n3) : Strategy.UNDEFINED;
    }

    @Override
    public int getChoiceIndex(int n, int n2) {
        int[] nArray = this.choices[n];
        int n3 = 0;
        for (int i = 0; i < nArray.length && nArray[i] >= n2; i += 2) {
            n3 = nArray[i + 1];
        }
        return n3;
    }

    @Override
    public int getMemorySize() {
        return this.bound;
    }

    @Override
    public int getInitialMemory(int n) {
        return this.bound;
    }

    @Override
    public int getUpdatedMemory(int n, Object object, int n2) {
        return n > 0 ? n - 1 : n;
    }

    public String getDescription() {
        Object object = "";
        object = (String)object + "Finite memory deterministic strategy\n";
        object = (String)object + "Size of memory: " + this.bound + "\n";
        object = (String)object + "Size of next move function: " + this.chSize + " \n";
        return object;
    }

    public void export(PrismLog prismLog) {
    }

    @Override
    public void exportActions(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
        int n = this.model.getNumStates();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= this.bound; ++j) {
                Object object = this.getChoiceAction(i, j);
                if (object == null) continue;
                prismLog.println(i + "," + j + ":" + object.toString() + "," + (j < this.bound ? j + 1 : j));
            }
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public Model<Value> constructInducedModel(StrategyExportOptions strategyExportOptions) throws PrismException {
        throw new PrismNotSupportedException("Strategy product not yet supported");
    }

    @Override
    public void exportIndices(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
        int n = this.model.getNumStates();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j <= this.bound; ++j) {
                int n2 = this.getChoiceIndex(i, j);
                if (n2 < 0) continue;
                prismLog.println(i + "," + j + ":" + n2 + "," + (j < this.bound ? j + 1 : j));
            }
        }
    }

    @Override
    public void exportInducedModel(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
    }

    @Override
    public void exportDotFile(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
    }

    @Override
    public int getNumStates() {
        return 0;
    }
}

