/*
 * Decompiled with CFR 0.152.
 */
package strat;

import dv.IntegerVector;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import parser.State;
import prism.Model;
import prism.PrismException;
import prism.PrismLog;
import prism.PrismNotSupportedException;
import strat.MDStrategy;
import strat.Strategy;
import strat.StrategyExportOptions;
import strat.StrategyInfo;
import strat.StrategyWithStates;

public class MDStrategyIV
extends StrategyWithStates<Double>
implements MDStrategy<Double> {
    private symbolic.model.Model model;
    private List<String> actions;
    private IntegerVector iv;

    public MDStrategyIV(symbolic.model.Model model, IntegerVector integerVector) {
        this.model = model;
        this.actions = model.getSynchs();
        this.iv = integerVector;
        this.setStateLookUp(state -> {
            try {
                return model.getReachableStates().getIndexOfState((State)state);
            }
            catch (PrismNotSupportedException prismNotSupportedException) {
                return -1;
            }
        });
    }

    @Override
    public Object getChoiceAction(int n, int n2) {
        int n3 = this.iv.getElement(n);
        return n3 >= 0 ? this.actions.get(n3) : Strategy.UNDEFINED;
    }

    @Override
    public int getChoiceIndex(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public StrategyInfo.UndefinedReason whyUndefined(int n, int n2) {
        switch (this.iv.getElement(n)) {
            case -1: {
                return StrategyInfo.UndefinedReason.UNKNOWN;
            }
            case -2: {
                return StrategyInfo.UndefinedReason.ARBITRARY;
            }
            case -3: {
                return StrategyInfo.UndefinedReason.UNREACHABLE;
            }
        }
        return null;
    }

    @Override
    public Model<Double> getModel() {
        return this.model;
    }

    public symbolic.model.Model constructInducedModel(StrategyExportOptions strategyExportOptions) throws PrismException {
        throw new PrismException("Induced model construction not yet supported for symbolic engines");
    }

    @Override
    public void exportInducedModel(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        throw new PrismException("Induced model construction not yet supported for symbolic engines");
    }

    @Override
    public void exportDotFile(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        throw new PrismException("Strategy dot export not yet supported for symbolic engines");
    }

    @Override
    public void clear() {
        this.iv.clear();
        this.iv = null;
    }

    public String toString() {
        return "[" + IntStream.range(0, this.getNumStates()).mapToObj(n -> n + "=" + this.getChoiceActionString(n)).collect(Collectors.joining(",")) + "]";
    }
}

