/*
 * Decompiled with CFR 0.152.
 */
package settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import settings.FileSetting;
import settings.Setting;
import settings.SettingEditor;
import userinterface.GUIPrism;

public class FileEditor
implements SettingEditor,
ActionListener,
FocusListener {
    private JLabel renderer;
    private JPanel panel;
    private ImageIcon warningIcon = GUIPrism.getIconFromImage("smallError.png");
    private JButton button;
    private JTable lastTable = null;
    private int tableRow = -1;
    private int tableCol = -1;
    private JPanel blank1;
    private FileSetting lastSetting;
    private boolean dialogFocus = false;
    private boolean modified = false;

    public FileEditor() {
        this.panel = new JPanel();
        this.panel.setLayout(new BorderLayout());
        this.renderer = new JLabel();
        this.renderer = new JLabel();
        this.blank1 = new JPanel();
        this.button = new JButton("...");
        this.button.setFont(new Font("serif", 0, 7));
        this.panel.add((Component)this.renderer, "Center");
        this.blank1.setLayout(new FlowLayout(1, 0, 0));
        this.blank1.setPreferredSize(new Dimension(18, 2));
        this.button.setPreferredSize(new Dimension(16, 12));
        this.blank1.add(this.button);
        this.panel.add((Component)this.blank1, "East");
        this.button.addActionListener(this);
        this.button.addFocusListener(this);
    }

    @Override
    public Object getEditorValue() {
        if (this.modified) {
            this.modified = false;
            return new File(this.renderer.getText());
        }
        return "$%^&*NOTCHANGED*&^%$";
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Setting setting, Object object, boolean bl, int n, int n2) {
        if (bl) {
            this.renderer.setForeground(jTable.getSelectionForeground());
            this.renderer.setBackground(jTable.getSelectionBackground());
            this.panel.setBackground(jTable.getSelectionBackground());
            this.blank1.setBackground(jTable.getSelectionBackground());
            this.button.setBackground(jTable.getSelectionBackground());
        } else {
            this.renderer.setForeground(jTable.getForeground());
            this.renderer.setBackground(jTable.getBackground());
            this.panel.setBackground(jTable.getBackground());
            this.blank1.setBackground(jTable.getBackground());
            this.button.setBackground(jTable.getBackground());
        }
        this.panel.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        if (setting instanceof FileSetting) {
            this.lastSetting = (FileSetting)setting;
            if (!this.lastSetting.isValidFile()) {
                this.renderer.setIcon(this.warningIcon);
            } else {
                this.renderer.setIcon(null);
            }
        }
        if (object instanceof File) {
            File file = (File)object;
            this.renderer.setText(file.toString());
        } else if (object instanceof ArrayList) {
            ArrayList arrayList = (ArrayList)object;
            if (arrayList.size() > 0) {
                File file = null;
                boolean bl2 = true;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (!(arrayList.get(i) instanceof File)) continue;
                    File file2 = (File)arrayList.get(i);
                    if (file != null) {
                        if (!file2.equals(file)) {
                            bl2 = false;
                            break;
                        }
                        file = file2;
                        continue;
                    }
                    file = file2;
                }
                if (bl2) {
                    this.renderer.setText(file.toString());
                } else {
                    this.renderer.setText("(Different values)");
                    this.renderer.setFont(new Font("monospaced", 2, 12));
                }
            }
            if (setting instanceof FileSetting) {
                this.lastSetting = (FileSetting)setting;
                if (!this.lastSetting.isValidFile()) {
                    this.renderer.setIcon(this.warningIcon);
                } else {
                    this.renderer.setIcon(null);
                }
            }
        }
        this.lastTable = jTable;
        this.tableRow = n;
        this.tableCol = n2;
        return this.panel;
    }

    @Override
    public void stopEditing() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.dialogFocus = true;
        if (this.lastSetting == null) {
            System.out.println("lastSetting null");
            return;
        }
        File file = this.lastSetting.getFileSelector().getFile(null, new File(this.renderer.getText()));
        if (file != null) {
            this.renderer.setText(file.toString());
            if (this.dialogFocus) {
                this.dialogFocus = false;
                if (this.lastTable != null) {
                    this.lastTable.editingStopped(new ChangeEvent(this));
                }
            } else if (this.lastTable != null) {
                this.lastTable.setValueAt(this.getEditorValue(), this.tableRow, this.tableCol);
            }
            this.modified = true;
        }
        if (this.lastTable != null) {
            this.lastTable.editingStopped(new ChangeEvent(this));
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.dialogFocus = false;
    }
}

