/*
 * Decompiled with CFR 0.152.
 */
package pta;

import explicit.IndexedSet;
import explicit.StateStorage;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import prism.PrismException;
import pta.Constraint;
import pta.Edge;
import pta.PTA;
import pta.Transition;

public class PTAParallel {
    private StateStorage<IndexPair> states;
    private LinkedList<IndexPair> explore;
    private PTA pta1;
    private PTA pta2;
    private PTA par;

    public PTA compose(PTA pTA, PTA pTA2) {
        this.pta1 = pTA;
        this.pta2 = pTA2;
        List<String> list = pTA.getAlphabet();
        List<String> list2 = pTA2.getAlphabet();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>();
        LinkedHashSet<String> linkedHashSet3 = new LinkedHashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>(pTA.getAlphabet());
        for (String string : list) {
            if (!"".equals(string) && list2.contains(string)) {
                linkedHashSet.add(string);
                continue;
            }
            linkedHashSet2.add(string);
        }
        for (String string : list2) {
            if (list.contains(string)) continue;
            linkedHashSet3.add(string);
            arrayList.add(string);
        }
        linkedHashSet2.add("");
        linkedHashSet3.add("");
        this.par = new PTA(arrayList);
        for (String string : pTA.clockNames) {
            this.par.getOrAddClock(string);
        }
        for (String string : pTA2.clockNames) {
            this.par.getOrAddClock(string);
        }
        this.states = new IndexedSet<IndexPair>();
        this.explore = new LinkedList();
        this.addState(0, 0);
        int n = -1;
        while (!this.explore.isEmpty()) {
            Edge edge;
            int n2;
            double d;
            Transition transition;
            IndexPair indexPair = this.explore.removeFirst();
            ++n;
            for (String string : linkedHashSet2) {
                for (Transition transition2 : pTA.getTransitionsByAction(indexPair.i1, string)) {
                    transition = this.par.addTransition(n, string);
                    for (Constraint constraint : transition2.getGuardConstraints()) {
                        transition.addGuardConstraint(constraint.deepCopy().renameClocks(pTA, this.par));
                    }
                    for (Edge edge2 : transition2.getEdges()) {
                        d = edge2.getProbability();
                        n2 = this.addState(edge2.getDestination(), indexPair.i2);
                        edge = transition.addEdge(d, n2);
                        for (Map.Entry entry : edge2.getResets()) {
                            edge.addReset(PTA.renameClock(pTA, this.par, (Integer)entry.getKey()), (Integer)entry.getValue());
                        }
                    }
                }
            }
            for (String string : linkedHashSet3) {
                for (Transition transition2 : pTA2.getTransitionsByAction(indexPair.i2, string)) {
                    transition = this.par.addTransition(n, string);
                    for (Constraint constraint : transition2.getGuardConstraints()) {
                        transition.addGuardConstraint(constraint.deepCopy().renameClocks(pTA2, this.par));
                    }
                    for (Edge edge3 : transition2.getEdges()) {
                        d = edge3.getProbability();
                        n2 = this.addState(indexPair.i1, edge3.getDestination());
                        edge = transition.addEdge(d, n2);
                        for (Map.Entry entry : edge3.getResets()) {
                            edge.addReset(PTA.renameClock(pTA2, this.par, (Integer)entry.getKey()), (Integer)entry.getValue());
                        }
                    }
                }
            }
            for (String string : linkedHashSet) {
                for (Transition transition2 : pTA.getTransitionsByAction(indexPair.i1, string)) {
                    for (Transition transition3 : pTA2.getTransitionsByAction(indexPair.i2, string)) {
                        transition = this.par.addTransition(n, string);
                        for (Constraint constraint : transition2.getGuardConstraints()) {
                            transition.addGuardConstraint(constraint.deepCopy().renameClocks(pTA, this.par));
                        }
                        for (Constraint constraint : transition3.getGuardConstraints()) {
                            transition.addGuardConstraint(constraint.deepCopy().renameClocks(pTA2, this.par));
                        }
                        for (Edge edge4 : transition2.getEdges()) {
                            for (Edge edge5 : transition3.getEdges()) {
                                d = edge4.getProbability() * edge5.getProbability();
                                n2 = this.addState(edge4.getDestination(), edge5.getDestination());
                                edge = transition.addEdge(d, n2);
                                for (Map.Entry<Integer, Integer> entry : edge4.getResets()) {
                                    edge.addReset(PTA.renameClock(pTA, this.par, entry.getKey()), entry.getValue());
                                }
                                for (Map.Entry<Integer, Integer> entry : edge5.getResets()) {
                                    edge.addReset(PTA.renameClock(pTA2, this.par, entry.getKey()), entry.getValue());
                                }
                            }
                        }
                    }
                }
            }
        }
        return this.par;
    }

    private int addState(int n, int n2) {
        IndexPair indexPair = new IndexPair(n, n2);
        if (this.states.add(indexPair)) {
            this.explore.add(indexPair);
            int n3 = this.states.getIndexOfLastAdd();
            this.par.addLocation(PTA.combineLocationNames(this.pta1.getLocationName(n), this.pta2.getLocationName(n2)));
            for (Constraint constraint : this.pta1.getInvariantConstraints(n)) {
                this.par.addInvariantCondition(n3, constraint.deepCopy().renameClocks(this.pta1, this.par));
            }
            for (Constraint constraint : this.pta2.getInvariantConstraints(n2)) {
                this.par.addInvariantCondition(n3, constraint.deepCopy().renameClocks(this.pta2, this.par));
            }
        }
        return this.states.getIndexOfLastAdd();
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: java ... <des files>");
            System.exit(1);
        }
        try {
            System.out.println("Building PTA from \"" + stringArray[0] + "\"");
            PTA pTA = PTA.buildPTAFromDesFile(stringArray[0]);
            System.out.println(pTA.infoString());
            for (int i = 1; i < stringArray.length; ++i) {
                System.out.println("Building PTA from \"" + stringArray[i] + "\"");
                PTA pTA2 = PTA.buildPTAFromDesFile(stringArray[i]);
                System.out.println(pTA2.infoString());
                pTA = new PTAParallel().compose(pTA, pTA2);
            }
            System.out.println("Final PTA: " + pTA.infoString());
            System.out.println(pTA);
            pTA.check();
            pTA.writeToDesFile("par.des");
        }
        catch (PrismException prismException) {
            System.err.println("Error: " + prismException.getMessage());
        }
    }

    class IndexPair {
        int i1;
        int i2;

        public IndexPair(int n, int n2) {
            this.i1 = n;
            this.i2 = n2;
        }

        public int hashCode() {
            return this.i1;
        }

        public boolean equals(Object object) {
            IndexPair indexPair;
            if (object == null) {
                return false;
            }
            try {
                indexPair = (IndexPair)object;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
            return this.i1 == indexPair.i1 && this.i2 == indexPair.i2;
        }

        public String toString() {
            return this.i1 + "," + this.i2;
        }
    }
}

