/*
 * Decompiled with CFR 0.152.
 */
package prism;

import explicit.PPLSupport;
import explicit.Pareto;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.fraction.BigFraction;
import parma_polyhedra_library.C_Polyhedron;
import parma_polyhedra_library.Coefficient;
import parma_polyhedra_library.Constraint;
import parma_polyhedra_library.Generator;
import parma_polyhedra_library.Generator_Type;
import parma_polyhedra_library.Linear_Expression;
import parma_polyhedra_library.Linear_Expression_Coefficient;
import parma_polyhedra_library.Linear_Expression_Times;
import parma_polyhedra_library.Linear_Expression_Variable;
import parma_polyhedra_library.Polyhedron;
import parma_polyhedra_library.Relation_Symbol;
import parma_polyhedra_library.Variable;
import parma_polyhedra_library.Variables_Set;
import parser.ast.Expression;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionQuant;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionVar;
import parser.type.TypeVoid;
import prism.Point;
import prism.PrismException;
import prism.TileList;
import userinterface.graph.Slice;

public class PointList
extends TileList {
    private static final boolean problem = false;
    private static final long denominator = 10000000000L;
    private static final double acc = 1.0E-10;
    protected ArrayList<Point> boundary_points = null;
    private ArrayList<List<Point>> poly_points = null;
    protected double[] cutoff_min;
    protected double[] cutoff_max;
    private static final double f1 = 5.0;
    private static final double f2 = 4.0;
    private static final double f3 = 3.0;
    private Pareto pareto = null;
    private List<Expression> expressions;
    private List<Double> bounds;
    protected int full_dim = 0;
    private int indexX;
    private int indexY;

    public double getCutoffMin(int n) {
        return this.cutoff_min[n] > 0.0 ? this.cutoff_min[n] / 3.0 : this.cutoff_min[n] * 3.0;
    }

    public double getCutoffMax(int n) {
        return this.cutoff_max[n] > 0.0 ? this.cutoff_max[n] * 3.0 : this.cutoff_max[n] / 3.0;
    }

    public double getMidpoint(int n) {
        if (this.bounds != null) {
            return n < this.bounds.size() ? this.bounds.get(n) : 0.0;
        }
        return (this.cutoff_max[n] + this.cutoff_min[n]) / 2.0;
    }

    public String getXLabel() {
        return this.getDim2Var(this.expressions.get(this.indexX), false);
    }

    public String getYLabel() {
        return this.getDim2Var(this.expressions.get(this.indexY), false);
    }

    public String getLabel(int n) {
        return this.getDim2Var(this.expressions.get(n), false);
    }

    public int getFullDim() {
        return this.full_dim;
    }

    public List<List<Point>> getPolyPoints() {
        return this.poly_points;
    }

    public PointList() {
        super(2, null, 0.0);
    }

    public PointList(Pareto pareto, List<Expression> list, List<Double> list2) throws PrismException {
        super(2, null, 0.0);
        if (pareto == null || pareto.size() == 0 || pareto.get(0) == null) {
            throw new PrismException("Pareto set cannot be empty.");
        }
        this.foldAndSet(pareto, list);
        this.calculateCutoffs(this.pareto);
        this.cutPareto(this.pareto);
        this.boundary_points = new ArrayList();
        this.poly_points = new ArrayList();
        this.bounds = list2;
    }

    private List<String> getDims2Vars(List<Expression> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Expression expression : list) {
            arrayList.add(this.getDim2Var(expression, true));
        }
        return arrayList;
    }

    private String getDim2Var(Expression expression, boolean bl) {
        Object object;
        Expression expression2 = null;
        if (expression instanceof ExpressionProb) {
            object = (ExpressionProb)expression;
            expression2 = ((ExpressionQuant)object).getExpression() instanceof ExpressionReward ? ((ExpressionReward)((ExpressionQuant)object).getExpression()).getReward() : ((ExpressionProb)expression).getProb();
        } else if (expression instanceof ExpressionReward) {
            expression2 = ((ExpressionReward)expression).getReward();
        }
        if (expression2 instanceof ExpressionVar) {
            object = ((ExpressionVar)expression2).getName();
            int n = ((ExpressionVar)expression2).getIndex();
            return object == null ? String.valueOf(n) : object;
        }
        if (expression2 instanceof ExpressionConstant) {
            return ((ExpressionConstant)expression2).getName();
        }
        return bl ? null : expression.toString();
    }

    private void foldAndSet(Pareto pareto, List<Expression> list) {
        Pareto pareto2 = new Pareto(pareto);
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        List<String> list2 = this.getDims2Vars(list);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Variables_Set variables_Set = new Variables_Set();
        int n = 0;
        for (String string : list2) {
            if (string != null) {
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, n);
                    arrayList.add(list.get(n));
                } else {
                    Constraint constraint = new Constraint((Linear_Expression)new Linear_Expression_Variable(new Variable((long)n)), Relation_Symbol.EQUAL, (Linear_Expression)new Linear_Expression_Variable(new Variable((long)((Integer)hashMap.get(string)).intValue())));
                    for (Polyhedron polyhedron : pareto2.getSets()) {
                        polyhedron.add_constraint(constraint);
                    }
                    variables_Set.add((Object)new Variable((long)n));
                }
            } else {
                arrayList.add(list.get(n));
            }
            ++n;
        }
        for (Polyhedron polyhedron : pareto2.getSets()) {
            polyhedron.remove_space_dimensions(variables_Set);
        }
        this.full_dim = arrayList.size();
        if (this.full_dim < 2) {
            for (Polyhedron polyhedron : pareto2.getSets()) {
                polyhedron.add_space_dimensions_and_embed((long)(2 - this.full_dim));
            }
            for (n = this.full_dim; n < 2; ++n) {
                arrayList.add(new ExpressionConstant("-", TypeVoid.getInstance()));
            }
        }
        this.pareto = pareto2;
        this.expressions = arrayList;
        this.full_dim = arrayList.size();
    }

    /*
     * WARNING - void declaration
     */
    public void updateParetoSet(Slice slice) throws PrismException {
        if (slice.fullSize() != this.full_dim - 2) {
            throw new PrismException(String.format("Need to specify at least %d dimensions for slicing or projecting. Currently only %d specified", this.full_dim - 2, slice.fullSize()));
        }
        Pareto pareto = new Pareto(this.pareto);
        Variables_Set variables_Set = new Variables_Set();
        for (Integer n : slice.keySet()) {
            variables_Set.add((Object)new Variable((long)n.intValue()));
            Linear_Expression_Times linear_Expression_Times = new Linear_Expression_Times(new Coefficient(10000000000L), new Variable((long)n.intValue()));
            Object object = BigInteger.valueOf((long)(slice.get(n) * 1.0E10));
            Linear_Expression_Coefficient linear_Expression_Coefficient = new Linear_Expression_Coefficient(new Coefficient((BigInteger)object));
            Constraint constraint = new Constraint((Linear_Expression)linear_Expression_Times, Relation_Symbol.EQUAL, (Linear_Expression)linear_Expression_Coefficient);
            for (Polyhedron polyhedron : pareto.getSets()) {
                polyhedron.add_constraint(constraint);
            }
        }
        for (Polyhedron polyhedron : pareto.getSets()) {
            polyhedron.remove_space_dimensions(variables_Set);
        }
        Variables_Set variables_Set2 = new Variables_Set();
        boolean bl = false;
        for (int i = 0; i < this.full_dim; ++i) {
            void var5_9;
            if (slice.getProject().contains(i)) {
                variables_Set2.add((Object)new Variable((long)var5_9));
            }
            if (slice.containsKey(i)) continue;
            ++var5_9;
        }
        for (Object object : pareto.getSets()) {
            object.remove_space_dimensions(variables_Set2);
        }
        this.fillPointList(slice, pareto);
    }

    void fillPointList(Slice slice, Pareto pareto) throws PrismException {
        int n;
        this.boundary_points.clear();
        this.poly_points.clear();
        boolean bl = false;
        for (n = 0; n < this.full_dim; ++n) {
            if (slice.removed(n)) continue;
            if (!bl) {
                this.indexX = n;
                bl = true;
                continue;
            }
            this.indexY = n;
            break;
        }
        if (slice.swapdimensions) {
            n = this.indexX;
            this.indexX = this.indexY;
            this.indexY = n;
        }
        for (n = 0; n < pareto.size(); ++n) {
            ArrayList<Point> arrayList = new ArrayList<Point>();
            for (Generator generator : pareto.get(n).minimized_generators()) {
                if (generator.type() == Generator_Type.RAY || generator.type() == Generator_Type.LINE) continue;
                Map<Integer, BigInteger> map = PPLSupport.getCoefficients(generator.linear_expression());
                BigInteger bigInteger = generator.divisor().getBigInteger();
                double[] dArray = new double[2];
                for (Map.Entry<Integer, BigInteger> entry : map.entrySet()) {
                    int n2 = slice.swapdimensions ? 1 - entry.getKey() : entry.getKey();
                    dArray[n2] = new BigFraction(entry.getValue(), bigInteger).doubleValue();
                }
                arrayList.add(new Point(dArray));
            }
            this.poly_points.add(arrayList);
        }
        this.sortPoints();
    }

    public static void addStoredPointList(String string, PointList pointList) {
        pointList.name = string;
        PointList.addStoredFormula(null);
        PointList.addStoredFormulaX(null);
        PointList.addStoredFormulaY(null);
        storedTileLists.add(pointList);
    }

    @Override
    public String toString() {
        return "Point List";
    }

    private void calculateCutoffs(Pareto pareto) {
        int n;
        ArrayList<Polyhedron> arrayList = new ArrayList<Polyhedron>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        block0: for (Polyhedron polyhedron : pareto.getSets()) {
            for (Generator generator : polyhedron.generators()) {
                if (generator.type() != Generator_Type.LINE) continue;
                arrayList.add(polyhedron);
                continue block0;
            }
            arrayList2.add(polyhedron);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            Polyhedron polyhedron = (Polyhedron)arrayList.get(n);
            for (int i = n + 1; i < arrayList.size(); ++i) {
                Generator generator;
                generator = new C_Polyhedron(((Polyhedron)arrayList.get(i)).generators());
                generator.intersection_assign(polyhedron);
                arrayList2.add(generator);
            }
        }
        this.cutoff_min = new double[this.full_dim];
        this.cutoff_max = new double[this.full_dim];
        for (n = 0; n < this.full_dim; ++n) {
            this.cutoff_max[n] = Double.NEGATIVE_INFINITY;
            this.cutoff_min[n] = Double.POSITIVE_INFINITY;
        }
        for (Polyhedron polyhedron : arrayList2) {
            for (Generator generator : polyhedron.generators()) {
                if (generator.type() != Generator_Type.POINT) continue;
                HashMap<Variable, BigInteger> hashMap = new HashMap<Variable, BigInteger>();
                PPLSupport.getCoefficientsFromLinearExpression(generator.linear_expression(), false, BigInteger.ONE, hashMap);
                BigInteger bigInteger = generator.divisor().getBigInteger();
                for (int i = 0; i < this.full_dim; ++i) {
                    boolean bl = false;
                    for (Variable variable : hashMap.keySet()) {
                        if (variable == null || (long)i != variable.id()) continue;
                        double d = new BigFraction((BigInteger)hashMap.get(variable), bigInteger).doubleValue();
                        bl = true;
                        if (this.cutoff_max[i] < d) {
                            this.cutoff_max[i] = d;
                        }
                        if (!(this.cutoff_min[i] > d)) break;
                        this.cutoff_min[i] = d;
                        break;
                    }
                    if (bl) continue;
                    if (this.cutoff_max[i] < 0.0) {
                        this.cutoff_max[i] = 0.0;
                    }
                    if (!(this.cutoff_min[i] > 0.0)) continue;
                    this.cutoff_min[i] = 0.0;
                }
            }
        }
        for (int i = 0; i < this.full_dim; ++i) {
            double d;
            double d2;
            if (this.cutoff_min[i] == Double.POSITIVE_INFINITY) {
                this.cutoff_min[i] = -10.0;
            }
            if (this.cutoff_max[i] == Double.NEGATIVE_INFINITY) {
                this.cutoff_max[i] = 10.0;
            }
            if (!((d2 = this.cutoff_max[i] - this.cutoff_min[i]) < (d = 2.0))) continue;
            int n2 = i;
            this.cutoff_max[n2] = this.cutoff_max[n2] + (d - d2) / 2.0;
            int n3 = i;
            this.cutoff_min[n3] = this.cutoff_min[n3] - (d - d2) / 2.0;
        }
    }

    private void cutPareto(Pareto pareto) {
        for (Polyhedron polyhedron : pareto.getSets()) {
            for (int i = 0; i < this.full_dim; ++i) {
                Linear_Expression_Variable linear_Expression_Variable = new Linear_Expression_Variable(new Variable((long)i));
                Linear_Expression_Coefficient linear_Expression_Coefficient = new Linear_Expression_Coefficient(new Coefficient((long)Math.ceil(this.cutoff_max[i] > 0.0 ? this.cutoff_max[i] * 5.0 : this.cutoff_max[i] / 5.0)));
                Linear_Expression_Coefficient linear_Expression_Coefficient2 = new Linear_Expression_Coefficient(new Coefficient((long)Math.floor(this.cutoff_min[i] > 0.0 ? this.cutoff_min[i] / 5.0 : this.cutoff_min[i] * 5.0)));
                Constraint constraint = new Constraint((Linear_Expression)linear_Expression_Variable, Relation_Symbol.LESS_OR_EQUAL, (Linear_Expression)linear_Expression_Coefficient);
                Constraint constraint2 = new Constraint((Linear_Expression)linear_Expression_Variable, Relation_Symbol.GREATER_OR_EQUAL, (Linear_Expression)linear_Expression_Coefficient2);
                polyhedron.add_constraint(constraint);
                polyhedron.add_constraint(constraint2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void sortPoints() throws PrismException {
        double d = Double.MIN_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MAX_VALUE;
        for (List<Point> list : this.poly_points) {
            Point point;
            Point point2;
            int n = list.size();
            for (Point point3 : list) {
                point3.setCoord(0, (double)Math.round(point3.getCoord(0) * 1.0E10) * 1.0E-10);
                point3.setCoord(1, (double)Math.round(point3.getCoord(1) * 1.0E10) * 1.0E-10);
                double d5 = point3.getCoord(0);
                double d6 = this.cutoff_max[this.indexX] > 0.0 ? this.cutoff_max[this.indexX] * 4.0 : this.cutoff_max[this.indexX] / 4.0;
                if (!(d5 < d6)) continue;
                double d7 = point3.getCoord(0);
                double d8 = this.cutoff_min[this.indexX] > 0.0 ? this.cutoff_min[this.indexX] / 4.0 : this.cutoff_min[this.indexX] * 4.0;
                if (!(d7 > d8)) continue;
                double d9 = point3.getCoord(1);
                double d10 = this.cutoff_max[this.indexY] > 0.0 ? this.cutoff_max[this.indexY] * 4.0 : this.cutoff_max[this.indexY] / 4.0;
                if (!(d9 < d10)) continue;
                double d11 = point3.getCoord(1);
                double d12 = this.cutoff_min[this.indexY] > 0.0 ? this.cutoff_min[this.indexY] / 4.0 : this.cutoff_min[this.indexY] * 4.0;
                if (!(d11 > d12)) continue;
                if (d < point3.getCoord(0)) {
                    d = point3.getCoord(0);
                }
                if (d2 > point3.getCoord(0)) {
                    d2 = point3.getCoord(0);
                }
                if (d3 < point3.getCoord(1)) {
                    d3 = point3.getCoord(1);
                }
                if (!(d4 > point3.getCoord(1))) continue;
                d4 = point3.getCoord(1);
            }
            if (n <= 1) continue;
            Object object3 = list.get(0);
            for (Point point4 : list) {
                if (!(point4.getCoord(1) == ((Point)object3).getCoord(1) && point4.getCoord(0) < ((Point)object3).getCoord(0)) && !(point4.getCoord(1) < ((Point)object3).getCoord(1))) continue;
                object3 = point4;
            }
            Object object = object3;
            ArrayList<void> arrayList = new ArrayList<void>();
            do {
                void var13_13;
                arrayList.add(var13_13);
                if (var13_13 != object3) {
                    list.remove(var13_13);
                }
                point = null;
                for (Point point5 : list) {
                    double d13;
                    if (point == null) {
                        point = point5;
                        continue;
                    }
                    double d14 = Math.atan2(var13_13.getCoord(1) - point.getCoord(1), var13_13.getCoord(0) - point.getCoord(0)) - Math.PI;
                    if (d14 < 0.0) {
                        d14 += Math.PI * 2;
                    }
                    if ((d13 = Math.atan2(var13_13.getCoord(1) - point5.getCoord(1), var13_13.getCoord(0) - point5.getCoord(0)) - Math.PI) < 0.0) {
                        d13 += Math.PI * 2;
                    }
                    if (var13_13.equals(point5) || !var13_13.equals(point) && !(d14 >= d13)) continue;
                    point = point5;
                }
            } while (!(point2 = point).equals(object3));
            list.clear();
            list.addAll(arrayList);
        }
        if (d == Double.MIN_VALUE) {
            double d15 = d = this.cutoff_max[this.indexX] > 0.0 ? this.cutoff_max[this.indexX] * 3.0 : this.cutoff_max[this.indexX] / 3.0;
        }
        if (d2 == Double.MAX_VALUE) {
            double d16 = d2 = this.cutoff_min[this.indexX] > 0.0 ? this.cutoff_min[this.indexX] / 3.0 : this.cutoff_min[this.indexX] * 3.0;
        }
        if (d3 == Double.MIN_VALUE) {
            double d17 = d3 = this.cutoff_max[this.indexY] > 0.0 ? this.cutoff_max[this.indexY] * 3.0 : this.cutoff_max[this.indexY] / 3.0;
        }
        if (d4 == Double.MAX_VALUE) {
            double d18 = d4 = this.cutoff_min[this.indexY] > 0.0 ? this.cutoff_min[this.indexY] / 3.0 : this.cutoff_min[this.indexY] * 3.0;
        }
        if (Math.abs(d - d2) < 0.1) {
            d += 1.0;
            d2 -= 1.0;
        }
        if (Math.abs(d3 - d4) < 0.1) {
            d3 += 1.0;
            d4 -= 1.0;
        }
        this.boundary_points.add(new Point(new double[]{d2, d4}));
        this.boundary_points.add(new Point(new double[]{d2, d3}));
        this.boundary_points.add(new Point(new double[]{d, d3}));
        this.boundary_points.add(new Point(new double[]{d, d4}));
    }

    @Override
    public List<Point> getPoints() {
        return this.boundary_points;
    }

    @Override
    public void addNewPoint(Point point) throws PrismException {
        this.boundary_points.add(point);
    }
}

