/*
 * Decompiled with CFR 0.152.
 */
package prism;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import parser.ast.Coalition;
import prism.PrismException;

public class PlayerInfo {
    protected List<String> playerNames;
    protected int[] coalitionPlayerMap;

    public PlayerInfo() {
        this.playerNames = new ArrayList<String>();
        this.coalitionPlayerMap = null;
    }

    public PlayerInfo(PlayerInfo playerInfo) {
        this.setPlayerNames(playerInfo.playerNames);
        this.setCoalitionPlayerMap(playerInfo.coalitionPlayerMap);
    }

    public void setNumPlayers(int n) {
        this.playerNames = new ArrayList<String>(Collections.nCopies(n, ""));
    }

    public void addPlayer(String string) {
        this.playerNames.add(string);
    }

    public void setPlayerNames(List<String> list) {
        this.playerNames = new ArrayList<String>(list.size());
        for (String string : list) {
            this.playerNames.add(string == null ? "" : string);
        }
    }

    public void setCoalition(Coalition coalition) throws PrismException {
        if (coalition == null) {
            this.coalitionPlayerMap = null;
            return;
        }
        int n = this.getNumPlayers();
        this.coalitionPlayerMap = new int[n];
        for (int i = 0; i < n; ++i) {
            boolean bl = coalition.isPlayerIndexInCoalition(i, this.playerNames);
            this.coalitionPlayerMap[i] = bl ? 0 : 1;
        }
    }

    private void setCoalitionPlayerMap(int[] nArray) {
        this.coalitionPlayerMap = nArray == null ? null : (int[])nArray.clone();
    }

    public int getNumPlayers() {
        return this.playerNames.size();
    }

    public String getPlayerName(int n) {
        return this.playerNames.get(n);
    }

    public List<String> getPlayerNames() {
        return this.playerNames;
    }

    public int getPlayer(int n) {
        if (this.coalitionPlayerMap == null) {
            return n;
        }
        return n == -1 ? 0 : this.coalitionPlayerMap[n];
    }
}

