/*
 * Decompiled with CFR 0.152.
 */
package prism;

import common.Interval;
import param.BigRational;
import param.Function;
import param.FunctionFactory;
import parser.EvaluateContext;
import parser.EvaluateContextState;
import parser.State;
import parser.Values;
import parser.ast.Expression;
import parser.type.TypeDouble;
import parser.type.TypeInterval;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismUtils;

public interface Evaluator<Value> {
    public static Evaluator<Double> forDouble() {
        return EvaluatorDouble.EVALUATOR_DOUBLE;
    }

    public static Evaluator<BigRational> forBigRational() {
        return EvaluatorBigRational.EVALUATOR_BIG_RATIONAL;
    }

    public static Evaluator<Function> forRationalFunction(FunctionFactory functionFactory) {
        return new EvaluatorFunction(functionFactory);
    }

    public static Evaluator<Interval<Double>> forDoubleInterval() {
        return EvaluatorDoubleInterval.EVALUATOR_DOUBLE_INTERVAL;
    }

    public Value zero();

    public Value one();

    public boolean isZero(Value var1);

    public boolean isOne(Value var1);

    public boolean isFinite(Value var1);

    public Value add(Value var1, Value var2);

    public Value subtract(Value var1, Value var2);

    public Value multiply(Value var1, Value var2);

    public Value divide(Value var1, Value var2);

    public boolean gt(Value var1, Value var2);

    public boolean geq(Value var1, Value var2);

    public boolean equals(Value var1, Value var2);

    public Value checkProbabilitySum(Value var1) throws PrismException;

    public Value evaluate(Expression var1, Values var2, State var3) throws PrismLangException;

    default public Value evaluate(Expression expression, State state) throws PrismLangException {
        return this.evaluate(expression, null, state);
    }

    public Value fromString(String var1) throws NumberFormatException;

    public double toDouble(Value var1);

    default public String toStringExport(Value Value2) {
        return Value2.toString();
    }

    default public String toStringExport(Value Value2, int n) {
        return this.toStringExport(Value2);
    }

    default public String toStringPrism(Value Value2) {
        return this.toStringExport(Value2);
    }

    default public String toStringPrism(Value Value2, int n) {
        return this.toStringExport(Value2, n);
    }

    public boolean exact();

    public boolean isSymbolic();

    public EvaluateContext.EvalMode evalMode();

    default public Evaluator<Interval<Value>> createIntervalEvaluator() throws PrismException {
        throw new PrismException("Intervals not supported for " + String.valueOf((Object)this.evalMode()));
    }

    default public Value sum(Iterable<Value> iterable) {
        Value Value2 = this.zero();
        for (Value Value3 : iterable) {
            Value2 = this.add(Value2, Value3);
        }
        return Value2;
    }

    default public Value product(Iterable<Value> iterable) {
        Value Value2 = this.one();
        for (Value Value3 : iterable) {
            Value2 = this.multiply(Value2, Value3);
        }
        return Value2;
    }

    public static class EvaluatorDouble
    implements Evaluator<Double> {
        private static final Evaluator<Double> EVALUATOR_DOUBLE = new EvaluatorDouble();
        private static final Double ZERO = 0.0;
        private static final Double ONE = 1.0;

        @Override
        public Double zero() {
            return ZERO;
        }

        @Override
        public Double one() {
            return ONE;
        }

        @Override
        public boolean isZero(Double d) {
            return d == 0.0;
        }

        @Override
        public boolean isOne(Double d) {
            return PrismUtils.doublesAreEqual(d, 1.0);
        }

        @Override
        public boolean isFinite(Double d) {
            return Double.isFinite(d);
        }

        @Override
        public Double add(Double d, Double d2) {
            return d + d2;
        }

        @Override
        public Double subtract(Double d, Double d2) {
            return d - d2;
        }

        @Override
        public Double multiply(Double d, Double d2) {
            return d * d2;
        }

        @Override
        public Double divide(Double d, Double d2) {
            return d / d2;
        }

        @Override
        public boolean gt(Double d, Double d2) {
            return d > d2;
        }

        @Override
        public boolean geq(Double d, Double d2) {
            return d >= d2;
        }

        @Override
        public boolean equals(Double d, Double d2) {
            return PrismUtils.doublesAreEqual(d, d2);
        }

        @Override
        public Double checkProbabilitySum(Double d) throws PrismException {
            if (!PrismUtils.doublesAreEqual(d, 1.0)) {
                throw new PrismException("Probabilities sum to " + d);
            }
            return d;
        }

        @Override
        public Double evaluate(Expression expression, Values values, State state) throws PrismLangException {
            return expression.evaluateDouble(values, state);
        }

        @Override
        public double toDouble(Double d) {
            return d;
        }

        @Override
        public String toStringExport(Double d) {
            return PrismUtils.formatDouble(d);
        }

        @Override
        public String toStringExport(Double d, int n) {
            return PrismUtils.formatDouble(n, d);
        }

        @Override
        public Double fromString(String string) throws NumberFormatException {
            return Double.parseDouble(string);
        }

        @Override
        public boolean exact() {
            return false;
        }

        @Override
        public boolean isSymbolic() {
            return false;
        }

        @Override
        public EvaluateContext.EvalMode evalMode() {
            return EvaluateContext.EvalMode.FP;
        }

        @Override
        public Evaluator<Interval<Double>> createIntervalEvaluator() {
            return EvaluatorDoubleInterval.EVALUATOR_DOUBLE_INTERVAL;
        }
    }

    public static class EvaluatorBigRational
    implements Evaluator<BigRational> {
        private static final Evaluator<BigRational> EVALUATOR_BIG_RATIONAL = new EvaluatorBigRational();

        @Override
        public BigRational zero() {
            return BigRational.ZERO;
        }

        @Override
        public BigRational one() {
            return BigRational.ONE;
        }

        @Override
        public boolean isZero(BigRational bigRational) {
            return bigRational.equals(BigRational.ZERO);
        }

        @Override
        public boolean isOne(BigRational bigRational) {
            return bigRational.equals(BigRational.ONE);
        }

        @Override
        public boolean isFinite(BigRational bigRational) {
            return bigRational.isFinite();
        }

        @Override
        public BigRational add(BigRational bigRational, BigRational bigRational2) {
            return bigRational.add(bigRational2);
        }

        @Override
        public BigRational subtract(BigRational bigRational, BigRational bigRational2) {
            return bigRational.subtract(bigRational2);
        }

        @Override
        public BigRational multiply(BigRational bigRational, BigRational bigRational2) {
            return bigRational.multiply(bigRational2);
        }

        @Override
        public BigRational divide(BigRational bigRational, BigRational bigRational2) {
            return bigRational.divide(bigRational2);
        }

        @Override
        public boolean gt(BigRational bigRational, BigRational bigRational2) {
            return bigRational.compareTo(bigRational2) > 0;
        }

        @Override
        public boolean geq(BigRational bigRational, BigRational bigRational2) {
            return bigRational.compareTo(bigRational2) >= 0;
        }

        @Override
        public boolean equals(BigRational bigRational, BigRational bigRational2) {
            return bigRational.equals(bigRational2);
        }

        @Override
        public BigRational checkProbabilitySum(BigRational bigRational) throws PrismException {
            if (!this.isOne(bigRational)) {
                throw new PrismException("Probabilities sum to " + String.valueOf(bigRational));
            }
            return bigRational;
        }

        @Override
        public BigRational evaluate(Expression expression, Values values, State state) throws PrismLangException {
            Object object = expression.evaluate(new EvaluateContextState(values, state).setEvaluationMode(EvaluateContext.EvalMode.EXACT));
            return (BigRational)TypeDouble.getInstance().castValueTo(object, EvaluateContext.EvalMode.EXACT);
        }

        @Override
        public double toDouble(BigRational bigRational) {
            return bigRational.doubleValue();
        }

        @Override
        public BigRational fromString(String string) throws NumberFormatException {
            return new BigRational(string);
        }

        @Override
        public boolean exact() {
            return true;
        }

        @Override
        public boolean isSymbolic() {
            return false;
        }

        @Override
        public EvaluateContext.EvalMode evalMode() {
            return EvaluateContext.EvalMode.EXACT;
        }

        @Override
        public Evaluator<Interval<BigRational>> createIntervalEvaluator() {
            return EvaluatorBigRationalInterval.EVALUATOR_BIG_RATIONAL_INTERVAL;
        }
    }

    public static class EvaluatorFunction
    implements Evaluator<Function> {
        protected FunctionFactory functionFactory;

        public EvaluatorFunction(FunctionFactory functionFactory) {
            this.functionFactory = functionFactory;
        }

        public FunctionFactory getFunctionFactory() {
            return this.functionFactory;
        }

        @Override
        public Function zero() {
            return this.functionFactory.getZero();
        }

        @Override
        public Function one() {
            return this.functionFactory.getOne();
        }

        @Override
        public boolean isZero(Function function) {
            return function.isZero();
        }

        @Override
        public boolean isOne(Function function) {
            return function.isOne();
        }

        @Override
        public boolean isFinite(Function function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Function add(Function function, Function function2) {
            return function.add(function2);
        }

        @Override
        public Function subtract(Function function, Function function2) {
            return function.subtract(function2);
        }

        @Override
        public Function multiply(Function function, Function function2) {
            return function.multiply(function2);
        }

        @Override
        public Function divide(Function function, Function function2) {
            return function.divide(function2);
        }

        @Override
        public boolean gt(Function function, Function function2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean geq(Function function, Function function2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Function function, Function function2) {
            return function.equals(function2);
        }

        @Override
        public Function checkProbabilitySum(Function function) throws PrismException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Function evaluate(Expression expression, Values values, State state) throws PrismLangException {
            return this.functionFactory.expr2function((Expression)expression.deepCopy().evaluatePartially(values, state));
        }

        @Override
        public double toDouble(Function function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Function fromString(String string) throws NumberFormatException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean exact() {
            return true;
        }

        @Override
        public boolean isSymbolic() {
            return true;
        }

        @Override
        public EvaluateContext.EvalMode evalMode() {
            return EvaluateContext.EvalMode.EXACT;
        }
    }

    public static class EvaluatorDoubleInterval
    implements Evaluator<Interval<Double>> {
        private static final Evaluator<Interval<Double>> EVALUATOR_DOUBLE_INTERVAL = new EvaluatorDoubleInterval();
        private static final Interval<Double> ZERO = new Interval<Double>(0.0, 0.0);
        private static final Interval<Double> ONE = new Interval<Double>(1.0, 1.0);

        @Override
        public Interval<Double> zero() {
            return ZERO;
        }

        @Override
        public Interval<Double> one() {
            return ONE;
        }

        @Override
        public boolean isZero(Interval<Double> interval) {
            return interval.getLower() == 0.0 && interval.getUpper() == 0.0;
        }

        @Override
        public boolean isOne(Interval<Double> interval) {
            return PrismUtils.doublesAreEqual(interval.getLower(), 1.0) && PrismUtils.doublesAreEqual(interval.getUpper(), 1.0);
        }

        @Override
        public boolean isFinite(Interval<Double> interval) {
            return Double.isFinite(interval.getLower()) && Double.isFinite(interval.getUpper());
        }

        @Override
        public Interval<Double> add(Interval<Double> interval, Interval<Double> interval2) {
            double d = interval.getLower() + interval2.getLower();
            double d2 = interval.getUpper() + interval2.getUpper();
            return new Interval<Double>(d, d2);
        }

        @Override
        public Interval<Double> subtract(Interval<Double> interval, Interval<Double> interval2) {
            double d = interval.getLower() - interval2.getLower();
            double d2 = interval.getUpper() - interval2.getUpper();
            return new Interval<Double>(d, d2);
        }

        @Override
        public Interval<Double> multiply(Interval<Double> interval, Interval<Double> interval2) {
            double d = interval.getLower() * interval2.getLower();
            double d2 = interval.getLower() * interval2.getUpper();
            double d3 = interval.getUpper() * interval2.getLower();
            double d4 = interval.getUpper() * interval2.getUpper();
            double d5 = Math.min(d, Math.min(d2, Math.min(d3, d4)));
            double d6 = Math.max(d, Math.max(d2, Math.max(d3, d4)));
            return new Interval<Double>(d5, d6);
        }

        @Override
        public Interval<Double> divide(Interval<Double> interval, Interval<Double> interval2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean gt(Interval<Double> interval, Interval<Double> interval2) {
            return interval.getLower() > interval2.getUpper();
        }

        @Override
        public boolean geq(Interval<Double> interval, Interval<Double> interval2) {
            return interval.getLower() >= interval2.getUpper();
        }

        @Override
        public boolean equals(Interval<Double> interval, Interval<Double> interval2) {
            boolean bl = PrismUtils.doublesAreEqual(interval.getLower(), interval2.getLower());
            boolean bl2 = PrismUtils.doublesAreEqual(interval.getUpper(), interval2.getUpper());
            return bl && bl2;
        }

        @Override
        public Interval<Double> checkProbabilitySum(Interval<Double> interval) throws PrismException {
            if (interval.getLower() > 1.0 + PrismUtils.epsilonDouble) {
                throw new PrismException("Probability lower bounds sum to " + String.valueOf(interval.getLower()) + " which is greater than 1");
            }
            if (interval.getUpper() < 1.0 - PrismUtils.epsilonDouble) {
                throw new PrismException("Probability upper bounds sum to " + String.valueOf(interval.getUpper()) + " which is less than 1");
            }
            return interval;
        }

        @Override
        public Interval<Double> evaluate(Expression expression, Values values, State state) throws PrismLangException {
            Object object = expression.evaluate(values, state);
            return TypeInterval.getInstance(TypeDouble.getInstance()).castValueTo(object);
        }

        @Override
        public double toDouble(Interval<Double> interval) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toStringExport(Interval<Double> interval) {
            String string = PrismUtils.formatDouble(interval.getLower());
            String string2 = PrismUtils.formatDouble(interval.getUpper());
            return "[" + string + "," + string2 + "]";
        }

        @Override
        public String toStringExport(Interval<Double> interval, int n) {
            String string = PrismUtils.formatDouble(n, interval.getLower());
            String string2 = PrismUtils.formatDouble(n, interval.getUpper());
            return "[" + string + "," + string2 + "]";
        }

        @Override
        public Interval<Double> fromString(String string) throws NumberFormatException {
            if (string.charAt(0) != '[' || string.charAt(string.length() - 1) != ']') {
                throw new NumberFormatException("Illegal interval " + string);
            }
            String[] stringArray = (string = string.substring(1, string.length() - 1)).split(",");
            if (stringArray.length != 2) {
                throw new NumberFormatException("Illegal interval " + string);
            }
            return new Interval<Double>(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]));
        }

        @Override
        public boolean exact() {
            return false;
        }

        @Override
        public boolean isSymbolic() {
            return false;
        }

        @Override
        public EvaluateContext.EvalMode evalMode() {
            return EvaluateContext.EvalMode.FP;
        }
    }

    public static class EvaluatorBigRationalInterval
    implements Evaluator<Interval<BigRational>> {
        private static final Evaluator<Interval<BigRational>> EVALUATOR_BIG_RATIONAL_INTERVAL = new EvaluatorBigRationalInterval();
        private static final Interval<BigRational> ZERO = new Interval<BigRational>(BigRational.ZERO, BigRational.ZERO);
        private static final Interval<BigRational> ONE = new Interval<BigRational>(BigRational.ONE, BigRational.ONE);

        @Override
        public Interval<BigRational> zero() {
            return ZERO;
        }

        @Override
        public Interval<BigRational> one() {
            return ONE;
        }

        @Override
        public boolean isZero(Interval<BigRational> interval) {
            return interval.getLower().equals(BigRational.ZERO) && interval.getUpper().equals(BigRational.ZERO);
        }

        @Override
        public boolean isOne(Interval<BigRational> interval) {
            return interval.getLower().equals(BigRational.ONE) && interval.getUpper().equals(BigRational.ONE);
        }

        @Override
        public boolean isFinite(Interval<BigRational> interval) {
            return interval.getLower().isFinite() && interval.getUpper().isFinite();
        }

        @Override
        public Interval<BigRational> add(Interval<BigRational> interval, Interval<BigRational> interval2) {
            BigRational bigRational = interval.getLower().add(interval2.getLower());
            BigRational bigRational2 = interval.getUpper().add(interval2.getUpper());
            return new Interval<BigRational>(bigRational, bigRational2);
        }

        @Override
        public Interval<BigRational> subtract(Interval<BigRational> interval, Interval<BigRational> interval2) {
            BigRational bigRational = interval.getLower().subtract(interval2.getLower());
            BigRational bigRational2 = interval.getUpper().subtract(interval2.getUpper());
            return new Interval<BigRational>(bigRational, bigRational2);
        }

        @Override
        public Interval<BigRational> multiply(Interval<BigRational> interval, Interval<BigRational> interval2) {
            BigRational bigRational = interval.getLower().multiply(interval2.getLower());
            BigRational bigRational2 = interval.getLower().multiply(interval2.getUpper());
            BigRational bigRational3 = interval.getUpper().multiply(interval2.getLower());
            BigRational bigRational4 = interval.getUpper().multiply(interval2.getUpper());
            BigRational bigRational5 = bigRational.min(bigRational2).min(bigRational3).min(bigRational4);
            BigRational bigRational6 = bigRational.max(bigRational2).max(bigRational3).max(bigRational4);
            return new Interval<BigRational>(bigRational5, bigRational6);
        }

        @Override
        public Interval<BigRational> divide(Interval<BigRational> interval, Interval<BigRational> interval2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean gt(Interval<BigRational> interval, Interval<BigRational> interval2) {
            return interval.getLower().greaterThan(interval2.getUpper());
        }

        @Override
        public boolean geq(Interval<BigRational> interval, Interval<BigRational> interval2) {
            return interval.getLower().greaterThanEquals(interval2.getUpper());
        }

        @Override
        public boolean equals(Interval<BigRational> interval, Interval<BigRational> interval2) {
            return interval.getLower().equals(interval2.getLower()) && interval.getUpper().equals(interval2.getUpper());
        }

        @Override
        public Interval<BigRational> checkProbabilitySum(Interval<BigRational> interval) throws PrismException {
            if (interval.getLower().greaterThan(BigRational.ONE)) {
                throw new PrismException("Probability lower bounds sum to " + String.valueOf(interval.getLower()) + " which is greater than 1");
            }
            if (interval.getUpper().lessThan(BigRational.ONE)) {
                throw new PrismException("Probability upper bounds sum to " + String.valueOf(interval.getUpper()) + " which is less than 1");
            }
            return interval;
        }

        @Override
        public Interval<BigRational> evaluate(Expression expression, Values values, State state) throws PrismLangException {
            Object object = expression.evaluate(new EvaluateContextState(values, state).setEvaluationMode(EvaluateContext.EvalMode.EXACT));
            return TypeInterval.getInstance(TypeDouble.getInstance()).castValueTo(object, EvaluateContext.EvalMode.EXACT);
        }

        @Override
        public double toDouble(Interval<BigRational> interval) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Interval<BigRational> fromString(String string) throws NumberFormatException {
            if (string.charAt(0) != '[' || string.charAt(string.length() - 1) != ']') {
                throw new NumberFormatException("Illegal interval " + string);
            }
            String[] stringArray = (string = string.substring(1, string.length() - 1)).split(",");
            if (stringArray.length != 2) {
                throw new NumberFormatException("Illegal interval " + string);
            }
            return new Interval<BigRational>(new BigRational(stringArray[0]), new BigRational(stringArray[1]));
        }

        @Override
        public boolean exact() {
            return true;
        }

        @Override
        public boolean isSymbolic() {
            return false;
        }

        @Override
        public EvaluateContext.EvalMode evalMode() {
            return EvaluateContext.EvalMode.EXACT;
        }
    }
}

