/*
 * Decompiled with CFR 0.152.
 */
package pepa.compiler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import pepa.compiler.InternalError;

public class Main {
    public static String compile(String string) throws InternalError {
        try {
            Class<?> clazz = Class.forName("pepa");
            Method[] methodArray = clazz.getMethods();
            if (methodArray.length == 0) {
                throw new InternalError("Could not locate the methods for the PEPA compiler");
            }
            Method method = null;
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals("compile")) continue;
                method = methodArray[i];
            }
            if (method == null) {
                throw new InternalError("Could not locate the entry point for the PEPA compiler");
            }
            Object[] objectArray = new Object[]{string};
            Object object = method.invoke(null, objectArray);
            if (!(object instanceof String)) {
                throw new InternalError("Non-string returned by PEPA compile method ");
            }
            String string2 = (String)object;
            return string2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError("Could not load the PEPA compiler class from pepa.zip");
        }
        catch (SecurityException securityException) {
            throw new InternalError("Could not secure the PEPA compiler class");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new InternalError("Could not access the PEPA compiler instance");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new InternalError("Attempted to start the PEPA compiler with the wrong arguments");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            throw new InternalError(throwable.toString());
        }
    }

    public static void main(String[] stringArray) throws InternalError {
        if (stringArray == null) {
            throw new InternalError("Cannot invoke the PEPA compiler on a null filename");
        }
        if (stringArray.length == 0) {
            throw new InternalError("Must supply a file name to invoke the PEPA compiler");
        }
        if (stringArray.length != 1) {
            throw new InternalError("Cannot invoke the PEPA compiler on more than one file");
        }
        System.out.println(Main.compile(stringArray[0]));
    }
}

