/*
 * Decompiled with CFR 0.152.
 */
package parser.visitor;

import java.util.HashMap;
import jltl2ba.SimpleLTL;
import parser.ast.ASTElement;
import parser.ast.Expression;
import parser.ast.ExpressionBinaryOp;
import parser.ast.ExpressionLabel;
import parser.ast.ExpressionLiteral;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionUnaryOp;
import parser.type.TypeBool;
import prism.PrismLangException;

public class ConvertForJltl2ba {
    private boolean allowSharing = true;
    private HashMap<ASTElement, SimpleLTL> formulas = null;

    public ConvertForJltl2ba() {
        this(false);
    }

    public ConvertForJltl2ba(boolean bl) {
        this.allowSharing = bl;
        if (bl) {
            this.formulas = new HashMap();
        }
    }

    public SimpleLTL convert(Expression expression) throws PrismLangException {
        SimpleLTL simpleLTL = null;
        if (this.allowSharing && (simpleLTL = this.getFormula(expression)) != null) {
            return simpleLTL;
        }
        if (expression instanceof ExpressionTemporal) {
            simpleLTL = this.convertTemporal((ExpressionTemporal)expression);
        } else if (expression instanceof ExpressionBinaryOp) {
            simpleLTL = this.convertBinaryOp((ExpressionBinaryOp)expression);
        } else if (expression instanceof ExpressionUnaryOp) {
            simpleLTL = this.convertUnaryOp((ExpressionUnaryOp)expression);
        } else if (expression instanceof ExpressionLiteral) {
            simpleLTL = this.convertLiteral((ExpressionLiteral)expression);
        } else if (expression instanceof ExpressionLabel) {
            simpleLTL = this.convertLabel((ExpressionLabel)expression);
        }
        if (this.allowSharing) {
            this.setFormula(expression, simpleLTL);
        }
        return simpleLTL;
    }

    private Object setFormula(ASTElement aSTElement, SimpleLTL simpleLTL) {
        return this.formulas.put(aSTElement, simpleLTL);
    }

    private SimpleLTL getFormula(ASTElement aSTElement) {
        return this.formulas.get(aSTElement);
    }

    private SimpleLTL convertTemporal(ExpressionTemporal expressionTemporal) throws PrismLangException {
        SimpleLTL simpleLTL = null;
        SimpleLTL simpleLTL2 = null;
        SimpleLTL simpleLTL3 = null;
        if (expressionTemporal.getOperand1() != null) {
            simpleLTL = this.convert(expressionTemporal.getOperand1());
        }
        if (expressionTemporal.getOperand2() != null) {
            simpleLTL2 = this.convert(expressionTemporal.getOperand2());
        }
        if (expressionTemporal.hasBounds()) {
            throw new PrismLangException("Can not convert expression with temporal bounds to SimpleLTL: " + String.valueOf(expressionTemporal));
        }
        switch (expressionTemporal.getOperator()) {
            case 1: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.NEXT, simpleLTL2);
                break;
            }
            case 2: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.UNTIL, simpleLTL, simpleLTL2);
                break;
            }
            case 3: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.FINALLY, simpleLTL2);
                break;
            }
            case 4: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.GLOBALLY, simpleLTL2);
                break;
            }
            case 5: 
            case 6: {
                Expression expression = expressionTemporal.convertToUntilForm();
                if (this.allowSharing) {
                    simpleLTL3 = this.getFormula(expression);
                }
                if (simpleLTL3 != null) break;
                simpleLTL3 = this.convert(expression);
                break;
            }
            default: {
                throw new PrismLangException("Cannot convert expression to jltl2ba form", expressionTemporal);
            }
        }
        return simpleLTL3;
    }

    private SimpleLTL convertBinaryOp(ExpressionBinaryOp expressionBinaryOp) throws PrismLangException {
        SimpleLTL simpleLTL = null;
        SimpleLTL simpleLTL2 = null;
        SimpleLTL simpleLTL3 = null;
        if (expressionBinaryOp.getOperand1() != null) {
            simpleLTL = this.convert(expressionBinaryOp.getOperand1());
        }
        if (expressionBinaryOp.getOperand2() != null) {
            simpleLTL2 = this.convert(expressionBinaryOp.getOperand2());
        }
        switch (expressionBinaryOp.getOperator()) {
            case 1: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.IMPLIES, simpleLTL, simpleLTL2);
                break;
            }
            case 2: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.EQUIV, simpleLTL, simpleLTL2);
                break;
            }
            case 3: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.OR, simpleLTL, simpleLTL2);
                break;
            }
            case 4: {
                simpleLTL3 = new SimpleLTL(SimpleLTL.LTLType.AND, simpleLTL, simpleLTL2);
                break;
            }
            default: {
                throw new PrismLangException("Cannot convert expression to jltl2ba form", expressionBinaryOp);
            }
        }
        return simpleLTL3;
    }

    private SimpleLTL convertUnaryOp(ExpressionUnaryOp expressionUnaryOp) throws PrismLangException {
        SimpleLTL simpleLTL = null;
        SimpleLTL simpleLTL2 = null;
        if (expressionUnaryOp.getOperand() != null) {
            simpleLTL = this.convert(expressionUnaryOp.getOperand());
        }
        switch (expressionUnaryOp.getOperator()) {
            case 1: {
                simpleLTL2 = new SimpleLTL(SimpleLTL.LTLType.NOT, simpleLTL);
                break;
            }
            case 3: {
                simpleLTL2 = simpleLTL;
                break;
            }
            default: {
                throw new PrismLangException("Cannot convert expression to jltl2ba form", expressionUnaryOp);
            }
        }
        return simpleLTL2;
    }

    private SimpleLTL convertLiteral(ExpressionLiteral expressionLiteral) throws PrismLangException {
        if (!(expressionLiteral.getType() instanceof TypeBool)) {
            throw new PrismLangException("Cannot convert expression to jltl2ba form", expressionLiteral);
        }
        return new SimpleLTL(expressionLiteral.evaluateBoolean());
    }

    private SimpleLTL convertLabel(ExpressionLabel expressionLabel) throws PrismLangException {
        return new SimpleLTL(expressionLabel.getName());
    }
}

