/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import acceptance.AcceptanceReach;
import acceptance.AcceptanceType;
import common.IntSet;
import common.IterableStateSet;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.DTMCModelChecker;
import explicit.IterationMethod;
import explicit.IterationMethodGS;
import explicit.IterationMethodPower;
import explicit.LTLModelChecker;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.PredecessorRelation;
import explicit.ProbModelChecker;
import explicit.StateValues;
import explicit.UDTMC;
import explicit.Utils;
import explicit.rewards.MCRewards;
import explicit.rewards.Rewards;
import java.util.BitSet;
import parser.ast.Expression;
import prism.AccuracyFactory;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismFileLog;
import prism.PrismLog;

public class UDTMCModelChecker
extends ProbModelChecker {
    protected DTMCModelChecker mcDTMC = new DTMCModelChecker(this);

    public UDTMCModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
        this.mcDTMC.inheritSettings(this);
    }

    @Override
    protected StateValues checkProbPathFormulaLTL(Model<?> model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object;
        BitSet bitSet2;
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        AcceptanceType[] acceptanceTypeArray = new AcceptanceType[]{AcceptanceType.RABIN, AcceptanceType.REACH, AcceptanceType.BUCHI, AcceptanceType.STREETT, AcceptanceType.GENERIC};
        LTLModelChecker.LTLProduct<UDTMC> lTLProduct = lTLModelChecker.constructDAProductForLTLFormula(this, (UDTMC)model, expression, bitSet, acceptanceTypeArray);
        this.doProductExports(lTLProduct);
        if (lTLProduct.getAcceptance() instanceof AcceptanceReach) {
            this.mainLog.println("\nSkipping BSCC computation since acceptance is defined via goal states...");
            bitSet2 = ((AcceptanceReach)lTLProduct.getAcceptance()).getGoalStates();
        } else {
            this.mainLog.println("\nFinding accepting BSCCs...");
            bitSet2 = lTLModelChecker.findAcceptingBSCCs((Model<?>)lTLProduct.getProductModel(), lTLProduct.getAcceptance());
        }
        this.mainLog.println("\nComputing reachability probabilities...");
        UDTMCModelChecker uDTMCModelChecker = new UDTMCModelChecker(this);
        uDTMCModelChecker.inheritSettings(this);
        ModelCheckerResult modelCheckerResult = uDTMCModelChecker.computeReachProbs((UDTMC)lTLProduct.getProductModel(), bitSet2, minMax);
        StateValues stateValues = StateValues.createFromArrayResult(modelCheckerResult, lTLProduct.getProductModel());
        if (this.getExportProductVector()) {
            this.mainLog.println("\nExporting product solution vector matrix to file \"" + this.getExportProductVectorFilename() + "\"...");
            object = new PrismFileLog(this.getExportProductVectorFilename());
            stateValues.print((PrismLog)object, false, false, false, false);
            ((PrismFileLog)object).close();
        }
        object = lTLProduct.projectToOriginalModel(stateValues);
        stateValues.clear();
        return object;
    }

    @Override
    protected StateValues checkRewardCoSafeLTL(Model<?> model, Rewards<?> rewards, Expression expression, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object;
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        LTLModelChecker.LTLProduct<UDTMC> lTLProduct = lTLModelChecker.constructDFAProductForCosafetyReward(this, (UDTMC)model, expression, bitSet);
        Rewards rewards2 = ((MCRewards)rewards).liftFromModel(lTLProduct);
        this.doProductExports(lTLProduct);
        BitSet bitSet2 = ((AcceptanceReach)lTLProduct.getAcceptance()).getGoalStates();
        this.mainLog.println("\nComputing reachability rewards...");
        UDTMCModelChecker uDTMCModelChecker = new UDTMCModelChecker(this);
        uDTMCModelChecker.inheritSettings(this);
        ModelCheckerResult modelCheckerResult = uDTMCModelChecker.computeReachRewards((UDTMC)lTLProduct.getProductModel(), (MCRewards<Double>)rewards2, bitSet2, minMax);
        StateValues stateValues = StateValues.createFromArrayResult(modelCheckerResult, lTLProduct.getProductModel());
        if (this.getExportProductVector()) {
            this.mainLog.println("\nExporting product solution vector matrix to file \"" + this.getExportProductVectorFilename() + "\"...");
            object = new PrismFileLog(this.getExportProductVectorFilename());
            stateValues.print((PrismLog)object, false, false, false, false);
            ((PrismFileLog)object).close();
        }
        object = lTLProduct.projectToOriginalModel(stateValues);
        stateValues.clear();
        return object;
    }

    public ModelCheckerResult computeNextProbs(UDTMC<Double> uDTMC, BitSet bitSet, MinMax minMax) throws PrismException {
        long l = System.currentTimeMillis();
        uDTMC.checkLowerBoundsArePositive();
        int n = uDTMC.getNumStates();
        FunctionalPrimitiveIterator.OfInt ofInt = new IterableStateSet(n).iterator();
        double[] dArray = Utils.bitsetToDoubleArray(bitSet, n);
        double[] dArray2 = new double[n];
        uDTMC.mvMultUnc(dArray, minMax, dArray2, ofInt);
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray2;
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.numIters = 1;
        l = System.currentTimeMillis() - l;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeBoundedReachProbs(UDTMC<Double> uDTMC, BitSet bitSet, int n, MinMax minMax) throws PrismException {
        return this.computeBoundedUntilProbs(uDTMC, null, bitSet, n, minMax);
    }

    public ModelCheckerResult computeBoundedUntilProbs(UDTMC<Double> uDTMC, BitSet bitSet, BitSet bitSet2, int n, MinMax minMax) throws PrismException {
        int n2;
        ModelCheckerResult modelCheckerResult = null;
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting bounded probabilistic reachability...");
        uDTMC.checkLowerBoundsArePositive();
        int n3 = uDTMC.getNumStates();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        for (int i = 0; i < n3; ++i) {
            dArray2[i] = bitSet2.get(i) ? 1.0 : 0.0;
            dArray[i] = dArray2[i];
        }
        BitSet bitSet3 = new BitSet();
        bitSet3.set(0, n3);
        bitSet3.andNot(bitSet2);
        if (bitSet != null) {
            bitSet3.and(bitSet);
        }
        IntSet intSet = IntSet.asIntSet(bitSet3);
        for (n2 = 0; n2 < n; ++n2) {
            uDTMC.mvMultUnc(dArray, minMax, dArray2, intSet.iterator());
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.print("Bounded probabilistic reachability");
        this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = dArray;
        modelCheckerResult.lastSoln = dArray2;
        modelCheckerResult.accuracy = AccuracyFactory.boundedNumericalIterations();
        modelCheckerResult.numIters = n2;
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        modelCheckerResult.timePre = 0.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachProbs(UDTMC<Double> uDTMC, BitSet bitSet, MinMax minMax) throws PrismException {
        return this.computeReachProbs(uDTMC, null, bitSet, minMax);
    }

    public ModelCheckerResult computeUntilProbs(UDTMC<Double> uDTMC, BitSet bitSet, BitSet bitSet2, MinMax minMax) throws PrismException {
        return this.computeReachProbs(uDTMC, bitSet, bitSet2, minMax);
    }

    public ModelCheckerResult computeReachProbs(UDTMC<Double> uDTMC, BitSet bitSet, BitSet bitSet2, MinMax minMax) throws PrismException {
        ModelCheckerResult modelCheckerResult;
        ProbModelChecker.IMDPSolnMethod iMDPSolnMethod = this.imdpSolnMethod;
        switch (iMDPSolnMethod) {
            case VALUE_ITERATION: 
            case GAUSS_SEIDEL: {
                break;
            }
            default: {
                iMDPSolnMethod = ProbModelChecker.IMDPSolnMethod.GAUSS_SEIDEL;
                this.mainLog.printWarning("Switching to solution method \"" + iMDPSolnMethod.fullName() + "\"");
            }
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting probabilistic reachability...");
        uDTMC.checkLowerBoundsArePositive();
        uDTMC.checkForDeadlocks(bitSet2);
        int n = uDTMC.getNumStates();
        PredecessorRelation predecessorRelation = null;
        if (this.precomp && (this.prob0 || this.prob1) && this.preRel) {
            predecessorRelation = uDTMC.getPredecessorRelation(this, true);
        }
        BitSet bitSet3 = this.precomp && this.prob0 ? (this.preRel ? this.mcDTMC.prob0(uDTMC, bitSet, bitSet2, predecessorRelation) : this.mcDTMC.prob0(uDTMC, bitSet, bitSet2)) : new BitSet();
        BitSet bitSet4 = this.precomp && this.prob1 ? (this.preRel ? this.mcDTMC.prob1(uDTMC, bitSet, bitSet2, predecessorRelation) : this.mcDTMC.prob1(uDTMC, bitSet, bitSet2)) : (BitSet)bitSet2.clone();
        int n2 = bitSet4.cardinality();
        int n3 = bitSet3.cardinality();
        this.mainLog.println("target=" + bitSet2.cardinality() + ", yes=" + n2 + ", no=" + n3 + ", maybe=" + (n - (n2 + n3)));
        l = System.currentTimeMillis();
        String string = minMax.isMinUnc() ? "min" : "max";
        this.mainLog.println("Starting value iteration (" + string + ")...");
        n = uDTMC.getNumStates();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = bitSet4.get(i) ? 1.0 : (bitSet3.get(i) ? 0.0 : 0.0);
        }
        BitSet bitSet5 = new BitSet();
        bitSet5.set(0, n);
        bitSet5.andNot(bitSet4);
        bitSet5.andNot(bitSet3);
        if (n2 + n3 < n) {
            IterationMethod iterationMethod = null;
            switch (iMDPSolnMethod) {
                case VALUE_ITERATION: {
                    iterationMethod = new IterationMethodPower(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam);
                    break;
                }
                case GAUSS_SEIDEL: {
                    iterationMethod = new IterationMethodGS(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam, false);
                    break;
                }
                default: {
                    throw new PrismException("Unknown solution method " + iMDPSolnMethod.fullName());
                }
            }
            IterationMethod.IterationValIter iterationValIter = iterationMethod.forMvMultMinMaxUnc(uDTMC, minMax);
            iterationValIter.init(dArray);
            IntSet intSet = IntSet.asIntSet(bitSet5);
            String string2 = string + ", with " + iterationMethod.getDescriptionShort();
            modelCheckerResult = iterationMethod.doValueIteration(this, string2, iterationValIter, intSet, l, null);
        } else {
            modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = Utils.bitsetToDoubleArray(bitSet4, n);
            modelCheckerResult.accuracy = AccuracyFactory.doublesFromQualitative();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Probabilistic reachability took " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewards(UDTMC<Double> uDTMC, MCRewards<Double> mCRewards, BitSet bitSet, MinMax minMax) throws PrismException {
        ModelCheckerResult modelCheckerResult;
        BitSet bitSet2;
        ProbModelChecker.IMDPSolnMethod iMDPSolnMethod = this.imdpSolnMethod;
        switch (iMDPSolnMethod) {
            case VALUE_ITERATION: 
            case GAUSS_SEIDEL: {
                break;
            }
            default: {
                iMDPSolnMethod = ProbModelChecker.IMDPSolnMethod.GAUSS_SEIDEL;
                this.mainLog.printWarning("Switching to solution method \"" + iMDPSolnMethod.fullName() + "\"");
            }
        }
        long l = System.currentTimeMillis();
        this.mainLog.println("\nStarting expected reachability...");
        uDTMC.checkLowerBoundsArePositive();
        uDTMC.checkForDeadlocks(bitSet);
        int n = uDTMC.getNumStates();
        if (this.preRel) {
            PredecessorRelation predecessorRelation = uDTMC.getPredecessorRelation(this, true);
            bitSet2 = this.mcDTMC.prob1(uDTMC, null, bitSet, predecessorRelation);
        } else {
            bitSet2 = this.mcDTMC.prob1(uDTMC, null, bitSet);
        }
        bitSet2.flip(0, n);
        int n2 = bitSet.cardinality();
        int n3 = bitSet2.cardinality();
        this.mainLog.println("target=" + n2 + ", inf=" + n3 + ", rest=" + (n - (n2 + n3)));
        l = System.currentTimeMillis();
        String string = minMax.isMinUnc() ? "min" : "max";
        this.mainLog.println("Starting value iteration (" + string + ")...");
        n = uDTMC.getNumStates();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = bitSet.get(i) ? 0.0 : (bitSet2.get(i) ? Double.POSITIVE_INFINITY : 0.0);
        }
        BitSet bitSet3 = new BitSet();
        bitSet3.set(0, n);
        bitSet3.andNot(bitSet);
        bitSet3.andNot(bitSet2);
        if (n2 + n3 < n) {
            IterationMethod iterationMethod = null;
            switch (iMDPSolnMethod) {
                case VALUE_ITERATION: {
                    iterationMethod = new IterationMethodPower(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam);
                    break;
                }
                case GAUSS_SEIDEL: {
                    iterationMethod = new IterationMethodGS(this.termCrit == ProbModelChecker.TermCrit.ABSOLUTE, this.termCritParam, false);
                    break;
                }
                default: {
                    throw new PrismException("Unknown solution method " + iMDPSolnMethod.fullName());
                }
            }
            IterationMethod.IterationValIter iterationValIter = iterationMethod.forMvMultRewMinMaxUnc(uDTMC, mCRewards, minMax);
            iterationValIter.init(dArray);
            IntSet intSet = IntSet.asIntSet(bitSet3);
            String string2 = string + ", with " + iterationMethod.getDescriptionShort();
            modelCheckerResult = iterationMethod.doValueIteration(this, string2, iterationValIter, intSet, l, null);
        } else {
            modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = Utils.bitsetToDoubleArray(bitSet2, n, Double.POSITIVE_INFINITY);
            modelCheckerResult.accuracy = AccuracyFactory.doublesFromQualitative();
        }
        l = System.currentTimeMillis() - l;
        this.mainLog.println("Probabilistic reachability took " + (double)l / 1000.0 + " seconds.");
        modelCheckerResult.timeTaken = (double)l / 1000.0;
        return modelCheckerResult;
    }
}

