/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import acceptance.AcceptanceReach;
import explicit.HyperplaneSelector;
import explicit.LTLModelChecker;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.MultiParameters;
import explicit.NondetModel;
import explicit.PPLSupport;
import explicit.Pareto;
import explicit.ProbModelChecker;
import explicit.SCCComputer;
import explicit.SCCConsumerStore;
import explicit.SMG;
import explicit.SMGSimple;
import explicit.STPG;
import explicit.STPGModelChecker;
import explicit.StateValues;
import explicit.rewards.Rewards;
import explicit.rewards.RewardsExplicit;
import explicit.rewards.RewardsSimple;
import explicit.rewards.STPGRewards;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.fraction.BigFraction;
import parma_polyhedra_library.C_Polyhedron;
import parma_polyhedra_library.Coefficient;
import parma_polyhedra_library.Constraint;
import parma_polyhedra_library.Constraint_System;
import parma_polyhedra_library.Generator;
import parma_polyhedra_library.Generator_System;
import parma_polyhedra_library.Generator_Type;
import parma_polyhedra_library.Linear_Expression;
import parma_polyhedra_library.Linear_Expression_Coefficient;
import parma_polyhedra_library.Linear_Expression_Sum;
import parma_polyhedra_library.Linear_Expression_Times;
import parma_polyhedra_library.Polyhedron;
import parma_polyhedra_library.Relation_Symbol;
import parma_polyhedra_library.Variable;
import parser.ast.Coalition;
import parser.ast.Expression;
import parser.ast.ExpressionConstant;
import parser.ast.ExpressionProb;
import parser.ast.ExpressionQuant;
import parser.ast.ExpressionReward;
import parser.ast.ExpressionTemporal;
import parser.ast.ExpressionVar;
import parser.ast.RelOp;
import parser.type.TypePareto;
import prism.ModelType;
import prism.OpRelOpBound;
import prism.PointList;
import prism.PrismComponent;
import prism.PrismException;
import prism.PrismLangException;
import prism.PrismUtils;
import strat.FMDStrategyProduct;
import strat.MDStrategy;
import strat.StochasticUpdateStrategy;
import strat.Strategy;

public class SMGModelChecker
extends ProbModelChecker {
    protected long maxCIter = 500L;
    protected int maxDIter = 100;
    protected int dIterOffset = 1;
    protected int maxRIter = 500;
    protected int minM = 2;
    protected int maxM = 16;
    protected double increase_factor = 1.01;
    protected long max_accuracy = 0x1FFFFFFFL;
    protected boolean gaussSeidel = true;
    protected boolean logCPareto = false;
    protected boolean logDPareto = false;
    protected boolean logRPareto = false;
    protected boolean logStrategy = false;
    protected double varepsilon = 1.0E-4;
    private List<String> strictToNonstrict = new ArrayList<String>();
    private List<String> unfolded = new ArrayList<String>();

    public SMGModelChecker(PrismComponent prismComponent) throws PrismException {
        super(prismComponent);
        if (this.settings != null) {
            this.varepsilon = this.settings.getDouble("prism.paretoEpsilon");
            if (this.varepsilon < 0.0) {
                throw new PrismException(String.format("Must have %s >= 0", this.settings.getSettingName("prism.paretoEpsilon")));
            }
            this.gaussSeidel = this.settings.getBoolean("prism.multiGaussSeidel");
            this.maxCIter = this.settings.getInteger("prism.multiMaxCIter");
            if (this.maxCIter < 1L) {
                throw new PrismException(String.format("Must have %s >= 1", this.settings.getSettingName("prism.multiMaxCIter")));
            }
            this.maxRIter = this.settings.getInteger("prism.multiMaxRIter");
            if (this.maxRIter < 1) {
                throw new PrismException(String.format("Must have %s >= 1", this.settings.getSettingName("prism.multiMaxRIter")));
            }
            this.maxDIter = this.settings.getInteger("prism.multiMaxDIter");
            if (this.maxDIter < 1) {
                throw new PrismException(String.format("Must have %s >= 1", this.settings.getSettingName("prism.multiMaxDIter")));
            }
            this.dIterOffset = this.settings.getInteger("prism.multiDIterOffset");
            if (this.dIterOffset < 1) {
                throw new PrismException(String.format("Must have %s >= 1", this.settings.getSettingName("prism.multiDIterOffset")));
            }
            this.minM = this.settings.getInteger("prism.multiMinM");
            this.maxM = this.settings.getInteger("prism.multiMaxM");
            if (this.maxM < this.minM || this.minM < 2) {
                throw new PrismException("Box size parameters invalid");
            }
            this.logCPareto = this.settings.getBoolean("log.multiCPareto");
            this.logDPareto = this.settings.getBoolean("log.multiDPareto");
            this.logRPareto = this.settings.getBoolean("log.multiRPareto");
            this.logStrategy = this.settings.getBoolean("log.multiStrategy");
            this.increase_factor = this.settings.getDouble("prism.increaseFactor");
            if (this.increase_factor < 1.0) {
                throw new PrismException(String.format("Must have %s >= 1", this.settings.getSettingName("prism.increaseFactor")));
            }
            this.max_accuracy = 0x1FFFFFFFL;
        }
    }

    @Override
    public StateValues checkExpressionMultiObjective(Model<?> model, List<List<Expression>> list, Coalition coalition) throws PrismException {
        PPLSupport.initPPL();
        MultiParameters multiParameters = this.initialiseRewards(model, list);
        return this.checkExpressionMultiDirect(model, multiParameters, coalition);
    }

    private boolean getMIC(SMG<Double> sMG, BitSet bitSet, int n) throws PrismException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isControllableMultichain(SMG<Double> sMG) throws PrismException {
        boolean bl;
        block13: {
            boolean bl2;
            int n = sMG.getNumStates();
            int n2 = sMG.getFirstInitialState();
            SCCConsumerStore sCCConsumerStore = new SCCConsumerStore();
            SCCComputer sCCComputer = SCCComputer.createSCCComputer(this, sMG, sCCConsumerStore);
            sCCComputer.computeSCCs();
            List<BitSet> list = sCCConsumerStore.getSCCs();
            BitSet bitSet = new BitSet();
            int n3 = list.size();
            for (int i = 0; i < n3; ++i) {
                bitSet.or(list.get(i));
            }
            HashSet<BitSet> hashSet = new HashSet<BitSet>();
            for (BitSet cloneable2 : list) {
                bl2 = false;
                BitSet n5 = new BitSet(n);
                BitSet bl3 = new BitSet(n);
                BitSet bitSet2 = new BitSet(n);
                for (int i = 0; i < n; ++i) {
                    if (!cloneable2.get(i) || sMG.getPlayer(i) != 0) continue;
                    bl2 = true;
                    n5.clear();
                    n5.set(i);
                    bl3.clear();
                    sMG.reachpositivestep(n5, false, true, bl3);
                    int n4 = bl3.nextSetBit(0);
                    while (n4 != -1) {
                        if (sMG.getPlayer(n4) != 0 && !bitSet2.get(n4)) {
                            BitSet n6 = this.getSubtree(sMG, n4, 1);
                            n6.set(i);
                            hashSet.add(n6);
                            bitSet2.or(n6);
                        }
                        n4 = bl3.nextSetBit(n4 + 1);
                    }
                }
                if (bl2) continue;
                hashSet.add(cloneable2);
            }
            bl = true;
            HashSet<BitSet> hashSet2 = new HashSet<BitSet>(hashSet.size());
            bl2 = false;
            int n5 = this.getVerbosity();
            boolean bl3 = this.genStrat;
            try {
                this.genStrat = false;
                this.setVerbosity(0);
                for (BitSet bitSet3 : hashSet) {
                    double[] dArray = this.createSTPGModelChecker().computeReachProbs(sMG, null, (BitSet)bitSet3, (boolean)false, (boolean)true, null, null).soln;
                    int n6 = bitSet.nextSetBit(0);
                    while (n6 != -1) {
                        if (!PrismUtils.doublesAreEqual(dArray[n6], 1.0)) {
                            if (!hashSet2.contains(bitSet3)) {
                                this.mainLog.print(String.format("Unreachable subtree: %s\n", bitSet3));
                            }
                            hashSet2.add(bitSet3);
                            bl = false;
                            if (!bl2) {
                                break block13;
                            }
                        }
                        n6 = bitSet.nextSetBit(n6 + 1);
                    }
                }
            }
            finally {
                this.genStrat = bl3;
                this.setVerbosity(n5);
            }
        }
        return bl;
    }

    public BitSet reachpositive(SMG<Double> sMG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2) {
        long l = System.currentTimeMillis();
        if (this.verbosity >= 1) {
            this.mainLog.println("Starting ReachPositive (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")...");
        }
        if (bitSet2.cardinality() == 0) {
            BitSet bitSet3 = new BitSet(sMG.getNumStates());
            return bitSet3;
        }
        int n = sMG.getNumStates();
        BitSet bitSet4 = new BitSet(n);
        BitSet bitSet5 = new BitSet(n);
        int n2 = 0;
        boolean bl3 = false;
        bitSet4.or(bitSet2);
        bitSet5.or(bitSet2);
        while (!bl3) {
            ++n2;
            sMG.reachpositivestep(bitSet4, bl, bl2, bitSet5);
            if (bitSet != null) {
                bitSet5.and(bitSet);
            }
            bl3 = bitSet5.equals(bitSet4);
            bitSet4.clear();
            bitSet4.or(bitSet5);
        }
        l = System.currentTimeMillis() - l;
        if (this.verbosity >= 1) {
            this.mainLog.print("ReachPositive (" + (bl ? "min" : "max") + (bl2 ? "min" : "max") + ")");
            this.mainLog.println(" took " + n2 + " iterations and " + (double)l / 1000.0 + " seconds.");
        }
        return bitSet4;
    }

    public BitSet getSubtree(STPG<Double> sTPG, int n, int n2) {
        int n3 = sTPG.getNumStates();
        BitSet bitSet = new BitSet(n3);
        BitSet bitSet2 = new BitSet(n3);
        boolean bl = false;
        bitSet.set(n);
        bitSet2.set(n);
        while (!bl) {
            ((SMGSimple)sTPG).subtreeStep(bitSet, n2, bitSet2);
            bl = bitSet2.equals(bitSet);
            bitSet.clear();
            bitSet.or(bitSet2);
        }
        return bitSet;
    }

    private MultiParameters initialiseRewards(Model<?> model, List<List<Expression>> list) throws PrismException {
        Object object;
        MultiParameters multiParameters = new MultiParameters();
        multiParameters.expr = list;
        multiParameters.rewards = new ArrayList<Rewards<Double>>();
        multiParameters.reward_names = new ArrayList<String>();
        multiParameters.divisors = new ArrayList<Rewards<Double>>();
        multiParameters.divisor_names = new ArrayList<String>();
        multiParameters.shifts = new ArrayList<Double>();
        multiParameters.reward_types = new ArrayList<Integer>();
        multiParameters.directions = new ArrayList<Integer>();
        multiParameters.expressions = new ArrayList<Expression>();
        multiParameters.bounds = new ArrayList<Double>();
        multiParameters.nested = new ArrayList<Boolean>();
        multiParameters.varepsilon = this.varepsilon;
        multiParameters.increase_factor = this.increase_factor;
        multiParameters.dIterOffset = this.dIterOffset;
        this.strictToNonstrict.clear();
        this.unfolded.clear();
        this.mainLog.print(String.format("expr: %s\n", list));
        int n = list.size();
        int[] nArray = new int[n];
        int n2 = 0;
        for (List<Expression> iterator : list) {
            nArray[n2] = iterator.size();
            int string = 0;
            for (Expression expression : iterator) {
                if (!(expression instanceof ExpressionQuant)) {
                    throw new PrismException("Only the R operator is supported.");
                }
                this.parseExpressionQuant(model, (ExpressionQuant)expression, multiParameters);
                multiParameters.expressions.add(expression);
                ++string;
            }
            ++n2;
        }
        if (this.strictToNonstrict.size() > 0) {
            object = "Strict inequalities ignored and turned into nonstrict inequalities:\n";
            for (String string : this.strictToNonstrict) {
                object = (String)object + String.format("\t%s\n", string);
            }
            this.mainLog.printWarning((String)object);
        }
        this.strictToNonstrict.clear();
        if (this.unfolded.size() > 0) {
            object = "Expressions not folded in Pareto set:\n";
            for (String string : this.unfolded) {
                object = (String)object + String.format("\t%s\n", string);
            }
            this.mainLog.printWarning((String)object);
        }
        this.unfolded.clear();
        multiParameters.CONJUNCTS = n;
        multiParameters.DISJUNCTS = nArray;
        multiParameters.maxCIter = this.maxCIter;
        multiParameters.maxDIter = this.maxDIter;
        multiParameters.maxRIter = this.maxRIter;
        multiParameters.rounding = this.settings.getBoolean("prism.multiRounding");
        multiParameters.baseline_accuracy = this.settings.getInteger("prism.baselineAccuracy");
        this.setObjectiveType(multiParameters);
        if (multiParameters.objective_type != 1) {
            if (multiParameters.objective_type == 2 || multiParameters.objective_type == 3) {
                this.mainLog.printWarning("Ensure that game is controllable multichain. Not tested.");
            } else if (multiParameters.objective_type == 4 || multiParameters.objective_type == 5) {
                if (!this.isConjunction(multiParameters)) {
                    throw new PrismException("Only conjunctions supported for satisfaction objectives");
                }
                if (this.computePareto) {
                    this.mainLog.printWarning("Ensure that game is controllable multichain. Not tested.");
                }
            } else if (multiParameters.objective_type == -1) {
                throw new PrismException("Cannot mix objective types");
            }
        }
        return multiParameters;
    }

    protected StateValues checkExpressionMultiDirect(Model<?> model, MultiParameters multiParameters, Coalition coalition) throws PrismException {
        return this.checkExpressionMultiDirect(model, multiParameters, coalition, false);
    }

    protected StateValues checkExpressionMultiDirect(Model<?> model, MultiParameters multiParameters, Coalition coalition, boolean bl) throws PrismException {
        int n = model.getFirstInitialState();
        this.mainLog.print(String.format("/////////////////   NEW (DIRECT) MODEL CHECKING TASK     /////////////////////\n", new Object[0]));
        this.mainLog.print(String.format("Property:\n\t%s\n\n", multiParameters.expr));
        this.mainLog.print(String.format("initial state: %d\n", n));
        this.mainLog.print(String.format("operation: %s\n", this.computePareto ? "Pareto set computation" : (this.genStrat ? "Strategy generation" : "Verification")));
        this.mainLog.flush();
        if (model.getModelType() != ModelType.SMG) {
            throw new PrismException("Only SMGs supported by multi-objective engine.");
        }
        if (model.getNumInitialStates() != 1) {
            throw new PrismException("Multi-objective engine supports only models with a single initial state.");
        }
        if (coalition != null) {
            ((SMG)model).setCoalition(coalition);
        } else {
            Coalition coalition2 = new Coalition();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("1");
            coalition2.setPlayers(arrayList);
            ((SMG)model).setCoalition(coalition2);
        }
        if (this.computePareto) {
            double d = System.nanoTime();
            this.setRewardBrackets(multiParameters, model);
            Object[] objectArray = this.computeRatioMQParetoSet((SMG)model, multiParameters);
            this.mainLog.print(String.format("Pareto set computation took %f s\n", ((double)System.nanoTime() - d) / 1.0E9));
            this.interiorPareto((Pareto[])objectArray);
            SMGModelChecker.turnParetoAndBounds((Pareto[])objectArray, multiParameters);
            this.pareto_set = objectArray[n];
            this.parsed_params = multiParameters;
            if (!bl) {
                PointList.addStoredPointList("M", new PointList(this.pareto_set, multiParameters.expressions, multiParameters.bounds));
            }
            this.mainLog.print("Resulting Pareto set:\n");
            PPLSupport.printReachabilityPolyhedron((Pareto[])objectArray, multiParameters.rewards.size(), n, this.mainLog);
            this.mainLog.flush();
            return StateValues.createFromObjectArray(TypePareto.getInstance(), objectArray, model);
        }
        double d = System.nanoTime();
        MultiParameters multiParameters2 = this.convertRatioMQToMQ((SMG)model, multiParameters);
        this.setRewardBrackets(multiParameters2, model);
        Map.Entry<StateValues, StochasticUpdateStrategy> entry = this.checkMQ((SMG)model, multiParameters2, this.genStrat);
        this.mainLog.print(String.format("%s took %f s\n", this.genStrat ? "Synthesis" : "Verification", ((double)System.nanoTime() - d) / 1.0E9));
        this.parsed_params = multiParameters;
        this.result.setStrategy(entry.getValue());
        this.mainLog.print(String.format("strategy: %s\n", this.result.getStrategy()));
        this.mainLog.flush();
        return entry.getKey();
    }

    private MultiParameters convertRatioMQToMQ(SMG<Double> sMG, MultiParameters multiParameters) throws PrismException {
        int n = sMG.getNumStates();
        int n2 = multiParameters.rewards.size();
        MultiParameters multiParameters2 = new MultiParameters();
        multiParameters2.shallow_copy(multiParameters);
        for (int i = 0; i < n2; ++i) {
            if (multiParameters2.reward_types.get(i) != 3 && multiParameters2.reward_types.get(i) != 5) continue;
            double d = multiParameters2.bounds.get(i);
            RewardsSimple<Double> rewardsSimple = new RewardsSimple<Double>(n);
            Rewards<Double> rewards = multiParameters.rewards.get(i);
            Rewards<Double> rewards2 = multiParameters.divisors.get(i);
            for (int j = 0; j < n; ++j) {
                rewardsSimple.setStateReward(j, rewards.getStateReward(j) - d * rewards2.getStateReward(j));
                for (int k = 0; k < sMG.getNumChoices(j); ++k) {
                    rewardsSimple.setTransitionReward(j, k, rewards.getTransitionReward(j, k) - d * rewards2.getTransitionReward(j, k));
                }
            }
            multiParameters2.rewards.set(i, rewardsSimple);
            multiParameters2.reward_types.set(i, 2);
            multiParameters2.divisors.set(i, null);
            multiParameters2.shifts.set(i, this.getShiftFromReward(sMG, rewardsSimple));
            multiParameters2.bounds.set(i, 0.0);
        }
        this.setObjectiveType(multiParameters2);
        return multiParameters2;
    }

    private void interiorPareto(Pareto[] paretoArray) {
        if (paretoArray == null) {
            return;
        }
        for (int i = 0; i < paretoArray.length; ++i) {
            paretoArray[i].interior(this.varepsilon);
        }
    }

    public static void turnParetoAndBounds(Pareto[] paretoArray, MultiParameters multiParameters) {
        int n;
        int n2 = multiParameters.rewards.size();
        if (paretoArray == null) {
            return;
        }
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        for (n = 0; n < n2; ++n) {
            if (multiParameters.directions.get(n) >= 0) continue;
            arrayList.add(new Variable((long)n));
            multiParameters.bounds.set(n, -multiParameters.bounds.get(n).doubleValue());
        }
        for (n = 0; n < paretoArray.length; ++n) {
            paretoArray[n].turn(arrayList);
        }
    }

    private void setRewardBrackets(MultiParameters multiParameters, Model<?> model) throws PrismException {
        int n = this.getVerbosity();
        boolean bl = this.genStrat;
        int n2 = model.getNumStates();
        int n3 = multiParameters.rewards.size();
        double[] dArray = multiParameters.rounding ? new double[n3] : null;
        double[] dArray2 = multiParameters.rounding ? new double[n3] : null;
        multiParameters.baseline_biggest_reward = dArray;
        multiParameters.baseline_smallest_reward = dArray2;
        multiParameters.no_union_with_previous = false;
        double[][] dArray3 = new double[n3][n2];
        multiParameters.MIN = dArray3;
        int n4 = 0;
        try {
            this.genStrat = false;
            this.setVerbosity(0);
            block13: for (n4 = 0; n4 < n3; ++n4) {
                Rewards<Double> rewards = multiParameters.rewards.get(n4);
                switch (multiParameters.reward_types.get(n4)) {
                    case 1: {
                        int n5;
                        int n6;
                        double[] dArray4 = null;
                        double[] dArray5 = null;
                        boolean bl2 = false;
                        block14: for (n6 = 0; n6 < n2; ++n6) {
                            if (rewards.getStateReward(n6) < 0.0) {
                                bl2 = true;
                                break;
                            }
                            for (n5 = 0; n5 < ((SMG)model).getNumChoices(n6); ++n5) {
                                if (!(rewards.getTransitionReward(n6, n5) < 0.0)) continue;
                                bl2 = true;
                                break block14;
                            }
                        }
                        if (bl2) {
                            try {
                                dArray5 = this.createSTPGModelChecker().computeReachRewardsValIter((STPG<Double>)((STPG)model), (STPGRewards<Double>)((STPGRewards)rewards), (BitSet)new BitSet((int)n2), (BitSet)new BitSet((int)n2), (boolean)true, (boolean)true, null, null).soln;
                            }
                            catch (PrismException prismException) {
                                if (this.computePareto) {
                                    dArray5 = new double[n2];
                                    for (n5 = 0; n5 < n2; ++n5) {
                                        dArray5[n5] = 0.0;
                                    }
                                    multiParameters.no_union_with_previous = true;
                                    this.mainLog.printWarning("Could not initialise value iteration, because the reward for objective " + n4 + " does not converge. Pareto set computation started at 0 and safety not guaranteed.");
                                }
                                throw prismException;
                            }
                        } else {
                            dArray5 = new double[n2];
                            for (n6 = 0; n6 < n2; ++n6) {
                                dArray5[n6] = 0.0;
                            }
                        }
                        if (multiParameters.rounding) {
                            double d = 1.0;
                            double d2 = 0.0;
                            try {
                                dArray4 = this.createSTPGModelChecker().computeReachRewardsValIter((STPG<Double>)((STPG)model), (STPGRewards<Double>)((STPGRewards)rewards), (BitSet)new BitSet((int)n2), (BitSet)new BitSet((int)n2), (boolean)false, (boolean)true, null, null).soln;
                                d = Double.NEGATIVE_INFINITY;
                                d2 = Double.POSITIVE_INFINITY;
                                for (int i = 0; i < n2; ++i) {
                                    if (d < dArray4[i]) {
                                        d = dArray4[i];
                                    }
                                    if (!(d2 > dArray5[i])) continue;
                                    d2 = dArray5[i];
                                }
                            }
                            catch (PrismException prismException) {
                                d = 1.0;
                                d2 = 0.0;
                                this.mainLog.printWarning("Could not initialise value iteration, because the reward for objective " + n4 + " does not converge. Rounding not sensitive to maximal rewards in the dimension " + n4 + ".");
                            }
                            dArray[n4] = d;
                            dArray2[n4] = d2;
                        }
                        System.arraycopy(dArray5, 0, dArray3[n4], 0, n2);
                        continue block13;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        if (!multiParameters.rounding) continue block13;
                        dArray[n4] = 100.0;
                        dArray2[n4] = 0.0;
                        continue block13;
                    }
                    default: {
                        throw new PrismException("Reward type not supported.");
                    }
                }
            }
        }
        catch (PrismException prismException) {
            throw new PrismException("Could not initialise value iteration, because the reward for objective " + n4 + " does not converge. Pareto set empty");
        }
        finally {
            this.genStrat = bl;
            this.setVerbosity(n);
        }
        double[] dArray6 = multiParameters.biggest_reward = multiParameters.rounding ? new double[multiParameters.CONJUNCTS] : null;
        if (multiParameters.rounding) {
            for (n4 = 0; n4 < multiParameters.CONJUNCTS; ++n4) {
                multiParameters.biggest_reward[n4] = Math.max(Math.abs(multiParameters.baseline_biggest_reward[n4]), Math.abs(multiParameters.baseline_smallest_reward[n4]));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseExpressionQuant(Model<?> model, ExpressionQuant expressionQuant, MultiParameters multiParameters) throws PrismException {
        boolean bl;
        ExpressionReward expressionReward = null;
        OpRelOpBound opRelOpBound = expressionQuant.getRelopBoundInfo(this.constantValues);
        if (expressionQuant instanceof ExpressionProb) {
            if (opRelOpBound.getBound() != 1.0) {
                throw new PrismLangException("Expression cannot occur in SMG multi-objective query", expressionQuant);
            }
            if (!(expressionQuant.getExpression() instanceof ExpressionReward) && ((ExpressionReward)expressionQuant.getExpression()).getModifier().equals("path")) {
                throw new PrismLangException("Expression cannot occur in SMG multi-objective query", expressionQuant);
            }
            expressionReward = (ExpressionReward)expressionQuant.getExpression();
            opRelOpBound = expressionReward.getRelopBoundInfo(this.constantValues);
            bl = true;
        } else {
            if (!(expressionQuant instanceof ExpressionReward)) throw new PrismLangException("Expression cannot occur in SMG multi-objective query", expressionQuant);
            expressionReward = (ExpressionReward)expressionQuant;
            bl = false;
        }
        multiParameters.nested.add(bl);
        int n = model.getNumStates();
        RelOp relOp = expressionReward.getRelOp();
        boolean bl2 = false;
        if (relOp == RelOp.LT || relOp == RelOp.GT) {
            this.strictToNonstrict.add(expressionReward.toString());
        } else if (relOp != RelOp.GEQ && relOp != RelOp.LEQ && relOp != RelOp.MIN && relOp != RelOp.MAX) {
            throw new PrismException("Only minimization or maximization supported.");
        }
        if (relOp == RelOp.LT || relOp == RelOp.LEQ || relOp == RelOp.MIN) {
            bl2 = true;
            multiParameters.directions.add(-1);
        } else {
            multiParameters.directions.add(1);
        }
        int n2 = expressionReward.getRewardStructIndexByIndexObject(this.rewardGen, this.constantValues);
        RewardsExplicit rewardsExplicit = (RewardsExplicit)this.constructExpectedRewards(model, n2);
        multiParameters.reward_names.add(expressionReward.getRewardStructIndex().toString());
        int n3 = expressionReward.getRewardStructDivIndexByIndexObject(this.rewardGen, this.constantValues);
        RewardsExplicit rewardsExplicit2 = n3 == -1 ? null : (RewardsExplicit)this.constructExpectedRewards(model, n3);
        multiParameters.divisor_names.add(n3 == -1 ? null : expressionReward.getRewardStructIndexDiv().toString());
        multiParameters.rewards.add(rewardsExplicit);
        multiParameters.divisors.add(rewardsExplicit2);
        Expression expression = expressionReward.getExpression();
        if (!(expression instanceof ExpressionTemporal)) throw new PrismException("Only temporal expressions supported in rewards so far.");
        switch (((ExpressionTemporal)expression).getOperator()) {
            case 11: {
                if (rewardsExplicit2 != null) throw new PrismException("Transient ratio rewards not supported");
                if (bl) {
                    throw new PrismException("Cannot nest total reward");
                }
                multiParameters.reward_types.add(1);
                break;
            }
            case 14: {
                if (rewardsExplicit2 == null) {
                    if (bl) {
                        multiParameters.reward_types.add(4);
                        break;
                    }
                    multiParameters.reward_types.add(2);
                    break;
                }
                if (bl) {
                    multiParameters.reward_types.add(5);
                    break;
                }
                multiParameters.reward_types.add(3);
                break;
            }
            default: {
                throw new PrismException("Only total, average and ratio rewards supported so far.");
            }
        }
        if (bl2) {
            for (int i = 0; i < n; ++i) {
                rewardsExplicit.setStateReward(i, -((Double)rewardsExplicit.getStateReward(i)).doubleValue());
                for (int j = 0; j < ((NondetModel)model).getNumChoices(i); ++j) {
                    rewardsExplicit.setTransitionReward(i, j, -((Double)rewardsExplicit.getTransitionReward(i, j)).doubleValue());
                }
            }
        }
        if (((ExpressionTemporal)expression).getOperator() == 14 && rewardsExplicit2 == null) {
            multiParameters.shifts.add(this.getShiftFromReward((SMG)model, rewardsExplicit));
        } else {
            multiParameters.shifts.add(0.0);
        }
        Expression expression2 = expressionReward.getReward();
        if (!(expression2 instanceof ExpressionVar) && !(expression2 instanceof ExpressionConstant) && this.computePareto) {
            this.unfolded.add(expressionReward.toString());
        }
        double d = 0.0;
        if (expression2 != null) {
            d = expression2.evaluateDouble(this.constantValues);
        } else if (relOp != RelOp.MIN && relOp != RelOp.MAX) {
            throw new PrismException("Reward bound required");
        }
        multiParameters.bounds.add(bl2 ? -d : d);
    }

    private double getShiftFromReward(Model<Double> model, Rewards<Double> rewards) {
        int n = ((SMG)model).getNumStates();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = rewards.getStateReward(i);
            if (d2 < 0.0 && d > d2) {
                d = d2;
            }
            for (int j = 0; j < ((NondetModel)model).getNumChoices(i); ++j) {
                d2 = rewards.getTransitionReward(i, j);
                if (!(d2 < 0.0) || !(d > d2)) continue;
                d = d2;
            }
        }
        return d;
    }

    protected StochasticUpdateStrategy constructStrategy(SMG<Double> sMG, List<Double> list, Pareto[] paretoArray, List<Pareto>[] listArray, MultiParameters multiParameters, boolean bl) throws PrismException {
        double[] dArray = new double[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            dArray[i] = list.get(i);
        }
        return new StochasticUpdateStrategy(sMG, dArray, paretoArray, listArray, multiParameters.rewards, multiParameters.biggest_reward, multiParameters.baseline_accuracy, true, multiParameters.rounding, bl ? this.varepsilon : 0.0, this.logStrategy, this.mainLog);
    }

    @Override
    protected StateValues checkProbPathFormulaCosafeLTL(Model<?> model, Expression expression, boolean bl, MinMax minMax, BitSet bitSet) throws PrismException {
        SMG sMG = (SMG)model;
        sMG.setCoalition(minMax.getCoalition());
        StateValues stateValues = this.createSTPGModelChecker().checkProbPathFormulaCosafeLTL(model, expression, bl, minMax, bitSet);
        sMG.setCoalition(null);
        return stateValues;
    }

    @Override
    protected StateValues checkRewardCoSafeLTL(Model<?> model, Rewards<?> rewards, Expression expression, MinMax minMax, BitSet bitSet) throws PrismException {
        Object object;
        LTLModelChecker lTLModelChecker = new LTLModelChecker(this);
        LTLModelChecker.LTLProduct<SMG> lTLProduct = lTLModelChecker.constructDFAProductForCosafetyReward(this, (SMG)model, expression, bitSet);
        Rewards<Double> rewards2 = rewards.liftFromModel(lTLProduct);
        this.doProductExports(lTLProduct);
        BitSet bitSet2 = ((AcceptanceReach)lTLProduct.getAcceptance()).getGoalStates();
        this.mainLog.println("\nComputing reachability rewards...");
        SMGModelChecker sMGModelChecker = new SMGModelChecker(this);
        sMGModelChecker.inheritSettings(this);
        ModelCheckerResult modelCheckerResult = sMGModelChecker.computeReachRewards((SMG)lTLProduct.getProductModel(), rewards2, bitSet2, 0, minMax.isMin1(), minMax.isMin2(), minMax.getCoalition());
        StateValues stateValues = StateValues.createFromArrayResult(modelCheckerResult, lTLProduct.getProductModel());
        if (modelCheckerResult.strat != null) {
            object = new FMDStrategyProduct(lTLProduct, (MDStrategy)modelCheckerResult.strat);
            this.result.setStrategy((Strategy<?>)object);
        }
        object = lTLProduct.projectToOriginalModel(stateValues);
        stateValues.clear();
        return object;
    }

    private MultiParameters convertRatioMQToRatioCQ(double[][] dArray, SMG<Double> sMG, MultiParameters multiParameters) throws PrismException {
        int n = sMG.getNumStates();
        MultiParameters multiParameters2 = new MultiParameters();
        multiParameters2.shallow_copy(multiParameters);
        ArrayList<Rewards<Double>> arrayList = new ArrayList<Rewards<Double>>();
        ArrayList<Rewards<Double>> arrayList2 = new ArrayList<Rewards<Double>>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        ArrayList<Double> arrayList4 = new ArrayList<Double>();
        ArrayList<Double> arrayList5 = new ArrayList<Double>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        multiParameters2.rewards = arrayList;
        multiParameters2.divisors = arrayList2;
        multiParameters2.reward_types = arrayList3;
        multiParameters2.bounds = arrayList5;
        multiParameters2.shifts = arrayList4;
        multiParameters.ji = arrayList6;
        double[] dArray2 = multiParameters.rounding ? new double[dArray.length] : null;
        double[] dArray3 = multiParameters.rounding ? new double[dArray.length] : null;
        multiParameters2.baseline_biggest_reward = dArray2;
        multiParameters2.baseline_smallest_reward = dArray3;
        double[] dArray4 = multiParameters.rounding ? new double[dArray.length] : null;
        multiParameters2.biggest_reward = dArray4;
        double[][] dArray5 = new double[dArray.length][n];
        multiParameters2.MIN = dArray5;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < multiParameters.CONJUNCTS; ++i) {
            int n4;
            int n5;
            RewardsSimple<Double> rewardsSimple;
            int n6;
            int n7 = -1;
            n2 = n3;
            for (n6 = 0; n6 < multiParameters.DISJUNCTS[i]; ++n6) {
                if (n7 < 0) {
                    n7 = multiParameters.reward_types.get(n2);
                } else if (n7 != multiParameters.reward_types.get(n2)) {
                    throw new PrismException("Cannot mix reward types within a disjunction");
                }
                ++n2;
            }
            arrayList3.add(n7);
            if (n7 == 3 || n7 == 5) {
                n6 = -1;
                for (int j = 0; j < multiParameters.DISJUNCTS[i]; ++j) {
                    if (!(Math.abs(dArray[i][j]) >= PrismUtils.epsilonDouble)) continue;
                    n6 = j;
                    break;
                }
                arrayList6.add(n6);
                if (n6 < 0) {
                    throw new PrismException("Weight vector for conjunct " + i + " is zero");
                }
                RewardsSimple<Double> rewardsSimple2 = new RewardsSimple<Double>(n);
                rewardsSimple = new RewardsSimple(n);
                for (n5 = 0; n5 < n; ++n5) {
                    Rewards<Double> rewards;
                    double d = 0.0;
                    n2 = n3;
                    Rewards<Double> rewards2 = null;
                    for (n4 = 0; n4 < multiParameters.DISJUNCTS[i]; ++n4) {
                        Rewards<Double> rewards3 = multiParameters.rewards.get(n2);
                        rewards = multiParameters.divisors.get(n2);
                        d += rewards3.getStateReward(n5) * dArray[i][n4];
                        if (n4 != n6) {
                            d -= rewards.getStateReward(n5) * dArray[i][n4];
                        } else {
                            rewards2 = rewards;
                        }
                        ++n2;
                    }
                    rewardsSimple2.setStateReward(n5, d);
                    rewardsSimple.setStateReward(n5, dArray[i][n6] * (Double)rewards2.getStateReward(n5));
                    for (n4 = 0; n4 < sMG.getNumChoices(n5); ++n4) {
                        d = 0.0;
                        n2 = n3;
                        rewards2 = null;
                        for (int j = 0; j < multiParameters.DISJUNCTS[i]; ++j) {
                            rewards = multiParameters.rewards.get(n2);
                            Rewards<Double> rewards4 = multiParameters.divisors.get(n2);
                            d += rewards.getTransitionReward(n5, n4) * dArray[i][j];
                            if (j != n6) {
                                d -= rewards4.getTransitionReward(n5, n4) * dArray[i][j];
                            } else {
                                rewards2 = rewards4;
                            }
                            ++n2;
                        }
                        rewardsSimple2.setTransitionReward(n5, n4, d);
                        rewardsSimple.setTransitionReward(n5, n4, dArray[i][n6] * rewards2.getTransitionReward(n5, n4));
                    }
                }
                arrayList5.add(0.0);
                arrayList.add(rewardsSimple2);
                arrayList2.add(rewardsSimple);
                arrayList4.add(0.0);
            } else {
                double d = 0.0;
                n2 = n3;
                for (int j = 0; j < multiParameters.DISJUNCTS[i]; ++j) {
                    d += multiParameters.bounds.get(n2) * dArray[i][j];
                    ++n2;
                }
                arrayList5.add(d);
                n2 = n3;
                rewardsSimple = new RewardsSimple<Double>(n);
                for (n5 = 0; n5 < n; ++n5) {
                    int n8;
                    double d2 = 0.0;
                    n2 = n3;
                    for (n8 = 0; n8 < multiParameters.DISJUNCTS[i]; ++n8) {
                        d2 += multiParameters.rewards.get(n2).getStateReward(n5) * dArray[i][n8];
                        ++n2;
                    }
                    rewardsSimple.setStateReward(n5, d2);
                    for (n8 = 0; n8 < sMG.getNumChoices(n5); ++n8) {
                        d2 = 0.0;
                        n2 = n3;
                        for (n4 = 0; n4 < multiParameters.DISJUNCTS[i]; ++n4) {
                            d2 += multiParameters.rewards.get(n2).getTransitionReward(n5, n8) * dArray[i][n4];
                            ++n2;
                        }
                        rewardsSimple.setTransitionReward(n5, n8, d2);
                    }
                }
                arrayList.add(rewardsSimple);
                if (n7 == 2) {
                    arrayList4.add(this.getShiftFromReward(sMG, rewardsSimple));
                } else {
                    arrayList4.add(0.0);
                }
                for (n5 = 0; n5 < n; ++n5) {
                    n2 = n3;
                    for (int j = 0; j < dArray[i].length; ++j) {
                        double[] dArray6 = dArray5[i];
                        int n9 = n5;
                        dArray6[n9] = dArray6[n9] + multiParameters.MIN[n2][n5] * dArray[i][j];
                        ++n2;
                    }
                }
                arrayList6.add(0);
            }
            if (multiParameters.rounding) {
                n2 = n3;
                for (int j = 0; j < dArray[i].length; ++j) {
                    int n10 = i;
                    dArray2[n10] = dArray2[n10] + multiParameters.baseline_biggest_reward[n2] * dArray[i][j];
                    int n11 = i;
                    dArray3[n11] = dArray3[n11] + multiParameters.baseline_smallest_reward[n2] * dArray[i][j];
                    ++n2;
                }
                dArray4[i] = Math.max(Math.abs(dArray2[i]), Math.abs(dArray3[i]));
            }
            n3 = n2;
        }
        multiParameters2.DISJUNCTS = new int[multiParameters2.CONJUNCTS];
        Arrays.fill(multiParameters2.DISJUNCTS, 1);
        return multiParameters2;
    }

    private Pareto[] convertCQParetoToMQPareto(double[][] dArray, SMG<Double> sMG, Pareto[] paretoArray, MultiParameters multiParameters) throws PrismException {
        int n = sMG.getNumStates();
        int n2 = multiParameters.rewards.size();
        long l = (long)(1.0 / PrismUtils.epsilonDouble);
        Pareto[] paretoArray2 = new Pareto[n];
        for (int i = 0; i < n; ++i) {
            for (Generator generator : paretoArray[i].get().generators()) {
                if (generator.type() != Generator_Type.POINT) continue;
                C_Polyhedron c_Polyhedron = null;
                Map<Integer, BigInteger> map = PPLSupport.getCoefficients(generator.linear_expression());
                int n3 = 0;
                for (int j = 0; j < dArray.length; ++j) {
                    BigInteger bigInteger;
                    BigInteger bigInteger2;
                    Object object = null;
                    for (int k = 0; k < dArray[j].length; ++k) {
                        bigInteger2 = BigInteger.valueOf((long)(dArray[j][k] * (double)l));
                        object = object != null ? new Linear_Expression_Sum((Linear_Expression)object, (Linear_Expression)new Linear_Expression_Times(new Coefficient(bigInteger2), new Variable((long)n3))) : new Linear_Expression_Times(new Coefficient(bigInteger2), new Variable((long)n3));
                        ++n3;
                    }
                    Linear_Expression_Times linear_Expression_Times = new Linear_Expression_Times(object, generator.divisor());
                    bigInteger2 = null;
                    BigInteger bigInteger3 = BigInteger.ZERO;
                    if (map.size() != 0 && map.get(j) != null) {
                        bigInteger3 = map.get(j);
                    }
                    if (multiParameters.reward_types.get(j) == 3 || multiParameters.reward_types.get(j) == 5) {
                        bigInteger = BigInteger.ZERO;
                        for (int k = 0; k < dArray[j].length; ++k) {
                            double d = dArray[j][k] * (double)l;
                            bigInteger = multiParameters.ji.get(j) == k ? bigInteger.add(bigInteger3.multiply(BigInteger.valueOf((long)d))) : bigInteger.add(BigInteger.valueOf((long)d).multiply(generator.divisor().getBigInteger()));
                        }
                        bigInteger2 = new Linear_Expression_Coefficient(new Coefficient(bigInteger));
                    } else {
                        bigInteger2 = new Linear_Expression_Coefficient(new Coefficient(bigInteger3.multiply(BigInteger.valueOf(l))));
                    }
                    bigInteger = new Constraint((Linear_Expression)linear_Expression_Times, Relation_Symbol.LESS_OR_EQUAL, (Linear_Expression)bigInteger2);
                    if (c_Polyhedron != null) {
                        c_Polyhedron.add_constraint((Constraint)bigInteger);
                        continue;
                    }
                    Constraint_System constraint_System = new Constraint_System();
                    constraint_System.add((Object)bigInteger);
                    c_Polyhedron = new C_Polyhedron(constraint_System);
                    c_Polyhedron.add_space_dimensions_and_embed((long)n2 - c_Polyhedron.space_dimension());
                }
                if (c_Polyhedron == null) {
                    throw new PrismException("Error in computing polyhedra from CQ evaluation");
                }
                if (paretoArray2[i] != null) {
                    paretoArray2[i].get().upper_bound_assign(c_Polyhedron);
                    continue;
                }
                paretoArray2[i] = new Pareto((Polyhedron)c_Polyhedron);
            }
        }
        return paretoArray2;
    }

    private boolean iterateMQParetoSet(double[][] dArray, SMG<Double> sMG, MultiParameters multiParameters, Pareto[] paretoArray, List<Pareto>[] listArray, boolean bl, boolean bl2, MultiParameters multiParameters2) throws PrismException {
        multiParameters2.shallow_copy(this.convertRatioMQToRatioCQ(dArray, sMG, multiParameters));
        boolean bl3 = this.computeCQParetoSet(sMG, multiParameters2, paretoArray, listArray, bl, bl2);
        if (this.logDPareto) {
            PPLSupport.printReachabilityPolyhedron(this.convertCQParetoToMQPareto(dArray, sMG, paretoArray, multiParameters), multiParameters.rewards.size(), sMG.getFirstInitialState(), this.mainLog);
        }
        return bl3;
    }

    private Pareto[] iterateRatioMQParetoSet(double[][] dArray, SMG<Double> sMG, MultiParameters multiParameters) throws PrismException {
        Pareto[] paretoArray = this.computeRatioCQParetoSet(sMG, this.convertRatioMQToRatioCQ(dArray, sMG, multiParameters));
        if (this.logRPareto) {
            PPLSupport.printReachabilityPolyhedron(paretoArray, multiParameters.CONJUNCTS, sMG.getFirstInitialState(), this.mainLog);
        }
        return this.convertCQParetoToMQPareto(dArray, sMG, paretoArray, multiParameters);
    }

    private void shiftRewards(Model<Double> model, MultiParameters multiParameters, boolean bl) {
        this.shiftRewards(model, multiParameters, false, bl);
    }

    private void shiftRewards(Model<Double> model, MultiParameters multiParameters, boolean bl, boolean bl2) {
        int n = model.getNumStates();
        Iterator<Double> iterator = multiParameters.shifts.iterator();
        int n2 = 0;
        for (Rewards<Double> rewards : multiParameters.rewards) {
            RewardsSimple rewardsSimple = (RewardsSimple)rewards;
            Double d = bl2 ? multiParameters.bounds.get(n2) : iterator.next();
            for (int i = 0; i < n; ++i) {
                rewardsSimple.setStateReward(i, bl ? (Double)rewardsSimple.getStateReward(i) + d : (Double)rewardsSimple.getStateReward(i) - d);
                for (int j = 0; j < ((NondetModel)model).getNumChoices(i); ++j) {
                    rewardsSimple.setTransitionReward(i, j, bl ? (Double)rewardsSimple.getTransitionReward(i, j) + d : (Double)rewardsSimple.getTransitionReward(i, j) - d);
                }
            }
            ++n2;
        }
    }

    private void shiftBounds(Model<Double> model, MultiParameters multiParameters, boolean bl, boolean bl2) {
        if (bl2) {
            return;
        }
        Iterator<Double> iterator = multiParameters.shifts.iterator();
        for (int i = 0; i < multiParameters.bounds.size(); ++i) {
            Double d = iterator.next();
            Double d2 = multiParameters.bounds.get(i);
            multiParameters.bounds.set(i, bl ? d2 + d : d2 - d);
        }
    }

    private void shiftPareto(SMG<Double> sMG, MultiParameters multiParameters, Pareto[] paretoArray) throws PrismException {
        int n;
        int n2 = sMG.getNumStates();
        int n3 = multiParameters.rewards.size();
        double[] dArray = new double[n3];
        for (n = 0; n < n3; ++n) {
            dArray[n] = multiParameters.shifts.get(n);
        }
        for (n = 0; n < n2; ++n) {
            paretoArray[n].replace(0, PPLSupport.add_rewards(paretoArray[n].get(), n, Integer.MIN_VALUE, null, dArray));
        }
    }

    private boolean isConjunction(MultiParameters multiParameters) {
        for (int i = 0; i < multiParameters.CONJUNCTS; ++i) {
            if (multiParameters.DISJUNCTS[i] == 1) continue;
            return false;
        }
        return true;
    }

    public Pareto[] computeRatioMQParetoSet(SMG<Double> sMG, MultiParameters multiParameters) throws PrismException {
        int n = sMG.getNumStates();
        if (multiParameters.maxCIter < 1L) {
            throw new PrismException("Iteration count for conjunctions has to be greater or equal to one.");
        }
        if (this.isConjunction(multiParameters)) {
            return this.computeRatioCQParetoSet(sMG, multiParameters);
        }
        Pareto[] paretoArray = new Pareto[n];
        for (int i = 0; i < n; ++i) {
            paretoArray[i] = new Pareto(multiParameters.maxDIter);
        }
        if (multiParameters.dIterOffset < 1) {
            throw new PrismException("Iteration offset for disjunctions has to be greater or equal to one");
        }
        if (multiParameters.maxDIter < 1) {
            throw new PrismException("Iteration count for disjunctions has to be greater or equal to one.");
        }
        HyperplaneSelector hyperplaneSelector = new HyperplaneSelector(multiParameters.CONJUNCTS, multiParameters.DISJUNCTS);
        for (int i = 1; i < multiParameters.maxDIter + multiParameters.dIterOffset; ++i) {
            double[][] dArray = hyperplaneSelector.next_hyperplane();
            if (i < multiParameters.dIterOffset) continue;
            if (this.logDPareto) {
                this.mainLog.print(String.format("D-ITER (%d/%d): x=%s\texclude=%s\n", i, multiParameters.maxDIter + multiParameters.dIterOffset, Arrays.deepToString((Object[])dArray), Arrays.toString(hyperplaneSelector.getExclude())));
            }
            Pareto[] paretoArray2 = this.iterateRatioMQParetoSet(dArray, sMG, multiParameters);
            if (this.logDPareto) {
                PPLSupport.printReachabilityPolyhedron(paretoArray2, multiParameters.rewards.size(), sMG.getFirstInitialState(), this.mainLog);
            }
            for (int j = 0; j < n; ++j) {
                paretoArray[j].add(paretoArray2[j]);
            }
        }
        return paretoArray;
    }

    private void setObjectiveType(MultiParameters multiParameters) throws PrismException {
        int n = -1;
        int n2 = 0;
        for (int i = 0; i < multiParameters.CONJUNCTS; ++i) {
            for (int j = 0; j < multiParameters.DISJUNCTS[i]; ++j) {
                if (n < 0) {
                    n = multiParameters.reward_types.get(n2);
                } else if (n != multiParameters.reward_types.get(n2)) {
                    multiParameters.objective_type = -1;
                    return;
                }
                ++n2;
            }
        }
        multiParameters.objective_type = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map.Entry<StateValues, StochasticUpdateStrategy> checkMQ(SMG<Double> sMG, MultiParameters multiParameters, boolean bl) throws PrismException {
        boolean bl2;
        int n = sMG.getNumStates();
        int n2 = sMG.getFirstInitialState();
        StateValues stateValues = null;
        StochasticUpdateStrategy stochasticUpdateStrategy = null;
        if (bl && multiParameters.objective_type < 0) {
            throw new PrismException("Strategy construction only available if all objectives are either expected cumulative total rewards, or expected cumulative ratio and expected average rewards");
        }
        boolean bl3 = multiParameters.objective_type == 2 || multiParameters.objective_type == 4;
        Pareto[] paretoArray = new Pareto[n];
        List[] listArray = bl ? new List[n] : null;
        List<Double> list = null;
        MultiParameters multiParameters2 = null;
        boolean bl4 = bl2 = multiParameters.objective_type == 1;
        if (multiParameters.maxCIter < 1L) {
            throw new PrismException("Iteration count for conjunctions has to be greater or equal to one.");
        }
        boolean bl5 = false;
        this.shiftRewards(sMG, multiParameters, false, bl3);
        this.shiftBounds(sMG, multiParameters, false, bl3);
        try {
            if (this.isConjunction(multiParameters)) {
                multiParameters.M = this.minM;
                do {
                    boolean bl6 = this.computeCQParetoSet(sMG, multiParameters, paretoArray, listArray, bl2, bl3);
                    if (bl3 && (paretoArray[n2].get().is_empty() || !bl6)) {
                        multiParameters.M *= multiParameters.M;
                        this.mainLog.print(String.format("Increasing M to %d\n", multiParameters.M));
                        continue;
                    }
                    if (bl3 && bl6) {
                        bl5 = true;
                        break;
                    }
                    if (!bl3) break;
                } while (multiParameters.M <= (long)this.maxM);
                multiParameters2 = multiParameters;
                list = bl3 ? this.initialCreditVector(paretoArray[n2]) : multiParameters2.bounds;
            } else {
                if (multiParameters.dIterOffset < 1) {
                    throw new PrismException("Iteration offset for disjunctions has to be greater or equal to zero");
                }
                if (multiParameters.maxDIter < 1) {
                    throw new PrismException("Iteration count for disjunctions has to be greater or equal to one.");
                }
                multiParameters.M = this.minM;
                do {
                    HyperplaneSelector hyperplaneSelector = new HyperplaneSelector(multiParameters.CONJUNCTS, multiParameters.DISJUNCTS);
                    multiParameters2 = new MultiParameters();
                    for (int i = 1; i < multiParameters.maxDIter + multiParameters.dIterOffset; ++i) {
                        double[][] dArray = hyperplaneSelector.next_hyperplane();
                        if (i < multiParameters.dIterOffset) continue;
                        if (this.logDPareto) {
                            this.mainLog.print(String.format("D-ITER (%d/%d): x=%s\n", i, multiParameters.maxDIter + multiParameters.dIterOffset, Arrays.deepToString((Object[])dArray)));
                        }
                        boolean bl7 = this.iterateMQParetoSet(dArray, sMG, multiParameters, paretoArray, listArray, bl2, bl3, multiParameters2);
                        List<Double> list2 = list = bl3 ? this.initialCreditVector(paretoArray[n2]) : multiParameters2.bounds;
                        if (this.logDPareto) {
                            PPLSupport.printReachabilityPolyhedron(paretoArray, multiParameters.CONJUNCTS, n2, this.mainLog);
                        }
                        if (bl3 && !bl7) continue;
                        if (this.logDPareto) {
                            this.mainLog.print(String.format("checking bounds %s on %d\n", list, n2));
                        }
                        if (!PPLSupport.checkBound(paretoArray[n2], list, multiParameters2)) continue;
                        bl5 = true;
                        break;
                    }
                    if (bl3 && !bl5) {
                        multiParameters.M *= multiParameters.M;
                        this.mainLog.print(String.format("Increasing M to %d\n", multiParameters.M));
                        continue;
                    }
                    if (bl3 && bl5 || !bl3) break;
                } while (multiParameters.M <= (long)this.maxM);
            }
            stateValues = list == null || bl3 && !bl5 ? StateValues.createFromBitSet(new BitSet(n), sMG) : StateValues.createFromBitSet(PPLSupport.checkBounds(paretoArray, list, multiParameters2), sMG);
            if (bl && stateValues.getBitSet().get(n2)) {
                double d = System.nanoTime();
                stochasticUpdateStrategy = this.constructStrategy(sMG, list, paretoArray, listArray, multiParameters2, bl3);
                this.mainLog.print(String.format("Strategy construction took %f s\n", ((double)System.nanoTime() - d) / 1.0E9));
            }
        }
        finally {
            this.shiftRewards(sMG, multiParameters, true, bl3);
            this.shiftBounds(sMG, multiParameters, true, bl3);
        }
        return new AbstractMap.SimpleEntry<StateValues, StochasticUpdateStrategy>(stateValues, stochasticUpdateStrategy);
    }

    private List<Double> initialCreditVector(Pareto pareto) throws PrismException {
        Generator_System generator_System = pareto.get().generators();
        for (int i = generator_System.size() - 1; i >= 0; --i) {
            Generator generator = (Generator)generator_System.get(i);
            if (generator.type() != Generator_Type.POINT) continue;
            List<Double> list = PPLSupport.getGeneratorAsVector(generator, (int)pareto.get().space_dimension());
            for (int j = 0; j < list.size(); ++j) {
                list.set(j, list.get(j) - this.varepsilon);
            }
            return list;
        }
        return null;
    }

    private Pareto[] initialiseCQParetoSet(int n, int n2, double[][] dArray) throws PrismException {
        Pareto[] paretoArray = new Pareto[n];
        for (int i = 0; i < n; ++i) {
            Generator_System generator_System = new Generator_System();
            double[] dArray2 = new double[n2];
            for (int j = 0; j < n2; ++j) {
                dArray2[j] = dArray[j][i];
                Linear_Expression_Times linear_Expression_Times = new Linear_Expression_Times(new Coefficient(BigInteger.ONE.negate()), new Variable((long)j));
                generator_System.add((Object)Generator.ray((Linear_Expression)linear_Expression_Times));
            }
            generator_System.add((Object)PPLSupport.generatorFromPoint(dArray2));
            C_Polyhedron c_Polyhedron = new C_Polyhedron(generator_System);
            paretoArray[i] = new Pareto((Polyhedron)c_Polyhedron);
        }
        return paretoArray;
    }

    public Pareto[] initialiseCQParetoSetPositive(int n, int n2, double[][] dArray) {
        Pareto[] paretoArray = new Pareto[n];
        for (int i = 0; i < n; ++i) {
            Generator_System generator_System = new Generator_System();
            for (int j = 0; j < n2; ++j) {
                BigFraction bigFraction = new BigFraction(dArray[j][i]);
                BigInteger bigInteger = bigFraction.getNumerator();
                BigInteger bigInteger2 = bigFraction.getDenominator();
                Linear_Expression_Times linear_Expression_Times = new Linear_Expression_Times(new Coefficient(bigInteger), new Variable((long)j));
                generator_System.add((Object)Generator.point((Linear_Expression)linear_Expression_Times, (Coefficient)new Coefficient(bigInteger2)));
                Linear_Expression_Times linear_Expression_Times2 = new Linear_Expression_Times(new Coefficient(BigInteger.ONE.negate()), new Variable((long)j));
                generator_System.add((Object)Generator.ray((Linear_Expression)linear_Expression_Times2));
            }
            C_Polyhedron c_Polyhedron = new C_Polyhedron(generator_System);
            paretoArray[i] = new Pareto((Polyhedron)c_Polyhedron);
        }
        return paretoArray;
    }

    private long increaseBaselineAccuracy(long l) {
        long l2 = this.increase_factor > 1.0 && (long)((double)l * this.increase_factor) <= l ? l + 1L : (long)((double)l * this.increase_factor);
        if (l2 < this.max_accuracy && l2 > 0L) {
            return l2;
        }
        return this.max_accuracy;
    }

    private MultiParameters convertRatioCQToCQ(SMG<Double> sMG, double[][] dArray, MultiParameters multiParameters) throws PrismException {
        int n = sMG.getNumStates();
        MultiParameters multiParameters2 = new MultiParameters();
        multiParameters2.shallow_copy(multiParameters);
        ArrayList<Rewards<Double>> arrayList = new ArrayList<Rewards<Double>>(multiParameters.CONJUNCTS);
        ArrayList<Rewards<Double>> arrayList2 = new ArrayList<Rewards<Double>>(multiParameters.CONJUNCTS);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(multiParameters.CONJUNCTS);
        ArrayList<Double> arrayList4 = new ArrayList<Double>(multiParameters.CONJUNCTS);
        ArrayList<Double> arrayList5 = new ArrayList<Double>(multiParameters.CONJUNCTS);
        multiParameters2.rewards = arrayList;
        multiParameters2.divisors = arrayList2;
        multiParameters2.reward_types = arrayList3;
        multiParameters2.bounds = arrayList5;
        multiParameters2.shifts = arrayList4;
        int n2 = 0;
        block4: for (int i = 0; i < multiParameters.CONJUNCTS; ++i) {
            switch (multiParameters.reward_types.get(i)) {
                case 1: 
                case 2: {
                    arrayList.add(multiParameters.rewards.get(i));
                    arrayList2.add(null);
                    arrayList3.add(multiParameters.reward_types.get(i));
                    arrayList5.add(multiParameters.bounds.get(i));
                    arrayList4.add(multiParameters.shifts.get(i));
                    continue block4;
                }
                case 3: 
                case 5: {
                    RewardsSimple<Double> rewardsSimple = new RewardsSimple<Double>(n);
                    Rewards<Double> rewards = multiParameters.rewards.get(i);
                    Rewards<Double> rewards2 = multiParameters.divisors.get(i);
                    for (int j = 0; j < n; ++j) {
                        rewardsSimple.setStateReward(j, dArray[n2][0] * rewards.getStateReward(j) - dArray[n2][1] * rewards2.getStateReward(j));
                        for (int k = 0; k < sMG.getNumChoices(j); ++k) {
                            rewardsSimple.setTransitionReward(j, k, dArray[n2][0] * rewards.getTransitionReward(j, k) - dArray[n2][1] * rewards2.getTransitionReward(j, k));
                        }
                    }
                    arrayList.add(rewardsSimple);
                    arrayList2.add(null);
                    arrayList3.add(2);
                    arrayList5.add(0.0);
                    arrayList4.add(this.getShiftFromReward(sMG, rewardsSimple));
                    ++n2;
                    continue block4;
                }
                default: {
                    throw new PrismException("Reward type not supported.");
                }
            }
        }
        this.setObjectiveType(multiParameters2);
        return multiParameters2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pareto[] computeRatioCQParetoSet(SMG<Double> sMG, MultiParameters multiParameters) throws PrismException {
        int n;
        int n2;
        int n3 = sMG.getNumStates();
        int n4 = sMG.getFirstInitialState();
        Pareto[] paretoArray = new Pareto[n3];
        int n5 = 0;
        for (Integer n6 : multiParameters.reward_types) {
            if (n6 != 3 && n6 != 5) continue;
            ++n5;
        }
        if (n5 == 0) {
            this.shiftRewards(sMG, multiParameters, false);
            try {
                this.computeCQParetoSet(sMG, multiParameters, paretoArray, null, false, false);
                this.shiftPareto(sMG, multiParameters, paretoArray);
                Pareto[] paretoArray2 = paretoArray;
                return paretoArray2;
            }
            finally {
                this.shiftRewards(sMG, multiParameters, true);
            }
        }
        double d = -100.0;
        double[] dArray = new double[n5];
        Arrays.fill(dArray, d);
        Generator_System[] generator_SystemArray = new Generator_System[n3];
        for (int i = 0; i < n3; ++i) {
            generator_SystemArray[i] = new Generator_System();
            for (n2 = 0; n2 < multiParameters.CONJUNCTS; ++n2) {
                generator_SystemArray[i].add((Object)Generator.ray((Linear_Expression)new Linear_Expression_Times(new Coefficient(BigInteger.ONE.negate()), new Variable((long)n2))));
            }
            generator_SystemArray[i].add((Object)PPLSupport.generatorFromPoint(dArray));
        }
        Generator_System generator_System = new Generator_System();
        for (n2 = 0; n2 < n5; ++n2) {
            generator_System.add((Object)Generator.ray((Linear_Expression)new Linear_Expression_Times(new Coefficient(BigInteger.ONE.negate()), new Variable((long)n2))));
        }
        generator_System.add((Object)PPLSupport.generatorFromPoint(dArray));
        C_Polyhedron c_Polyhedron = new C_Polyhedron(generator_System);
        HashSet<double[]> hashSet = new HashSet<double[]>();
        if (multiParameters.maxRIter < 1) {
            throw new PrismException("Iteration count for ratios has to be greater or equal to one.");
        }
        int[] nArray = new int[n5];
        Arrays.fill(nArray, 2);
        double[][] dArray2 = new double[n5][2];
        HyperplaneSelector hyperplaneSelector = new HyperplaneSelector(n5, nArray);
        block10: for (n = 0; n < multiParameters.maxRIter; ++n) {
            Integer n72;
            int n8;
            double[][] dArray3 = hyperplaneSelector.next_hyperplane();
            double d2 = hyperplaneSelector.getStart();
            for (n8 = 0; n8 < n5; ++n8) {
                dArray2[n8][0] = dArray3[n8][0] + dArray3[n8][1] - (1.0 - d2);
                dArray2[n8][1] = dArray3[n8][0] - dArray3[n8][1];
            }
            n8 = 0;
            double[] dArray4 = new double[n5];
            for (Integer n72 : multiParameters.reward_types) {
                if (n72 != 3 && n72 != 5) continue;
                if (Math.abs(dArray2[n8][0]) < PrismUtils.epsilonDouble) {
                    --n;
                    continue block10;
                }
                dArray4[n8] = dArray2[n8][1] / dArray2[n8][0];
                ++n8;
            }
            Generator_System generator_System2 = new Generator_System();
            generator_System2.add((Object)PPLSupport.generatorFromPoint(dArray4));
            n72 = new C_Polyhedron(generator_System2);
            if (c_Polyhedron.contains((Polyhedron)n72)) continue;
            block13: for (Object[] objectArray : hashSet) {
                for (n8 = 0; n8 < n5; ++n8) {
                    if (dArray4[n8] < objectArray[n8]) continue block13;
                }
                continue block10;
            }
            MultiParameters multiParameters2 = this.convertRatioCQToCQ(sMG, dArray2, multiParameters);
            this.shiftRewards(sMG, multiParameters2, false);
            try {
                Object[] objectArray;
                objectArray = new Pareto[n3];
                this.computeCQParetoSet(sMG, multiParameters2, (Pareto[])objectArray, null, false, false);
                this.shiftPareto(sMG, multiParameters2, (Pareto[])objectArray);
                if (this.logRPareto) {
                    this.mainLog.print(String.format("QX[%d/%d](%s):", n, multiParameters.maxRIter, Arrays.toString(dArray4)));
                    PPLSupport.printReachabilityPolyhedron((Pareto[])objectArray, multiParameters.CONJUNCTS, n4, this.mainLog);
                }
                for (int i = 0; i < n3; ++i) {
                    boolean bl = false;
                    block16: for (Generator generator : objectArray[i].get().generators()) {
                        if (generator.type() != Generator_Type.POINT) continue;
                        Map<Integer, BigInteger> map = PPLSupport.getCoefficients(generator.linear_expression());
                        int n9 = 0;
                        n8 = 0;
                        double[] dArray5 = new double[multiParameters.CONJUNCTS];
                        for (Integer n10 : multiParameters.reward_types) {
                            double d3;
                            double d4 = d3 = map.get(n8) == null ? 0.0 : map.get(n8).doubleValue();
                            if (n10 == 3 || n10 == 5) {
                                if (d3 < 0.0) continue block16;
                                dArray5[n8] = dArray4[n9];
                                ++n9;
                            } else {
                                dArray5[n8] = d3 / generator.divisor().getBigInteger().doubleValue();
                            }
                            ++n8;
                        }
                        if (i == n4) {
                            bl = true;
                        }
                        generator_SystemArray[i].add((Object)PPLSupport.generatorFromPoint(dArray5));
                    }
                    if (i == n4 && bl) {
                        c_Polyhedron.add_generator(PPLSupport.generatorFromPoint(dArray4));
                        if (!this.logRPareto) continue;
                        this.mainLog.print(String.format("R-ITER[%d/%d]: lambda=%s\n", n + 1, multiParameters.maxRIter, Arrays.toString(dArray4)));
                        continue;
                    }
                    if (i != n4) continue;
                    hashSet.add(dArray4);
                }
                continue;
            }
            finally {
                this.shiftRewards(sMG, multiParameters2, true);
            }
        }
        for (n = 0; n < n3; ++n) {
            paretoArray[n] = new Pareto((Polyhedron)new C_Polyhedron(generator_SystemArray[n]));
        }
        return paretoArray;
    }

    public boolean computeCQParetoSet(SMG<Double> sMG, MultiParameters multiParameters, Pareto[] paretoArray, List<Pareto>[] listArray, boolean bl, boolean bl2) throws PrismException {
        int n;
        int n2 = sMG.getNumStates();
        int n3 = multiParameters.rewards.size();
        int n4 = sMG.getFirstInitialState();
        if (n3 == 1 && !bl2 && !bl) {
            double[] dArray = new double[n2];
            double[] dArray2 = new double[n2];
            BitSet bitSet = new BitSet();
            bitSet.set(0, n2);
            int n5 = 0;
            while ((long)n5 < multiParameters.maxCIter) {
                sMG.mvMultRewMinMax(dArray, (STPGRewards)multiParameters.rewards.get(0), false, true, dArray2, bitSet, false, null, 1.0);
                double[] dArray3 = dArray;
                dArray = dArray2;
                dArray2 = dArray3;
                ++n5;
            }
            if (multiParameters.objective_type == 2) {
                n5 = 0;
                while (n5 < n2) {
                    int n6 = n5++;
                    dArray[n6] = dArray[n6] / (double)(2L * multiParameters.maxCIter);
                }
            }
            double[][] dArrayArray = new double[][]{dArray};
            Pareto[] paretoArray2 = this.initialiseCQParetoSet(n2, 1, dArrayArray);
            System.arraycopy(paretoArray2, 0, paretoArray, 0, paretoArray2.length);
            return true;
        }
        boolean bl3 = this.gaussSeidel && (multiParameters.objective_type == 1 || bl2);
        Pareto[] paretoArray3 = this.initialiseCQParetoSet(n2, n3, multiParameters.MIN);
        int[] nArray = new int[n3];
        Arrays.fill(nArray, 1);
        double[] dArray = new double[n3];
        double[] dArray4 = new double[n3];
        for (n = 0; n < n3; ++n) {
            dArray4[n] = multiParameters.bounds.get(n) - multiParameters.shifts.get(n);
        }
        n = 0;
        long l = multiParameters.baseline_accuracy;
        int n7 = 0;
        while ((long)n7 < multiParameters.maxCIter) {
            if (this.logCPareto) {
                this.mainLog.print(String.format("C-ITER %d/%s, %s", n7 + 1, multiParameters.maxCIter, multiParameters.rounding ? String.format("acc = %d, ", l) : ""));
            }
            this.mainLog.flush();
            for (int i = 0; i < n3; ++i) {
                if (!bl2 && multiParameters.reward_types.get(i) == 2) {
                    nArray[i] = (n7 + 1) * 2;
                    dArray[i] = dArray4[i] * (double)((n7 + 1) * 2);
                    continue;
                }
                dArray[i] = dArray4[i];
            }
            Pareto[] paretoArray4 = sMG.pMultiObjective(paretoArray3, multiParameters.rewards, bl3, l, multiParameters.biggest_reward, listArray, multiParameters.rounding, !multiParameters.no_union_with_previous & !bl2, bl2, multiParameters.M);
            System.arraycopy(paretoArray4, 0, paretoArray, 0, paretoArray4.length);
            if (this.logCPareto) {
                PPLSupport.printReachabilityPolyhedron(paretoArray, multiParameters.CONJUNCTS, n4, this.mainLog);
            }
            if (this.convergeNorm(paretoArray, paretoArray3, n3, nArray, bl2, n4)) {
                if (this.logCPareto) {
                    this.mainLog.print("CQ value iteration converged.\n");
                }
                n = 1;
                break;
            }
            if (bl && !bl2 && PPLSupport.checkBound(paretoArray[n4], dArray, multiParameters)) break;
            l = this.increaseBaselineAccuracy(l);
            System.arraycopy(paretoArray, 0, paretoArray3, 0, paretoArray.length);
            ++n7;
        }
        if (!bl2) {
            double[] dArray5 = new double[n3];
            Arrays.fill(dArray5, 1.0);
            for (int i = 0; i < n3; ++i) {
                if (multiParameters.reward_types.get(i) != 2) continue;
                dArray5[i] = 1.0 / (double)nArray[i];
            }
            PPLSupport.discountPareto(paretoArray, dArray5);
            PPLSupport.discountPareto(listArray, dArray5);
        }
        return n != 0;
    }

    private boolean convergeNorm(Pareto[] paretoArray, Pareto[] paretoArray2, int n, int[] nArray, boolean bl, int n2) throws PrismException {
        for (int i = 0; i < paretoArray.length; ++i) {
            BigInteger bigInteger;
            BigInteger bigInteger2;
            BigFraction bigFraction;
            Generator_System generator_System;
            C_Polyhedron c_Polyhedron = new C_Polyhedron((C_Polyhedron)paretoArray[i].get());
            C_Polyhedron c_Polyhedron2 = new C_Polyhedron((C_Polyhedron)paretoArray2[i].get());
            for (int j = 0; j < n; ++j) {
                if (nArray[j] <= 1) continue;
                generator_System = new Variable((long)j);
                bigFraction = new Linear_Expression_Times(new Coefficient(1), (Variable)generator_System);
                bigInteger2 = new Coefficient(nArray[j]);
                bigInteger = new Coefficient(nArray[j] - 1);
                c_Polyhedron.affine_image((Variable)generator_System, (Linear_Expression)bigFraction, (Coefficient)bigInteger2);
                c_Polyhedron2.affine_image((Variable)generator_System, (Linear_Expression)bigFraction, (Coefficient)bigInteger);
            }
            if (!c_Polyhedron.contains((Polyhedron)c_Polyhedron2)) {
                C_Polyhedron c_Polyhedron3 = new C_Polyhedron(c_Polyhedron2.generators());
                c_Polyhedron2.intersection_assign((Polyhedron)c_Polyhedron);
                c_Polyhedron.upper_bound_assign((Polyhedron)c_Polyhedron3);
            }
            generator_System = new Generator_System();
            bigFraction = new BigFraction(this.varepsilon);
            bigInteger2 = bigFraction.getNumerator();
            bigInteger = bigFraction.getDenominator();
            Linear_Expression_Times linear_Expression_Times = new Linear_Expression_Times(new Coefficient(bigInteger2), new Variable(0L));
            Coefficient coefficient = new Coefficient(bigInteger);
            for (int j = 1; j < n; ++j) {
                linear_Expression_Times = new Linear_Expression_Sum((Linear_Expression)linear_Expression_Times, (Linear_Expression)new Linear_Expression_Times(new Coefficient(bigInteger2), new Variable((long)j)));
            }
            for (Generator generator : c_Polyhedron2.generators()) {
                if (generator.type() == Generator_Type.POINT) {
                    Linear_Expression_Sum linear_Expression_Sum = new Linear_Expression_Sum(linear_Expression_Times.times(generator.divisor()), generator.linear_expression().times(coefficient));
                    Coefficient coefficient2 = new Coefficient(generator.divisor().getBigInteger().multiply(coefficient.getBigInteger()));
                    generator_System.add((Object)Generator.point((Linear_Expression)linear_Expression_Sum, (Coefficient)coefficient2));
                    continue;
                }
                generator_System.add((Object)generator);
            }
            C_Polyhedron c_Polyhedron4 = new C_Polyhedron(generator_System);
            if (c_Polyhedron.is_empty()) continue;
            if (c_Polyhedron4.is_empty() && !c_Polyhedron.is_empty()) {
                return false;
            }
            if (c_Polyhedron4.is_empty() || c_Polyhedron4.contains((Polyhedron)c_Polyhedron)) continue;
            return false;
        }
        return true;
    }

    public ModelCheckerResult computeNextProbs(SMG<Double> sMG, BitSet bitSet, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        sMG.setCoalition(coalition);
        ModelCheckerResult modelCheckerResult = this.createSTPGModelChecker().computeNextProbs(sMG, bitSet, bl, bl2);
        sMG.setCoalition(null);
        return modelCheckerResult;
    }

    public ModelCheckerResult computeBoundedUntilProbs(SMG<Double> sMG, BitSet bitSet, BitSet bitSet2, int n, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        sMG.setCoalition(coalition);
        ModelCheckerResult modelCheckerResult = this.createSTPGModelChecker().computeBoundedUntilProbs(sMG, bitSet, bitSet2, n, bl, bl2);
        sMG.setCoalition(null);
        return modelCheckerResult;
    }

    public ModelCheckerResult computeUntilProbs(SMG<Double> sMG, BitSet bitSet, BitSet bitSet2, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        sMG.setCoalition(coalition);
        ModelCheckerResult modelCheckerResult = this.createSTPGModelChecker().computeUntilProbs(sMG, bitSet, bitSet2, bl, bl2, -1.0);
        sMG.setCoalition(null);
        return modelCheckerResult;
    }

    public ModelCheckerResult computeReachRewards(SMG<Double> sMG, Rewards<Double> rewards, BitSet bitSet, int n, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        sMG.setCoalition(coalition);
        ModelCheckerResult modelCheckerResult = this.createSTPGModelChecker().computeReachRewards(sMG, (STPGRewards)rewards, bitSet, bl, bl2, null, null, n);
        sMG.setCoalition(null);
        return modelCheckerResult;
    }

    public ModelCheckerResult computeInstantaneousRewards(SMG<Double> sMG, Rewards<Double> rewards, int n, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        sMG.setCoalition(coalition);
        ModelCheckerResult modelCheckerResult = this.createSTPGModelChecker().computeInstantaneousRewards(sMG, (STPGRewards)rewards, n, bl, bl2);
        sMG.setCoalition(null);
        return modelCheckerResult;
    }

    public ModelCheckerResult computeCumulativeRewards(SMG<Double> sMG, Rewards<Double> rewards, int n, boolean bl, boolean bl2, Coalition coalition) throws PrismException {
        sMG.setCoalition(coalition);
        ModelCheckerResult modelCheckerResult = this.createSTPGModelChecker().computeCumulativeRewards(sMG, (STPGRewards)rewards, n, bl, bl2);
        sMG.setCoalition(null);
        return modelCheckerResult;
    }

    private STPGModelChecker createSTPGModelChecker() throws PrismException {
        STPGModelChecker sTPGModelChecker = new STPGModelChecker(this);
        sTPGModelChecker.inheritSettings(this);
        return sTPGModelChecker;
    }
}

