/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.fraction.BigFraction;
import parma_polyhedra_library.C_Polyhedron;
import parma_polyhedra_library.Coefficient;
import parma_polyhedra_library.Generator;
import parma_polyhedra_library.Generator_System;
import parma_polyhedra_library.Generator_Type;
import parma_polyhedra_library.Linear_Expression;
import parma_polyhedra_library.Linear_Expression_Sum;
import parma_polyhedra_library.Linear_Expression_Times;
import parma_polyhedra_library.Linear_Expression_Variable;
import parma_polyhedra_library.Polyhedron;
import parma_polyhedra_library.Variable;
import prism.PrismException;

public class Pareto {
    private List<Polyhedron> sets;

    public Pareto() {
        this.sets = new ArrayList<Polyhedron>();
    }

    public Pareto(int n) {
        this.sets = new ArrayList<Polyhedron>(n);
    }

    public Pareto(Pareto pareto) {
        this.sets = new ArrayList<Polyhedron>(pareto.size());
        for (Polyhedron polyhedron : pareto.getSets()) {
            if (polyhedron.is_empty()) continue;
            this.sets.add((Polyhedron)new C_Polyhedron((C_Polyhedron)polyhedron));
        }
    }

    public Pareto(Polyhedron polyhedron) {
        this(1);
        this.add(polyhedron);
    }

    public Pareto(List<Polyhedron> list) {
        this.sets = new ArrayList<Polyhedron>(list.size());
        for (Polyhedron polyhedron : list) {
            this.sets.add((Polyhedron)new C_Polyhedron((C_Polyhedron)polyhedron));
        }
    }

    public void replace(int n, Polyhedron polyhedron) {
        this.sets.set(n, polyhedron);
    }

    public void add(Pareto pareto) {
        for (Polyhedron polyhedron : pareto.getSets()) {
            this.add(polyhedron);
        }
    }

    public long getDimension() {
        return this.sets.get(0).space_dimension();
    }

    public void add(Polyhedron polyhedron) {
        ArrayList<Polyhedron> arrayList = new ArrayList<Polyhedron>();
        arrayList.clear();
        for (Polyhedron polyhedron2 : this.sets) {
            if (polyhedron2.contains(polyhedron)) {
                return;
            }
            if (!polyhedron.contains(polyhedron2)) continue;
            arrayList.add(polyhedron2);
        }
        this.sets.removeAll(arrayList);
        this.sets.add(polyhedron);
    }

    public void interior(double d) {
        if (d < 0.0) {
            return;
        }
        Pareto pareto = new Pareto(this.sets.size());
        for (Polyhedron polyhedron : this.sets) {
            long l = polyhedron.space_dimension();
            Generator_System generator_System = new Generator_System();
            BigFraction bigFraction = new BigFraction(-d);
            BigInteger bigInteger = bigFraction.getNumerator();
            BigInteger bigInteger2 = bigFraction.getDenominator();
            Linear_Expression_Times linear_Expression_Times = new Linear_Expression_Times(new Coefficient(bigInteger), new Variable(0L));
            Coefficient coefficient = new Coefficient(bigInteger2);
            int n = 1;
            while ((long)n < l) {
                linear_Expression_Times = new Linear_Expression_Sum((Linear_Expression)linear_Expression_Times, (Linear_Expression)new Linear_Expression_Times(new Coefficient(bigInteger), new Variable((long)n)));
                ++n;
            }
            for (Generator generator : polyhedron.generators()) {
                if (generator.type() == Generator_Type.POINT) {
                    Linear_Expression_Sum linear_Expression_Sum = new Linear_Expression_Sum(linear_Expression_Times.times(generator.divisor()), generator.linear_expression().times(coefficient));
                    Coefficient coefficient2 = new Coefficient(generator.divisor().getBigInteger().multiply(coefficient.getBigInteger()));
                    generator_System.add((Object)Generator.point((Linear_Expression)linear_Expression_Sum, (Coefficient)coefficient2));
                    continue;
                }
                generator_System.add((Object)generator);
            }
            pareto.sets.add((Polyhedron)new C_Polyhedron(generator_System));
        }
        this.sets = pareto.getSets();
    }

    public void turn(List<Variable> list) {
        this.sets = this.turned(list).getSets();
    }

    public Pareto turned(List<Variable> list) {
        Pareto pareto = new Pareto(this.sets.size());
        for (Polyhedron polyhedron : this.sets) {
            C_Polyhedron c_Polyhedron = new C_Polyhedron(polyhedron.generators());
            for (Variable variable : list) {
                c_Polyhedron.affine_image(variable, (Linear_Expression)new Linear_Expression_Variable(variable), new Coefficient(-1));
            }
            pareto.sets.add((Polyhedron)c_Polyhedron);
        }
        return pareto;
    }

    public Polyhedron get() throws PrismException {
        if (this.sets.size() == 1) {
            return this.sets.get(0);
        }
        throw new PrismException("Pareto set does not consist of a single Polyhedron");
    }

    public Polyhedron get(int n) {
        return this.sets.get(n);
    }

    public List<Polyhedron> getSets() {
        return this.sets;
    }

    public int size() {
        return this.sets.size();
    }

    public boolean isConvex() {
        return this.sets.size() <= 1;
    }
}

