/*
 * Decompiled with CFR 0.152.
 */
package explicit;

import common.IntSet;
import common.PeriodicTimer;
import common.iterable.FunctionalPrimitiveIterator;
import explicit.DTMC;
import explicit.ExportIterations;
import explicit.MDP;
import explicit.MinMax;
import explicit.Model;
import explicit.ModelCheckerResult;
import explicit.ProbModelChecker;
import explicit.SCCInfo;
import explicit.UDTMC;
import explicit.UMDP;
import explicit.rewards.MCRewards;
import explicit.rewards.MDPRewards;
import java.util.PrimitiveIterator;
import prism.AccuracyFactory;
import prism.OptionsIntervalIteration;
import prism.PrismException;
import prism.PrismUtils;

public abstract class IterationMethod {
    public static final int LOGGING_PRECISION = 12;
    protected final boolean absolute;
    protected final double termCritParam;

    protected IterationMethod(boolean bl, double d) {
        this.absolute = bl;
        this.termCritParam = d;
    }

    public abstract IterationValIter forMvMult(DTMC<Double> var1) throws PrismException;

    public abstract IterationIntervalIter forMvMultInterval(DTMC<Double> var1, boolean var2, boolean var3, boolean var4) throws PrismException;

    public abstract IterationValIter forMvMultRew(DTMC<Double> var1, MCRewards<Double> var2) throws PrismException;

    public abstract IterationIntervalIter forMvMultRewInterval(DTMC<Double> var1, MCRewards<Double> var2, boolean var3, boolean var4, boolean var5) throws PrismException;

    public abstract IterationValIter forMvMultMinMax(MDP<Double> var1, boolean var2, int[] var3) throws PrismException;

    public abstract IterationIntervalIter forMvMultMinMaxInterval(MDP<Double> var1, boolean var2, int[] var3, boolean var4, boolean var5, boolean var6) throws PrismException;

    public abstract IterationValIter forMvMultRewMinMax(MDP<Double> var1, MDPRewards<Double> var2, boolean var3, int[] var4) throws PrismException;

    public abstract IterationIntervalIter forMvMultRewMinMaxInterval(MDP<Double> var1, MDPRewards<Double> var2, boolean var3, int[] var4, boolean var5, boolean var6, boolean var7) throws PrismException;

    public abstract IterationValIter forMvMultMinMaxUnc(UDTMC<Double> var1, MinMax var2) throws PrismException;

    public abstract IterationValIter forMvMultRewMinMaxUnc(UDTMC<Double> var1, MCRewards<Double> var2, MinMax var3) throws PrismException;

    public abstract IterationValIter forMvMultMinMaxUnc(UMDP<Double> var1, MinMax var2, int[] var3) throws PrismException;

    public abstract IterationValIter forMvMultRewMinMaxUnc(UMDP<Double> var1, MDPRewards<Double> var2, MinMax var3, int[] var4) throws PrismException;

    public abstract String getDescriptionShort();

    public ModelCheckerResult doValueIteration(ProbModelChecker probModelChecker, String string, IterationValIter iterationValIter, IntSet intSet, long l, ExportIterations exportIterations) throws PrismException {
        int n = 0;
        int n2 = probModelChecker.maxIters;
        boolean bl = false;
        PeriodicTimer periodicTimer = new PeriodicTimer(5000L);
        periodicTimer.start();
        while (!bl && n < n2) {
            ++n;
            bl = iterationValIter.iterateAndCheckConvergence(intSet);
            if (exportIterations != null) {
                exportIterations.exportVector(iterationValIter.getSolnVector(), 0);
            }
            if (bl || !periodicTimer.triggered()) continue;
            probModelChecker.getLog().print("Iteration " + n + ": ");
            probModelChecker.getLog().println(PrismUtils.formatDouble2dp((double)periodicTimer.elapsedMillisTotal() / 1000.0) + " sec so far");
        }
        long l2 = (long)n * iterationValIter.getModel().getNumTransitions(intSet.iterator());
        long l3 = System.currentTimeMillis() - l;
        probModelChecker.getLog().print("Value iteration (" + string + ")");
        probModelChecker.getLog().print(" took " + n + " iterations, ");
        probModelChecker.getLog().print(l2 + " multiplications");
        probModelChecker.getLog().println(" and " + (double)l3 / 1000.0 + " seconds.");
        if (exportIterations != null) {
            exportIterations.close();
        }
        if (!bl && probModelChecker.errorOnNonConverge) {
            String string2 = "Iterative method did not converge within " + n + " iterations.";
            string2 = string2 + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string2);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = iterationValIter.getSolnVector();
        modelCheckerResult.accuracy = AccuracyFactory.valueIteration(this.termCritParam, iterationValIter.getError(), this.absolute);
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l3 / 1000.0;
        return modelCheckerResult;
    }

    public ModelCheckerResult doTopologicalValueIteration(ProbModelChecker probModelChecker, String string, SCCInfo sCCInfo, IterationValIter iterationValIter, SingletonSCCSolver singletonSCCSolver, long l, ExportIterations exportIterations) throws PrismException {
        int n = 0;
        long l2 = 0L;
        int n2 = probModelChecker.maxIters;
        double d = 0.0;
        int n3 = sCCInfo.getNumSCCs();
        int n4 = sCCInfo.countNonSingletonSCCs();
        int n5 = 0;
        PeriodicTimer periodicTimer = new PeriodicTimer(5000L);
        periodicTimer.start();
        boolean bl = true;
        for (int i = 0; i < n3; ++i) {
            boolean bl2;
            if (sCCInfo.isSingletonSCC(i)) {
                int n6 = sCCInfo.getStatesForSCC(i).iterator().nextInt();
                iterationValIter.solveSingletonSCC(n6, singletonSCCSolver);
                l2 += (long)iterationValIter.getModel().getNumTransitions(n6);
                ++n;
                if (exportIterations != null) {
                    exportIterations.exportVector(iterationValIter.getSolnVector(), 0);
                }
                bl2 = true;
            } else {
                bl2 = false;
                IntSet intSet = sCCInfo.getStatesForSCC(i);
                int n7 = 0;
                while (!bl2 && n7 < n2) {
                    ++n;
                    ++n7;
                    bl2 = iterationValIter.iterateAndCheckConvergence(intSet);
                    if (exportIterations != null) {
                        exportIterations.exportVector(iterationValIter.getSolnVector(), 0);
                    }
                    if (bl2 || !periodicTimer.triggered()) continue;
                    probModelChecker.getLog().print("Iteration " + n + ": ");
                    probModelChecker.getLog().print("Iteration " + n7 + " in SCC " + (n5 + 1) + " of " + n4);
                    probModelChecker.getLog().println(", " + PrismUtils.formatDouble2dp((double)periodicTimer.elapsedMillisTotal() / 1000.0) + " sec so far");
                }
                d = Math.max(d, iterationValIter.getError());
                iterationValIter.doneWith(intSet);
                l2 += (long)n7 * iterationValIter.getModel().getNumTransitions(intSet.iterator());
            }
            if (bl2) continue;
            bl = false;
            break;
        }
        long l3 = System.currentTimeMillis() - l;
        probModelChecker.getLog().print("Value iteration (" + string + ", with " + n4 + " non-singleton SCCs)");
        probModelChecker.getLog().print(" took " + n + " iterations, ");
        probModelChecker.getLog().print(l2 + " multiplications");
        probModelChecker.getLog().println(" and " + (double)l3 / 1000.0 + " seconds.");
        if (exportIterations != null) {
            exportIterations.close();
        }
        if (!bl && probModelChecker.errorOnNonConverge) {
            String string2 = "Iterative method did not converge within " + n + " iterations.";
            string2 = string2 + "\nConsider using a different numerical method or increasing the maximum number of iterations";
            throw new PrismException(string2);
        }
        ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
        modelCheckerResult.soln = iterationValIter.getSolnVector();
        modelCheckerResult.accuracy = AccuracyFactory.valueIteration(this.termCritParam, d, this.absolute);
        modelCheckerResult.numIters = n;
        modelCheckerResult.timeTaken = (double)l3 / 1000.0;
        return modelCheckerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelCheckerResult doIntervalIteration(ProbModelChecker probModelChecker, String string, IterationIntervalIter iterationIntervalIter, IterationIntervalIter iterationIntervalIter2, IntSet intSet, long l, ExportIterations exportIterations) throws PrismException {
        try {
            int n = 0;
            int n2 = probModelChecker.maxIters;
            boolean bl = false;
            double d = Double.POSITIVE_INFINITY;
            PeriodicTimer periodicTimer = new PeriodicTimer(5000L);
            periodicTimer.start();
            while (!bl && n < n2) {
                ++n;
                iterationIntervalIter.iterate(intSet);
                iterationIntervalIter2.iterate(intSet);
                if (exportIterations != null) {
                    exportIterations.exportVector(iterationIntervalIter.getSolnVector(), 0);
                    exportIterations.exportVector(iterationIntervalIter2.getSolnVector(), 1);
                }
                IterationMethod.intervalIterationCheckForProblems(iterationIntervalIter.getSolnVector(), iterationIntervalIter2.getSolnVector(), intSet.iterator());
                bl = PrismUtils.doublesAreClose(iterationIntervalIter.getSolnVector(), iterationIntervalIter2.getSolnVector(), this.termCritParam, this.absolute);
                if (bl) {
                    d = PrismUtils.measureSupNormInterval(iterationIntervalIter.getSolnVector(), iterationIntervalIter2.getSolnVector(), this.absolute);
                    probModelChecker.getLog().println("Max " + (!this.absolute ? "relative " : "") + "diff between upper and lower bound on convergence: " + PrismUtils.formatDouble(12, d));
                    bl = true;
                }
                if (bl || !periodicTimer.triggered()) continue;
                double d2 = PrismUtils.measureSupNormInterval(iterationIntervalIter.getSolnVector(), iterationIntervalIter2.getSolnVector(), this.absolute);
                probModelChecker.getLog().print("Iteration " + n + ": ");
                probModelChecker.getLog().print("max " + (this.absolute ? "" : "relative ") + "diff=" + PrismUtils.formatDouble(12, d2));
                probModelChecker.getLog().println(", " + PrismUtils.formatDouble2dp((double)periodicTimer.elapsedMillisTotal() / 1000.0) + " sec so far");
            }
            long l2 = (long)(2 * n) * iterationIntervalIter.getModel().getNumTransitions(intSet.iterator());
            l = System.currentTimeMillis() - l;
            probModelChecker.getLog().print("Interval iteration (" + string + ")");
            probModelChecker.getLog().print(" took " + n + " iterations, ");
            probModelChecker.getLog().print(l2 + " multiplications");
            probModelChecker.getLog().println(" and " + (double)l / 1000.0 + " seconds.");
            if (bl && OptionsIntervalIteration.from(probModelChecker.getSettings()).isSelectMidpointForResult()) {
                PrismUtils.selectMidpoint(iterationIntervalIter.getSolnVector(), iterationIntervalIter2.getSolnVector());
                if (exportIterations != null) {
                    exportIterations.exportVector(iterationIntervalIter.getSolnVector(), 0);
                    exportIterations.exportVector(iterationIntervalIter.getSolnVector(), 1);
                }
            }
            if (!bl && probModelChecker.errorOnNonConverge) {
                String string2 = "Iterative method (interval iteration) did not converge within " + n + " iterations.";
                string2 = string2 + "\nConsider using a different numerical method or increasing the maximum number of iterations";
                throw new PrismException(string2);
            }
            ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = iterationIntervalIter.getSolnVector();
            modelCheckerResult.accuracy = AccuracyFactory.guaranteedNumericalIterative(d, this.absolute);
            modelCheckerResult.numIters = n;
            modelCheckerResult.timeTaken = (double)l / 1000.0;
            ModelCheckerResult modelCheckerResult2 = modelCheckerResult;
            return modelCheckerResult2;
        }
        finally {
            if (exportIterations != null) {
                exportIterations.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelCheckerResult doTopologicalIntervalIteration(ProbModelChecker probModelChecker, String string, SCCInfo sCCInfo, IterationIntervalIter iterationIntervalIter, IterationIntervalIter iterationIntervalIter2, SingletonSCCSolver singletonSCCSolver, long l, ExportIterations exportIterations) throws PrismException {
        try {
            int n = 0;
            long l2 = 0L;
            int n2 = probModelChecker.maxIters;
            double d = Double.POSITIVE_INFINITY;
            PeriodicTimer periodicTimer = new PeriodicTimer(5000L);
            periodicTimer.start();
            int n3 = sCCInfo.getNumSCCs();
            int n4 = sCCInfo.countNonSingletonSCCs();
            int n5 = 0;
            boolean bl = true;
            for (int i = 0; i < n3; ++i) {
                boolean bl2;
                int n6;
                if (sCCInfo.isSingletonSCC(i)) {
                    n6 = sCCInfo.getStatesForSCC(i).iterator().nextInt();
                    iterationIntervalIter.solveSingletonSCC(n6, singletonSCCSolver);
                    iterationIntervalIter2.solveSingletonSCC(n6, singletonSCCSolver);
                    ++n;
                    l2 += (long)(2 * iterationIntervalIter.getModel().getNumTransitions(n6));
                    if (exportIterations != null) {
                        exportIterations.exportVector(iterationIntervalIter.getSolnVector(), 0);
                        exportIterations.exportVector(iterationIntervalIter2.getSolnVector(), 1);
                    }
                    IterationMethod.intervalIterationCheckForProblems(iterationIntervalIter.getSolnVector(), iterationIntervalIter2.getSolnVector(), IntSet.asIntSet(n6).iterator());
                    bl2 = true;
                } else {
                    bl2 = false;
                    n6 = 0;
                    IntSet intSet = sCCInfo.getStatesForSCC(i);
                    FunctionalPrimitiveIterator.OfInt ofInt = intSet.iterator();
                    double[] dArray = iterationIntervalIter2.getSolnVector();
                    double d2 = 2.0 * this.termCritParam;
                    while (ofInt.hasNext()) {
                        int n7 = ofInt.nextInt();
                        dArray[n7] = dArray[n7] + d2;
                    }
                    while (!bl2 && n6 < n2) {
                        ++n;
                        ++n6;
                        iterationIntervalIter.iterate(intSet);
                        iterationIntervalIter2.iterate(intSet);
                        if (exportIterations != null) {
                            exportIterations.exportVector(iterationIntervalIter.getSolnVector(), 0);
                            exportIterations.exportVector(iterationIntervalIter2.getSolnVector(), 1);
                        }
                        IterationMethod.intervalIterationCheckForProblems(iterationIntervalIter.getSolnVector(), iterationIntervalIter2.getSolnVector(), intSet.iterator());
                        bl2 = PrismUtils.doublesAreClose(iterationIntervalIter.getSolnVector(), iterationIntervalIter2.getSolnVector(), intSet.iterator(), this.termCritParam, this.absolute);
                        if (bl2 || !periodicTimer.triggered()) continue;
                        double d3 = PrismUtils.measureSupNormInterval(iterationIntervalIter.getSolnVector(), iterationIntervalIter2.getSolnVector(), this.absolute, intSet.iterator());
                        probModelChecker.getLog().print("Iteration " + n + ": ");
                        probModelChecker.getLog().print("max " + (this.absolute ? "" : "relative ") + "diff (for iteration " + n6 + " in current SCC " + (n5 + 1) + " of " + n4 + ") = " + PrismUtils.formatDouble(12, d3));
                        probModelChecker.getLog().println(", " + PrismUtils.formatDouble2dp((double)periodicTimer.elapsedMillisTotal() / 1000.0) + " sec so far");
                    }
                    iterationIntervalIter.doneWith(intSet);
                    iterationIntervalIter2.doneWith(intSet);
                    l2 += (long)(2 * n6) * iterationIntervalIter.getModel().getNumTransitions(intSet.iterator());
                    ++n5;
                }
                if (bl2) continue;
                bl = false;
                break;
            }
            if (bl) {
                d = PrismUtils.measureSupNormInterval(iterationIntervalIter.getSolnVector(), iterationIntervalIter2.getSolnVector(), this.absolute);
                probModelChecker.getLog().println("Max " + (this.absolute ? "" : "relative ") + "diff between upper and lower bound on convergence: " + PrismUtils.formatDouble(12, d));
                bl = true;
            }
            l = System.currentTimeMillis() - l;
            probModelChecker.getLog().print("Interval iteration (" + string + ", with " + n4 + " non-singleton SCCs)");
            probModelChecker.getLog().print(" took " + n + " iterations, ");
            probModelChecker.getLog().print(l2 + " multiplications");
            probModelChecker.getLog().println(" and " + (double)l / 1000.0 + " seconds.");
            if (bl && OptionsIntervalIteration.from(probModelChecker.getSettings()).isSelectMidpointForResult()) {
                PrismUtils.selectMidpoint(iterationIntervalIter.getSolnVector(), iterationIntervalIter2.getSolnVector());
                if (exportIterations != null) {
                    exportIterations.exportVector(iterationIntervalIter.getSolnVector(), 0);
                    exportIterations.exportVector(iterationIntervalIter.getSolnVector(), 1);
                }
            }
            if (exportIterations != null) {
                exportIterations.close();
            }
            if (!bl && probModelChecker.errorOnNonConverge) {
                String string2 = "Iterative method (interval iteration) did not converge within " + n + " iterations.";
                string2 = string2 + "\nConsider using a different numerical method or increasing the maximum number of iterations";
                throw new PrismException(string2);
            }
            ModelCheckerResult modelCheckerResult = new ModelCheckerResult();
            modelCheckerResult.soln = iterationIntervalIter.getSolnVector();
            modelCheckerResult.accuracy = AccuracyFactory.guaranteedNumericalIterative(d, this.absolute);
            modelCheckerResult.numIters = n;
            modelCheckerResult.timeTaken = (double)l / 1000.0;
            ModelCheckerResult modelCheckerResult2 = modelCheckerResult;
            return modelCheckerResult2;
        }
        finally {
            if (exportIterations != null) {
                exportIterations.close();
            }
        }
    }

    private static void intervalIterationCheckForProblems(double[] dArray, double[] dArray2, PrimitiveIterator.OfInt ofInt) throws PrismException {
        while (ofInt.hasNext()) {
            int n = ofInt.nextInt();
            if (!(dArray[n] > dArray2[n])) continue;
            throw new PrismException("In interval iteration, the lower value (" + dArray[n] + ") is larger than the upper value (" + dArray2[n] + ").\nThis indicates either problems with numerical stability (rounding, precision of the floating-point representation) or that the initial bounds (for reward computations) are incorrect");
        }
    }

    public static void twoVectorPostProcessing(double[] dArray, double[] dArray2, IntSet intSet, boolean bl, boolean bl2, boolean bl3) throws PrismException {
        if (bl2) {
            if (bl) {
                PrismUtils.ensureMonotonicityFromBelow(dArray, dArray2);
            } else {
                PrismUtils.ensureMonotonicityFromAbove(dArray, dArray2);
            }
        }
        if (bl3) {
            PrismUtils.checkMonotonicity(dArray, dArray2, !bl);
        }
    }

    public static interface IterationValIter {
        public void init(double[] var1);

        public double[] getSolnVector();

        public double getError();

        public boolean iterateAndCheckConvergence(IntSet var1) throws PrismException;

        public void doneWith(IntSet var1);

        public void solveSingletonSCC(int var1, SingletonSCCSolver var2);

        public Model<?> getModel();
    }

    @FunctionalInterface
    public static interface SingletonSCCSolver {
        public void solveFor(int var1, double[] var2);
    }

    public static interface IterationIntervalIter {
        public void init(double[] var1);

        public double[] getSolnVector();

        public void iterate(IntSet var1) throws PrismException;

        public void doneWith(IntSet var1);

        public void solveSingletonSCC(int var1, SingletonSCCSolver var2);

        public Model<?> getModel();
    }

    protected abstract class TwoVectorIteration
    extends IterationBasic
    implements IterationValIter,
    IterationIntervalIter {
        protected double[] soln2;
        protected final IterationPostProcessor postProcessor;

        protected TwoVectorIteration(Model<?> model, IterationPostProcessor iterationPostProcessor) {
            super(model);
            this.postProcessor = iterationPostProcessor;
        }

        @Override
        public void init(double[] dArray) {
            super.init(dArray);
            this.soln2 = new double[dArray.length];
            System.arraycopy(dArray, 0, this.soln2, 0, dArray.length);
        }

        public abstract void doIterate(IntSet var1) throws PrismException;

        @Override
        public void iterate(IntSet intSet) throws PrismException {
            this.doIterate(intSet);
            if (this.postProcessor != null) {
                this.postProcessor.apply(this.soln, this.soln2, intSet);
            }
            double[] dArray = this.soln;
            this.soln = this.soln2;
            this.soln2 = dArray;
        }

        @Override
        public boolean iterateAndCheckConvergence(IntSet intSet) throws PrismException {
            this.doIterate(intSet);
            if (this.postProcessor != null) {
                this.postProcessor.apply(this.soln, this.soln2, intSet);
            }
            boolean bl = PrismUtils.doublesAreClose(this.soln, this.soln2, intSet.iterator(), IterationMethod.this.termCritParam, IterationMethod.this.absolute);
            double[] dArray = this.soln;
            this.soln = this.soln2;
            this.soln2 = dArray;
            return bl;
        }

        @Override
        public double getError() {
            return PrismUtils.measureSupNorm(this.soln, this.soln2, IterationMethod.this.absolute);
        }

        @Override
        public void doneWith(IntSet intSet) {
            FunctionalPrimitiveIterator.OfInt ofInt = intSet.iterator();
            while (ofInt.hasNext()) {
                int n = ofInt.nextInt();
                this.soln2[n] = this.soln[n];
            }
        }

        @Override
        public void solveSingletonSCC(int n, SingletonSCCSolver singletonSCCSolver) {
            super.solveSingletonSCC(n, singletonSCCSolver);
            this.soln2[n] = this.soln[n];
        }
    }

    @FunctionalInterface
    static interface IterationPostProcessor {
        public void apply(double[] var1, double[] var2, IntSet var3) throws PrismException;
    }

    protected abstract class SingleVectorIterationIntervalIter
    extends IterationBasic
    implements IterationIntervalIter {
        public SingleVectorIterationIntervalIter(Model<?> model) {
            super(model);
        }
    }

    protected abstract class SingleVectorIterationValIter
    extends IterationBasic
    implements IterationValIter {
        protected double error;

        @Override
        public double getError() {
            return this.error;
        }

        public SingleVectorIterationValIter(Model<?> model) {
            super(model);
            this.error = Double.POSITIVE_INFINITY;
        }
    }

    public class IterationBasic {
        protected final Model<?> model;
        protected double[] soln;

        public IterationBasic(Model<?> model) {
            this.model = model;
        }

        public void init(double[] dArray) {
            this.soln = dArray;
        }

        public double[] getSolnVector() {
            return this.soln;
        }

        public void solveSingletonSCC(int n, SingletonSCCSolver singletonSCCSolver) {
            singletonSCCSolver.solveFor(n, this.soln);
        }

        public void doneWith(IntSet intSet) {
        }

        public Model<?> getModel() {
            return this.model;
        }
    }
}

