/*
 * Decompiled with CFR 0.152.
 */
package automata;

import acceptance.AcceptanceOmega;
import acceptance.AcceptanceRabin;
import acceptance.AcceptanceReach;
import acceptance.AcceptanceType;
import automata.DA;
import automata.LTSFromDA;
import explicit.SCCComputer;
import explicit.SCCConsumerStore;
import java.util.BitSet;
import prism.PrismComponent;
import prism.PrismException;

public class DASimplifyAcceptance {
    public static DA<BitSet, ? extends AcceptanceOmega> simplifyAcceptance(PrismComponent prismComponent, DA<BitSet, ? extends AcceptanceOmega> dA, AcceptanceType ... acceptanceTypeArray) throws PrismException {
        if (dA.getAcceptance() instanceof AcceptanceRabin) {
            DA<BitSet, ? extends AcceptanceOmega> dA2 = dA;
            LTSFromDA lTSFromDA = new LTSFromDA(dA);
            SCCConsumerStore sCCConsumerStore = new SCCConsumerStore();
            SCCComputer sCCComputer = SCCComputer.createSCCComputer(prismComponent, lTSFromDA, sCCConsumerStore);
            sCCComputer.computeSCCs();
            BitSet bitSet = sCCConsumerStore.getNotInSCCs();
            for (AcceptanceRabin.RabinPair rabinPair : (AcceptanceRabin)dA2.getAcceptance()) {
                if (!rabinPair.getK().intersects(bitSet)) continue;
                rabinPair.getK().andNot(bitSet);
            }
            if (AcceptanceType.contains(acceptanceTypeArray, AcceptanceType.REACH) && DASimplifyAcceptance.isDFA(dA2)) {
                AcceptanceReach acceptanceReach = new AcceptanceReach(DASimplifyAcceptance.getDFAGoalStatesForRabin((AcceptanceRabin)dA2.getAcceptance()));
                DA.switchAcceptance(dA2, acceptanceReach);
                dA = dA2;
            }
        }
        return dA;
    }

    public static boolean isDFA(DA<BitSet, AcceptanceRabin> dA) {
        int n;
        AcceptanceRabin acceptanceRabin = dA.getAcceptance();
        BitSet bitSet = DASimplifyAcceptance.getDFAGoalStatesForRabin(acceptanceRabin);
        for (n = 0; n < acceptanceRabin.size(); ++n) {
            if (!bitSet.intersects(((AcceptanceRabin.RabinPair)acceptanceRabin.get(n)).getL())) continue;
            return false;
        }
        n = bitSet.nextSetBit(0);
        while (n >= 0) {
            int n2 = dA.getNumEdges(n);
            for (int i = 0; i < n2; ++i) {
                if (bitSet.get(dA.getEdgeDest(n, i))) continue;
                return false;
            }
            n = bitSet.nextSetBit(n + 1);
        }
        return true;
    }

    public static BitSet getDFAGoalStatesForRabin(AcceptanceRabin acceptanceRabin) {
        BitSet bitSet = new BitSet();
        int n = acceptanceRabin.size();
        for (int i = 0; i < n; ++i) {
            bitSet.or(((AcceptanceRabin.RabinPair)acceptanceRabin.get(i)).getK());
        }
        return bitSet;
    }
}

