/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.UniqueIdFormat;

@API(status=API.Status.STABLE, since="1.0")
public class UniqueId
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ENGINE_SEGMENT_TYPE = "engine";
    private final UniqueIdFormat uniqueIdFormat;
    private final List<Segment> segments;
    private transient int hashCode;
    private transient String toString;

    public static UniqueId parse(String uniqueId) throws JUnitException {
        Preconditions.notBlank(uniqueId, "Unique ID string must not be null or blank");
        return UniqueIdFormat.getDefault().parse(uniqueId);
    }

    public static UniqueId forEngine(String engineId) {
        Preconditions.notBlank(engineId, "engineId must not be null or blank");
        return UniqueId.root(ENGINE_SEGMENT_TYPE, engineId);
    }

    public static UniqueId root(String segmentType, String value) {
        return new UniqueId(UniqueIdFormat.getDefault(), new Segment(segmentType, value));
    }

    private UniqueId(UniqueIdFormat uniqueIdFormat, Segment segment) {
        this.uniqueIdFormat = uniqueIdFormat;
        this.segments = Collections.singletonList(segment);
    }

    UniqueId(UniqueIdFormat uniqueIdFormat, List<Segment> segments) {
        this.uniqueIdFormat = uniqueIdFormat;
        this.segments = Collections.unmodifiableList(segments);
    }

    final Optional<Segment> getRoot() {
        return this.segments.isEmpty() ? Optional.empty() : Optional.of(this.segments.get(0));
    }

    public final Optional<String> getEngineId() {
        return this.getRoot().filter(segment -> segment.getType().equals(ENGINE_SEGMENT_TYPE)).map(Segment::getValue);
    }

    public final List<Segment> getSegments() {
        return this.segments;
    }

    public final UniqueId append(String segmentType, String value) {
        return this.append(new Segment(segmentType, value));
    }

    @API(status=API.Status.STABLE, since="1.1")
    public final UniqueId append(Segment segment) {
        Preconditions.notNull(segment, "segment must not be null");
        ArrayList<Segment> baseSegments = new ArrayList<Segment>(this.segments);
        baseSegments.add(segment);
        return new UniqueId(this.uniqueIdFormat, baseSegments);
    }

    @API(status=API.Status.STABLE, since="1.1")
    public boolean hasPrefix(UniqueId potentialPrefix) {
        Preconditions.notNull(potentialPrefix, "potentialPrefix must not be null");
        int size = this.segments.size();
        int prefixSize = potentialPrefix.segments.size();
        return size >= prefixSize && this.segments.subList(0, prefixSize).equals(potentialPrefix.segments);
    }

    @API(status=API.Status.STABLE, since="1.5")
    public UniqueId removeLastSegment() {
        Preconditions.condition(this.segments.size() > 1, "Cannot remove last remaining segment");
        return new UniqueId(this.uniqueIdFormat, new ArrayList<Segment>(this.segments.subList(0, this.segments.size() - 1)));
    }

    @API(status=API.Status.STABLE, since="1.5")
    public Segment getLastSegment() {
        return this.segments.get(this.segments.size() - 1);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniqueId that = (UniqueId)o;
        return this.segments.equals(that.segments);
    }

    public int hashCode() {
        int value = this.hashCode;
        if (value == 0) {
            value = this.segments.hashCode();
            if (value == 0) {
                value = 1;
            }
            this.hashCode = value;
        }
        return value;
    }

    public String toString() {
        String s = this.toString;
        if (s == null) {
            this.toString = s = this.uniqueIdFormat.format(this);
        }
        return s;
    }

    @API(status=API.Status.STABLE, since="1.0")
    public static class Segment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String type;
        private final String value;

        Segment(String type, String value) {
            Preconditions.notBlank(type, "type must not be null or blank");
            Preconditions.notBlank(value, "value must not be null or blank");
            this.type = type;
            this.value = value;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Segment that = (Segment)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
        }

        public String toString() {
            return new ToStringBuilder(this).append("type", this.type).append("value", this.value).toString();
        }
    }
}

