/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.util;

import edu.jas.util.DistHashTable;
import edu.jas.util.DistHashTableServer;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class DistHashTableTest
extends TestCase {
    private static final String host = "localhost";
    private DistHashTable<Integer, Integer> l1;
    private DistHashTable<Integer, Integer> l2;
    private DistHashTable<Integer, Integer> l3;
    private DistHashTableServer<Integer> dls;
    int rl = 7;
    int kl = 10;
    int ll = 10;
    int el = 5;
    float q = 0.5f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)DistHashTableTest.suite());
    }

    public DistHashTableTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(DistHashTableTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.dls = new DistHashTableServer();
        this.dls.init();
    }

    protected void tearDown() {
        this.dls.terminate();
        this.dls = null;
        if (this.l1 != null) {
            this.l1.terminate();
        }
        if (this.l2 != null) {
            this.l2.terminate();
        }
        if (this.l3 != null) {
            this.l3.terminate();
        }
        this.l3 = null;
        this.l2 = null;
        this.l1 = null;
    }

    public void testDistHashTable0() {
    }

    public void testDistHashTable1() {
        this.l1 = new DistHashTable(host);
        this.l1.init();
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
    }

    public void testDistHashTable2() {
        this.l1 = new DistHashTable(host);
        this.l1.init();
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        this.l1.putWait(1, 1);
        DistHashTableTest.assertFalse((String)"l1!=empty", (boolean)this.l1.isEmpty());
        DistHashTableTest.assertTrue((String)"#l1==1", (this.l1.size() == 1 ? 1 : 0) != 0);
        this.l1.putWait(2, 2);
        DistHashTableTest.assertTrue((String)"#l1==2", (this.l1.size() == 2 ? 1 : 0) != 0);
        this.l1.putWait(3, 3);
        DistHashTableTest.assertTrue((String)"#l1==3", (this.l1.size() == 3 ? 1 : 0) != 0);
        Iterator<Integer> iterator = null;
        iterator = this.l1.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Integer n2 = iterator.next();
            Integer n3 = this.l1.get(n2);
            Integer n4 = ++n;
            DistHashTableTest.assertEquals((String)"l1(i)==v(i)", (Object)n4, (Object)n3);
            DistHashTableTest.assertEquals((String)"l1(i)==k(i)", (Object)n4, (Object)n2);
        }
        this.l1.clear();
        DistHashTableTest.assertTrue((String)"#l1==0", (this.l1.size() == 0 ? 1 : 0) != 0);
    }

    public void testDistHashTable3() {
        Object object;
        this.l2 = new DistHashTable(host);
        this.l2.init();
        DistHashTableTest.assertTrue((String)"l2==empty", (boolean)this.l2.isEmpty());
        this.l1 = new DistHashTable(host);
        this.l1.init();
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        int n = 0;
        int n2 = 10;
        while (n < n2) {
            object = ++n;
            this.l1.putWait((Integer)object, (Integer)object);
            DistHashTableTest.assertTrue((String)"#l1==i", (this.l1.size() == n ? 1 : 0) != 0);
        }
        DistHashTableTest.assertTrue((String)("#l1==" + n2), (this.l1.size() == n2 ? 1 : 0) != 0);
        while (this.l2.size() < n2) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        DistHashTableTest.assertTrue((String)("#l2==" + n2), (this.l2.size() == n2 ? 1 : 0) != 0);
        object = null;
        object = this.l2.iterator();
        n = 0;
        while (object.hasNext()) {
            Object e = object.next();
            Integer n3 = this.l2.get(e);
            Integer n4 = ++n;
            DistHashTableTest.assertEquals((String)"l2(i)==k(i)", (Object)n4, e);
            DistHashTableTest.assertEquals((String)"l2(i)==v(i)", (Object)n4, (Object)n3);
        }
        this.l1.clear();
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        while (this.l2.size() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        DistHashTableTest.assertTrue((String)"l2==empty", (boolean)this.l2.isEmpty());
    }

    public void testDistHashTable4() {
        Object object;
        this.l1 = new DistHashTable(host);
        this.l1.init();
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        this.l2 = new DistHashTable(host);
        this.l2.init();
        DistHashTableTest.assertTrue((String)"l2==empty", (boolean)this.l2.isEmpty());
        this.l3 = new DistHashTable(host);
        this.l3.init();
        DistHashTableTest.assertTrue((String)"l3==empty", (boolean)this.l3.isEmpty());
        int n = 0;
        int n2 = 10;
        while (n < n2) {
            object = ++n;
            this.l3.putWait((Integer)object, (Integer)object);
            DistHashTableTest.assertTrue((String)"#l3==i", (this.l3.size() == n ? 1 : 0) != 0);
        }
        DistHashTableTest.assertTrue((String)("#l3==" + n2), (this.l3.size() == n2 ? 1 : 0) != 0);
        while (this.l2.size() < n2 || this.l1.size() < n2 - 1) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        DistHashTableTest.assertTrue((String)("#l2==" + n2), (this.l2.size() == n2 ? 1 : 0) != 0);
        DistHashTableTest.assertTrue((String)("#l1==" + n2), (this.l1.size() == n2 ? 1 : 0) != 0);
        object = null;
        object = this.l2.iterator();
        Iterator<Integer> iterator = null;
        iterator = this.l1.iterator();
        n = 0;
        while (object.hasNext() && iterator.hasNext()) {
            Object e = object.next();
            Integer n3 = iterator.next();
            Integer n4 = this.l2.get(e);
            Integer n5 = this.l1.get(n3);
            Integer n6 = ++n;
            DistHashTableTest.assertEquals((String)"l2(i)==k(i)", (Object)n6, e);
            DistHashTableTest.assertEquals((String)"l1(i)==k(i)", (Object)n6, (Object)n3);
            DistHashTableTest.assertEquals((String)"l2(i)==v(i)", (Object)n6, (Object)n4);
            DistHashTableTest.assertEquals((String)"l1(i)==v(i)", (Object)n6, (Object)n5);
        }
        this.l1.clear();
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        while (this.l2.size() > 0 || this.l3.size() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        DistHashTableTest.assertTrue((String)"l2==empty", (boolean)this.l2.isEmpty());
        DistHashTableTest.assertTrue((String)"l3==empty", (boolean)this.l3.isEmpty());
    }

    public void testDistHashTable5() {
        Object object;
        this.l1 = new DistHashTable(host);
        this.l1.init();
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        int n = 0;
        int n2 = 10;
        while (n < n2) {
            object = ++n;
            this.l1.putWait((Integer)object, (Integer)object);
            DistHashTableTest.assertTrue((String)"#l1==i", (this.l1.size() == n ? 1 : 0) != 0);
        }
        DistHashTableTest.assertTrue((String)("#l1==" + n2), (this.l1.size() == n2 ? 1 : 0) != 0);
        this.l2 = new DistHashTable(host);
        this.l2.init();
        while (this.l2.size() < n2) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        object = null;
        object = this.l2.iterator();
        n = 0;
        while (object.hasNext()) {
            Object e = object.next();
            Integer n3 = this.l2.get(e);
            Integer n4 = ++n;
            DistHashTableTest.assertEquals((String)"l2(i)==k(i)", (Object)n4, e);
            DistHashTableTest.assertEquals((String)"l2(i)==v(i)", (Object)n4, (Object)n3);
        }
        DistHashTableTest.assertTrue((String)("#l2==" + n2), (this.l2.size() == n2 ? 1 : 0) != 0);
    }

    public void testDistHashTable6() {
        Object object;
        this.l1 = new DistHashTable(host);
        this.l1.init();
        DistHashTableTest.assertTrue((String)"l1==empty", (boolean)this.l1.isEmpty());
        int n = 0;
        int n2 = 10;
        while (n < n2) {
            object = ++n;
            this.l1.putWait((Integer)object, (Integer)object);
            DistHashTableTest.assertTrue((String)"#l1==i", (this.l1.size() == n ? 1 : 0) != 0);
        }
        DistHashTableTest.assertTrue((String)("#l1==" + n2), (this.l1.size() == n2 ? 1 : 0) != 0);
        this.l2 = new DistHashTable(host);
        this.l2.init();
        object = null;
        object = this.l1.iterator();
        n = 0;
        while (object.hasNext()) {
            Integer n3 = (Integer)object.next();
            Integer n4 = this.l2.getWait(n3);
            Integer n5 = ++n;
            DistHashTableTest.assertEquals((String)"l1(i)==k(i)", (Object)n5, (Object)n3);
            DistHashTableTest.assertEquals((String)"l2(i)==v(i)", (Object)n5, (Object)n4);
        }
        DistHashTableTest.assertTrue((String)("#l2==" + n2), (this.l2.size() == n2 ? 1 : 0) != 0);
    }
}

