/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.poly;

import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import edu.jas.poly.TermOrder;
import edu.jas.structure.RingElem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class OrderedPolynomialList<C extends RingElem<C>>
extends PolynomialList<C> {
    public OrderedPolynomialList(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list) {
        super(genPolynomialRing, OrderedPolynomialList.sort(genPolynomialRing, list));
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        OrderedPolynomialList orderedPolynomialList = null;
        try {
            orderedPolynomialList = (OrderedPolynomialList)object;
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return orderedPolynomialList != null;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> sort(List<GenPolynomial<C>> list) {
        if (list == null) {
            return list;
        }
        if (list.size() <= 1) {
            return list;
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        return OrderedPolynomialList.sort(genPolynomialRing, list);
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> sort(GenPolynomialRing<C> genPolynomialRing, List<GenPolynomial<C>> list) {
        if (list == null) {
            return list;
        }
        if (list.size() <= 1) {
            return list;
        }
        final TermOrder.EVComparator eVComparator = genPolynomialRing.tord.getAscendComparator();
        Comparator comparator = new Comparator<GenPolynomial<C>>(){

            @Override
            public int compare(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
                ExpVector expVector = genPolynomial.leadingExpVector();
                ExpVector expVector2 = genPolynomial2.leadingExpVector();
                if (expVector == null) {
                    return -1;
                }
                if (expVector2 == null) {
                    return 1;
                }
                if (expVector.length() != expVector2.length()) {
                    if (expVector.length() > expVector2.length()) {
                        return 1;
                    }
                    return -1;
                }
                return eVComparator.compare(expVector, expVector2);
            }
        };
        GenPolynomial[] genPolynomialArray = null;
        try {
            genPolynomialArray = new GenPolynomial[list.size()];
            int n = 0;
            for (GenPolynomial<C> genPolynomial : list) {
                genPolynomialArray[n++] = genPolynomial;
            }
            Arrays.sort(genPolynomialArray, comparator);
            return new ArrayList<GenPolynomial<C>>(Arrays.asList(genPolynomialArray));
        }
        catch (ClassCastException classCastException) {
            System.out.println("Warning: polynomials not sorted");
            return list;
        }
    }

    public static <C extends RingElem<C>> List<GenPolynomial<C>> sortDegree(List<GenPolynomial<C>> list) {
        if (list == null) {
            return list;
        }
        if (list.size() <= 1) {
            return list;
        }
        Comparator comparator = new Comparator<GenPolynomial<C>>(){

            @Override
            public int compare(GenPolynomial<C> genPolynomial, GenPolynomial<C> genPolynomial2) {
                long l;
                long l2 = genPolynomial.degree();
                if (l2 > (l = genPolynomial2.degree())) {
                    return -1;
                }
                if (l2 < l) {
                    return 1;
                }
                return 0;
            }
        };
        GenPolynomial[] genPolynomialArray = null;
        try {
            genPolynomialArray = new GenPolynomial[list.size()];
            int n = 0;
            for (GenPolynomial<C> genPolynomial : list) {
                genPolynomialArray[n++] = genPolynomial;
            }
            Arrays.sort(genPolynomialArray, comparator);
            return new ArrayList<GenPolynomial<C>>(Arrays.asList(genPolynomialArray));
        }
        catch (ClassCastException classCastException) {
            System.out.println("Warning: polynomials not sorted");
            return list;
        }
    }
}

