/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.arith.BigComplex;
import edu.jas.arith.BigInteger;
import edu.jas.arith.BigRational;
import edu.jas.gb.DReductionSeq;
import edu.jas.gb.EReductionSeq;
import edu.jas.gb.Reduction;
import edu.jas.gb.ReductionPar;
import edu.jas.gb.ReductionSeq;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.PolynomialList;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ReductionTest
extends TestCase {
    GenPolynomialRing<BigRational> fac;
    GenPolynomial<BigRational> a;
    GenPolynomial<BigRational> b;
    GenPolynomial<BigRational> c;
    GenPolynomial<BigRational> d;
    GenPolynomial<BigRational> e;
    List<GenPolynomial<BigRational>> L;
    PolynomialList<BigRational> F;
    PolynomialList<BigRational> G;
    ReductionSeq<BigRational> red;
    Reduction<BigRational> redpar;
    int rl = 4;
    int kl = 10;
    int ll = 11;
    int el = 5;
    float q = 0.6f;

    public static void main(String[] stringArray) {
        TestRunner.run((Test)ReductionTest.suite());
    }

    public ReductionTest(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite(ReductionTest.class);
        return testSuite;
    }

    protected void setUp() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = new GenPolynomialRing<BigRational>(new BigRational(0L), this.rl);
        this.red = new ReductionSeq();
        this.redpar = new ReductionPar<BigRational>();
    }

    protected void tearDown() {
        this.e = null;
        this.d = null;
        this.c = null;
        this.b = null;
        this.a = null;
        this.fac = null;
        this.red = null;
        this.redpar = null;
    }

    public void testRatReduction0() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.getONE();
        this.d = this.fac.getZERO();
        this.e = this.red.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.red.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.c);
        this.e = this.red.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.red.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.red.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.d);
        this.e = this.red.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.red.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
    }

    public void testRatReductionPar0() {
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.getONE();
        this.d = this.fac.getZERO();
        this.e = this.redpar.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.redpar.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L.add(this.c);
        this.e = this.redpar.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.redpar.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.e = this.redpar.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.d);
        this.e = this.redpar.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)this.e.isONE());
        this.e = this.redpar.normalform(this.L, this.d);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
    }

    public void testRatReduction() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        this.e = this.red.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.red.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
        this.e = this.red.SPolynomial(this.a, this.b);
        ExpVector expVector = this.a.leadingExpVector().lcm(this.b.leadingExpVector());
        ExpVector expVector2 = this.e.leadingExpVector();
        ReductionTest.assertTrue((String)("lcm(lt(a),lt(b)) > lt(e) " + expVector + " > " + expVector2), (this.fac.tord.getAscendComparator().compare(expVector, expVector2) > 0 ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)this.red.isTopReducible(this.L, this.a));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)this.red.isReducible(this.L, this.a));
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.L.add(this.b);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)this.red.isTopReducible(this.L, this.b));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)this.red.isReducible(this.L, this.b));
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.red.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)this.red.isNormalform(this.L, this.e));
    }

    public void testRatReductionPar() {
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        this.e = this.redpar.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        this.L.add(this.b);
        this.e = this.redpar.normalform(this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)this.e.isZERO());
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)this.redpar.isTopReducible(this.L, this.a));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)this.redpar.isReducible(this.L, this.a));
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.L.add(this.b);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)this.redpar.isTopReducible(this.L, this.b));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)this.redpar.isReducible(this.L, this.b));
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.e = this.redpar.normalform(this.L, this.c);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)this.redpar.isNormalform(this.L, this.e));
    }

    public void testComplexReduction() {
        GenPolynomialRing<BigComplex> genPolynomialRing = new GenPolynomialRing<BigComplex>(new BigComplex(0L), this.rl);
        ReductionSeq<BigComplex> reductionSeq = new ReductionSeq<BigComplex>();
        GenPolynomial<BigComplex> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigComplex> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!genPolynomial.isZERO() ? 1 : 0) != 0);
        ArrayList arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        GenPolynomial<BigComplex> genPolynomial3 = reductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)genPolynomial3.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!genPolynomial2.isZERO() ? 1 : 0) != 0);
        arrayList.add(genPolynomial2);
        genPolynomial3 = reductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)genPolynomial3.isZERO());
        arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)reductionSeq.isTopReducible(arrayList, genPolynomial));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)reductionSeq.isReducible(arrayList, genPolynomial));
        genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        arrayList.add(genPolynomial2);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)reductionSeq.isTopReducible(arrayList, genPolynomial2));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)reductionSeq.isReducible(arrayList, genPolynomial2));
        GenPolynomial<BigComplex> genPolynomial4 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial3 = reductionSeq.normalform(arrayList, genPolynomial4);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)reductionSeq.isNormalform(arrayList, genPolynomial3));
    }

    public void testRatReductionRecording() {
        int n;
        ArrayList arrayList = null;
        this.a = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.b = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.c = this.fac.random(this.kl, this.ll, this.el, this.q);
        this.d = this.fac.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!this.a.isZERO() ? 1 : 0) != 0);
        this.L = new ArrayList<GenPolynomial<BigRational>>();
        this.L.add(this.a);
        arrayList = new ArrayList(this.L.size());
        for (n = 0; n < this.L.size(); ++n) {
            arrayList.add(null);
        }
        this.e = this.red.normalform(arrayList, this.L, this.a);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)this.e.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!this.b.isZERO() ? 1 : 0) != 0);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(arrayList, this.L, this.a, this.e));
        this.L.add(this.b);
        arrayList = new ArrayList(this.L.size());
        for (n = 0; n < this.L.size(); ++n) {
            arrayList.add(null);
        }
        this.e = this.red.normalform(arrayList, this.L, this.b);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(arrayList, this.L, this.b, this.e));
        this.L.add(this.c);
        arrayList = new ArrayList(this.L.size());
        for (n = 0; n < this.L.size(); ++n) {
            arrayList.add(null);
        }
        this.e = this.red.normalform(arrayList, this.L, this.c);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(arrayList, this.L, this.c, this.e));
        this.L.add(this.d);
        arrayList = new ArrayList(this.L.size());
        for (n = 0; n < this.L.size(); ++n) {
            arrayList.add(null);
        }
        this.e = this.red.normalform(arrayList, this.L, this.d);
        ReductionTest.assertTrue((String)"is Reduction ", (boolean)this.red.isReductionNF(arrayList, this.L, this.d, this.e));
    }

    public void testIntegerEReduction() {
        BigInteger bigInteger = new BigInteger(0L);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        EReductionSeq<BigInteger> eReductionSeq = new EReductionSeq<BigInteger>();
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!genPolynomial.isZERO() ? 1 : 0) != 0);
        ArrayList arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        GenPolynomial<BigInteger> genPolynomial3 = eReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)genPolynomial3.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!genPolynomial2.isZERO() ? 1 : 0) != 0);
        arrayList.add(genPolynomial2);
        genPolynomial3 = eReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)genPolynomial3.isZERO());
        GenPolynomial<BigInteger> genPolynomial4 = genPolynomialRing.getONE();
        genPolynomial = genPolynomial.sum((BigInteger)((Object)genPolynomial4));
        genPolynomial3 = eReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isONE( e ) some times", (boolean)genPolynomial3.isONE());
        arrayList = new ArrayList();
        genPolynomial = genPolynomial4.multiply(bigInteger.fromInteger(4L));
        genPolynomial2 = genPolynomial4.multiply(bigInteger.fromInteger(5L));
        arrayList.add(genPolynomial);
        genPolynomial3 = eReductionSeq.normalform(arrayList, genPolynomial2);
        ReductionTest.assertTrue((String)"isONE( e )", (boolean)genPolynomial3.isONE());
        genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial4 = eReductionSeq.GPolynomial(genPolynomial, genPolynomial2);
        genPolynomial3 = eReductionSeq.SPolynomial(genPolynomial, genPolynomial2);
        BigInteger bigInteger2 = genPolynomial.leadingBaseCoefficient().gcd(genPolynomial2.leadingBaseCoefficient());
        ReductionTest.assertEquals((String)"gcd(lbc(a),lbc(b)) = lbc(c) ", (Object)bigInteger2, (Object)genPolynomial4.leadingBaseCoefficient());
        ExpVector expVector = genPolynomial.leadingExpVector().lcm(genPolynomial2.leadingExpVector());
        ReductionTest.assertEquals((String)"lcm(lt(a),lt(b)) == lt(c) ", (Object)expVector, (Object)genPolynomial4.leadingExpVector());
        ReductionTest.assertFalse((String)"lcm(lt(a),lt(b)) != lt(e) ", (boolean)expVector.equals(genPolynomial3.leadingExpVector()));
        arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)eReductionSeq.isTopReducible(arrayList, genPolynomial));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)eReductionSeq.isReducible(arrayList, genPolynomial));
        genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        arrayList.add(genPolynomial2);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)eReductionSeq.isTopReducible(arrayList, genPolynomial2));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)eReductionSeq.isReducible(arrayList, genPolynomial2));
        genPolynomial4 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial3 = eReductionSeq.normalform(arrayList, genPolynomial4);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)eReductionSeq.isNormalform(arrayList, genPolynomial3));
    }

    public void testIntegerDReduction() {
        BigInteger bigInteger = new BigInteger(0L);
        GenPolynomialRing<BigInteger> genPolynomialRing = new GenPolynomialRing<BigInteger>(bigInteger, this.rl);
        DReductionSeq<BigInteger> dReductionSeq = new DReductionSeq<BigInteger>();
        GenPolynomial<BigInteger> genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        GenPolynomial<BigInteger> genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        ReductionTest.assertTrue((String)"not isZERO( a )", (!genPolynomial.isZERO() ? 1 : 0) != 0);
        ArrayList arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        GenPolynomial<BigInteger> genPolynomial3 = dReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e )", (boolean)genPolynomial3.isZERO());
        ReductionTest.assertTrue((String)"not isZERO( b )", (!genPolynomial2.isZERO() ? 1 : 0) != 0);
        arrayList.add(genPolynomial2);
        genPolynomial3 = dReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isZERO( e ) some times", (boolean)genPolynomial3.isZERO());
        GenPolynomial<BigInteger> genPolynomial4 = genPolynomialRing.getONE();
        genPolynomial = genPolynomial.sum((BigInteger)((Object)genPolynomial4));
        genPolynomial3 = dReductionSeq.normalform(arrayList, genPolynomial);
        ReductionTest.assertTrue((String)"isONE( e ) some times", (boolean)genPolynomial3.isONE());
        arrayList = new ArrayList();
        genPolynomial = genPolynomial4.multiply(bigInteger.fromInteger(5L));
        arrayList.add(genPolynomial);
        genPolynomial2 = genPolynomial4.multiply(bigInteger.fromInteger(4L));
        genPolynomial3 = dReductionSeq.normalform(arrayList, genPolynomial2);
        ReductionTest.assertTrue((String)"nf(b) = b ", (boolean)genPolynomial3.equals(genPolynomial2));
        genPolynomial = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial4 = dReductionSeq.GPolynomial(genPolynomial, genPolynomial2);
        genPolynomial3 = dReductionSeq.SPolynomial(genPolynomial, genPolynomial2);
        BigInteger bigInteger2 = genPolynomial.leadingBaseCoefficient().gcd(genPolynomial2.leadingBaseCoefficient());
        ReductionTest.assertEquals((String)"gcd(lbc(a),lbc(b)) = lbc(c) ", (Object)bigInteger2, (Object)genPolynomial4.leadingBaseCoefficient());
        ExpVector expVector = genPolynomial.leadingExpVector().lcm(genPolynomial2.leadingExpVector());
        ReductionTest.assertEquals((String)"lcm(lt(a),lt(b)) == lt(c) ", (Object)expVector, (Object)genPolynomial4.leadingExpVector());
        ReductionTest.assertFalse((String)"lcm(lt(a),lt(b)) != lt(e) ", (boolean)expVector.equals(genPolynomial3.leadingExpVector()));
        arrayList = new ArrayList();
        arrayList.add(genPolynomial);
        ReductionTest.assertTrue((String)"isTopRed( a )", (boolean)dReductionSeq.isTopReducible(arrayList, genPolynomial));
        ReductionTest.assertTrue((String)"isRed( a )", (boolean)dReductionSeq.isReducible(arrayList, genPolynomial));
        genPolynomial2 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        arrayList.add(genPolynomial2);
        ReductionTest.assertTrue((String)"isTopRed( b )", (boolean)dReductionSeq.isTopReducible(arrayList, genPolynomial2));
        ReductionTest.assertTrue((String)"isRed( b )", (boolean)dReductionSeq.isReducible(arrayList, genPolynomial2));
        genPolynomial4 = genPolynomialRing.random(this.kl, this.ll, this.el, this.q);
        genPolynomial3 = dReductionSeq.normalform(arrayList, genPolynomial4);
        ReductionTest.assertTrue((String)"isNF( e )", (boolean)dReductionSeq.isNormalform(arrayList, genPolynomial3));
    }
}

