/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.DReduction;
import edu.jas.gb.DReductionSeq;
import edu.jas.gb.OrderedPairlist;
import edu.jas.gb.Pair;
import edu.jas.gb.PairList;
import edu.jas.poly.ExpVector;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.structure.RingElem;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OrderedDPairlist<C extends RingElem<C>>
extends OrderedPairlist<C> {
    private static final Logger logger = LogManager.getLogger(OrderedDPairlist.class);
    protected final DReduction<C> dreduction = new DReductionSeq();

    public OrderedDPairlist(GenPolynomialRing<C> genPolynomialRing) {
        this(0, genPolynomialRing);
    }

    public OrderedDPairlist(int n, GenPolynomialRing<C> genPolynomialRing) {
        super(n, genPolynomialRing);
    }

    @Override
    public PairList<C> create(GenPolynomialRing<C> genPolynomialRing) {
        return new OrderedDPairlist<C>(genPolynomialRing);
    }

    @Override
    public PairList<C> create(int n, GenPolynomialRing<C> genPolynomialRing) {
        return new OrderedDPairlist<C>(n, genPolynomialRing);
    }

    @Override
    public synchronized Pair<C> removeNext() {
        if (this.oneInGB) {
            return null;
        }
        Iterator iterator = this.pairlist.entrySet().iterator();
        Pair pair = null;
        boolean bl = false;
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ExpVector expVector = (ExpVector)entry.getKey();
            LinkedList linkedList = (LinkedList)entry.getValue();
            if (logger.isInfoEnabled()) {
                logger.info("g  = " + expVector);
            }
            pair = null;
            if (linkedList.size() > 0) {
                pair = (Pair)linkedList.removeFirst();
                int n = pair.i;
                int n2 = pair.j;
                bl = this.useCriterion4 ? this.dreduction.criterion4(pair.pi, pair.pj, expVector) : true;
                pair.setUseCriterion4(bl);
                if (bl) {
                    bl = this.criterion3(n, n2, expVector);
                    pair.setUseCriterion3(bl);
                }
                ((BitSet)this.red.get(n2)).clear(n);
            }
            if (linkedList.size() == 0) {
                iterator.remove();
            }
        }
        ++this.remCount;
        return pair;
    }

    @Override
    public boolean criterion3(int n, int n2, ExpVector expVector) {
        boolean bl = ((BitSet)this.red.get(n2)).get(n);
        if (!bl) {
            logger.warn("c3.s false for " + n2 + " " + n);
            return bl;
        }
        bl = true;
        Object c = ((GenPolynomial)this.P.get(n)).leadingBaseCoefficient();
        Object c2 = ((GenPolynomial)this.P.get(n2)).leadingBaseCoefficient();
        Object c3 = c.gcd(c2);
        for (int i = 0; i < this.P.size(); ++i) {
            GenPolynomial genPolynomial = (GenPolynomial)this.P.get(i);
            ExpVector expVector2 = genPolynomial.leadingExpVector();
            boolean bl2 = expVector.multipleOf(expVector2);
            if (bl2) {
                Object c4 = genPolynomial.leadingBaseCoefficient();
                RingElem ringElem = (RingElem)c3.remainder(c4);
                bl2 = ringElem.isZERO();
            }
            if (!bl2) continue;
            if (i < n) {
                boolean bl3 = bl = ((BitSet)this.red.get(n)).get(i) || ((BitSet)this.red.get(n2)).get(i);
            }
            if (n < i && i < n2) {
                boolean bl4 = bl = ((BitSet)this.red.get(i)).get(n) || ((BitSet)this.red.get(n2)).get(i);
            }
            if (n2 < i) {
                boolean bl5 = bl = ((BitSet)this.red.get(i)).get(n) || ((BitSet)this.red.get(i)).get(n2);
            }
            if (bl) continue;
            return bl;
        }
        return true;
    }
}

