/*
 * Decompiled with CFR 0.152.
 */
package edu.jas.gb;

import edu.jas.gb.GroebnerBaseAbstract;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.GenPolynomialRing;
import edu.jas.poly.OptimizedPolynomialList;
import edu.jas.poly.TermOrderOptimization;
import edu.jas.structure.GcdRingElem;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GBOptimized<C extends GcdRingElem<C>>
extends GroebnerBaseAbstract<C> {
    private static final Logger logger = LogManager.getLogger(GBOptimized.class);
    private static final boolean debug = logger.isDebugEnabled();
    public final GroebnerBaseAbstract<C> e1;
    public final boolean retPermuted;

    public GBOptimized(GroebnerBaseAbstract<C> groebnerBaseAbstract) {
        this(groebnerBaseAbstract, false);
    }

    public GBOptimized(GroebnerBaseAbstract<C> groebnerBaseAbstract, boolean bl) {
        this.e1 = groebnerBaseAbstract;
        this.retPermuted = bl;
    }

    @Override
    public String toString() {
        return "GBOptimized[ " + this.e1.toString() + " ]";
    }

    @Override
    public void terminate() {
        this.e1.terminate();
    }

    @Override
    public int cancel() {
        int n = this.e1.cancel();
        return n;
    }

    @Override
    public List<GenPolynomial<C>> GB(int n, List<GenPolynomial<C>> list) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        if (n != 0) {
            throw new UnsupportedOperationException("implemented only for modv = 0, not " + n);
        }
        GenPolynomialRing genPolynomialRing = list.get((int)0).ring;
        OptimizedPolynomialList optimizedPolynomialList = TermOrderOptimization.optimizeTermOrder(genPolynomialRing, list);
        List list2 = optimizedPolynomialList.list;
        if (debug) {
            logger.info("optimized polynomials: " + list2);
        }
        List<Integer> list3 = TermOrderOptimization.inversePermutation(optimizedPolynomialList.perm);
        logger.info("optimize perm: " + optimizedPolynomialList.perm + ", de-optimize perm: " + list3);
        List list4 = this.e1.GB(n, list2);
        if (this.retPermuted || list4.isEmpty()) {
            return list4;
        }
        List list5 = TermOrderOptimization.permutation(list3, genPolynomialRing, list4);
        if (debug) {
            logger.info("de-optimized polynomials: " + list5);
        }
        if (list5.size() == 1) {
            return list5;
        }
        logger.warn("recomputing GB");
        list4 = this.e1.GB(n, list5);
        return list4;
    }
}

