/*
 * Decompiled with CFR 0.152.
 */
package userinterface.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import userinterface.util.PropertyException;
import userinterface.util.PropertyOwner;
import userinterface.util.SingleProperty;

public class ChoiceProperty
extends SingleProperty {
    private ArrayList<String> properties;
    private int currIndex;
    private boolean fixedSize;
    private DefaultComboBoxModel listModel;
    private JComboBox editor;
    JPanel pan = new JPanel();

    public ChoiceProperty(PropertyOwner propertyOwner, String string, String[] stringArray, int n) {
        this(propertyOwner, string, stringArray, n, "");
    }

    public ChoiceProperty(PropertyOwner propertyOwner, String string, String[] stringArray, int n, String string2) {
        super(propertyOwner, string, stringArray[n], "", false, string2);
        this.properties = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            this.properties.add(stringArray[i]);
        }
        this.currIndex = n;
        this.fixedSize = true;
        this.listModel = new DefaultComboBoxModel<String>(stringArray);
        this.editor = new JComboBox(this.listModel);
        this.editor.setEditable(false);
        Font font = this.editor.getFont();
        this.editor.setFont(new Font(font.getName(), 0, font.getSize()));
        this.editor.setBackground(Color.WHITE);
        this.editor.setBorder(null);
        this.pan.setLayout(new BorderLayout());
        this.pan.add((Component)this.editor, "Center");
    }

    public String getValue() {
        String string;
        try {
            string = (String)super.getProperty();
        }
        catch (Exception exception) {
            string = this.properties.get(this.currIndex);
            try {
                this.setProperty(string);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        return string;
    }

    public int getNumChoices() {
        if (this.properties == null) {
            return 0;
        }
        return this.properties.size();
    }

    public String getChoice(int n) {
        return this.properties.get(n);
    }

    public int getCurrentIndex() {
        return this.currIndex;
    }

    public void setSelectedIndex(int n) throws PropertyException {
        this.currIndex = n;
        this.setProperty(this.properties.get(n), true);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (this.editor != null) {
            this.editor.setEnabled(bl);
        }
    }

    @Override
    public void setProperty(Object object, boolean bl) throws PropertyException {
        if (this.properties == null) {
            this.properties = new ArrayList();
        }
        if (this.listModel == null) {
            this.listModel = new DefaultComboBoxModel();
        }
        if (object instanceof String) {
            String string = (String)object;
            boolean bl2 = false;
            for (int i = 0; i < this.getNumChoices(); ++i) {
                if (!this.getChoice(i).equals(string)) continue;
                this.currIndex = i;
                super.setProperty(this.getChoice(i), bl);
                bl2 = true;
                break;
            }
            if (!bl2) {
                if (this.isFixedSize()) {
                    throw new PropertyException("Unknown property String");
                }
                this.properties.add(string);
                this.currIndex = this.properties.size() - 1;
                this.listModel.addElement(string);
                super.setProperty(this.getChoice(this.currIndex), bl);
            }
        } else {
            throw new PropertyException("Value must be a String");
        }
    }

    public boolean isFixedSize() {
        return this.fixedSize;
    }

    public void setFixedSize(boolean bl) {
        this.fixedSize = bl;
        this.editor.setEditable(!bl);
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.pan.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        return this.pan;
    }

    @Override
    public Component getTableCellEditorComponentMulti(JTable jTable, Object object, boolean bl, int n, int n2, boolean bl2) {
        if (bl2) {
            return this.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
        this.pan.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
        this.editor.setBackground(new Color(240, 240, 240));
        return this.pan;
    }

    public String getEditorValue() {
        return (String)this.editor.getSelectedItem();
    }

    public void addListenerToEditor(ActionListener actionListener) {
        this.editor.addActionListener(actionListener);
    }

    public void removeListenerFromEditor(ActionListener actionListener) {
        this.editor.removeActionListener(actionListener);
    }
}

