/*
 * Decompiled with CFR 0.152.
 */
package userinterface.properties.computation;

import csv.CsvFormatException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.swing.SwingUtilities;
import parser.ast.Property;
import prism.PrismLangException;
import prism.ResultsImporter;
import userinterface.properties.GUIExperimentTable;
import userinterface.properties.GUIMultiProperties;
import userinterface.util.GUIComputationEvent;

public class ImportResultsThread
extends Thread {
    private final GUIMultiProperties parent;
    private final File file;
    private final GUIExperimentTable table;

    public ImportResultsThread(GUIMultiProperties gUIMultiProperties, GUIExperimentTable gUIExperimentTable, File file) {
        this.parent = gUIMultiProperties;
        this.table = gUIExperimentTable;
        this.file = file;
    }

    @Override
    public void run() {
        Object object;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImportResultsThread.this.parent.startProgress();
                ImportResultsThread.this.parent.notifyEventListeners(new GUIComputationEvent(0, ImportResultsThread.this.parent));
                ImportResultsThread.this.parent.setTaskBarText("Importing results...");
            }
        });
        String string = null;
        try {
            object = new FileReader(this.file);
            ResultsImporter resultsImporter = new ResultsImporter(new BufferedReader((Reader)object));
            for (Map.Entry entry : resultsImporter) {
                this.table.importExperiment((Property)entry.getKey(), ((ResultsImporter.RawResultsCollection)entry.getValue()).toResultsCollection());
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            string = "Could not export results: " + fileNotFoundException.getMessage();
        }
        catch (IOException iOException) {
            string = "Could not read results file: " + iOException.getMessage();
        }
        catch (CsvFormatException csvFormatException) {
            string = "Malformatted CSV results file: " + csvFormatException.getMessage();
        }
        catch (PrismLangException prismLangException) {
            string = "Syntax error in results file: " + prismLangException.getMessage();
        }
        if (string != null) {
            object = string;
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ String val$msg;
                {
                    this.val$msg = string;
                }

                @Override
                public void run() {
                    ImportResultsThread.this.parent.stopProgress();
                    ImportResultsThread.this.parent.setTaskBarText("Importing results... error.");
                    ImportResultsThread.this.parent.notifyEventListeners(new GUIComputationEvent(2, ImportResultsThread.this.parent));
                    ImportResultsThread.this.parent.error("Could not import results: " + this.val$msg);
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ImportResultsThread.this.parent.stopProgress();
                ImportResultsThread.this.parent.setTaskBarText("Importing results... done.");
                ImportResultsThread.this.parent.notifyEventListeners(new GUIComputationEvent(1, ImportResultsThread.this.parent));
            }
        });
    }
}

