/*
 * Decompiled with CFR 0.152.
 */
package strat;

import explicit.ConstructStrategyProduct;
import explicit.NondetModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import parser.State;
import prism.Model;
import prism.PrismException;
import prism.PrismLog;
import strat.Strategy;
import strat.StrategyExplicit;
import strat.StrategyExportOptions;
import strat.StrategyInfo;

public class FMDStrategyStep<Value>
extends StrategyExplicit<Value> {
    private int numStates;
    private int k;
    private ArrayList<StepChoices> choices;

    public FMDStrategyStep(NondetModel<Value> nondetModel, int n) {
        super(nondetModel);
        this.numStates = nondetModel.getNumStates();
        this.k = n;
        this.choices = new ArrayList(this.numStates);
        for (int i = 0; i < this.numStates; ++i) {
            this.choices.add(new StepChoicesArray(n));
        }
    }

    public void setStepChoice(int n, int n2, int n3) {
        this.choices.get(n).setChoiceForStep(n2, n3);
    }

    public void setStepChoices(int n, int[] nArray) {
        for (int i = 0; i < this.numStates; ++i) {
            this.choices.get(i).setChoiceForStep(n, nArray[i]);
        }
    }

    @Override
    public StrategyInfo.Memory memory() {
        return StrategyInfo.Memory.FINITE;
    }

    @Override
    public Object getChoiceAction(int n, int n2) {
        int n3 = this.getChoiceIndex(n, n2);
        return n3 >= 0 ? this.model.getAction(n, n3) : Strategy.UNDEFINED;
    }

    @Override
    public int getChoiceIndex(int n, int n2) {
        return n2 < this.k ? this.choices.get(n).getChoiceForStep(n2) : -1;
    }

    @Override
    public int getMemorySize() {
        return this.k + 1;
    }

    @Override
    public int getInitialMemory(int n) {
        return 0;
    }

    @Override
    public int getUpdatedMemory(int n, Object object, int n2) {
        return n >= this.k ? this.k : n + 1;
    }

    @Override
    public explicit.Model<Value> constructInducedModel(StrategyExportOptions strategyExportOptions) throws PrismException {
        ConstructStrategyProduct constructStrategyProduct = new ConstructStrategyProduct();
        constructStrategyProduct.setMode(strategyExportOptions.getMode());
        explicit.Model model = constructStrategyProduct.constructProductModel(this.model, this);
        return model;
    }

    @Override
    public void exportActions(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
        List<State> list = this.model.getStatesList();
        boolean bl = strategyExportOptions.getShowStates() && list != null;
        for (int i = 0; i < this.numStates; ++i) {
            for (int j = 0; j < this.k; ++j) {
                if (!this.isChoiceDefined(i, j)) continue;
                prismLog.println(String.valueOf(bl ? (Serializable)list.get(i) : Integer.valueOf(i)) + "," + j + "=" + this.getChoiceActionString(i, j));
            }
        }
    }

    @Override
    public void exportIndices(PrismLog prismLog, StrategyExportOptions strategyExportOptions) {
        for (int i = 0; i < this.numStates; ++i) {
            for (int j = 0; j < this.k; ++j) {
                if (!this.isChoiceDefined(i, j)) continue;
                prismLog.println(i + "," + j + "=" + this.getChoiceIndex(i, j));
            }
        }
    }

    @Override
    public void exportInducedModel(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        Model model = this.constructInducedModel(strategyExportOptions);
        model.exportToPrismExplicitTra(prismLog, strategyExportOptions.getModelPrecision());
    }

    @Override
    public void exportDotFile(PrismLog prismLog, StrategyExportOptions strategyExportOptions) throws PrismException {
        Model model = this.constructInducedModel(strategyExportOptions);
        model.exportToDotFile(prismLog, null, strategyExportOptions.getShowStates(), strategyExportOptions.getModelPrecision());
    }

    @Override
    public void clear() {
        this.choices = null;
    }

    public String toString() {
        return "[" + IntStream.range(0, this.getNumStates()).mapToObj(n -> IntStream.range(0, this.k).mapToObj(n2 -> n + "," + n2 + "=" + this.getChoiceActionString(n, n2)).collect(Collectors.joining(","))).collect(Collectors.joining(",")) + "]";
    }

    class StepChoicesArray
    extends StepChoices {
        int[] stepChoices;

        StepChoicesArray(int n) {
            this.stepChoices = new int[n];
            for (int i = 0; i < n; ++i) {
                this.stepChoices[i] = -1;
            }
        }

        @Override
        void setChoiceForStep(int n, int n2) {
            this.stepChoices[n] = n2;
        }

        @Override
        int getChoiceForStep(int n) {
            return this.stepChoices[n];
        }
    }

    abstract class StepChoices {
        StepChoices() {
        }

        abstract void setChoiceForStep(int var1, int var2);

        abstract int getChoiceForStep(int var1);
    }
}

